/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.dfs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.internal.storage.commitgraph.CommitGraphWriter;
import org.eclipse.jgit.internal.storage.dfs.DfsObjDatabase;
import org.eclipse.jgit.internal.storage.dfs.DfsRepositoryDescription;
import org.eclipse.jgit.internal.storage.dfs.DfsStreamKey;
import org.eclipse.jgit.internal.storage.pack.PackExt;
import org.eclipse.jgit.internal.storage.reftable.ReftableWriter;
import org.eclipse.jgit.storage.pack.PackStatistics;

public class DfsPackDescription {
    private final DfsRepositoryDescription repoDesc;
    private final String packName;
    private DfsObjDatabase.PackSource packSource;
    private long lastModified;
    private long[] sizeMap;
    private int[] blockSizeMap;
    private long objectCount;
    private long deltaCount;
    private long minUpdateIndex;
    private long maxUpdateIndex;
    private PackStatistics packStats;
    private ReftableWriter.Stats refStats;
    private CommitGraphWriter.Stats commitGraphStats;
    private int extensions;
    private int indexVersion;
    private long estimatedPackSize;
    private List<? extends DfsPackDescription> coveredPacks = Collections.EMPTY_LIST;
    private DfsPackDescription multiPackIndexBase;

    public static Comparator<DfsPackDescription> objectLookupComparator() {
        return DfsPackDescription.objectLookupComparator(DfsObjDatabase.PackSource.DEFAULT_COMPARATOR);
    }

    public static Comparator<DfsPackDescription> objectLookupComparator(Comparator<DfsObjDatabase.PackSource> packSourceComparator) {
        return Comparator.comparing(DfsPackDescription::getPackSource, packSourceComparator).thenComparing((a, b) -> {
            int cmp;
            DfsObjDatabase.PackSource bs;
            DfsObjDatabase.PackSource as = a.getPackSource();
            if (as == (bs = b.getPackSource()) && DfsPackDescription.isGC(as) && (cmp = Long.signum(a.getFileSize(PackExt.PACK) - b.getFileSize(PackExt.PACK))) != 0) {
                return cmp;
            }
            cmp = Long.signum(b.getLastModified() - a.getLastModified());
            if (cmp != 0) {
                return cmp;
            }
            return Long.signum(a.getObjectCount() - b.getObjectCount());
        });
    }

    static Comparator<DfsPackDescription> reftableComparator() {
        return (a, b) -> {
            int c = DfsObjDatabase.PackSource.DEFAULT_COMPARATOR.reversed().compare(a.getPackSource(), b.getPackSource());
            if (c != 0) {
                return c;
            }
            c = Long.signum(a.getMaxUpdateIndex() - b.getMaxUpdateIndex());
            if (c != 0) {
                return c;
            }
            return Long.signum(a.getLastModified() - b.getLastModified());
        };
    }

    static Comparator<DfsPackDescription> reuseComparator() {
        return (a, b) -> {
            DfsObjDatabase.PackSource bs;
            DfsObjDatabase.PackSource as = a.getPackSource();
            if (as == (bs = b.getPackSource()) && DfsPackDescription.isGC(as)) {
                return Long.signum(b.getFileSize(PackExt.PACK) - a.getFileSize(PackExt.PACK));
            }
            return 0;
        };
    }

    public DfsPackDescription(DfsRepositoryDescription repoDesc, String name, @NonNull DfsObjDatabase.PackSource packSource) {
        this.repoDesc = repoDesc;
        int dot = name.lastIndexOf(46);
        this.packName = dot < 0 ? name : name.substring(0, dot);
        this.packSource = packSource;
        int extCnt = PackExt.values().length;
        this.sizeMap = new long[extCnt];
        this.blockSizeMap = new int[extCnt];
    }

    public DfsRepositoryDescription getRepositoryDescription() {
        return this.repoDesc;
    }

    public void addFileExt(PackExt ext) {
        this.extensions |= ext.getBit();
    }

    public boolean hasFileExt(PackExt ext) {
        return (this.extensions & ext.getBit()) != 0;
    }

    public String getPackName() {
        return this.packName;
    }

    public String getFileName(PackExt ext) {
        return this.packName + "." + ext.getExtension();
    }

    public DfsStreamKey getStreamKey(PackExt ext) {
        return DfsStreamKey.of(this.getRepositoryDescription(), this.getFileName(ext), ext);
    }

    @NonNull
    public DfsObjDatabase.PackSource getPackSource() {
        return this.packSource;
    }

    public DfsPackDescription setPackSource(@NonNull DfsObjDatabase.PackSource source2) {
        this.packSource = source2;
        return this;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public DfsPackDescription setLastModified(long timeMillis) {
        this.lastModified = timeMillis;
        return this;
    }

    public long getMinUpdateIndex() {
        return this.minUpdateIndex;
    }

    public DfsPackDescription setMinUpdateIndex(long min) {
        this.minUpdateIndex = min;
        return this;
    }

    public long getMaxUpdateIndex() {
        return this.maxUpdateIndex;
    }

    public DfsPackDescription setMaxUpdateIndex(long max) {
        this.maxUpdateIndex = max;
        return this;
    }

    public DfsPackDescription setFileSize(PackExt ext, long bytes) {
        int i2 = ext.getPosition();
        if (i2 >= this.sizeMap.length) {
            this.sizeMap = Arrays.copyOf(this.sizeMap, i2 + 1);
        }
        this.sizeMap[i2] = Math.max(0L, bytes);
        return this;
    }

    public long getFileSize(PackExt ext) {
        int i2 = ext.getPosition();
        return i2 < this.sizeMap.length ? this.sizeMap[i2] : 0L;
    }

    public int getBlockSize(PackExt ext) {
        int i2 = ext.getPosition();
        return i2 < this.blockSizeMap.length ? this.blockSizeMap[i2] : 0;
    }

    public DfsPackDescription setBlockSize(PackExt ext, int blockSize) {
        int i2 = ext.getPosition();
        if (i2 >= this.blockSizeMap.length) {
            this.blockSizeMap = Arrays.copyOf(this.blockSizeMap, i2 + 1);
        }
        this.blockSizeMap[i2] = Math.max(0, blockSize);
        return this;
    }

    public DfsPackDescription setEstimatedPackSize(long estimatedPackSize) {
        this.estimatedPackSize = Math.max(0L, estimatedPackSize);
        return this;
    }

    public long getEstimatedPackSize() {
        return this.estimatedPackSize;
    }

    public long getObjectCount() {
        return this.objectCount;
    }

    public DfsPackDescription setObjectCount(long cnt) {
        this.objectCount = Math.max(0L, cnt);
        return this;
    }

    public long getDeltaCount() {
        return this.deltaCount;
    }

    public DfsPackDescription setDeltaCount(long cnt) {
        this.deltaCount = Math.max(0L, cnt);
        return this;
    }

    public PackStatistics getPackStats() {
        return this.packStats;
    }

    DfsPackDescription setPackStats(PackStatistics stats) {
        this.packStats = stats;
        this.setFileSize(PackExt.PACK, stats.getTotalBytes());
        this.setObjectCount(stats.getTotalObjects());
        this.setDeltaCount(stats.getTotalDeltas());
        return this;
    }

    public ReftableWriter.Stats getReftableStats() {
        return this.refStats;
    }

    void setReftableStats(ReftableWriter.Stats stats) {
        this.refStats = stats;
        this.setMinUpdateIndex(stats.minUpdateIndex());
        this.setMaxUpdateIndex(stats.maxUpdateIndex());
        this.setFileSize(PackExt.REFTABLE, stats.totalBytes());
        this.setBlockSize(PackExt.REFTABLE, stats.refBlockSize());
    }

    public CommitGraphWriter.Stats getCommitGraphStats() {
        return this.commitGraphStats;
    }

    void setCommitGraphStats(CommitGraphWriter.Stats stats) {
        this.commitGraphStats = stats;
    }

    public DfsPackDescription clearPackStats() {
        this.packStats = null;
        this.refStats = null;
        return this;
    }

    public int getIndexVersion() {
        return this.indexVersion;
    }

    public DfsPackDescription setIndexVersion(int version) {
        this.indexVersion = version;
        return this;
    }

    @NonNull
    public List<DfsPackDescription> getCoveredPacks() {
        return new ArrayList<DfsPackDescription>(this.coveredPacks);
    }

    public void setCoveredPacks(List<? extends DfsPackDescription> coveredPacks) {
        if (coveredPacks == null) {
            throw new IllegalStateException("Cannot set to null coveredPacks. Use empty list if needed.");
        }
        this.coveredPacks = coveredPacks;
    }

    @Nullable
    public DfsPackDescription getMultiPackIndexBase() {
        return this.multiPackIndexBase;
    }

    public void setMultiPackIndexBase(DfsPackDescription desc) {
        this.multiPackIndexBase = desc;
    }

    public int hashCode() {
        return this.packName.hashCode();
    }

    public boolean equals(Object b) {
        if (b instanceof DfsPackDescription) {
            DfsPackDescription desc = (DfsPackDescription)b;
            return this.packName.equals(desc.packName) && this.getRepositoryDescription().equals(desc.getRepositoryDescription());
        }
        return false;
    }

    static boolean isGC(DfsObjDatabase.PackSource s) {
        switch (s) {
            case GC: 
            case GC_REST: {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return this.getFileName(PackExt.PACK);
    }
}

