/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.dfs;

import java.util.List;
import org.eclipse.jgit.internal.storage.dfs.DfsBlockCacheTable;
import org.eclipse.jgit.internal.storage.pack.PackExt;

class AggregatedBlockCacheStats
implements DfsBlockCacheTable.BlockCacheStats {
    private final List<DfsBlockCacheTable.BlockCacheStats> blockCacheStats;

    static DfsBlockCacheTable.BlockCacheStats fromStatsList(List<DfsBlockCacheTable.BlockCacheStats> blockCacheStats) {
        if (blockCacheStats.size() == 1) {
            return blockCacheStats.get(0);
        }
        return new AggregatedBlockCacheStats(blockCacheStats);
    }

    private AggregatedBlockCacheStats(List<DfsBlockCacheTable.BlockCacheStats> blockCacheStats) {
        this.blockCacheStats = blockCacheStats;
    }

    @Override
    public String getName() {
        return AggregatedBlockCacheStats.class.getName();
    }

    @Override
    public long[] getCurrentSize() {
        long[] sums = AggregatedBlockCacheStats.emptyPackStats();
        for (DfsBlockCacheTable.BlockCacheStats blockCacheStatsEntry : this.blockCacheStats) {
            sums = AggregatedBlockCacheStats.add(sums, blockCacheStatsEntry.getCurrentSize());
        }
        return sums;
    }

    @Override
    public long[] getHitCount() {
        long[] sums = AggregatedBlockCacheStats.emptyPackStats();
        for (DfsBlockCacheTable.BlockCacheStats blockCacheStatsEntry : this.blockCacheStats) {
            sums = AggregatedBlockCacheStats.add(sums, blockCacheStatsEntry.getHitCount());
        }
        return sums;
    }

    @Override
    public long[] getMissCount() {
        long[] sums = AggregatedBlockCacheStats.emptyPackStats();
        for (DfsBlockCacheTable.BlockCacheStats blockCacheStatsEntry : this.blockCacheStats) {
            sums = AggregatedBlockCacheStats.add(sums, blockCacheStatsEntry.getMissCount());
        }
        return sums;
    }

    @Override
    public long[] getTotalRequestCount() {
        long[] sums = AggregatedBlockCacheStats.emptyPackStats();
        for (DfsBlockCacheTable.BlockCacheStats blockCacheStatsEntry : this.blockCacheStats) {
            sums = AggregatedBlockCacheStats.add(sums, blockCacheStatsEntry.getTotalRequestCount());
        }
        return sums;
    }

    @Override
    public long[] getHitRatio() {
        long[] hit = this.getHitCount();
        long[] miss = this.getMissCount();
        long[] ratio = new long[Math.max(hit.length, miss.length)];
        int i2 = 0;
        while (i2 < ratio.length) {
            long total;
            ratio[i2] = i2 >= hit.length ? 0L : (i2 >= miss.length ? 100L : ((total = hit[i2] + miss[i2]) == 0L ? 0L : hit[i2] * 100L / total));
            ++i2;
        }
        return ratio;
    }

    @Override
    public long[] getEvictions() {
        long[] sums = AggregatedBlockCacheStats.emptyPackStats();
        for (DfsBlockCacheTable.BlockCacheStats blockCacheStatsEntry : this.blockCacheStats) {
            sums = AggregatedBlockCacheStats.add(sums, blockCacheStatsEntry.getEvictions());
        }
        return sums;
    }

    private static long[] emptyPackStats() {
        return new long[PackExt.values().length];
    }

    private static long[] add(long[] first, long[] second) {
        long[] sums = new long[Integer.max(first.length, second.length)];
        int i2 = 0;
        while (i2 < Integer.min(first.length, second.length)) {
            sums[i2] = first[i2] + second[i2];
            ++i2;
        }
        int j = i2;
        while (j < first.length) {
            sums[j] = first[i2];
            ++j;
        }
        j = i2;
        while (j < second.length) {
            sums[j] = second[i2];
            ++j;
        }
        return sums;
    }
}

