/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.errors.CannotDeleteCurrentBranchException;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.api.errors.NotMergedException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.NullProgressMonitor;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;

public class DeleteBranchCommand
extends GitCommand<List<String>> {
    private final Set<String> branchNames = new HashSet<String>();
    private ProgressMonitor monitor = NullProgressMonitor.INSTANCE;
    private boolean force;

    protected DeleteBranchCommand(Repository repo) {
        super(repo);
    }

    @Override
    public List<String> call() throws GitAPIException, NotMergedException, CannotDeleteCurrentBranchException {
        this.checkCallable();
        ArrayList<String> result = new ArrayList<String>();
        HashSet<String> shortNames = new HashSet<String>();
        if (this.branchNames.isEmpty()) {
            return result;
        }
        Exception error = null;
        try {
            this.deleteBranches(result, shortNames);
        }
        catch (Exception e) {
            error = e;
        }
        this.monitor.beginTask(JGitText.get().updatingConfig, 1);
        try {
            this.updateConfig(shortNames, error);
        }
        finally {
            this.monitor.update(1);
            this.monitor.endTask();
        }
        return result;
    }

    private void deleteBranches(List<String> result, Set<String> shortNames) throws GitAPIException, NotMergedException, CannotDeleteCurrentBranchException {
        try {
            String currentBranch = this.repo.getFullBranch();
            if (!this.force) {
                Throwable throwable = null;
                Iterator<String> iterator2 = null;
                try (RevWalk walk = new RevWalk(this.repo);){
                    RevCommit tip = walk.parseCommit(this.repo.resolve("HEAD"));
                    for (String branchName : this.branchNames) {
                        RevCommit base;
                        Ref currentRef;
                        if (branchName == null || (currentRef = this.repo.findRef(branchName)) == null || walk.isMergedInto(base = walk.parseCommit(this.repo.resolve(branchName)), tip)) continue;
                        throw new NotMergedException();
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            this.setCallable(false);
            this.monitor.start(2);
            this.monitor.beginTask(JGitText.get().deletingBranches, this.branchNames.size());
            try {
                for (String branchName : this.branchNames) {
                    if (branchName == null) {
                        this.monitor.update(1);
                        continue;
                    }
                    Ref currentRef = this.repo.findRef(branchName);
                    if (currentRef == null) {
                        this.monitor.update(1);
                        continue;
                    }
                    String fullName = currentRef.getName();
                    if (fullName.equals(currentBranch)) {
                        throw new CannotDeleteCurrentBranchException(MessageFormat.format(JGitText.get().cannotDeleteCheckedOutBranch, branchName));
                    }
                    RefUpdate update = this.repo.updateRef(fullName);
                    update.setRefLogMessage("branch deleted", false);
                    update.setForceUpdate(true);
                    RefUpdate.Result deleteResult = update.delete();
                    switch (deleteResult) {
                        case LOCK_FAILURE: 
                        case REJECTED: 
                        case IO_FAILURE: {
                            throw new JGitInternalException(MessageFormat.format(JGitText.get().deleteBranchUnexpectedResult, deleteResult.name()));
                        }
                    }
                    result.add(fullName);
                    if (fullName.startsWith("refs/heads/")) {
                        shortNames.add(fullName.substring("refs/heads/".length()));
                    }
                    this.monitor.update(1);
                    if (!this.monitor.isCancelled()) continue;
                    break;
                }
            }
            finally {
                this.monitor.endTask();
            }
        }
        catch (IOException ioe) {
            throw new JGitInternalException(ioe.getMessage(), ioe);
        }
    }

    private void updateConfig(Set<String> shortNames, Exception error) throws GitAPIException {
        IOException configError = null;
        if (!shortNames.isEmpty()) {
            try {
                StoredConfig cfg = this.repo.getConfig();
                boolean changed = false;
                for (String branchName : shortNames) {
                    changed |= cfg.removeSection("branch", branchName);
                }
                if (changed) {
                    cfg.save();
                }
            }
            catch (IOException e) {
                configError = e;
            }
        }
        if (error == null) {
            if (configError != null) {
                throw new JGitInternalException(configError.getMessage(), configError);
            }
        } else {
            if (error instanceof GitAPIException) {
                if (configError != null) {
                    error.addSuppressed(configError);
                }
                throw (GitAPIException)error;
            }
            if (error instanceof RuntimeException) {
                if (configError != null) {
                    error.addSuppressed(configError);
                }
                throw (RuntimeException)error;
            }
            JGitInternalException internal = new JGitInternalException(error.getMessage(), error);
            if (configError != null) {
                internal.addSuppressed(configError);
            }
            throw internal;
        }
    }

    public DeleteBranchCommand setBranchNames(String ... branchnames) {
        this.checkCallable();
        this.branchNames.clear();
        this.branchNames.addAll(Arrays.asList(branchnames));
        return this;
    }

    public DeleteBranchCommand setBranchNames(Collection<String> branchNames) {
        this.checkCallable();
        this.branchNames.clear();
        this.branchNames.addAll(branchNames);
        return this;
    }

    public DeleteBranchCommand setForce(boolean force) {
        this.checkCallable();
        this.force = force;
        return this;
    }

    public ProgressMonitor getProgressMonitor() {
        return this.monitor;
    }

    public DeleteBranchCommand setProgressMonitor(ProgressMonitor monitor) {
        this.checkCallable();
        if (monitor == null) {
            monitor = NullProgressMonitor.INSTANCE;
        }
        this.monitor = monitor;
        return this;
    }
}

