/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.staxmate.out;

import javax.xml.stream.XMLStreamException;
import org.codehaus.staxmate.out.SMOutputContext;
import org.codehaus.staxmate.out.SMOutputtable;
import org.codehaus.staxmate.out.SMSimpleOutput;

public abstract class SMOCharacters
extends SMSimpleOutput {
    private SMOCharacters() {
    }

    public static SMOutputtable create(String text) {
        return new StringBased(text);
    }

    public static SMOutputtable createShared(char[] buf, int offset, int len) {
        if (len < 1) {
            return SMOCharacters.create("");
        }
        char[] arr = new char[len];
        System.arraycopy(buf, offset, arr, 0, len);
        return new ArrayBased(arr);
    }

    public static SMOutputtable createNonShared(char[] buf, int offset, int len) {
        if (offset == 0 && len == buf.length) {
            return new ArrayBased(buf);
        }
        return new ArrayBased3(buf, offset, len);
    }

    @Override
    protected abstract boolean _output(SMOutputContext var1, boolean var2) throws XMLStreamException;

    private static final class ArrayBased3
    extends SMOCharacters {
        final char[] mBuf;
        final int mOffset;
        final int mLen;

        ArrayBased3(char[] buf, int offset, int len) {
            this.mBuf = buf;
            this.mOffset = offset;
            this.mLen = len;
        }

        @Override
        protected boolean _output(SMOutputContext ctxt, boolean canClose) throws XMLStreamException {
            ctxt.writeCharacters(this.mBuf, this.mOffset, this.mLen);
            return true;
        }
    }

    private static final class ArrayBased
    extends SMOCharacters {
        final char[] mBuf;

        ArrayBased(char[] buf) {
            this.mBuf = buf;
        }

        @Override
        protected boolean _output(SMOutputContext ctxt, boolean canClose) throws XMLStreamException {
            ctxt.writeCharacters(this.mBuf, 0, this.mBuf.length);
            return true;
        }
    }

    private static final class StringBased
    extends SMOCharacters {
        final String mText;

        StringBased(String text) {
            this.mText = text;
        }

        @Override
        protected boolean _output(SMOutputContext ctxt, boolean canClose) throws XMLStreamException {
            ctxt.writeCharacters(this.mText);
            return true;
        }
    }
}

