/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.rainbow;

import org.bouncycastle.pqc.crypto.rainbow.ComputeInField;
import org.bouncycastle.pqc.crypto.rainbow.GF2Field;
import org.bouncycastle.pqc.crypto.rainbow.RainbowDRBG;
import org.bouncycastle.pqc.crypto.rainbow.RainbowParameters;
import org.bouncycastle.pqc.crypto.rainbow.RainbowPublicKeyParameters;
import org.bouncycastle.pqc.crypto.rainbow.RainbowUtil;
import org.bouncycastle.util.Arrays;

class RainbowPublicMap {
    private ComputeInField cf = new ComputeInField();
    private RainbowParameters params;
    private final int num_gf_elements = 256;

    public RainbowPublicMap(RainbowParameters rainbowParameters) {
        this.params = rainbowParameters;
    }

    private short[][] compute_accumulator(short[] sArray, short[] sArray2, short[][][] sArray3, int n) {
        short[][] sArray4 = new short[256][n];
        if (sArray2.length != sArray3[0].length || sArray.length != sArray3[0][0].length || sArray3.length != n) {
            throw new RuntimeException("Accumulator calculation not possible!");
        }
        for (int j = 0; j < sArray2.length; ++j) {
            short[] sArray5 = this.cf.multVect(sArray2[j], sArray);
            for (int k = 0; k < sArray.length; ++k) {
                for (int i2 = 0; i2 < sArray3.length; ++i2) {
                    short s = sArray5[k];
                    if (s == 0) continue;
                    sArray4[s][i2] = GF2Field.addElem(sArray4[s][i2], sArray3[i2][j][k]);
                }
            }
        }
        return sArray4;
    }

    private short[] add_and_reduce(short[][] sArray) {
        int n = this.params.getM();
        short[] sArray2 = new short[n];
        for (int j = 0; j < 8; ++j) {
            int n2 = (int)Math.pow(2.0, j);
            short[] sArray3 = new short[n];
            for (int k = n2; k < 256; k += n2 * 2) {
                for (int i2 = 0; i2 < n2; ++i2) {
                    sArray3 = this.cf.addVect(sArray3, sArray[k + i2]);
                }
            }
            sArray2 = this.cf.addVect(sArray2, this.cf.multVect((short)n2, sArray3));
        }
        return sArray2;
    }

    public short[] publicMap(RainbowPublicKeyParameters rainbowPublicKeyParameters, short[] sArray) {
        short[][] sArray2 = this.compute_accumulator(sArray, sArray, rainbowPublicKeyParameters.pk, this.params.getM());
        return this.add_and_reduce(sArray2);
    }

    public short[] publicMap_cyclic(RainbowPublicKeyParameters rainbowPublicKeyParameters, short[] sArray) {
        int n = this.params.getV1();
        int n2 = this.params.getO1();
        int n3 = this.params.getO2();
        short[][] sArray2 = new short[256][n2 + n3];
        short[] sArray3 = Arrays.copyOfRange(sArray, 0, n);
        short[] sArray4 = Arrays.copyOfRange(sArray, n, n + n2);
        short[] sArray5 = Arrays.copyOfRange(sArray, n + n2, sArray.length);
        RainbowDRBG rainbowDRBG = new RainbowDRBG(rainbowPublicKeyParameters.pk_seed, rainbowPublicKeyParameters.getParameters().getHash_algo());
        short[][][] sArray6 = RainbowUtil.generate_random(rainbowDRBG, n2, n, n, true);
        short[][] sArray7 = this.compute_accumulator(sArray3, sArray3, sArray6, n2);
        sArray6 = RainbowUtil.generate_random(rainbowDRBG, n2, n, n2, false);
        sArray7 = this.cf.addMatrix(sArray7, this.compute_accumulator(sArray4, sArray3, sArray6, n2));
        sArray7 = this.cf.addMatrix(sArray7, this.compute_accumulator(sArray5, sArray3, rainbowPublicKeyParameters.l1_Q3, n2));
        sArray7 = this.cf.addMatrix(sArray7, this.compute_accumulator(sArray4, sArray4, rainbowPublicKeyParameters.l1_Q5, n2));
        sArray7 = this.cf.addMatrix(sArray7, this.compute_accumulator(sArray5, sArray4, rainbowPublicKeyParameters.l1_Q6, n2));
        sArray7 = this.cf.addMatrix(sArray7, this.compute_accumulator(sArray5, sArray5, rainbowPublicKeyParameters.l1_Q9, n2));
        sArray6 = RainbowUtil.generate_random(rainbowDRBG, n3, n, n, true);
        short[][] sArray8 = this.compute_accumulator(sArray3, sArray3, sArray6, n3);
        sArray6 = RainbowUtil.generate_random(rainbowDRBG, n3, n, n2, false);
        sArray8 = this.cf.addMatrix(sArray8, this.compute_accumulator(sArray4, sArray3, sArray6, n3));
        sArray6 = RainbowUtil.generate_random(rainbowDRBG, n3, n, n3, false);
        sArray8 = this.cf.addMatrix(sArray8, this.compute_accumulator(sArray5, sArray3, sArray6, n3));
        sArray6 = RainbowUtil.generate_random(rainbowDRBG, n3, n2, n2, true);
        sArray8 = this.cf.addMatrix(sArray8, this.compute_accumulator(sArray4, sArray4, sArray6, n3));
        sArray6 = RainbowUtil.generate_random(rainbowDRBG, n3, n2, n3, false);
        sArray8 = this.cf.addMatrix(sArray8, this.compute_accumulator(sArray5, sArray4, sArray6, n3));
        sArray8 = this.cf.addMatrix(sArray8, this.compute_accumulator(sArray5, sArray5, rainbowPublicKeyParameters.l2_Q9, n3));
        for (int j = 0; j < 256; ++j) {
            sArray2[j] = Arrays.concatenate(sArray7[j], sArray8[j]);
        }
        return this.add_and_reduce(sArray2);
    }
}

