/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.mldsa;

import org.bouncycastle.pqc.crypto.mldsa.MLDSAEngine;
import org.bouncycastle.pqc.crypto.mldsa.PolyVecK;
import org.bouncycastle.pqc.crypto.mldsa.PolyVecL;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class PolyVecMatrix {
    private final PolyVecL[] matrix;

    PolyVecMatrix(MLDSAEngine mLDSAEngine) {
        int n = mLDSAEngine.getDilithiumK();
        this.matrix = new PolyVecL[n];
        for (int j = 0; j < n; ++j) {
            this.matrix[j] = new PolyVecL(mLDSAEngine);
        }
    }

    public void pointwiseMontgomery(PolyVecK polyVecK, PolyVecL polyVecL) {
        for (int j = 0; j < this.matrix.length; ++j) {
            polyVecK.getVectorIndex(j).pointwiseAccountMontgomery(this.matrix[j], polyVecL);
        }
    }

    public void expandMatrix(byte[] byArray) {
        for (int j = 0; j < this.matrix.length; ++j) {
            this.matrix[j].uniformBlocks(byArray, j << 8);
        }
    }

    private String addString() {
        String string = "[";
        for (int j = 0; j < this.matrix.length; ++j) {
            string = string + "Outer Matrix " + j + " [";
            string = string + this.matrix[j].toString();
            string = j == this.matrix.length - 1 ? string + "]\n" : string + "],\n";
        }
        string = string + "]\n";
        return string;
    }

    public String toString(String string) {
        return string.concat(": \n" + this.addString());
    }
}

