/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.mldsa;

import org.bouncycastle.pqc.crypto.mldsa.MLDSAEngine;
import org.bouncycastle.pqc.crypto.mldsa.Poly;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class PolyVecL {
    private final Poly[] vec;

    PolyVecL(MLDSAEngine mLDSAEngine) {
        int n = mLDSAEngine.getDilithiumL();
        this.vec = new Poly[n];
        for (int j = 0; j < n; ++j) {
            this.vec[j] = new Poly(mLDSAEngine);
        }
    }

    public PolyVecL() throws Exception {
        throw new Exception("Requires Parameter");
    }

    public Poly getVectorIndex(int n) {
        return this.vec[n];
    }

    void uniformBlocks(byte[] byArray, int n) {
        for (int j = 0; j < this.vec.length; ++j) {
            this.vec[j].uniformBlocks(byArray, (short)(n + j));
        }
    }

    public void uniformEta(byte[] byArray, short s) {
        short s2 = s;
        for (int j = 0; j < this.vec.length; ++j) {
            short s3 = s2;
            s2 = (short)(s2 + 1);
            this.getVectorIndex(j).uniformEta(byArray, s3);
        }
    }

    void copyTo(PolyVecL polyVecL) {
        for (int j = 0; j < this.vec.length; ++j) {
            this.vec[j].copyTo(polyVecL.vec[j]);
        }
    }

    public void polyVecNtt() {
        for (int j = 0; j < this.vec.length; ++j) {
            this.vec[j].polyNtt();
        }
    }

    public void uniformGamma1(byte[] byArray, short s) {
        for (int j = 0; j < this.vec.length; ++j) {
            this.getVectorIndex(j).uniformGamma1(byArray, (short)(this.vec.length * s + j));
        }
    }

    public void pointwisePolyMontgomery(Poly poly, PolyVecL polyVecL) {
        for (int j = 0; j < this.vec.length; ++j) {
            this.getVectorIndex(j).pointwiseMontgomery(poly, polyVecL.getVectorIndex(j));
        }
    }

    public void invNttToMont() {
        for (int j = 0; j < this.vec.length; ++j) {
            this.getVectorIndex(j).invNttToMont();
        }
    }

    public void addPolyVecL(PolyVecL polyVecL) {
        for (int j = 0; j < this.vec.length; ++j) {
            this.getVectorIndex(j).addPoly(polyVecL.getVectorIndex(j));
        }
    }

    public void reduce() {
        for (int j = 0; j < this.vec.length; ++j) {
            this.getVectorIndex(j).reduce();
        }
    }

    public boolean checkNorm(int n) {
        for (int j = 0; j < this.vec.length; ++j) {
            if (!this.getVectorIndex(j).checkNorm(n)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        String string = "\n[";
        for (int j = 0; j < this.vec.length; ++j) {
            string = string + "Inner Matrix " + j + " " + this.getVectorIndex(j).toString();
            if (j == this.vec.length - 1) continue;
            string = string + ",\n";
        }
        string = string + "]";
        return string;
    }

    public String toString(String string) {
        return string + ": " + this.toString();
    }
}

