/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.mldsa;

import org.bouncycastle.pqc.crypto.mldsa.MLDSAEngine;
import org.bouncycastle.pqc.crypto.mldsa.Poly;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class PolyVecK {
    private final Poly[] vec;

    PolyVecK(MLDSAEngine mLDSAEngine) {
        int n = mLDSAEngine.getDilithiumK();
        this.vec = new Poly[n];
        for (int j = 0; j < n; ++j) {
            this.vec[j] = new Poly(mLDSAEngine);
        }
    }

    Poly getVectorIndex(int n) {
        return this.vec[n];
    }

    void setVectorIndex(int n, Poly poly) {
        this.vec[n] = poly;
    }

    public void uniformEta(byte[] byArray, short s) {
        short s2 = s;
        for (int j = 0; j < this.vec.length; ++j) {
            short s3 = s2;
            s2 = (short)(s2 + 1);
            this.vec[j].uniformEta(byArray, s3);
        }
    }

    public void reduce() {
        for (int j = 0; j < this.vec.length; ++j) {
            this.getVectorIndex(j).reduce();
        }
    }

    public void invNttToMont() {
        for (int j = 0; j < this.vec.length; ++j) {
            this.getVectorIndex(j).invNttToMont();
        }
    }

    public void addPolyVecK(PolyVecK polyVecK) {
        for (int j = 0; j < this.vec.length; ++j) {
            this.getVectorIndex(j).addPoly(polyVecK.getVectorIndex(j));
        }
    }

    public void conditionalAddQ() {
        for (int j = 0; j < this.vec.length; ++j) {
            this.getVectorIndex(j).conditionalAddQ();
        }
    }

    public void power2Round(PolyVecK polyVecK) {
        for (int j = 0; j < this.vec.length; ++j) {
            this.getVectorIndex(j).power2Round(polyVecK.getVectorIndex(j));
        }
    }

    public void polyVecNtt() {
        for (int j = 0; j < this.vec.length; ++j) {
            this.vec[j].polyNtt();
        }
    }

    public void decompose(PolyVecK polyVecK) {
        for (int j = 0; j < this.vec.length; ++j) {
            this.getVectorIndex(j).decompose(polyVecK.getVectorIndex(j));
        }
    }

    public void packW1(MLDSAEngine mLDSAEngine, byte[] byArray, int n) {
        for (int j = 0; j < this.vec.length; ++j) {
            this.getVectorIndex(j).packW1(byArray, n + j * mLDSAEngine.getDilithiumPolyW1PackedBytes());
        }
    }

    public void pointwisePolyMontgomery(Poly poly, PolyVecK polyVecK) {
        for (int j = 0; j < this.vec.length; ++j) {
            this.getVectorIndex(j).pointwiseMontgomery(poly, polyVecK.getVectorIndex(j));
        }
    }

    public void subtract(PolyVecK polyVecK) {
        for (int j = 0; j < this.vec.length; ++j) {
            this.getVectorIndex(j).subtract(polyVecK.getVectorIndex(j));
        }
    }

    public boolean checkNorm(int n) {
        for (int j = 0; j < this.vec.length; ++j) {
            if (!this.getVectorIndex(j).checkNorm(n)) continue;
            return true;
        }
        return false;
    }

    public int makeHint(PolyVecK polyVecK, PolyVecK polyVecK2) {
        int n = 0;
        for (int j = 0; j < this.vec.length; ++j) {
            n += this.getVectorIndex(j).polyMakeHint(polyVecK.getVectorIndex(j), polyVecK2.getVectorIndex(j));
        }
        return n;
    }

    public void useHint(PolyVecK polyVecK, PolyVecK polyVecK2) {
        for (int j = 0; j < this.vec.length; ++j) {
            this.getVectorIndex(j).polyUseHint(polyVecK.getVectorIndex(j), polyVecK2.getVectorIndex(j));
        }
    }

    public void shiftLeft() {
        for (int j = 0; j < this.vec.length; ++j) {
            this.getVectorIndex(j).shiftLeft();
        }
    }

    public String toString() {
        String string = "[";
        for (int j = 0; j < this.vec.length; ++j) {
            string = string + j + " " + this.getVectorIndex(j).toString();
            if (j == this.vec.length - 1) continue;
            string = string + ",\n";
        }
        string = string + "]";
        return string;
    }

    public String toString(String string) {
        return string + ": " + this.toString();
    }
}

