/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.crystals.dilithium;

import org.bouncycastle.pqc.crypto.crystals.dilithium.DilithiumEngine;
import org.bouncycastle.pqc.crypto.crystals.dilithium.Poly;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class PolyVecL {
    Poly[] vec;
    private DilithiumEngine engine;
    private int mode;
    private int polyVecBytes;
    private int dilithiumL;
    private int dilithiumK;

    public PolyVecL(DilithiumEngine dilithiumEngine) {
        this.engine = dilithiumEngine;
        this.mode = dilithiumEngine.getDilithiumMode();
        this.dilithiumL = dilithiumEngine.getDilithiumL();
        this.dilithiumK = dilithiumEngine.getDilithiumK();
        this.vec = new Poly[this.dilithiumL];
        for (int j = 0; j < this.dilithiumL; ++j) {
            this.vec[j] = new Poly(dilithiumEngine);
        }
    }

    public PolyVecL() throws Exception {
        throw new Exception("Requires Parameter");
    }

    public Poly getVectorIndex(int n) {
        return this.vec[n];
    }

    public void expandMatrix(byte[] byArray, int n) {
        for (int j = 0; j < this.dilithiumL; ++j) {
            this.vec[j].uniformBlocks(byArray, (short)((n << 8) + j));
        }
    }

    public void uniformEta(byte[] byArray, short s) {
        short s2 = s;
        for (int j = 0; j < this.dilithiumL; ++j) {
            short s3 = s2;
            s2 = (short)(s2 + 1);
            this.getVectorIndex(j).uniformEta(byArray, s3);
        }
    }

    public void copyPolyVecL(PolyVecL polyVecL) {
        for (int j = 0; j < this.dilithiumL; ++j) {
            for (int k = 0; k < 256; ++k) {
                polyVecL.getVectorIndex(j).setCoeffIndex(k, this.getVectorIndex(j).getCoeffIndex(k));
            }
        }
    }

    public void polyVecNtt() {
        for (int j = 0; j < this.dilithiumL; ++j) {
            this.vec[j].polyNtt();
        }
    }

    public void uniformGamma1(byte[] byArray, short s) {
        for (int j = 0; j < this.dilithiumL; ++j) {
            this.getVectorIndex(j).uniformGamma1(byArray, (short)(this.dilithiumL * s + j));
        }
    }

    public void pointwisePolyMontgomery(Poly poly, PolyVecL polyVecL) {
        for (int j = 0; j < this.dilithiumL; ++j) {
            this.getVectorIndex(j).pointwiseMontgomery(poly, polyVecL.getVectorIndex(j));
        }
    }

    public void invNttToMont() {
        for (int j = 0; j < this.dilithiumL; ++j) {
            this.getVectorIndex(j).invNttToMont();
        }
    }

    public void addPolyVecL(PolyVecL polyVecL) {
        for (int j = 0; j < this.dilithiumL; ++j) {
            this.getVectorIndex(j).addPoly(polyVecL.getVectorIndex(j));
        }
    }

    public void reduce() {
        for (int j = 0; j < this.dilithiumL; ++j) {
            this.getVectorIndex(j).reduce();
        }
    }

    public boolean checkNorm(int n) {
        for (int j = 0; j < this.dilithiumL; ++j) {
            if (!this.getVectorIndex(j).checkNorm(n)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        String string = "\n[";
        for (int j = 0; j < this.dilithiumL; ++j) {
            string = string + "Inner Matrix " + j + " " + this.getVectorIndex(j).toString();
            if (j == this.dilithiumL - 1) continue;
            string = string + ",\n";
        }
        string = string + "]";
        return string;
    }

    public String toString(String string) {
        return string + ": " + this.toString();
    }
}

