/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.math.ec.custom.sec;

import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastle.math.ec.AbstractECLookupTable;
import org.bouncycastle.math.ec.ECConstants;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECFieldElement;
import org.bouncycastle.math.ec.ECLookupTable;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.math.ec.custom.sec.SecP160R2Field;
import org.bouncycastle.math.ec.custom.sec.SecP160R2FieldElement;
import org.bouncycastle.math.ec.custom.sec.SecP160R2Point;
import org.bouncycastle.math.raw.Nat160;
import org.bouncycastle.util.encoders.Hex;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class SecP160R2Curve
extends ECCurve.AbstractFp {
    public static final BigInteger q = SecP160R2FieldElement.Q;
    private static final int SECP160R2_DEFAULT_COORDS = 2;
    private static final ECFieldElement[] SECP160R2_AFFINE_ZS = new ECFieldElement[]{new SecP160R2FieldElement(ECConstants.ONE)};
    protected SecP160R2Point infinity = new SecP160R2Point(this, null, null);

    public SecP160R2Curve() {
        super(q);
        this.a = this.fromBigInteger(new BigInteger(1, Hex.decodeStrict("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFFFFAC70")));
        this.b = this.fromBigInteger(new BigInteger(1, Hex.decodeStrict("B4E134D3FB59EB8BAB57274904664D5AF50388BA")));
        this.order = new BigInteger(1, Hex.decodeStrict("0100000000000000000000351EE786A818F3A1A16B"));
        this.cofactor = BigInteger.valueOf(1L);
        this.coord = 2;
    }

    @Override
    protected ECCurve cloneCurve() {
        return new SecP160R2Curve();
    }

    @Override
    public boolean supportsCoordinateSystem(int n) {
        switch (n) {
            case 2: {
                return true;
            }
        }
        return false;
    }

    @Override
    public BigInteger getQ() {
        return q;
    }

    @Override
    public int getFieldSize() {
        return q.bitLength();
    }

    @Override
    public ECFieldElement fromBigInteger(BigInteger bigInteger) {
        return new SecP160R2FieldElement(bigInteger);
    }

    @Override
    protected ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2) {
        return new SecP160R2Point(this, eCFieldElement, eCFieldElement2);
    }

    @Override
    protected ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, ECFieldElement[] eCFieldElementArray) {
        return new SecP160R2Point(this, eCFieldElement, eCFieldElement2, eCFieldElementArray);
    }

    @Override
    public ECPoint getInfinity() {
        return this.infinity;
    }

    @Override
    public ECLookupTable createCacheSafeLookupTable(ECPoint[] eCPointArray, int n, final int n2) {
        final int[] nArray = new int[n2 * 5 * 2];
        int n3 = 0;
        for (int j = 0; j < n2; ++j) {
            ECPoint eCPoint = eCPointArray[n + j];
            Nat160.copy(((SecP160R2FieldElement)eCPoint.getRawXCoord()).x, 0, nArray, n3);
            Nat160.copy(((SecP160R2FieldElement)eCPoint.getRawYCoord()).x, 0, nArray, n3 += 5);
            n3 += 5;
        }
        return new AbstractECLookupTable(this){
            final /* synthetic */ SecP160R2Curve this$0;
            {
                this.this$0 = secP160R2Curve;
            }

            @Override
            public int getSize() {
                return n2;
            }

            @Override
            public ECPoint lookup(int n) {
                int[] nArray3 = Nat160.create();
                int[] nArray2 = Nat160.create();
                int n22 = 0;
                for (int j = 0; j < n2; ++j) {
                    int n3 = (j ^ n) - 1 >> 31;
                    for (int k = 0; k < 5; ++k) {
                        int n4 = k;
                        nArray3[n4] = nArray3[n4] ^ nArray[n22 + k] & n3;
                        int n5 = k;
                        nArray2[n5] = nArray2[n5] ^ nArray[n22 + 5 + k] & n3;
                    }
                    n22 += 10;
                }
                return this.createPoint(nArray3, nArray2);
            }

            @Override
            public ECPoint lookupVar(int n) {
                int[] nArray3 = Nat160.create();
                int[] nArray2 = Nat160.create();
                int n22 = n * 5 * 2;
                for (int j = 0; j < 5; ++j) {
                    nArray3[j] = nArray[n22 + j];
                    nArray2[j] = nArray[n22 + 5 + j];
                }
                return this.createPoint(nArray3, nArray2);
            }

            private ECPoint createPoint(int[] nArray3, int[] nArray2) {
                return this.this$0.createRawPoint(new SecP160R2FieldElement(nArray3), new SecP160R2FieldElement(nArray2), SECP160R2_AFFINE_ZS);
            }
        };
    }

    @Override
    public ECFieldElement randomFieldElement(SecureRandom secureRandom) {
        int[] nArray = Nat160.create();
        SecP160R2Field.random(secureRandom, nArray);
        return new SecP160R2FieldElement(nArray);
    }

    @Override
    public ECFieldElement randomFieldElementMult(SecureRandom secureRandom) {
        int[] nArray = Nat160.create();
        SecP160R2Field.randomMult(secureRandom, nArray);
        return new SecP160R2FieldElement(nArray);
    }
}

