/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.util;

import java.util.HashMap;
import java.util.Map;
import org.bouncycastle.crypto.AlphabetMapper;

public class BasicAlphabetMapper
implements AlphabetMapper {
    private Map<Character, Integer> indexMap = new HashMap<Character, Integer>();
    private Map<Integer, Character> charMap = new HashMap<Integer, Character>();

    public BasicAlphabetMapper(String string) {
        this(string.toCharArray());
    }

    public BasicAlphabetMapper(char[] cArray) {
        for (int j = 0; j != cArray.length; ++j) {
            if (this.indexMap.containsKey(Character.valueOf(cArray[j]))) {
                throw new IllegalArgumentException("duplicate key detected in alphabet: " + cArray[j]);
            }
            this.indexMap.put(Character.valueOf(cArray[j]), j);
            this.charMap.put(j, Character.valueOf(cArray[j]));
        }
    }

    @Override
    public int getRadix() {
        return this.indexMap.size();
    }

    @Override
    public byte[] convertToIndexes(char[] cArray) {
        byte[] byArray;
        if (this.indexMap.size() <= 256) {
            byArray = new byte[cArray.length];
            for (int j = 0; j != cArray.length; ++j) {
                byArray[j] = this.indexMap.get(Character.valueOf(cArray[j])).byteValue();
            }
        } else {
            byArray = new byte[cArray.length * 2];
            for (int j = 0; j != cArray.length; ++j) {
                int n = this.indexMap.get(Character.valueOf(cArray[j]));
                byArray[j * 2] = (byte)(n >> 8 & 0xFF);
                byArray[j * 2 + 1] = (byte)(n & 0xFF);
            }
        }
        return byArray;
    }

    @Override
    public char[] convertToChars(byte[] byArray) {
        char[] cArray;
        if (this.charMap.size() <= 256) {
            cArray = new char[byArray.length];
            for (int j = 0; j != byArray.length; ++j) {
                cArray[j] = this.charMap.get(byArray[j] & 0xFF).charValue();
            }
        } else {
            if ((byArray.length & 1) != 0) {
                throw new IllegalArgumentException("two byte radix and input string odd length");
            }
            cArray = new char[byArray.length / 2];
            for (int j = 0; j != byArray.length; j += 2) {
                cArray[j / 2] = this.charMap.get(byArray[j] << 8 & 0xFF00 | byArray[j + 1] & 0xFF).charValue();
            }
        }
        return cArray;
    }
}

