/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.security.eddsa.generic;

import java.security.InvalidKeyException;
import java.security.PublicKey;
import java.util.Arrays;

public final class EdDSAUtils {
    private static final int ED25519_LENGTH = 32;
    private static final int ED448_LENGTH = 57;
    private static final byte[] ED25519_X509_PREFIX = new byte[]{48, 42, 48, 5, 6, 3, 43, 101, 112, 3, 33, 0};
    private static final byte[] ED448_X509_PREFIX = new byte[]{48, 67, 48, 5, 6, 3, 43, 101, 113, 3, 58, 0};

    private EdDSAUtils() {
        throw new IllegalStateException("No instantiation");
    }

    private static boolean startsWith(byte[] data, byte[] prefix) {
        if (data == null || prefix == null || prefix.length == 0 || data.length < prefix.length) {
            return false;
        }
        int unequal = 0;
        int length = prefix.length;
        for (int i2 = 0; i2 < length; ++i2) {
            unequal |= data[i2] ^ prefix[i2];
        }
        return unequal == 0;
    }

    public static byte[] getBytes(PublicKey key) throws InvalidKeyException {
        int n;
        if (!"X.509".equalsIgnoreCase(key.getFormat())) {
            throw new InvalidKeyException("Cannot extract public key bytes from a non-X.509 encoding");
        }
        byte[] encoded = key.getEncoded();
        if (encoded == null) {
            throw new InvalidKeyException("Public key " + key.getClass().getCanonicalName() + " does not support encoding");
        }
        if (encoded.length == 32 + ED25519_X509_PREFIX.length && EdDSAUtils.startsWith(encoded, ED25519_X509_PREFIX)) {
            n = 32;
        } else if (encoded.length == 57 + ED448_X509_PREFIX.length && EdDSAUtils.startsWith(encoded, ED448_X509_PREFIX)) {
            n = 57;
        } else {
            throw new InvalidKeyException("Public key is neither ed25519 nor ed448");
        }
        return Arrays.copyOfRange(encoded, encoded.length - n, encoded.length);
    }
}

