/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.buffer;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.IntUnaryOperator;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.NumberUtils;
import org.apache.sshd.common.util.Readable;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.BufferException;
import org.apache.sshd.common.util.buffer.BufferUtils;

public class ByteArrayBuffer
extends Buffer {
    public static final int DEFAULT_SIZE = 256;
    private byte[] data;
    private int rpos;
    private int wpos;

    public ByteArrayBuffer() {
        this(256, false);
    }

    public ByteArrayBuffer(int size) {
        this(size, true);
    }

    public ByteArrayBuffer(int size, boolean roundOff) {
        this(new byte[roundOff ? BufferUtils.getNextPowerOf2(size) : size], false);
    }

    public ByteArrayBuffer(byte[] data) {
        this(data, 0, data.length, true);
    }

    public ByteArrayBuffer(byte[] data, boolean read) {
        this(data, 0, data.length, read);
    }

    public ByteArrayBuffer(byte[] data, int off, int len) {
        this(data, off, len, true);
    }

    public ByteArrayBuffer(byte[] data, int off, int len, boolean read) {
        if (off < 0 || len < 0) {
            throw new IndexOutOfBoundsException("Invalid offset(" + off + ")/length(" + len + ")");
        }
        this.data = data;
        this.rpos = off;
        this.wpos = (read ? len : 0) + off;
    }

    @Override
    public int rpos() {
        return this.rpos;
    }

    @Override
    public void rpos(int rpos) {
        this.rpos = rpos;
    }

    @Override
    public int wpos() {
        return this.wpos;
    }

    @Override
    public void wpos(int wpos) {
        if (wpos > this.wpos) {
            this.ensureCapacity(wpos - this.wpos);
        }
        this.wpos = wpos;
    }

    @Override
    public int available() {
        return this.wpos - this.rpos;
    }

    @Override
    public int capacity() {
        return this.data.length - this.wpos;
    }

    @Override
    public byte[] array() {
        return this.data;
    }

    @Override
    public byte[] getBytesConsumed() {
        byte[] consumed = new byte[this.rpos];
        System.arraycopy(this.data, 0, consumed, 0, this.rpos);
        return consumed;
    }

    @Override
    public byte[] getBytesConsumed(int from) {
        if (from >= this.rpos) {
            return new byte[0];
        }
        return Arrays.copyOfRange(this.data, from, this.rpos);
    }

    @Override
    public byte rawByte(int pos) {
        return this.data[pos];
    }

    @Override
    public long rawUInt(int pos) {
        return BufferUtils.getUInt(this.data, pos, 4);
    }

    @Override
    public void compact() {
        int avail = this.available();
        if (avail > 0) {
            System.arraycopy(this.data, this.rpos, this.data, 0, avail);
        }
        this.wpos -= this.rpos;
        this.rpos = 0;
    }

    @Override
    public Buffer clear(boolean wipeData) {
        this.rpos = 0;
        this.wpos = 0;
        if (wipeData) {
            Arrays.fill(this.data, (byte)0);
        }
        return this;
    }

    @Override
    public byte getByte() {
        if (this.rpos >= this.wpos) {
            throw new BufferException("Underflow: no available bytes in buffer");
        }
        return this.data[this.rpos++];
    }

    @Override
    public void putByte(byte b) {
        if (this.wpos >= this.data.length) {
            this.ensureCapacity(1);
        }
        this.data[this.wpos++] = b;
    }

    @Override
    public int getInt() {
        if (this.rpos + 4 > this.wpos) {
            throw new BufferException("Underflow: not enough bytes in buffer, need 4");
        }
        int i2 = BufferUtils.getInt(this.data, this.rpos, 4);
        this.rpos += 4;
        return i2;
    }

    @Override
    public void putInt(long i2) {
        ValidateUtils.checkTrue((long)((int)i2) == i2, "Invalid INT32 value: %d", i2);
        if (this.wpos + 4 > this.data.length) {
            this.ensureCapacity(4);
        }
        BufferUtils.putUInt(i2, this.data, this.wpos, 4);
        this.wpos += 4;
    }

    @Override
    public long getUInt() {
        if (this.rpos + 4 > this.wpos) {
            throw new BufferException("Underflow: not enough bytes in buffer, need 4");
        }
        long l = BufferUtils.getUInt(this.data, this.rpos, 4);
        this.rpos += 4;
        return l;
    }

    @Override
    public void putUInt(long i2) {
        ValidateUtils.checkTrue((i2 & 0xFFFFFFFFL) == i2, "Invalid UINT32 value: %d", i2);
        if (this.wpos + 4 > this.data.length) {
            this.ensureCapacity(4);
        }
        BufferUtils.putUInt(i2, this.data, this.wpos, 4);
        this.wpos += 4;
    }

    @Override
    public int putBuffer(Readable buffer, boolean expand) {
        int required = expand ? buffer.available() : Math.min(buffer.available(), this.capacity());
        this.ensureCapacity(required);
        buffer.getRawBytes(this.data, this.wpos, required);
        this.wpos += required;
        return required;
    }

    @Override
    public void putBuffer(ByteBuffer buffer) {
        int required = buffer.remaining();
        this.ensureCapacity(required + 4);
        this.putUInt(required);
        buffer.get(this.data, this.wpos, required);
        this.wpos += required;
    }

    @Override
    public void putBytes(byte[] b, int off, int len) {
        ValidateUtils.checkTrue(len >= 0, "Negative raw bytes length: %d", len);
        if (this.wpos + 4 + len > this.data.length) {
            this.ensureCapacity(4 + len);
        }
        BufferUtils.putUInt(len, this.data, this.wpos, 4);
        this.wpos += 4;
        System.arraycopy(b, off, this.data, this.wpos, len);
        this.wpos += len;
    }

    @Override
    public void putRawBytes(byte[] d, int off, int len) {
        ValidateUtils.checkTrue(len >= 0, "Negative raw bytes length: %d", len);
        if (this.wpos + len > this.data.length) {
            this.ensureCapacity(len);
        }
        System.arraycopy(d, off, this.data, this.wpos, len);
        this.wpos += len;
    }

    @Override
    public String getString(Charset charset) {
        Objects.requireNonNull(charset, "No charset specified");
        int reqLen = this.getInt();
        int len = this.ensureAvailable(reqLen);
        String s = new String(this.data, this.rpos, len, charset);
        this.rpos += len;
        return s;
    }

    @Override
    public void getRawBytes(byte[] buf, int off, int len) {
        this.ensureAvailable(len);
        this.copyRawBytes(0, buf, off, len);
        this.rpos += len;
    }

    @Override
    protected void copyRawBytes(int offset, byte[] buf, int pos, int len) {
        if (offset < 0 || pos < 0 || len < 0) {
            throw new IndexOutOfBoundsException("Invalid offset(" + offset + ")/position(" + pos + ")/length(" + len + ") required");
        }
        System.arraycopy(this.data, this.rpos + offset, buf, pos, len);
    }

    @Override
    public Buffer ensureCapacity(int capacity, IntUnaryOperator growthFactor) {
        ValidateUtils.checkTrue(capacity >= 0, "Negative capacity requested: %d", capacity);
        int maxSize = this.size();
        int curPos = this.wpos();
        int remaining = maxSize - curPos;
        if (remaining < capacity) {
            int minimum = curPos + capacity;
            int actual = growthFactor.applyAsInt(minimum);
            if (actual < minimum) {
                throw new IllegalStateException("ensureCapacity(" + capacity + ") actual (" + actual + ") below min. (" + minimum + ")");
            }
            byte[] tmp = new byte[actual];
            System.arraycopy(this.data, 0, tmp, 0, this.data.length);
            this.data = tmp;
        }
        return this;
    }

    @Override
    protected int size() {
        return this.data.length;
    }

    public static ByteArrayBuffer getCompactClone(byte[] data) {
        return ByteArrayBuffer.getCompactClone(data, 0, NumberUtils.length(data));
    }

    public static ByteArrayBuffer getCompactClone(byte[] data, int offset, int len) {
        byte[] clone;
        byte[] byArray = clone = len > 0 ? new byte[len] : GenericUtils.EMPTY_BYTE_ARRAY;
        if (len > 0) {
            System.arraycopy(data, offset, clone, 0, len);
        }
        return new ByteArrayBuffer(clone, true);
    }
}

