/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.future;

import java.io.IOException;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.apache.sshd.common.future.CancelOption;

public interface WaitableFuture {
    public Object getId();

    default public boolean await() throws IOException {
        return this.await(new CancelOption[0]);
    }

    default public boolean await(CancelOption ... options) throws IOException {
        return this.await(Long.MAX_VALUE, options);
    }

    default public boolean await(long timeout2, TimeUnit unit) throws IOException {
        return this.await(timeout2, unit, new CancelOption[0]);
    }

    default public boolean await(long timeout2, TimeUnit unit, CancelOption ... options) throws IOException {
        return this.await(unit.toMillis(timeout2), options);
    }

    default public boolean await(Duration timeout2) throws IOException {
        return this.await(timeout2, new CancelOption[0]);
    }

    default public boolean await(Duration timeout2, CancelOption ... options) throws IOException {
        return timeout2 != null ? this.await(timeout2.toMillis(), options) : this.await(options);
    }

    default public boolean await(long timeoutMillis) throws IOException {
        return this.await(timeoutMillis, new CancelOption[0]);
    }

    public boolean await(long var1, CancelOption ... var3) throws IOException;

    default public boolean awaitUninterruptibly() {
        return this.awaitUninterruptibly(new CancelOption[0]);
    }

    default public boolean awaitUninterruptibly(CancelOption ... options) {
        return this.awaitUninterruptibly(Long.MAX_VALUE, options);
    }

    default public boolean awaitUninterruptibly(long timeout2, TimeUnit unit) {
        return this.awaitUninterruptibly(timeout2, unit, new CancelOption[0]);
    }

    default public boolean awaitUninterruptibly(long timeout2, TimeUnit unit, CancelOption ... options) {
        return this.awaitUninterruptibly(unit.toMillis(timeout2), options);
    }

    default public boolean awaitUninterruptibly(Duration timeoutMillis) {
        return this.awaitUninterruptibly(timeoutMillis, new CancelOption[0]);
    }

    default public boolean awaitUninterruptibly(Duration timeoutMillis, CancelOption ... options) {
        return timeoutMillis != null ? this.awaitUninterruptibly(timeoutMillis.toMillis(), options) : this.awaitUninterruptibly(options);
    }

    default public boolean awaitUninterruptibly(long timeoutMillis) {
        return this.awaitUninterruptibly(timeoutMillis, new CancelOption[0]);
    }

    public boolean awaitUninterruptibly(long var1, CancelOption ... var3);

    public boolean isDone();
}

