/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.future;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.StreamCorruptedException;
import java.net.ConnectException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.future.CancelFuture;
import org.apache.sshd.common.future.CancelOption;
import org.apache.sshd.common.future.SshFuture;
import org.apache.sshd.common.future.SshFutureListener;
import org.apache.sshd.common.util.ExceptionUtils;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;
import org.apache.sshd.common.util.threads.ThreadUtils;

public abstract class AbstractSshFuture<T extends SshFuture<T>>
extends AbstractLoggingBean
implements SshFuture<T> {
    private final Object id;

    protected AbstractSshFuture(Object id) {
        this.id = id;
    }

    @Override
    public Object getId() {
        return this.id;
    }

    @Override
    public boolean await(long timeoutMillis, CancelOption ... options) throws IOException {
        return this.await0(timeoutMillis, true, options) != null;
    }

    @Override
    public boolean awaitUninterruptibly(long timeoutMillis, CancelOption ... options) {
        try {
            return this.await0(timeoutMillis, false, options) != null;
        }
        catch (InterruptedIOException e) {
            throw this.formatExceptionMessage(msg -> new IllegalStateException((String)msg, e), "Unexpected interrupted exception wile awaitUninterruptibly %d msec: %s", timeoutMillis, e.getMessage());
        }
    }

    protected <R> R verifyResult(Class<? extends R> expectedType, long timeout2, CancelOption ... options) throws IOException {
        Object value = this.await0(timeout2, true, options);
        if (value == null) {
            TimeoutException cause = new TimeoutException("Timed out after " + timeout2 + " msec");
            throw this.formatExceptionMessage(msg -> new SshException((String)msg, (Throwable)cause), "Failed to get operation result within specified timeout: %s msec", timeout2);
        }
        if (value == GenericUtils.NULL) {
            return null;
        }
        Class<Object> actualType = value.getClass();
        if (expectedType.isAssignableFrom(actualType)) {
            return expectedType.cast(value);
        }
        if (value instanceof CancelFuture) {
            if ((value = ((CancelFuture)value).getBackTrace()) == null) {
                value = new CancellationException("Operation was cancelled before");
            }
            actualType = CancellationException.class;
        }
        if (Throwable.class.isAssignableFrom(actualType)) {
            Throwable t = ExceptionUtils.peelException((Throwable)value);
            if (t instanceof SshException) {
                throw new SshException(((SshException)t).getDisconnectCode(), t.getMessage(), t);
            }
            Throwable cause = t instanceof ConnectException ? t : ExceptionUtils.resolveExceptionCause(t);
            throw this.formatExceptionMessage(msg -> new SshException((String)msg, cause), "Failed (%s) to execute: %s", t.getClass().getSimpleName(), t.getMessage());
        }
        throw this.formatExceptionMessage(StreamCorruptedException::new, "Unknown result type: %s", actualType.getName());
    }

    protected abstract Object await0(long var1, boolean var3, CancelOption ... var4) throws InterruptedIOException;

    protected SshFutureListener<T> asListener(Object o) {
        return (SshFutureListener)o;
    }

    protected void notifyListener(SshFutureListener<T> l) {
        try {
            Object arg = this.asT();
            ThreadUtils.runAsInternal(() -> {
                l.operationComplete(arg);
                return null;
            });
        }
        catch (Throwable t) {
            this.warn("notifyListener({}) failed ({}) to invoke {}: {}", this, t.getClass().getSimpleName(), l, t.getMessage(), t);
        }
    }

    protected T asT() {
        return (T)this;
    }

    protected <E extends Throwable> E formatExceptionMessage(Function<? super String, ? extends E> exceptionCreator, String format, Object ... args) {
        String messagePayload = String.format(format, args);
        String excMessage = this.getClass().getSimpleName() + "[" + this.getId() + "]: " + messagePayload;
        return (E)((Throwable)exceptionCreator.apply(excMessage));
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[id=" + this.getId() + "]";
    }
}

