/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.file.root;

import java.nio.file.InvalidPathException;
import java.nio.file.Path;

public final class RootedFileSystemUtils {
    private RootedFileSystemUtils() {
    }

    public static void validateSafeRelativeSymlink(Path target) {
        int numNames = 0;
        int numCdUps = 0;
        for (int i2 = 0; i2 < target.getNameCount(); ++i2) {
            if ("..".equals(target.getName(i2).toString())) {
                ++numCdUps;
            } else if (!".".equals(target.getName(i2).toString())) {
                ++numNames;
            }
            if (numCdUps <= numNames) continue;
            throw new InvalidPathException(target.toString(), "Symlink would exit chroot: " + target);
        }
    }
}

