/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.config.keys;

import java.io.IOException;
import java.io.StreamCorruptedException;
import java.security.KeyPair;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Objects;
import org.apache.sshd.common.AlgorithmNameProvider;
import org.apache.sshd.common.Factory;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.digest.Digest;
import org.apache.sshd.common.keyprovider.KeyIdentityProvider;
import org.apache.sshd.common.keyprovider.KeySizeIndicator;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;

public class KeyRandomArt
implements AlgorithmNameProvider,
KeySizeIndicator {
    public static final int FLDBASE = 8;
    public static final int FLDSIZE_Y = 9;
    public static final int FLDSIZE_X = 17;
    public static final String AUGMENTATION_STRING = " .o+=*BOX@%&#/^SE";
    private final String algorithm;
    private final int keySize;
    private final char[][] field = new char[17][9];

    public KeyRandomArt(PublicKey key) throws Exception {
        this(key, KeyUtils.getDefaultFingerPrintFactory());
    }

    public KeyRandomArt(PublicKey key, Factory<? extends Digest> f) throws Exception {
        this(key, Objects.requireNonNull(f, "No digest factory").create());
    }

    public KeyRandomArt(PublicKey key, Digest d) throws Exception {
        this(Objects.requireNonNull(key, "No key provided").getAlgorithm(), KeyUtils.getKeySize(key), KeyUtils.getRawFingerprint(Objects.requireNonNull(d, "No key digest"), key));
    }

    public KeyRandomArt(String algorithm, int keySize, byte[] digest) {
        this.algorithm = ValidateUtils.checkNotNullAndNotEmpty(algorithm, "No algorithm provided");
        ValidateUtils.checkTrue(keySize > 0, "Invalid key size: %d", keySize);
        this.keySize = keySize;
        Objects.requireNonNull(digest, "No key digest provided");
        int x = 8;
        int y = 4;
        int len = AUGMENTATION_STRING.length() - 1;
        for (int i2 = 0; i2 < digest.length; ++i2) {
            int input = digest[i2] & 0xFF;
            for (int b = 0; b < 4; ++b) {
                x += (input & 1) != 0 ? 1 : -1;
                y += (input & 2) != 0 ? 1 : -1;
                x = Math.max(x, 0);
                y = Math.max(y, 0);
                if (this.field[x = Math.min(x, 16)][y = Math.min(y, 8)] < len - 2) {
                    char[] cArray = this.field[x];
                    int n = y;
                    cArray[n] = (char)(cArray[n] + '\u0001');
                }
                input >>= 2;
            }
        }
        this.field[8][4] = (char)(len - 1);
        this.field[x][y] = (char)len;
    }

    @Override
    public String getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public int getKeySize() {
        return this.keySize;
    }

    public <A extends Appendable> A append(A sb) throws IOException {
        String s = String.format("+--[%4s %4d]", this.getAlgorithm(), this.getKeySize());
        sb.append(s);
        for (int index = s.length(); index <= 17; ++index) {
            sb.append('-');
        }
        sb.append('+');
        sb.append('\n');
        int len = AUGMENTATION_STRING.length() - 1;
        for (int y = 0; y < 9; ++y) {
            sb.append('|');
            for (int x = 0; x < 17; ++x) {
                char ch = this.field[x][y];
                sb.append(AUGMENTATION_STRING.charAt(Math.min(ch, len)));
            }
            sb.append('|');
            sb.append('\n');
        }
        sb.append('+');
        for (int index = 0; index < 17; ++index) {
            sb.append('-');
        }
        sb.append('+');
        sb.append('\n');
        return sb;
    }

    public String toString() {
        try {
            return this.append(new StringBuilder(252)).toString();
        }
        catch (IOException e) {
            return e.getClass().getSimpleName();
        }
    }

    public static String combine(char separator, Collection<? extends KeyRandomArt> arts) {
        if (GenericUtils.isEmpty(arts)) {
            return "";
        }
        try {
            return KeyRandomArt.combine(new StringBuilder(arts.size() * 21 * 12), separator, arts).toString();
        }
        catch (IOException e) {
            return e.getClass().getSimpleName();
        }
    }

    public static String combine(SessionContext session, char separator, KeyIdentityProvider provider) throws Exception {
        return KeyRandomArt.combine(session, new StringBuilder(1008), separator, provider).toString();
    }

    public static <A extends Appendable> A combine(SessionContext session, A sb, char separator, KeyIdentityProvider provider) throws Exception {
        return KeyRandomArt.combine(sb, separator, KeyRandomArt.generate(session, provider));
    }

    public static Collection<KeyRandomArt> generate(SessionContext session, KeyIdentityProvider provider) throws Exception {
        Iterator<KeyPair> iter;
        Iterable<KeyPair> keys2 = provider == null ? null : provider.loadKeys(session);
        Iterator<KeyPair> iterator2 = iter = keys2 == null ? null : keys2.iterator();
        if (iter == null || !iter.hasNext()) {
            return Collections.emptyList();
        }
        LinkedList<KeyRandomArt> arts = new LinkedList<KeyRandomArt>();
        do {
            KeyPair kp = iter.next();
            KeyRandomArt a = new KeyRandomArt(kp.getPublic());
            arts.add(a);
        } while (iter.hasNext());
        return arts;
    }

    /*
     * WARNING - void declaration
     */
    public static <A extends Appendable> A combine(A sb, char separator, Collection<? extends KeyRandomArt> arts) throws IOException {
        if (GenericUtils.isEmpty(arts)) {
            return sb;
        }
        ArrayList<String[]> allLines = new ArrayList<String[]>(arts.size());
        int numLines = -1;
        for (KeyRandomArt keyRandomArt : arts) {
            String s = keyRandomArt.toString();
            String[] lines = GenericUtils.split(s, '\n');
            if (numLines <= 0) {
                numLines = lines.length;
            } else if (numLines != lines.length) {
                throw new StreamCorruptedException("Mismatched lines count: expected=" + numLines + ", actual=" + lines.length);
            }
            for (int index = 0; index < lines.length; ++index) {
                String l = lines[index];
                if (l.length() <= 0 || l.charAt(l.length() - 1) != '\r') continue;
                lines[index] = l = l.substring(0, l.length() - 1);
            }
            allLines.add(lines);
        }
        for (int row = 0; row < numLines; ++row) {
            void var6_9;
            boolean bl = false;
            while (var6_9 < allLines.size()) {
                String[] lines = (String[])allLines.get((int)var6_9);
                String l = lines[row];
                sb.append(l);
                if (var6_9 > 0 && separator != '\u0000') {
                    sb.append(separator);
                }
                ++var6_9;
            }
            sb.append('\n');
        }
        return sb;
    }
}

