/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.cipher;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import org.apache.sshd.common.cipher.BaseCipher;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;

public class BaseCTRCipher
extends BaseCipher {
    private long blocksProcessed;

    public BaseCTRCipher(int ivsize, int authSize, int kdfSize, String algorithm, int keySize, String transformation, int blkSize) {
        super(ivsize, authSize, kdfSize, algorithm, keySize, transformation, blkSize);
    }

    @Override
    public void update(byte[] input, int inputOffset, int inputLen) throws Exception {
        this.blocksProcessed += (long)(inputLen / this.getCipherBlockSize());
        super.update(input, inputOffset, inputLen);
    }

    @Override
    protected void reInit(byte[] processed, int offset, int length) throws InvalidKeyException, InvalidAlgorithmParameterException {
        super.reInit(processed, offset, length);
        this.blocksProcessed = 0L;
    }

    @Override
    protected AlgorithmParameterSpec determineNewParameters(byte[] processed, int offset, int length) {
        byte[] iv = (byte[])this.getCipherInstance().getIV().clone();
        ByteArrayBuffer buf = new ByteArrayBuffer(iv, iv.length - 8, 8);
        long unsigned = buf.getLong();
        long highBitBefore = unsigned & Long.MIN_VALUE;
        unsigned &= Long.MAX_VALUE;
        long highBitNow = (unsigned += this.blocksProcessed) & Long.MIN_VALUE;
        unsigned = unsigned & Long.MAX_VALUE | highBitBefore ^ highBitNow;
        int carry = (int)((highBitBefore & highBitNow) >>> 63);
        this.addCarry(iv, iv.length - 8, carry);
        buf.wpos(iv.length - 8);
        buf.putLong(unsigned);
        return new IvParameterSpec(iv);
    }

    private void addCarry(byte[] iv, int length, int carry) {
        int add = carry;
        for (int i2 = length - 1; i2 >= 0; --i2) {
            int b = (iv[i2] & 0xFF) + add;
            iv[i2] = (byte)b;
            add = b >> 8;
        }
    }
}

