/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.config.keys;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.util.Collection;
import java.util.Objects;
import org.apache.sshd.client.config.keys.LazyClientKeyIdentityProvider;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.config.keys.FilePasswordProvider;
import org.apache.sshd.common.keyprovider.KeyIdentityProvider;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.io.IoUtils;
import org.apache.sshd.common.util.io.resource.PathResource;
import org.apache.sshd.common.util.security.SecurityUtils;

public interface ClientIdentityLoader {
    public static final ClientIdentityLoader DEFAULT = new ClientIdentityLoader(){

        @Override
        public boolean isValidLocation(NamedResource location) throws IOException {
            Path path = this.toPath(location);
            return Files.exists(path, IoUtils.EMPTY_LINK_OPTIONS);
        }

        @Override
        public Iterable<KeyPair> loadClientIdentities(SessionContext session, NamedResource location, FilePasswordProvider provider) throws IOException, GeneralSecurityException {
            Path path = this.toPath(location);
            PathResource resource = new PathResource(path);
            try (InputStream inputStream2 = resource.openInputStream();){
                Iterable<KeyPair> iterable = SecurityUtils.loadKeyPairIdentities(session, resource, inputStream2, provider);
                return iterable;
            }
        }

        public String toString() {
            return "DEFAULT";
        }

        private Path toPath(NamedResource location) {
            Objects.requireNonNull(location, "No location provided");
            Path path = Paths.get(ValidateUtils.hasContent(location.getName(), "No location value for %s", (Object)location), new String[0]);
            path = path.toAbsolutePath();
            path = path.normalize();
            return path;
        }
    };

    public boolean isValidLocation(NamedResource var1) throws IOException;

    public Iterable<KeyPair> loadClientIdentities(SessionContext var1, NamedResource var2, FilePasswordProvider var3) throws IOException, GeneralSecurityException;

    public static KeyIdentityProvider asKeyIdentityProvider(ClientIdentityLoader loader, Collection<? extends NamedResource> locations, FilePasswordProvider passwordProvider, boolean ignoreNonExisting) {
        return GenericUtils.isEmpty(locations) ? KeyIdentityProvider.EMPTY_KEYS_PROVIDER : new LazyClientKeyIdentityProvider(loader, locations, passwordProvider, ignoreNonExisting);
    }
}

