/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.similarity;

import java.util.HashSet;
import org.apache.commons.text.similarity.SimilarityInput;
import org.apache.commons.text.similarity.SimilarityScore;

public class JaccardSimilarity
implements SimilarityScore<Double> {
    static final JaccardSimilarity INSTANCE = new JaccardSimilarity();

    @Override
    public Double apply(CharSequence left, CharSequence right) {
        return this.apply(SimilarityInput.input(left), SimilarityInput.input(right));
    }

    @Override
    public <E> Double apply(SimilarityInput<E> left, SimilarityInput<E> right) {
        if (left == null || right == null) {
            throw new IllegalArgumentException("Input cannot be null");
        }
        int leftLength = left.length();
        int rightLength = right.length();
        if (leftLength == 0 && rightLength == 0) {
            return 1.0;
        }
        if (leftLength == 0 || rightLength == 0) {
            return 0.0;
        }
        HashSet<E> leftSet = new HashSet<E>();
        for (int i2 = 0; i2 < leftLength; ++i2) {
            leftSet.add(left.at(i2));
        }
        HashSet<E> rightSet = new HashSet<E>();
        for (int i3 = 0; i3 < rightLength; ++i3) {
            rightSet.add(right.at(i3));
        }
        HashSet<E> unionSet = new HashSet<E>(leftSet);
        unionSet.addAll(rightSet);
        int intersectionSize = leftSet.size() + rightSet.size() - unionSet.size();
        return 1.0 * (double)intersectionSize / (double)unionSet.size();
    }
}

