/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.exec;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.function.Supplier;
import org.apache.commons.exec.ThreadUtil;
import org.apache.commons.exec.TimeoutObserver;

public class Watchdog
implements Runnable {
    private final List<TimeoutObserver> observers = new ArrayList<TimeoutObserver>(1);
    private final Duration timeout;
    private boolean stopped;
    private final ThreadFactory threadFactory;

    public static Builder builder() {
        return new Builder();
    }

    private Watchdog(Builder builder) {
        if (builder.timeout.isNegative() || Duration.ZERO.equals(builder.timeout)) {
            throw new IllegalArgumentException("Timeout must be positive.");
        }
        this.timeout = builder.timeout;
        this.threadFactory = builder.threadFactory;
    }

    @Deprecated
    public Watchdog(long timeoutMillis) {
        this(Watchdog.builder().setTimeout(Duration.ofMillis(timeoutMillis)));
    }

    public void addTimeoutObserver(TimeoutObserver to) {
        this.observers.add(to);
    }

    protected final void fireTimeoutOccured() {
        this.observers.forEach(o -> o.timeoutOccured(this));
    }

    ThreadFactory getThreadFactory() {
        return this.threadFactory;
    }

    public Duration getTimeout() {
        return this.timeout;
    }

    public void removeTimeoutObserver(TimeoutObserver to) {
        this.observers.remove(to);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean isWaiting;
        long startTimeMillis = System.currentTimeMillis();
        Watchdog watchdog = this;
        synchronized (watchdog) {
            long timeoutMillis = this.timeout.toMillis();
            long timeLeftMillis = timeoutMillis - (System.currentTimeMillis() - startTimeMillis);
            boolean bl = isWaiting = timeLeftMillis > 0L;
            while (!this.stopped && isWaiting) {
                try {
                    this.wait(timeLeftMillis);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                timeLeftMillis = timeoutMillis - (System.currentTimeMillis() - startTimeMillis);
                isWaiting = timeLeftMillis > 0L;
            }
        }
        if (!isWaiting) {
            this.fireTimeoutOccured();
        }
    }

    public synchronized void start() {
        this.stopped = false;
        ThreadUtil.newThread(this.threadFactory, this, "CommonsExecWatchdog-", true).start();
    }

    public synchronized void stop() {
        this.stopped = true;
        this.notifyAll();
    }

    public static final class Builder
    implements Supplier<Watchdog> {
        private static final Duration DEFAULT_TIMEOUT = Duration.ofSeconds(30L);
        private ThreadFactory threadFactory = Executors.defaultThreadFactory();
        private Duration timeout = DEFAULT_TIMEOUT;

        @Override
        public Watchdog get() {
            return new Watchdog(this);
        }

        public Builder setThreadFactory(ThreadFactory threadFactory) {
            this.threadFactory = threadFactory != null ? threadFactory : Executors.defaultThreadFactory();
            return this;
        }

        public Builder setTimeout(Duration timeout2) {
            this.timeout = timeout2 != null ? timeout2 : DEFAULT_TIMEOUT;
            return this;
        }
    }
}

