/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import okhttp3.internal._NormalizeJvmKt;
import okhttp3.internal._UtilCommonKt;
import okhttp3.internal.idn.IdnaMappingTableInstanceKt;
import okhttp3.internal.idn.Punycode;
import okio.Buffer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\f\u001a\n\u0010\u0002\u001a\u00020\u0003*\u00020\u0004\u001a\f\u0010\u0005\u001a\u00020\u0003*\u00020\u0004H\u0000\u001a\f\u0010\u0006\u001a\u00020\u0003*\u00020\u0004H\u0000\u001a\"\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0000\u001a0\u0010\r\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u000bH\u0000\u001a\u0010\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\bH\u0000\u001a\u0010\u0010\u0011\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\bH\u0000\u001a\u0010\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\bH\u0002\u001a\u0010\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\bH\u0000\u001a\u000e\u0010\u0014\u001a\u0004\u0018\u00010\u0004*\u00020\u0004H\u0000\u001a\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0016\u001a\u00020\u0004H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"VERIFY_AS_IP_ADDRESS", "Lkotlin/text/Regex;", "canParseAsIpAddress", "", "", "containsInvalidLabelLengths", "containsInvalidHostnameAsciiCodes", "decodeIpv6", "", "input", "pos", "", "limit", "decodeIpv4Suffix", "address", "addressOffset", "inet6AddressToAscii", "canonicalizeInetAddress", "isMappedIpv4Address", "inet4AddressToAscii", "toCanonicalHost", "idnToAscii", "host", "okhttp"})
public final class _HostnamesCommonKt {
    @NotNull
    private static final Regex VERIFY_AS_IP_ADDRESS = new Regex("([0-9a-fA-F]*:[0-9a-fA-F:.]*)|([\\d.]+)");

    public static final boolean canParseAsIpAddress(@NotNull String $this$canParseAsIpAddress) {
        Intrinsics.checkNotNullParameter($this$canParseAsIpAddress, "<this>");
        return VERIFY_AS_IP_ADDRESS.matches($this$canParseAsIpAddress);
    }

    public static final boolean containsInvalidLabelLengths(@NotNull String $this$containsInvalidLabelLengths) {
        Intrinsics.checkNotNullParameter($this$containsInvalidLabelLengths, "<this>");
        int n = $this$containsInvalidLabelLengths.length();
        if (!(1 <= n ? n < 254 : false)) {
            return true;
        }
        int labelStart = 0;
        while (true) {
            int dot;
            int labelLength;
            int n2 = labelLength = (dot = StringsKt.indexOf$default((CharSequence)$this$containsInvalidLabelLengths, '.', labelStart, false, 4, null)) == -1 ? $this$containsInvalidLabelLengths.length() - labelStart : dot - labelStart;
            if (!(1 <= labelLength ? labelLength < 64 : false)) {
                return true;
            }
            if (dot == -1 || dot == $this$containsInvalidLabelLengths.length() - 1) break;
            labelStart = dot + 1;
        }
        return false;
    }

    public static final boolean containsInvalidHostnameAsciiCodes(@NotNull String $this$containsInvalidHostnameAsciiCodes) {
        Intrinsics.checkNotNullParameter($this$containsInvalidHostnameAsciiCodes, "<this>");
        int n = $this$containsInvalidHostnameAsciiCodes.length();
        for (int i2 = 0; i2 < n; ++i2) {
            char c = $this$containsInvalidHostnameAsciiCodes.charAt(i2);
            if (Intrinsics.compare(c, 31) <= 0 || Intrinsics.compare(c, 127) >= 0) {
                return true;
            }
            if (StringsKt.indexOf$default((CharSequence)" #%/:?@[\\]", c, 0, false, 6, null) == -1) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static final byte[] decodeIpv6(@NotNull String input, int pos, int limit) {
        Intrinsics.checkNotNullParameter(input, "input");
        byte[] address = new byte[16];
        int b = 0;
        int compress = -1;
        int groupOffset = -1;
        int i2 = pos;
        while (i2 < limit) {
            int hexDigit;
            if (b == address.length) {
                return null;
            }
            if (i2 + 2 <= limit && StringsKt.startsWith$default(input, "::", i2, false, 4, null)) {
                if (compress != -1) {
                    return null;
                }
                compress = b += 2;
                if ((i2 += 2) == limit) {
                    break;
                }
            } else if (b != 0 && !StringsKt.startsWith$default(input, ":", i2, false, 4, null)) {
                if (StringsKt.startsWith$default(input, ".", i2, false, 4, null)) {
                    if (!_HostnamesCommonKt.decodeIpv4Suffix(input, groupOffset, limit, address, b - 2)) {
                        return null;
                    }
                    b += 2;
                    break;
                }
                return null;
            }
            int value = 0;
            groupOffset = ++i2;
            while (i2 < limit && (hexDigit = _UtilCommonKt.parseHexDigit(input.charAt(i2))) != -1) {
                value = (value << 4) + hexDigit;
                ++i2;
            }
            int groupLength = i2 - groupOffset;
            if (groupLength == 0 || groupLength > 4) {
                return null;
            }
            address[b++] = (byte)(value >>> 8 & 0xFF);
            address[b++] = (byte)(value & 0xFF);
        }
        if (b != address.length) {
            if (compress == -1) {
                return null;
            }
            ArraysKt.copyInto(address, address, address.length - (b - compress), compress, b);
            ArraysKt.fill(address, (byte)0, compress, compress + (address.length - b));
        }
        return address;
    }

    public static final boolean decodeIpv4Suffix(@NotNull String input, int pos, int limit, @NotNull byte[] address, int addressOffset) {
        Intrinsics.checkNotNullParameter(input, "input");
        Intrinsics.checkNotNullParameter(address, "address");
        int b = addressOffset;
        int i2 = pos;
        while (i2 < limit) {
            char c;
            if (b == address.length) {
                return false;
            }
            if (b != addressOffset && input.charAt(i2) != '.') {
                return false;
            }
            int value = 0;
            int groupOffset = ++i2;
            while (i2 < limit && Intrinsics.compare(c = input.charAt(i2), 48) >= 0 && Intrinsics.compare(c, 57) <= 0) {
                if (value == 0 && groupOffset != i2) {
                    return false;
                }
                if ((value = value * 10 + c - 48) > 255) {
                    return false;
                }
                ++i2;
            }
            int groupLength = i2 - groupOffset;
            if (groupLength == 0) {
                return false;
            }
            address[b++] = (byte)value;
        }
        return b == addressOffset + 4;
    }

    @NotNull
    public static final String inet6AddressToAscii(@NotNull byte[] address) {
        int i2;
        Intrinsics.checkNotNullParameter(address, "address");
        int longestRunOffset = 0;
        longestRunOffset = -1;
        int longestRunLength = 0;
        boolean bl = false;
        for (i2 = 0; i2 < address.length; i2 += 2) {
            int currentRunOffset = i2;
            while (i2 < 16 && address[i2] == 0 && address[i2 + 1] == 0) {
                i2 += 2;
            }
            int currentRunLength = i2 - currentRunOffset;
            if (currentRunLength <= longestRunLength || currentRunLength < 4) continue;
            longestRunOffset = currentRunOffset;
            longestRunLength = currentRunLength;
        }
        Buffer result = new Buffer();
        i2 = 0;
        while (i2 < address.length) {
            if (i2 == longestRunOffset) {
                result.writeByte(58);
                if ((i2 += longestRunLength) != 16) continue;
                result.writeByte(58);
                continue;
            }
            if (i2 > 0) {
                result.writeByte(58);
            }
            int group = _UtilCommonKt.and(address[i2], 255) << 8 | _UtilCommonKt.and(address[i2 + 1], 255);
            result.writeHexadecimalUnsignedLong(group);
            i2 += 2;
        }
        return result.readUtf8();
    }

    @NotNull
    public static final byte[] canonicalizeInetAddress(@NotNull byte[] address) {
        Intrinsics.checkNotNullParameter(address, "address");
        return _HostnamesCommonKt.isMappedIpv4Address(address) ? ArraysKt.sliceArray(address, RangesKt.until(12, 16)) : address;
    }

    private static final boolean isMappedIpv4Address(byte[] address) {
        if (address.length != 16) {
            return false;
        }
        for (int i2 = 0; i2 < 10; ++i2) {
            if (address[i2] == 0) continue;
            return false;
        }
        if (address[10] != -1) {
            return false;
        }
        return address[11] == -1;
    }

    @NotNull
    public static final String inet4AddressToAscii(@NotNull byte[] address) {
        Intrinsics.checkNotNullParameter(address, "address");
        if (!(address.length == 4)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        return new Buffer().writeDecimalLong(_UtilCommonKt.and(address[0], 255)).writeByte(46).writeDecimalLong(_UtilCommonKt.and(address[1], 255)).writeByte(46).writeDecimalLong(_UtilCommonKt.and(address[2], 255)).writeByte(46).writeDecimalLong(_UtilCommonKt.and(address[3], 255)).readUtf8();
    }

    @Nullable
    public static final String toCanonicalHost(@NotNull String $this$toCanonicalHost) {
        Intrinsics.checkNotNullParameter($this$toCanonicalHost, "<this>");
        String host = $this$toCanonicalHost;
        if (StringsKt.contains$default((CharSequence)host, ":", false, 2, null)) {
            byte[] byArray = StringsKt.startsWith$default(host, "[", false, 2, null) && StringsKt.endsWith$default(host, "]", false, 2, null) ? _HostnamesCommonKt.decodeIpv6(host, 1, host.length() - 1) : _HostnamesCommonKt.decodeIpv6(host, 0, host.length());
            if (byArray == null) {
                return null;
            }
            byte[] inetAddressByteArray = byArray;
            byte[] address = _HostnamesCommonKt.canonicalizeInetAddress(inetAddressByteArray);
            if (address.length == 16) {
                return _HostnamesCommonKt.inet6AddressToAscii(address);
            }
            if (address.length == 4) {
                return _HostnamesCommonKt.inet4AddressToAscii(address);
            }
            throw new AssertionError((Object)("Invalid IPv6 address: '" + host + '\''));
        }
        String string = _HostnamesCommonKt.idnToAscii(host);
        if (string == null) {
            return null;
        }
        String result = string;
        if (((CharSequence)result).length() == 0) {
            return null;
        }
        if (_HostnamesCommonKt.containsInvalidHostnameAsciiCodes(result)) {
            return null;
        }
        if (_HostnamesCommonKt.containsInvalidLabelLengths(result)) {
            return null;
        }
        return result;
    }

    @Nullable
    public static final String idnToAscii(@NotNull String host) {
        Intrinsics.checkNotNullParameter(host, "host");
        Buffer bufferA = new Buffer().writeUtf8(host);
        Buffer bufferB = new Buffer();
        while (!bufferA.exhausted()) {
            int codePoint = bufferA.readUtf8CodePoint();
            if (IdnaMappingTableInstanceKt.getIDNA_MAPPING_TABLE().map(codePoint, bufferB)) continue;
            return null;
        }
        String normalized = _NormalizeJvmKt.normalizeNfc(bufferB.readUtf8());
        bufferA.writeUtf8(normalized);
        String string = Punycode.INSTANCE.decode(bufferA.readUtf8());
        if (string == null) {
            return null;
        }
        String decoded = string;
        if (!Intrinsics.areEqual(decoded, _NormalizeJvmKt.normalizeNfc(decoded))) {
            return null;
        }
        return Punycode.INSTANCE.encode(decoded);
    }
}

