/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import kotlin.sequences.SequencesKt;
import okhttp3.internal.Tags;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B%\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u0006\u0010\u0006\u001a\u00028\u0000\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0004\b\b\u0010\tJ/\u0010\u000b\u001a\u00020\u0003\"\b\b\u0001\u0010\f*\u00020\u00022\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u0002H\f0\u00052\b\u0010\u0006\u001a\u0004\u0018\u0001H\fH\u0016\u00a2\u0006\u0002\u0010\rJ(\u0010\u000e\u001a\u0004\u0018\u0001H\f\"\b\b\u0001\u0010\f*\u00020\u00022\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u0002H\f0\u0005H\u0096\u0002\u00a2\u0006\u0002\u0010\u000fJ\b\u0010\u0010\u001a\u00020\u0011H\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00028\u0000X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR\u000e\u0010\u0007\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lokhttp3/internal/LinkedTags;", "K", "", "Lokhttp3/internal/Tags;", "key", "Lkotlin/reflect/KClass;", "value", "next", "<init>", "(Lkotlin/reflect/KClass;Ljava/lang/Object;Lokhttp3/internal/Tags;)V", "Ljava/lang/Object;", "plus", "T", "(Lkotlin/reflect/KClass;Ljava/lang/Object;)Lokhttp3/internal/Tags;", "get", "(Lkotlin/reflect/KClass;)Ljava/lang/Object;", "toString", "", "okhttp"})
final class LinkedTags<K>
extends Tags {
    @NotNull
    private final KClass<K> key;
    @NotNull
    private final K value;
    @NotNull
    private final Tags next;

    public LinkedTags(@NotNull KClass<K> key, @NotNull K value, @NotNull Tags next) {
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(value, "value");
        Intrinsics.checkNotNullParameter(next, "next");
        super(null);
        this.key = key;
        this.value = value;
        this.next = next;
    }

    @Override
    @NotNull
    public <T> Tags plus(@NotNull KClass<T> key, @Nullable T value) {
        Tags tags;
        Intrinsics.checkNotNullParameter(key, "key");
        if (Intrinsics.areEqual(key, this.key)) {
            tags = this.next;
        } else {
            Tags nextMinusKey = this.next.plus(key, null);
            tags = nextMinusKey == this.next ? this : new LinkedTags<K>(this.key, this.value, nextMinusKey);
        }
        Tags thisMinusKey = tags;
        return value != null ? (Tags)new LinkedTags<T>(key, value, thisMinusKey) : thisMinusKey;
    }

    @Override
    @Nullable
    public <T> T get(@NotNull KClass<T> key) {
        Intrinsics.checkNotNullParameter(key, "key");
        return (T)(Intrinsics.areEqual(key, this.key) ? JvmClassMappingKt.getJavaClass(key).cast(this.value) : this.next.get(key));
    }

    @NotNull
    public String toString() {
        return CollectionsKt.joinToString$default(CollectionsKt.reversed((Iterable)SequencesKt.toList(SequencesKt.generateSequence(this, LinkedTags::toString$lambda$0))), null, "{", "}", 0, null, LinkedTags::toString$lambda$1, 25, null);
    }

    private static final LinkedTags toString$lambda$0(LinkedTags it) {
        Intrinsics.checkNotNullParameter(it, "it");
        Tags tags = it.next;
        return tags instanceof LinkedTags ? (LinkedTags)tags : null;
    }

    private static final CharSequence toString$lambda$1(LinkedTags it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return "" + it.key + '=' + it.value;
    }
}

