/*
 * Decompiled with CFR 0.152.
 */
package nl.altindag.ssl.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509ExtendedTrustManager;
import nl.altindag.ssl.SSLFactory;
import nl.altindag.ssl.exception.GenericIOException;
import nl.altindag.ssl.model.ClientConfig;
import nl.altindag.ssl.util.AuthenticatorUtils;
import nl.altindag.ssl.util.CertificateUtils;
import nl.altindag.ssl.util.ClientRunnable;
import nl.altindag.ssl.util.SSLSessionUtils;
import nl.altindag.ssl.util.TrustManagerUtils;
import nl.altindag.ssl.util.internal.CollectorsUtils;
import nl.altindag.sude.Logger;
import nl.altindag.sude.LoggerFactory;

public class CertificateExtractingClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(CertificateExtractingClient.class);
    private static final Pattern CA_ISSUERS_AUTHORITY_INFO_ACCESS = Pattern.compile("(?s)^AuthorityInfoAccess\\h+\\[\\R\\s*\\[\\R.*?accessMethod:\\h+caIssuers\\R\\h*accessLocation: URIName:\\h+(https?://\\S+)", 8);
    private static final Duration DEFAULT_TIMEOUT = Duration.ofSeconds(1L);
    private static CertificateExtractingClient instance;
    private final boolean shouldResolveRootCa;
    private final Proxy proxy;
    private final SSLFactory sslFactoryForCertificateCapturing;
    private final SSLFactory unsafeSslFactory;
    private final SSLSocketFactory unsafeSslSocketFactory;
    private final SSLSocketFactory certificateCapturingSslSocketFactory;
    private final List<X509Certificate> certificatesCollector;
    private final Duration timeout;
    private final ClientConfig clientConfig;
    private final ClientRunnable clientRunnable;

    private CertificateExtractingClient(boolean shouldResolveRootCa, Proxy proxy, PasswordAuthentication passwordAuthentication, Duration timeout2, ClientRunnable clientRunnable) {
        this.shouldResolveRootCa = shouldResolveRootCa;
        this.proxy = proxy;
        this.timeout = timeout2;
        this.clientRunnable = clientRunnable;
        if (passwordAuthentication != null) {
            Authenticator authenticator = AuthenticatorUtils.create(passwordAuthentication);
            Authenticator.setDefault(authenticator);
        }
        this.certificatesCollector = new CopyOnWriteArrayList<X509Certificate>();
        X509ExtendedTrustManager certificateCapturingTrustManager = TrustManagerUtils.createCertificateCapturingTrustManager(this.certificatesCollector);
        this.sslFactoryForCertificateCapturing = SSLFactory.builder().withTrustMaterial(certificateCapturingTrustManager).build();
        this.unsafeSslFactory = SSLFactory.builder().withUnsafeTrustMaterial().build();
        this.certificateCapturingSslSocketFactory = this.sslFactoryForCertificateCapturing.getSslSocketFactory();
        this.unsafeSslSocketFactory = this.unsafeSslFactory.getSslSocketFactory();
        this.clientConfig = new ClientConfig(this.sslFactoryForCertificateCapturing, proxy, passwordAuthentication, timeout2);
    }

    static CertificateExtractingClient getInstance() {
        if (instance == null) {
            instance = new CertificateExtractingClient(true, null, null, DEFAULT_TIMEOUT, null);
        }
        return instance;
    }

    public List<X509Certificate> get(String url) {
        try {
            URI uri = URI.create(url);
            if (this.clientRunnable != null) {
                this.clientRunnable.run(this.clientConfig, uri);
            } else if ("https".equalsIgnoreCase(uri.getScheme())) {
                HttpsURLConnection connection = (HttpsURLConnection)this.createConnection(uri.toURL());
                connection.setSSLSocketFactory(this.certificateCapturingSslSocketFactory);
                connection.setConnectTimeout((int)this.timeout.toMillis());
                connection.setReadTimeout((int)this.timeout.toMillis());
                connection.connect();
                connection.disconnect();
            } else {
                List<X509Certificate> connection = Collections.emptyList();
                return connection;
            }
            List resolvedRootCa = this.shouldResolveRootCa ? this.getRootCaFromChainIfPossible(this.certificatesCollector) : Collections.emptyList();
            List<X509Certificate> list = Stream.of(this.certificatesCollector, resolvedRootCa).flatMap(Collection::stream).collect(CollectorsUtils.toUnmodifiableList());
            return list;
        }
        catch (IOException exception) {
            if (exception instanceof SocketTimeoutException || exception.getCause() instanceof SocketTimeoutException) {
                LOGGER.debug(String.format("The client didn't get a respond within the configured time-out of [%d] milliseconds from: [%s]", this.timeout.toMillis(), url));
                List<X509Certificate> list = Collections.emptyList();
                return list;
            }
            throw new GenericIOException(String.format("Failed getting certificate from: [%s]", url), exception);
        }
        finally {
            this.certificatesCollector.clear();
            SSLSessionUtils.invalidateCaches(this.sslFactoryForCertificateCapturing);
        }
    }

    URLConnection createConnection(URL url) throws IOException {
        return this.proxy != null ? url.openConnection(this.proxy) : url.openConnection();
    }

    List<X509Certificate> getRootCaFromChainIfPossible(List<X509Certificate> certificates) {
        String subject;
        X509Certificate certificate;
        String issuer;
        boolean isSelfSignedCertificate;
        if (!certificates.isEmpty() && !(isSelfSignedCertificate = (issuer = (certificate = certificates.get(certificates.size() - 1)).getIssuerX500Principal().getName()).equals(subject = certificate.getSubjectX500Principal().getName()))) {
            return this.getRootCaIfPossible(certificate);
        }
        return Collections.emptyList();
    }

    List<X509Certificate> getRootCaIfPossible(X509Certificate x509Certificate) {
        List<X509Certificate> rootCaFromAuthorityInfoAccessExtension = this.getRootCaFromAuthorityInfoAccessExtensionIfPresent(x509Certificate);
        if (!rootCaFromAuthorityInfoAccessExtension.isEmpty()) {
            return rootCaFromAuthorityInfoAccessExtension;
        }
        List<X509Certificate> rootCaFromJdkTrustedCertificates = this.getRootCaFromJdkTrustedCertificates(x509Certificate);
        if (!rootCaFromJdkTrustedCertificates.isEmpty()) {
            return rootCaFromJdkTrustedCertificates;
        }
        return Collections.emptyList();
    }

    List<X509Certificate> getRootCaFromAuthorityInfoAccessExtensionIfPresent(X509Certificate certificate) {
        String certificateContent = certificate.toString();
        Matcher caIssuersMatcher = CA_ISSUERS_AUTHORITY_INFO_ACCESS.matcher(certificateContent);
        if (caIssuersMatcher.find()) {
            String issuerLocation = caIssuersMatcher.group(1);
            return this.getCertificatesFromRemoteFile(issuerLocation, certificate);
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<X509Certificate> getCertificatesFromRemoteFile(String issuerLocation, X509Certificate intermediateCertificate) {
        try {
            List<X509Certificate> list;
            block12: {
                URL url = URI.create(issuerLocation).toURL();
                URLConnection connection = this.createConnection(url);
                connection.setConnectTimeout((int)this.timeout.toMillis());
                connection.setReadTimeout((int)this.timeout.toMillis());
                if (connection instanceof HttpsURLConnection) {
                    ((HttpsURLConnection)connection).setSSLSocketFactory(this.unsafeSslSocketFactory);
                }
                InputStream inputStream2 = connection.getInputStream();
                try {
                    list = CertificateUtils.parseDerCertificate(inputStream2).stream().filter(X509Certificate.class::isInstance).map(X509Certificate.class::cast).filter(issuer -> this.isIssuerOfIntermediateCertificate(intermediateCertificate, (X509Certificate)issuer)).collect(CollectorsUtils.toUnmodifiableList());
                    if (inputStream2 == null) break block12;
                }
                catch (Throwable throwable) {
                    try {
                        if (inputStream2 != null) {
                            try {
                                inputStream2.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        LOGGER.debug(String.format("Skipped getting certificate from remote file while using the following location [%s]", issuerLocation), e);
                        List<X509Certificate> list2 = Collections.emptyList();
                        return list2;
                    }
                }
                inputStream2.close();
            }
            return list;
        }
        finally {
            SSLSessionUtils.invalidateCaches(this.unsafeSslFactory);
        }
    }

    List<X509Certificate> getRootCaFromJdkTrustedCertificates(X509Certificate intermediateCertificate) {
        List<X509Certificate> jdkTrustedCertificates = CertificateUtils.getJdkTrustedCertificates();
        return jdkTrustedCertificates.stream().filter(issuer -> this.isIssuerOfIntermediateCertificate(intermediateCertificate, (X509Certificate)issuer)).collect(CollectorsUtils.toUnmodifiableList());
    }

    boolean isIssuerOfIntermediateCertificate(X509Certificate intermediateCertificate, X509Certificate issuer) {
        try {
            intermediateCertificate.verify(issuer.getPublicKey());
            return true;
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | SignatureException | CertificateException e) {
            return false;
        }
    }

    List<X509Certificate> getCertificatesCollector() {
        return this.certificatesCollector;
    }

    public static Builder builder() {
        return new Builder();
    }

    static /* synthetic */ Duration access$000() {
        return DEFAULT_TIMEOUT;
    }

    public static class Builder {
        private Proxy proxy = null;
        private PasswordAuthentication passwordAuthentication = null;
        private boolean shouldResolveRootCa = true;
        private Duration timeout = CertificateExtractingClient.access$000();
        private ClientRunnable clientRunnable = null;

        public Builder withProxy(Proxy proxy) {
            this.proxy = proxy;
            return this;
        }

        public Builder withPasswordAuthentication(PasswordAuthentication passwordAuthentication) {
            this.passwordAuthentication = passwordAuthentication;
            return this;
        }

        public Builder withResolvedRootCa(boolean shouldResolveRootCa) {
            this.shouldResolveRootCa = shouldResolveRootCa;
            return this;
        }

        public Builder withTimeout(int timeoutInMilliseconds) {
            return this.withTimeout(Duration.ofMillis(timeoutInMilliseconds));
        }

        public Builder withTimeout(Duration timeout2) {
            this.timeout = timeout2;
            return this;
        }

        public Builder withClientRunnable(ClientRunnable clientRunnable) {
            this.clientRunnable = clientRunnable;
            return this;
        }

        public CertificateExtractingClient build() {
            return new CertificateExtractingClient(this.shouldResolveRootCa, this.proxy, this.passwordAuthentication, this.timeout, this.clientRunnable);
        }
    }
}

