/*
 * Decompiled with CFR 0.152.
 */
package com.trilead.ssh2.crypto.cipher;

import com.trilead.ssh2.crypto.cipher.BlockCipher;

public class CTRMode
implements BlockCipher {
    byte[] X;
    byte[] Xenc;
    BlockCipher bc;
    int blockSize;
    boolean doEncrypt;
    int count = 0;

    public void init(boolean forEncryption, byte[] key) {
    }

    public CTRMode(BlockCipher tc, byte[] iv, boolean doEnc) throws IllegalArgumentException {
        this.bc = tc;
        this.blockSize = this.bc.getBlockSize();
        this.doEncrypt = doEnc;
        if (this.blockSize != iv.length) {
            throw new IllegalArgumentException("IV must be " + this.blockSize + " bytes long! (currently " + iv.length + ")");
        }
        this.X = new byte[this.blockSize];
        this.Xenc = new byte[this.blockSize];
        System.arraycopy(iv, 0, this.X, 0, this.blockSize);
    }

    public final int getBlockSize() {
        return this.blockSize;
    }

    public final void transformBlock(byte[] src, int srcoff, byte[] dst, int dstoff) {
        int i2;
        this.bc.transformBlock(this.X, 0, this.Xenc, 0);
        for (i2 = 0; i2 < this.blockSize; ++i2) {
            dst[dstoff + i2] = (byte)(src[srcoff + i2] ^ this.Xenc[i2]);
        }
        for (i2 = this.blockSize - 1; i2 >= 0; --i2) {
            int n = i2;
            this.X[n] = (byte)(this.X[n] + 1);
            if (this.X[i2] != 0) break;
        }
    }
}

