/*
 * Decompiled with CFR 0.152.
 */
package com.trilead.ssh2;

import com.trilead.ssh2.IOWarningException;
import com.trilead.ssh2.crypto.Base64;
import com.trilead.ssh2.crypto.digest.Digest;
import com.trilead.ssh2.crypto.digest.HMAC;
import com.trilead.ssh2.crypto.digest.MD5;
import com.trilead.ssh2.crypto.digest.SHA1;
import com.trilead.ssh2.log.Logger;
import com.trilead.ssh2.signature.DSAPublicKey;
import com.trilead.ssh2.signature.DSASHA1Verify;
import com.trilead.ssh2.signature.RSAPublicKey;
import com.trilead.ssh2.signature.RSASHA1Verify;
import java.io.BufferedReader;
import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.SecureRandom;
import java.util.LinkedList;
import java.util.Vector;

public class KnownHosts {
    private static final Logger LOGGER = Logger.getLogger(KnownHosts.class);
    public static final int HOSTKEY_IS_OK = 0;
    public static final int HOSTKEY_IS_NEW = 1;
    public static final int HOSTKEY_HAS_CHANGED = 2;
    private LinkedList publicKeys = new LinkedList();

    public KnownHosts() {
    }

    public KnownHosts(char[] knownHostsData) throws IOException {
        this.initialize(knownHostsData);
    }

    public KnownHosts(File knownHosts) throws IOException {
        this.initialize(knownHosts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHostkey(String[] hostnames, String serverHostKeyAlgorithm, byte[] serverHostKey) throws IOException {
        if (hostnames == null) {
            throw new IllegalArgumentException("hostnames may not be null");
        }
        if ("ssh-rsa".equals(serverHostKeyAlgorithm)) {
            RSAPublicKey rpk = RSASHA1Verify.decodeSSHRSAPublicKey(serverHostKey);
            LinkedList linkedList = this.publicKeys;
            synchronized (linkedList) {
                this.publicKeys.add(new KnownHostsEntry(hostnames, rpk));
            }
        } else if ("ssh-dss".equals(serverHostKeyAlgorithm)) {
            DSAPublicKey dpk = DSASHA1Verify.decodeSSHDSAPublicKey(serverHostKey);
            LinkedList linkedList = this.publicKeys;
            synchronized (linkedList) {
                this.publicKeys.add(new KnownHostsEntry(hostnames, dpk));
            }
        } else {
            throw new IOWarningException("Unknwon host key type (" + serverHostKeyAlgorithm + ")");
        }
    }

    public void addHostkeys(char[] knownHostsData) throws IOException {
        this.initialize(knownHostsData);
    }

    public void addHostkeys(File knownHosts) throws IOException {
        this.initialize(knownHosts);
    }

    public static final String createHashedHostname(String hostname) {
        SHA1 sha1 = new SHA1();
        byte[] salt = new byte[sha1.getDigestLength()];
        new SecureRandom().nextBytes(salt);
        byte[] hash = KnownHosts.hmacSha1Hash(salt, hostname);
        String base64_salt = new String(Base64.encode(salt));
        String base64_hash = new String(Base64.encode(hash));
        return new String("|1|" + base64_salt + "|" + base64_hash);
    }

    private static final byte[] hmacSha1Hash(byte[] salt, String hostname) {
        SHA1 sha1 = new SHA1();
        if (salt.length != sha1.getDigestLength()) {
            throw new IllegalArgumentException("Salt has wrong length (" + salt.length + ")");
        }
        HMAC hmac = new HMAC(sha1, salt, salt.length);
        try {
            hmac.update(hostname.getBytes("ISO-8859-1"));
        }
        catch (UnsupportedEncodingException ignore) {
            hmac.update(hostname.getBytes());
        }
        byte[] dig = new byte[hmac.getDigestLength()];
        hmac.digest(dig);
        return dig;
    }

    private final boolean checkHashed(String entry, String hostname) {
        if (!entry.startsWith("|1|")) {
            return false;
        }
        int delim_idx = entry.indexOf(124, 3);
        if (delim_idx == -1) {
            return false;
        }
        String salt_base64 = entry.substring(3, delim_idx);
        String hash_base64 = entry.substring(delim_idx + 1);
        byte[] salt = null;
        byte[] hash = null;
        try {
            salt = Base64.decode(salt_base64.toCharArray());
            hash = Base64.decode(hash_base64.toCharArray());
        }
        catch (IOException e) {
            return false;
        }
        SHA1 sha1 = new SHA1();
        if (salt.length != sha1.getDigestLength()) {
            return false;
        }
        byte[] dig = KnownHosts.hmacSha1Hash(salt, hostname);
        for (int i2 = 0; i2 < dig.length; ++i2) {
            if (dig[i2] == hash[i2]) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int checkKey(String remoteHostname, Object remoteKey) {
        int result = 1;
        LinkedList linkedList = this.publicKeys;
        synchronized (linkedList) {
            for (KnownHostsEntry ke : this.publicKeys) {
                if (!this.hostnameMatches(ke.patterns, remoteHostname)) continue;
                boolean res = this.matchKeys(ke.key, remoteKey);
                if (res) {
                    return 0;
                }
                result = 2;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Vector getAllKeys(String hostname) {
        Vector<Object> keys2 = new Vector<Object>();
        LinkedList linkedList = this.publicKeys;
        synchronized (linkedList) {
            for (KnownHostsEntry ke : this.publicKeys) {
                if (!this.hostnameMatches(ke.patterns, hostname)) continue;
                keys2.addElement(ke.key);
            }
        }
        return keys2;
    }

    public String[] getPreferredServerHostkeyAlgorithmOrder(String hostname) {
        String[] algos = this.recommendHostkeyAlgorithms(hostname);
        if (algos != null) {
            return algos;
        }
        InetAddress[] ipAdresses = null;
        try {
            ipAdresses = InetAddress.getAllByName(hostname);
        }
        catch (UnknownHostException e) {
            return null;
        }
        for (int i2 = 0; i2 < ipAdresses.length; ++i2) {
            algos = this.recommendHostkeyAlgorithms(ipAdresses[i2].getHostAddress());
            if (algos == null) continue;
            return algos;
        }
        return null;
    }

    private final boolean hostnameMatches(String[] hostpatterns, String hostname) {
        boolean isMatch = false;
        boolean negate = false;
        hostname = hostname.toLowerCase();
        for (int k = 0; k < hostpatterns.length; ++k) {
            String bracketizedHost;
            if (hostpatterns[k] == null) continue;
            String pattern = null;
            if (hostpatterns[k].length() > 0 && hostpatterns[k].charAt(0) == '!') {
                pattern = hostpatterns[k].substring(1);
                negate = true;
            } else {
                pattern = hostpatterns[k];
                negate = false;
            }
            if (isMatch && !negate) continue;
            if (pattern.charAt(0) == '|') {
                if (!this.checkHashed(pattern, hostname)) continue;
                if (negate) {
                    return false;
                }
                isMatch = true;
                continue;
            }
            if ((pattern = pattern.toLowerCase()).indexOf(63) != -1 || pattern.indexOf(42) != -1) {
                if (!this.pseudoRegex(pattern.toCharArray(), 0, hostname.toCharArray(), 0)) continue;
                if (negate) {
                    return false;
                }
                isMatch = true;
                continue;
            }
            if (pattern.compareTo(hostname) == 0) {
                if (negate) {
                    return false;
                }
                isMatch = true;
                continue;
            }
            int indexColon = pattern.indexOf(58);
            int indexLastColon = pattern.indexOf(58);
            if (indexColon <= 0 || indexColon >= pattern.length() - 2 || indexColon != indexLastColon || !pattern.startsWith(bracketizedHost = '[' + hostname + ']')) continue;
            if (negate) {
                return false;
            }
            isMatch = true;
        }
        return isMatch;
    }

    private void initialize(char[] knownHostsData) throws IOException {
        BufferedReader br = new BufferedReader(new CharArrayReader(knownHostsData));
        String line = br.readLine();
        while (line != null) {
            String serverHostKeyAlgorithm;
            String[] arr;
            if (!(line = line.trim()).startsWith("#") && (arr = line.split(" ")).length >= 3 && ("ssh-rsa".equals(serverHostKeyAlgorithm = arr[1]) || "ssh-dss".equals(serverHostKeyAlgorithm))) {
                String[] hostnames = arr[0].split(",");
                byte[] msg = Base64.decode(arr[2].toCharArray());
                try {
                    this.addHostkey(hostnames, serverHostKeyAlgorithm, msg);
                }
                catch (IOWarningException ex) {
                    LOGGER.log(20, "Ignored invalid line '" + line + "'");
                }
            }
            line = br.readLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize(File knownHosts) throws IOException {
        char[] buffer = new char[512];
        CharArrayWriter charWriter = new CharArrayWriter();
        knownHosts.createNewFile();
        FileReader reader = new FileReader(knownHosts);
        try {
            int readCharCount;
            while ((readCharCount = reader.read(buffer)) >= 0) {
                charWriter.write(buffer, 0, readCharCount);
            }
        }
        finally {
            ((Reader)reader).close();
        }
        this.initialize(charWriter.toCharArray());
    }

    private final boolean matchKeys(Object key1, Object key2) {
        if (key1 instanceof RSAPublicKey && key2 instanceof RSAPublicKey) {
            RSAPublicKey savedRSAKey = (RSAPublicKey)key1;
            RSAPublicKey remoteRSAKey = (RSAPublicKey)key2;
            if (!savedRSAKey.getE().equals(remoteRSAKey.getE())) {
                return false;
            }
            return savedRSAKey.getN().equals(remoteRSAKey.getN());
        }
        if (key1 instanceof DSAPublicKey && key2 instanceof DSAPublicKey) {
            DSAPublicKey savedDSAKey = (DSAPublicKey)key1;
            DSAPublicKey remoteDSAKey = (DSAPublicKey)key2;
            if (!savedDSAKey.getG().equals(remoteDSAKey.getG())) {
                return false;
            }
            if (!savedDSAKey.getP().equals(remoteDSAKey.getP())) {
                return false;
            }
            if (!savedDSAKey.getQ().equals(remoteDSAKey.getQ())) {
                return false;
            }
            return savedDSAKey.getY().equals(remoteDSAKey.getY());
        }
        return false;
    }

    private final boolean pseudoRegex(char[] pattern, int i2, char[] match, int j) {
        while (pattern.length != i2) {
            if (pattern[i2] == '*') {
                if (pattern.length == ++i2) {
                    return true;
                }
                if (pattern[i2] != '*' && pattern[i2] != '?') {
                    do {
                        if (pattern[i2] != match[j] || !this.pseudoRegex(pattern, i2 + 1, match, j + 1)) continue;
                        return true;
                    } while (match.length != ++j);
                    return false;
                }
                do {
                    if (!this.pseudoRegex(pattern, i2, match, j)) continue;
                    return true;
                } while (match.length != ++j);
                return false;
            }
            if (match.length == j) {
                return false;
            }
            if (pattern[i2] != '?' && pattern[i2] != match[j]) {
                return false;
            }
            ++i2;
            ++j;
        }
        return match.length == j;
    }

    private String[] recommendHostkeyAlgorithms(String hostname) {
        String preferredAlgo = null;
        Vector keys2 = this.getAllKeys(hostname);
        for (int i2 = 0; i2 < keys2.size(); ++i2) {
            String thisAlgo = null;
            if (keys2.elementAt(i2) instanceof RSAPublicKey) {
                thisAlgo = "ssh-rsa";
            } else {
                if (!(keys2.elementAt(i2) instanceof DSAPublicKey)) continue;
                thisAlgo = "ssh-dss";
            }
            if (preferredAlgo == null || preferredAlgo.compareTo(thisAlgo) == 0) continue;
            return null;
        }
        if (preferredAlgo == null) {
            return null;
        }
        if (preferredAlgo.equals("ssh-rsa")) {
            return new String[]{"ssh-rsa", "ssh-dss"};
        }
        return new String[]{"ssh-dss", "ssh-rsa"};
    }

    public int verifyHostkey(String hostname, String serverHostKeyAlgorithm, byte[] serverHostKey) throws IOException {
        Object remoteKey = null;
        if ("ssh-rsa".equals(serverHostKeyAlgorithm)) {
            remoteKey = RSASHA1Verify.decodeSSHRSAPublicKey(serverHostKey);
        } else if ("ssh-dss".equals(serverHostKeyAlgorithm)) {
            remoteKey = DSASHA1Verify.decodeSSHDSAPublicKey(serverHostKey);
        } else {
            throw new IllegalArgumentException("Unknown hostkey type " + serverHostKeyAlgorithm);
        }
        int result = this.checkKey(hostname, remoteKey);
        if (result == 0) {
            return result;
        }
        InetAddress[] ipAdresses = null;
        try {
            ipAdresses = InetAddress.getAllByName(hostname);
        }
        catch (UnknownHostException e) {
            return result;
        }
        for (int i2 = 0; i2 < ipAdresses.length; ++i2) {
            int newresult = this.checkKey(ipAdresses[i2].getHostAddress(), remoteKey);
            if (newresult == 0) {
                return newresult;
            }
            if (newresult != 2) continue;
            result = 2;
        }
        return result;
    }

    public static final void addHostkeyToFile(File knownHosts, String[] hostnames, String serverHostKeyAlgorithm, byte[] serverHostKey) throws IOException {
        if (hostnames == null || hostnames.length == 0) {
            throw new IllegalArgumentException("Need at least one hostname specification");
        }
        if (serverHostKeyAlgorithm == null || serverHostKey == null) {
            throw new IllegalArgumentException();
        }
        CharArrayWriter writer = new CharArrayWriter();
        for (int i2 = 0; i2 < hostnames.length; ++i2) {
            if (i2 != 0) {
                writer.write(44);
            }
            writer.write(hostnames[i2]);
        }
        writer.write(32);
        writer.write(serverHostKeyAlgorithm);
        writer.write(32);
        writer.write(Base64.encode(serverHostKey));
        writer.write("\n");
        char[] entry = writer.toCharArray();
        RandomAccessFile raf = new RandomAccessFile(knownHosts, "rw");
        long len = raf.length();
        if (len > 0L) {
            raf.seek(len - 1L);
            int last = raf.read();
            if (last != 10) {
                raf.write(10);
            }
        }
        raf.write(new String(entry).getBytes("ISO-8859-1"));
        raf.close();
    }

    private static final byte[] rawFingerPrint(String type, String keyType, byte[] hostkey) {
        Digest dig = null;
        if ("md5".equals(type)) {
            dig = new MD5();
        } else if ("sha1".equals(type)) {
            dig = new SHA1();
        } else {
            throw new IllegalArgumentException("Unknown hash type " + type);
        }
        if (!"ssh-rsa".equals(keyType) && !"ssh-dss".equals(keyType)) {
            throw new IllegalArgumentException("Unknown key type " + keyType);
        }
        if (hostkey == null) {
            throw new IllegalArgumentException("hostkey is null");
        }
        dig.update(hostkey);
        byte[] res = new byte[dig.getDigestLength()];
        dig.digest(res);
        return res;
    }

    private static final String rawToHexFingerprint(byte[] fingerprint) {
        char[] alpha = "0123456789abcdef".toCharArray();
        StringBuffer sb = new StringBuffer();
        for (int i2 = 0; i2 < fingerprint.length; ++i2) {
            if (i2 != 0) {
                sb.append(':');
            }
            int b = fingerprint[i2] & 0xFF;
            sb.append(alpha[b >> 4]);
            sb.append(alpha[b & 0xF]);
        }
        return sb.toString();
    }

    private static final String rawToBubblebabbleFingerprint(byte[] raw) {
        char[] v = "aeiouy".toCharArray();
        char[] c = "bcdfghklmnprstvzx".toCharArray();
        StringBuffer sb = new StringBuffer();
        int seed = 1;
        int rounds = raw.length / 2 + 1;
        sb.append('x');
        for (int i2 = 0; i2 < rounds; ++i2) {
            if (i2 + 1 < rounds || raw.length % 2 != 0) {
                sb.append(v[((raw[2 * i2] >> 6 & 3) + seed) % 6]);
                sb.append(c[raw[2 * i2] >> 2 & 0xF]);
                sb.append(v[((raw[2 * i2] & 3) + seed / 6) % 6]);
                if (i2 + 1 >= rounds) continue;
                sb.append(c[raw[2 * i2 + 1] >> 4 & 0xF]);
                sb.append('-');
                sb.append(c[raw[2 * i2 + 1] & 0xF]);
                seed = (seed * 5 + ((raw[2 * i2] & 0xFF) * 7 + (raw[2 * i2 + 1] & 0xFF))) % 36;
                continue;
            }
            sb.append(v[seed % 6]);
            sb.append('x');
            sb.append(v[seed / 6]);
        }
        sb.append('x');
        return sb.toString();
    }

    public static final String createHexFingerprint(String keytype, byte[] publickey) {
        byte[] raw = KnownHosts.rawFingerPrint("md5", keytype, publickey);
        return KnownHosts.rawToHexFingerprint(raw);
    }

    public static final String createBubblebabbleFingerprint(String keytype, byte[] publickey) {
        byte[] raw = KnownHosts.rawFingerPrint("sha1", keytype, publickey);
        return KnownHosts.rawToBubblebabbleFingerprint(raw);
    }

    private class KnownHostsEntry {
        String[] patterns;
        Object key;

        KnownHostsEntry(String[] patterns, Object key) {
            this.patterns = patterns;
            this.key = key;
        }
    }
}

