/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch.agentproxy.usocket;

import com.jcraft.jsch.agentproxy.AgentProxyException;
import com.jcraft.jsch.agentproxy.USocketFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class NCUSocketFactory
implements USocketFactory {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NCUSocketFactory() throws AgentProxyException {
        String result;
        Process p = null;
        StringBuilder sb = new StringBuilder();
        try {
            p = Runtime.getRuntime().exec("nc -h");
            InputStream is = p.getErrorStream();
            byte[] buf = new byte[1024];
            int i2 = 0;
            while ((i2 = is.read(buf, 0, buf.length)) > 0) {
                sb.append(new String(buf, 0, i2));
            }
        }
        catch (IOException e) {
        }
        finally {
            try {
                if (p != null) {
                    p.getErrorStream().close();
                    p.getOutputStream().close();
                    p.getInputStream().close();
                    p.destroy();
                }
            }
            catch (IOException e) {}
        }
        if ((result = sb.toString()).indexOf("-U") == -1) {
            throw new AgentProxyException("netcat does not support -U option.");
        }
    }

    public USocketFactory.Socket open(String path) throws IOException {
        Process p = null;
        try {
            p = Runtime.getRuntime().exec("nc -U " + path);
        }
        catch (SecurityException e) {
            throw new IOException(e.toString());
        }
        return new MySocket(p);
    }

    public class MySocket
    extends USocketFactory.Socket {
        private Process p;
        private InputStream is;
        private OutputStream os;

        public int readFull(byte[] buf, int s, int len) throws IOException {
            int _len = len;
            while (len > 0) {
                int j = this.is.read(buf, s, len);
                if (j <= 0) {
                    return -1;
                }
                if (j <= 0) continue;
                s += j;
                len -= j;
            }
            return _len;
        }

        public void write(byte[] buf, int s, int len) throws IOException {
            this.os.write(buf, s, len);
            this.os.flush();
        }

        MySocket(Process p) throws IOException {
            this.p = p;
            this.os = p.getOutputStream();
            this.is = p.getInputStream();
        }

        public void close() throws IOException {
            this.p.getErrorStream().close();
            this.p.getInputStream().close();
            this.p.destroy();
            this.os.close();
        }
    }
}

