if (typeof document !== 'undefined') {
  
  (function(doc, svgSymbol) {
    
    // Inserts an element at the top of the target element.
    function prepend (el, target) {
      var firstChild = target.firstChild;
      
      if (firstChild) {
        firstChild.parentNode.insertBefore(el, firstChild);
      } else {
        target.appendChild(el);
      }
    };
    
    // Add SVG Symbols to the body.
    function appendSvg () {
      var div, svg;
      
      div = doc.createElement('div');
      div.innerHTML = svgSymbol;
      svgSymbol = null;
      svg = div.getElementsByTagName('svg')[0];
      if (svg) {
        svg.setAttribute('aria-hidden', 'true');
        svg.style.cssText = 'position: absolute; width: 0px; height: 0px; overflow: hidden;';
        prepend(svg, doc.body);
      }
    }
    
    // The function checks that the DOM is ready.
    function ready(fn) {
      if (doc.addEventListener) {
        doc.addEventListener('DOMContentLoaded', function handler() {
          doc.removeEventListener('DOMContentLoaded', handler, false);
          fn();
        }, false);
      } else if (doc.attachEvent) { //IE
        doc.attachEvent('onreadystatechange', function handler() {
          if (doc.readyState == 'complete') {
            doc.detachEvent('onreadystatechange', handler);
            fn();
          }
        });
      }
    };

    ready(appendSvg);
    
  })(document, '<svg xmlns=\"http://www.w3.org/2000/svg\">\n<defs>\n<clipPath id=\"clip0_8427_408645\">\n<rect width=\"20\" height=\"20\" fill=\"white\" transform=\"translate(0.217224)\"/>\n</clipPath>\n\n\n<clipPath id=\"clip0_12431_13148\">\n<rect width=\"20\" height=\"20\" fill=\"white\"/>\n</clipPath>\n\n\n<clipPath id=\"clip0_8427_408645\">\n<rect width=\"20\" height=\"20\" fill=\"white\" transform=\"translate(0.217224)\"/>\n</clipPath>\n</defs>\n<symbol id=\"svg-icon-abnormal\" viewBox=\"0 0 20 20\">\n  <path d=\"M9.84214 2.58734V3.78166\" stroke=\"currentColor\" stroke-linecap=\"square\" fill=\"none\"/>\n  <path d=\"M14.5763 4.31039L13.8086 5.22531\" stroke=\"currentColor\" stroke-linecap=\"square\" fill=\"none\"/>\n  <path d=\"M17.0951 8.67334L15.9189 8.88075\" stroke=\"currentColor\" stroke-linecap=\"square\" fill=\"none\"/>\n  <path d=\"M2.58912 8.67334L3.7653 8.88071\" stroke=\"currentColor\" stroke-linecap=\"square\" fill=\"none\"/>\n  <path d=\"M5.1081 4.31039L5.87581 5.22532\" stroke=\"currentColor\" stroke-linecap=\"square\" fill=\"none\"/>\n  <path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M6.3611 10.5494C6.3611 8.62692 7.91965 7.06837 9.84217 7.06837C11.7647 7.06837 13.3232 8.62692 13.3232 10.5494V16.4192H6.3611V10.5494ZM9.84217 6.06837C7.36736 6.06837 5.3611 8.07464 5.3611 10.5494V16.4192H2.6762H2.1762V17.4192H2.6762H17.4062H17.9062V16.4192H17.4062H14.3232V10.5494C14.3232 8.07464 12.317 6.06837 9.84217 6.06837Z\" fill=\"currentColor\"/>\n  <path d=\"M8.41008 12.6418L8.41008 14.7585\" stroke=\"currentColor\" stroke-linecap=\"square\" fill=\"none\"/>\n</symbol>\n<symbol id=\"svg-icon-aimonitor\" viewBox=\"0 0 20 20\">\n<g fill=\"none\">\n<path d=\"M10.381 17.5C14.5231 17.5 17.881 14.1421 17.881 10C17.881 5.85786 14.5231 2.5 10.381 2.5C6.23884 2.5 2.88098 5.85786 2.88098 10C2.88098 14.1421 6.23884 17.5 10.381 17.5Z\" stroke=\"currentColor\" stroke-linejoin=\"round\"/>\n<path d=\"M12.639 13V6.52002H13.7235V13H12.639Z\" fill=\"currentColor\"/>\n<path d=\"M6.06097 13L8.10397 6.52002H9.69247L11.7355 13H10.6195L8.76547 7.18602H9.00847L7.17697 13H6.06097ZM7.19947 11.596V10.5835H10.6015V11.596H7.19947Z\" fill=\"currentColor\"/>\n</g></symbol>\n<symbol id=\"svg-icon-alertlog\" viewBox=\"0 0 21 20\">\n<g clip-path=\"url(#clip0_8427_408645)\">\n<path d=\"M15.4266 7.75082V6.25082L11.9266 2.75082H3.42656V16.9508H9.42656\" stroke=\"currentColor\" stroke-linecap=\"square\" fill=\"none\"/>\n<path d=\"M6.42656 7.75082H11.4266\" stroke=\"currentColor\" stroke-linecap=\"square\" stroke-linejoin=\"round\" fill=\"none\"/>\n<path d=\"M6.42656 11.4508H8.92656\" stroke=\"currentColor\" stroke-linecap=\"square\" stroke-linejoin=\"round\" fill=\"none\"/>\n<circle cx=\"14.4266\" cy=\"13.7508\" r=\"4\" stroke=\"currentColor\" stroke-linecap=\"square\" fill=\"none\"/>\n<path d=\"M14.4266 15.5008L14.4266 13.7508\" stroke=\"currentColor\" stroke-linecap=\"square\" fill=\"none\"/>\n<rect x=\"13.9319\" y=\"11.5338\" width=\"0.989426\" height=\"0.989426\" fill=\"currentColor\"/>\n</g>\n\n</symbol>\n<symbol id=\"svg-icon-auditlog\" viewBox=\"0 0 20 20\">\n  <path d=\"M9.84214 2.58734V3.78166\" stroke=\"currentColor\" fill=\"none\" stroke-linecap=\"square\"/>\n  <path d=\"M14.5763 4.31039L13.8086 5.22531\" stroke=\"currentColor\" fill=\"none\" stroke-linecap=\"square\"/>\n  <path d=\"M17.0951 8.67334L15.9189 8.88075\" stroke=\"currentColor\" fill=\"none\" stroke-linecap=\"square\"/>\n  <path d=\"M2.58912 8.67334L3.7653 8.88071\" stroke=\"currentColor\" fill=\"none\" stroke-linecap=\"square\"/>\n  <path d=\"M5.1081 4.31039L5.87581 5.22532\" stroke=\"currentColor\" fill=\"none\" stroke-linecap=\"square\"/>\n  <path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M6.3611 10.5494C6.3611 8.62692 7.91965 7.06837 9.84217 7.06837C11.7647 7.06837 13.3232 8.62692 13.3232 10.5494V16.4192H6.3611V10.5494ZM9.84217 6.06837C7.36736 6.06837 5.3611 8.07464 5.3611 10.5494V16.4192H2.6762H2.1762V17.4192H2.6762H17.4062H17.9062V16.4192H17.4062H14.3232V10.5494C14.3232 8.07464 12.317 6.06837 9.84217 6.06837Z\" fill=\"currentColor\"/>\n  <path d=\"M8.41008 12.6418L8.41008 14.7585\" stroke=\"currentColor\" fill=\"none\" stroke-linecap=\"square\"/>\n</symbol>\n<symbol id=\"svg-icon-authentication\" viewBox=\"0 0 21 20\">\n  <path d=\"M3.29828 15.4054C3.29862 14.8174 3.29828 11.5319 3.29828 11.5319C3.29828 11.5319 6.61638 11.5319 8.05811 11.5319C8.45659 11.5319 8.45447 11.1785 8.45447 10.337C8.45447 9.49544 6.33486 8.78664 6.33486 5.82824C6.33486 2.86984 8.53067 2 10.3556 2C12.1805 2 14.1682 2.86984 14.1682 5.82824C14.1682 8.78664 12.0597 9.25699 12.0597 10.337C12.0597 11.4169 12.0597 11.5319 12.3972 11.5319C13.8327 11.5319 17.1362 11.5319 17.1362 11.5319C17.1362 11.5319 17.1362 14.8182 17.1362 15.4054H3.29828Z\" stroke=\"currentColor\" fill=\"none\"/>\n  <path d=\"M3.29828 18H17.1361\" stroke=\"currentColor\" fill=\"none\" stroke-linecap=\"square\" stroke-linejoin=\"round\"/>\n</symbol>\n<symbol id=\"svg-icon-client\" viewBox=\"0 0 24 20\">\n<path d=\"M3.1588 13.9V3H19.5544V7.22077\" stroke=\"currentColor\" fill=\"none\" stroke-linecap=\"square\"/>\n<path d=\"M21.1017 17.0631H16.2346V17.0621H11.0383V10.566H13.4601V7.25645H21.1017V17.0631ZM14.4601 10.566H16.881V16.0631H20.1017V8.25645H14.4601V10.566ZM12.0383 16.0621H15.881V11.566H12.0383V16.0621Z\" fill=\"currentColor\"/>\n<path d=\"M11.4475 14.3466L2.1158 14.3466L3.05976 16.4016H11.4475\" stroke=\"currentColor\" fill=\"none\" stroke-linecap=\"square\"/>\n</symbol>\n<symbol id=\"svg-icon-cloud\" viewBox=\"0 0 21 20\">\n  <path d=\"M5.76275 7.81104L5.84541 8.30649L6.20343 8.24676L6.2591 7.88809L5.76275 7.81104ZM14.6719 7.81105L14.1755 7.8881L14.2312 8.24676L14.5892 8.3065L14.6719 7.81105ZM5.76275 7.81104L6.2591 7.88809C6.5568 5.97028 8.21609 4.5023 10.2173 4.5023V4V3.4977C7.71317 3.4977 5.6389 5.33426 5.2664 7.73399L5.76275 7.81104ZM10.2173 4V4.5023C12.2185 4.5023 13.8778 5.97028 14.1755 7.8881L14.6719 7.81105L15.1682 7.73401C14.7957 5.33427 12.7215 3.4977 10.2173 3.4977V4ZM14.6719 7.81105L14.5892 8.3065C16.3629 8.60244 17.715 10.1453 17.715 12.0029H18.2173H18.7196C18.7196 9.6462 17.0046 7.69102 14.7546 7.3156L14.6719 7.81105ZM18.2173 12.0029H17.715C17.715 14.0727 16.0371 15.7506 13.9673 15.7506V16.2529V16.7552C16.5919 16.7552 18.7196 14.6275 18.7196 12.0029H18.2173ZM13.9673 16.2529V15.7506H6.46729V16.2529V16.7552H13.9673V16.2529ZM6.46729 16.2529V15.7506C4.39749 15.7506 2.71958 14.0727 2.71958 12.0029H2.21729H1.71499C1.71499 14.6275 3.84266 16.7552 6.46729 16.7552V16.2529ZM2.21729 12.0029H2.71958C2.71958 10.1453 4.07166 8.60241 5.84541 8.30649L5.76275 7.81104L5.68009 7.31559C3.43001 7.69098 1.71499 9.64617 1.71499 12.0029H2.21729Z\" fill=\"currentColor\"/>\n</symbol>\n<symbol id=\"svg-icon-configuration\" viewBox=\"0 0 18 18\">\n  <path d=\"M15.5625 3.75H13.3125\" stroke=\"currentColor\" stroke-width=\"1.3\" stroke-linecap=\"square\" stroke-linejoin=\"round\"/>\n  <path d=\"M10.3125 2.25V5.25\" stroke=\"currentColor\" stroke-width=\"1.3\" stroke-linecap=\"square\" stroke-linejoin=\"round\"/>\n  <path d=\"M10.3125 3.75H2.0625\" stroke=\"currentColor\" stroke-width=\"1.3\" stroke-linecap=\"square\" stroke-linejoin=\"round\"/>\n  <path d=\"M5.0625 9H2.0625\" stroke=\"currentColor\" stroke-width=\"1.3\" stroke-linecap=\"square\" stroke-linejoin=\"round\"/>\n  <path d=\"M8.0625 7.5V10.5\" stroke=\"currentColor\" stroke-width=\"1.3\" stroke-linecap=\"square\" stroke-linejoin=\"round\"/>\n  <path d=\"M16.3125 9H8.0625\" stroke=\"currentColor\" stroke-width=\"1.3\" stroke-linecap=\"square\" stroke-linejoin=\"round\"/>\n  <path d=\"M15.5625 14.25H13.3125\" stroke=\"currentColor\" stroke-width=\"1.3\" stroke-linecap=\"square\" stroke-linejoin=\"round\"/>\n  <path d=\"M10.3125 12.75V15.75\" stroke=\"currentColor\" stroke-width=\"1.3\" stroke-linecap=\"square\" stroke-linejoin=\"round\"/>\n  <path d=\"M10.3125 14.25H2.0625\" stroke=\"currentColor\" stroke-width=\"1.3\" stroke-linecap=\"square\" stroke-linejoin=\"round\"/>\n</symbol>\n<symbol id=\"svg-icon-customer\" viewBox=\"-1 -1 20 20\">\n  <path d=\"M15.375 5.24989L9 1.5L2.625 5.24989V12.7499L9 16.5L15.375 12.7499V5.24989Z\" stroke=\"currentColor\" fill=\"none\"/>\n  <path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M6.26529 6.70024L5.84145 6.43498L5.31093 7.28265L5.73476 7.54791L8.50001 9.27856V12.375V12.875H9.50001V12.375V9.27555L12.2632 7.54804L12.6872 7.28299L12.1571 6.43506L11.7331 6.70011L8.99762 8.41029L6.26529 6.70024Z\" fill=\"currentColor\"/>\n</symbol>\n<symbol id=\"svg-icon-dashboard\" viewBox=\"0 0 20 20\">\n  <path d=\"M4.34315 16.6569C2.89543 15.2091 2 13.2091 2 11C2 6.58171 5.58171 3 10 3C14.4183 3 18 6.58171 18 11C18 13.2091 17.1046 15.2091 15.6569 16.6569\" stroke=\"currentColor\" stroke-linecap=\"square\" stroke-linejoin=\"round\" fill=\"none\"/>\n  <path d=\"M6.40018 14.5998C5.47891 13.6785 4.90909 12.4058 4.90909 11C4.90909 8.18836 7.18836 5.90909 10 5.90909\" stroke=\"currentColor\" stroke-linecap=\"square\" fill=\"none\"/>\n  <path d=\"M10 11V8.09091\" stroke=\"currentColor\" stroke-linecap=\"square\" stroke-linejoin=\"round\" fill=\"none\"/>\n</symbol>\n<symbol id=\"svg-icon-device\" viewBox=\"0 0 20 20\">\n  <circle cx=\"10\" cy=\"10\" r=\"7.5\" stroke=\"currentColor\" fill=\"none\"/>\n  <circle cx=\"10\" cy=\"10\" r=\"2.5\" stroke=\"currentColor\" fill=\"none\"/>\n</symbol>\n<symbol id=\"svg-icon-deviceconfig\" viewBox=\"0 0 21 20\">\n<g fill=\"none\">\n<path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M11.0262 16.9253C10.6913 16.9745 10.3486 17 10 17C6.13401 17 3 13.866 3 10C3 6.13401 6.13401 3 10 3C13.866 3 17 6.13401 17 10C17 10.3486 16.9745 10.6913 16.9253 11.0262H17.9348C17.9778 10.6902 18 10.3477 18 10C18 5.58172 14.4183 2 10 2C5.58172 2 2 5.58172 2 10C2 14.4183 5.58172 18 10 18C10.3477 18 10.6902 17.9778 11.0262 17.9348V16.9253Z\" fill=\"currentColor\"/>\n<circle cx=\"10\" cy=\"10\" r=\"2.5\" stroke=\"currentColor\"/>\n<path d=\"M17.2743 18.4345L19.0242 15.4595L17.2743 12.4845H13.7742L12.0242 15.4595L13.7742 18.4345H17.2743Z\" stroke=\"currentColor\"/>\n<path d=\"M15.5238 14.3103C16.1584 14.3104 16.6732 14.8251 16.6732 15.4597C16.6731 16.0943 16.1584 16.609 15.5238 16.6091C14.8892 16.6091 14.3745 16.0943 14.3744 15.4597C14.3744 14.825 14.8891 14.3103 15.5238 14.3103Z\" stroke=\"currentColor\" stroke-linejoin=\"round\"/>\n</g>\n</symbol>\n<symbol id=\"svg-icon-export\" viewBox=\"0 0 20 20\">\n<path d=\"M16 6.5V3H4V17.2H12\" stroke=\"currentColor\" fill=\"none\" stroke-linecap=\"square\"/>\n<path d=\"M10 13H17\" stroke=\"currentColor\" fill=\"none\" stroke-linecap=\"square\" stroke-linejoin=\"round\"/>\n<path d=\"M15 10.5L17.5 13L15 15.5\" stroke=\"currentColor\" fill=\"none\" stroke-linecap=\"square\"/>\n<path d=\"M7.5 6H12.5\" stroke=\"currentColor\" fill=\"none\" stroke-linecap=\"square\"/>\n<path d=\"M7.5 8.5H12.5\" stroke=\"currentColor\" fill=\"none\" stroke-linecap=\"square\"/>\n</symbol>\n<symbol id=\"svg-icon-firmware\" viewBox=\"0 0 20 20\">\n<path d=\"M3 9.57895L10 2L17 9.57895H12.9474V17.1579H7.05263V9.57895H3Z\" stroke=\"currentColor\" stroke-width=\"1.10769\" stroke-linejoin=\"round\" fill=\"none\"/>\n</symbol>\n<symbol id=\"svg-icon-fix-menu-btn\" viewBox=\"0 0 20 20\">\n<g id=\"icon/&#xe6;&#x201d;&#xb6;&#xe8;&#xb5;&#xb7;\" fill=\"none\">\n<rect id=\"Rectangle 34625103\" x=\"3\" y=\"3.46655\" width=\"14\" height=\"13.0667\" stroke=\"currentColor\"/>\n<path id=\"Vector 3684\" d=\"M8 3.46655V16.5332\" stroke=\"currentColor\"/>\n</g>\n</symbol>\n<symbol id=\"svg-icon-health\" viewBox=\"0 0 20 20\">\n  <path d=\"M3.08301 9.89775C3.01367 9.75116 2.94923 9.60255 2.8904 9.4521C2.64724 8.83023 2.5 8.17657 2.5 7.5C2.5 5.26323 4.33156 3.45 6.59091 3.45C8.01385 3.45 9.2671 4.16922 10 5.2605C10.7329 4.16922 11.9862 3.45 13.4091 3.45C15.6684 3.45 17.5 5.26323 17.5 7.5C17.5 10.4118 14.7727 12.9 13.4091 14.25C12.5 15.15 11.3636 16.05 10 16.95C8.63635 16.05 7.49999 15.15 6.59091 14.25C6.45362 14.1141 6.30254 13.9666 6.14178 13.8084\" stroke=\"currentColor\" fill=\"none\" stroke-linecap=\"square\"/>\n  <path d=\"M3.99998 12.44L8.16765 8.33986L10.5918 10.8397L14.2232 7.13206\" stroke=\"currentColor\" fill=\"none\" stroke-linecap=\"square\"/>\n</symbol>\n<symbol id=\"svg-icon-home\" viewBox=\"0 0 20 20\">\n<path d=\"M3.5 7.63333L3.18765 7.2429L3 7.39302V7.63333H3.5ZM3.5 17.1667H3V17.6667H3.5V17.1667ZM10 2.43333L10.3123 2.0429L10 1.79302L9.68765 2.0429L10 2.43333ZM16.5 7.63333H17V7.39302L16.8123 7.2429L16.5 7.63333ZM16.5 17.1667V17.6667H17V17.1667H16.5ZM12.0309 17.1667H11.5309V17.6667H12.0309V17.1667ZM12.0309 11.506H12.5309V11.006H12.0309V11.506ZM7.96843 11.506V11.006H7.46843V11.506H7.96843ZM7.96843 17.1667V17.6667H8.46843V17.1667H7.96843ZM3 7.63333V17.1667H4V7.63333H3ZM9.68765 2.0429L3.18765 7.2429L3.81235 8.02377L10.3123 2.82377L9.68765 2.0429ZM16.8123 7.2429L10.3123 2.0429L9.68765 2.82377L16.1877 8.02377L16.8123 7.2429ZM17 17.1667V7.63333H16V17.1667H17ZM12.0309 17.6667H16.5V16.6667H12.0309V17.6667ZM12.5309 17.1667V11.506H11.5309V17.1667H12.5309ZM12.0309 11.006H7.96843V12.006H12.0309V11.006ZM7.46843 11.506V17.1667H8.46843V11.506H7.46843ZM3.5 17.6667H7.96843V16.6667H3.5V17.6667Z\" fill=\"currentColor\"/>\n</symbol>\n<symbol id=\"svg-icon-hotspot\" viewBox=\"0 0 20 20\">\n<path d=\"M10 17.5C14.1421 17.5 17.5 14.1421 17.5 10C17.5 5.85786 14.1421 2.5 10 2.5C5.85786 2.5 2.5 5.85786 2.5 10C2.5 14.1421 5.85786 17.5 10 17.5Z\" stroke=\"currentColor\" fill=\"none\" stroke-linejoin=\"round\"/>\n<path d=\"M10 5.50002C7.51473 5.50002 5.5 7.51474 5.5 10\" stroke=\"currentColor\" fill=\"none\" stroke-linecap=\"square\" stroke-linejoin=\"round\"/>\n<path d=\"M10 14.5C12.4853 14.5 14.5 12.4853 14.5 10\" stroke=\"currentColor\" fill=\"none\" stroke-linecap=\"square\" stroke-linejoin=\"round\"/>\n<path d=\"M10 11.5C10.8284 11.5 11.5 10.8284 11.5 10C11.5 9.17162 10.8284 8.50003 10 8.50003C9.17162 8.50003 8.50003 9.17162 8.50003 10C8.50003 10.8284 9.17162 11.5 10 11.5Z\" stroke=\"currentColor\" fill=\"none\" stroke-linejoin=\"round\"/>\n</symbol>\n<symbol id=\"svg-icon-insight\" viewBox=\"0 0 20 20\">\n<path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M10 12.8167C12.7614 12.8167 15 10.5781 15 7.81667C15 5.05524 12.7614 2.81667 10 2.81667C7.23858 2.81667 5 5.05524 5 7.81667C5 10.5781 7.23858 12.8167 10 12.8167ZM10 13.8167C10.6513 13.8167 11.2783 13.7129 11.8654 13.521L11.2574 15.4667H8.74262L8.1346 13.521C8.72175 13.7129 9.34876 13.8167 10 13.8167ZM16 7.81667C16 10.0011 14.8327 11.9129 13.0878 12.9622L12.1023 16.1158L11.9926 16.4667H11.625H8.37502H8.00742L7.89778 16.1158L6.91228 12.9622C5.16736 11.9129 4 10.0011 4 7.81667C4 4.50296 6.68629 1.81667 10 1.81667C13.3137 1.81667 16 4.50296 16 7.81667ZM8.91669 17.5H8.41669V18.5H8.91669H11.0834H11.5834V17.5H11.0834H8.91669Z\" fill=\"currentColor\"/>\n</symbol>\n<symbol id=\"svg-icon-insights\" viewBox=\"0 0 20 20\">\n<g fill=\"none\">\n<path d=\"M7.12912 3.06921C6.2124 3.44933 5.38745 4.00601 4.69662 4.69683C3.3394 6.05405 2.49994 7.92902 2.49994 10C2.49994 14.1421 5.85777 17.4999 9.99987 17.4999C12.0709 17.4999 13.9459 16.6604 15.3031 15.3032C15.994 14.6124 16.5506 13.7875 16.9307 12.8707\" stroke=\"currentColor\" stroke-linecap=\"square\" stroke-linejoin=\"round\"/>\n<path d=\"M10 9.99998H17.4999C17.4999 5.85792 14.1421 2.50012 10 2.50012V9.99998Z\" stroke=\"currentColor\"/></g></symbol>\n<symbol id=\"svg-icon-intellirecover\" viewBox=\"0 0 21 20\">\n<path d=\"M17.0003 10.5922C17.0003 13.1614 15.0551 15.2922 12.5999 15.2924H4.64679L6.20636 16.9721L6.54718 17.3383L5.81378 18.019L5.47394 17.6518L3.13409 15.1323L2.81769 14.7914L3.13409 14.4516L5.47394 11.9321L5.81378 11.5649L6.54718 12.2455L6.20636 12.6118L4.64581 14.2924H12.5999C14.4367 14.2922 16.0003 12.6776 16.0003 10.5922V10.0922H17.0003V10.5922ZM14.5267 2.69183L16.8665 5.21136L17.1829 5.55121L16.8665 5.89203L14.5267 8.41156L14.1868 8.77875L13.4534 8.09808L13.7943 7.73187L15.3538 6.05121H7.4007C5.56374 6.05121 4.00041 7.66598 4.00031 9.7514V10.2514H3.00031V9.7514C3.00041 7.18219 4.94536 5.05121 7.4007 5.05121H15.3538L13.7943 3.37152L13.4534 3.00531L14.1868 2.32465L14.5267 2.69183Z\" fill=\"currentColor\"/>\n</symbol>\n<symbol id=\"svg-icon-license\" viewBox=\"0 0 20 20\">\n  <path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M6.52478 2.06165H7.02478H10.3721H10.8721V2.56165V8.51235V9.62577L10.0399 8.88605L8.69842 7.69365L7.35696 8.88605L6.52478 9.62577V8.51235V2.56165V2.06165ZM7.52478 3.06165V7.39893L8.36623 6.65097L8.69842 6.3557L9.0306 6.65097L9.87205 7.39893V3.06165H7.52478ZM6.52478 10.9877H7.02478H10.744H11.244V11.9877H10.744H7.02478H6.52478V10.9877ZM7.02478 13.2192H6.52478V14.2192H7.02478H12.9755H13.4755V13.2192H12.9755H7.02478Z\" fill=\"currentColor\"/>\n  <rect x=\"4\" y=\"2.5\" width=\"11.6667\" height=\"15\" stroke=\"currentColor\" fill=\"none\" stroke-linecap=\"square\"/>\n</symbol>\n<symbol id=\"svg-icon-line-legend\" viewBox=\"0 0 20 20\">\n<g clip-path=\"url(#clip0_12431_13148)\">\n<path d=\"M0 13.2358H3.47003L6.27657 8.30208L9.39751 13.5L13.3285 4.76416L16.2301 13.5H20.0002\" stroke=\"currentColor\" fill=\"none\"/>\n</g>\n\n</symbol>\n<symbol id=\"svg-icon-log\" viewBox=\"0 0 21 20\">\n<g clip-path=\"url(#clip0_8427_408645)\">\n<path d=\"M15.4266 7.75082V6.25082L11.9266 2.75082H3.42656V16.9508H9.42656\" stroke=\"currentColor\" stroke-linecap=\"square\" fill=\"none\"/>\n<path d=\"M6.42656 7.75082H11.4266\" stroke=\"currentColor\" stroke-linecap=\"square\" stroke-linejoin=\"round\" fill=\"none\"/>\n<path d=\"M6.42656 11.4508H8.92656\" stroke=\"currentColor\" stroke-linecap=\"square\" stroke-linejoin=\"round\" fill=\"none\"/>\n<circle cx=\"14.4266\" cy=\"13.7508\" r=\"4\" stroke=\"currentColor\" stroke-linecap=\"square\" fill=\"none\"/>\n<path d=\"M14.4266 15.5008L14.4266 13.7508\" stroke=\"currentColor\" stroke-linecap=\"square\" fill=\"none\"/>\n<rect x=\"13.9319\" y=\"11.5338\" width=\"0.989426\" height=\"0.989426\" fill=\"currentColor\"/>\n</g>\n\n</symbol>\n<symbol id=\"svg-icon-maintenance\" viewBox=\"0 0 21 20\">\n<g fill=\"none\">\n<path d=\"M17.7423 7.9C17.7423 10.8823 15.3246 13.3 12.3423 13.3C11.4303 13.3 10.5711 13.0739 9.81763 12.6747L4.82074 17.6716L2.57074 15.4216L7.56763 10.4247C7.16844 9.67124 6.94231 8.81201 6.94231 7.9C6.94231 4.91766 9.35998 2.5 12.3423 2.5C13.2543 2.5 14.1136 2.7261 14.867 3.12532L11.4423 6.55L13.6923 8.8L17.117 5.37532C17.5162 6.12875 17.7423 6.98798 17.7423 7.9Z\" stroke=\"currentColor\" stroke-linecap=\"square\"/>\n</g>\n</symbol>\n<symbol id=\"svg-icon-maintenancecentralglobal\" viewBox=\"0 0 20 20\">\n    <path d=\"M17.5251 7.9C17.5251 10.8823 15.1074 13.3 12.1251 13.3C11.2131 13.3 10.3538 13.0739 9.60041 12.6747L4.60352 17.6716L2.35352 15.4216L7.35041 10.4247C6.95121 9.67124 6.72509 8.81201 6.72509 7.9C6.72509 4.91766 9.14276 2.5 12.1251 2.5C13.0371 2.5 13.8963 2.7261 14.6498 3.12532L11.2251 6.55L13.4751 8.8L16.8998 5.37532C17.299 6.12875 17.5251 6.98798 17.5251 7.9Z\" stroke=\"currentColor\" fill=\"none\" stroke-linecap=\"square\"/>\n</symbol>\n<symbol id=\"svg-icon-map\" viewBox=\"0 0 20 20\">\n  <path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M2.0582 2.52095L2.76773 2.84843L7.40294 4.98775L12.4077 2.84283L12.6122 2.75519L12.8142 2.84843L17.6514 5.08098L17.9419 5.21505V5.53496V16.6978V17.4792L17.2324 17.1517L12.5972 15.0124L7.59237 17.1573L7.38788 17.245L7.18588 17.1517L2.34867 14.9192L2.0582 14.7851V14.4652V3.3024V2.52095ZM7.89536 5.86468L12.1048 4.06065V14.1355L7.89536 15.9395V5.86468ZM6.89536 5.85486L3.0582 4.08386V14.1453L6.89536 15.9163V5.85486ZM16.9419 15.9163L13.1048 14.1453V4.08388L16.9419 5.85488V15.9163Z\" fill=\"currentColor\"/>\n</symbol>\n<symbol id=\"svg-icon-monitoring\" viewBox=\"0 0 20 20\">\n  <g fill=\"none\">\n    <path d=\"M5.00001 13.75H1.66667V2.91666H18.3333V13.75H15H5.00001Z\" stroke=\"currentColor\" stroke-width=\"1.3\" stroke-linecap=\"square\" stroke-linejoin=\"round\"/>\n    <path d=\"M6.66667 9.16666V10.8333\" stroke=\"currentColor\" stroke-width=\"1.3\" stroke-linecap=\"square\" stroke-linejoin=\"round\"/>\n    <path d=\"M10 13.75V16.25\" stroke=\"currentColor\" stroke-width=\"1.3\" stroke-linecap=\"square\" stroke-linejoin=\"round\"/>\n    <path d=\"M10 7.5V10.8333\" stroke=\"currentColor\" stroke-width=\"1.3\" stroke-linecap=\"square\" stroke-linejoin=\"round\"/>\n    <path d=\"M13.3333 5.83334V10.8333\" stroke=\"currentColor\" stroke-width=\"1.3\" stroke-linecap=\"square\" stroke-linejoin=\"round\"/>\n    <path d=\"M5 17.0833H15\" stroke=\"currentColor\" stroke-width=\"1.3\" stroke-linecap=\"square\" stroke-linejoin=\"round\"/>\n  </g>\n</symbol>\n<symbol id=\"svg-icon-networkconfig\" viewBox=\"0 0 21 20\">\n<path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M8.4112 3.23907C5.5812 3.99321 3.45698 6.4772 3.2401 9.48948H6.95928C7.00563 7.57589 7.31059 5.83531 7.79313 4.52556C7.97075 4.04345 8.17685 3.60755 8.4112 3.23907ZM3.23906 10.4941C3.45001 13.512 5.57526 16.0022 8.4085 16.7585C8.17527 16.3909 7.97007 15.9565 7.79313 15.4762C7.30906 14.1623 7.0037 12.4148 6.95884 10.4941H3.23906ZM10.2619 16.9944C10.247 16.9945 10.2321 16.9945 10.2172 16.9945C10.2027 16.9945 10.1881 16.9945 10.1736 16.9944C9.99757 16.9794 9.77648 16.8725 9.52125 16.5795C9.24522 16.2626 8.97379 15.7749 8.73579 15.1289C8.30006 13.9462 8.00852 12.3211 7.96372 10.4941H12.4717C12.4269 12.3211 12.1354 13.9462 11.6996 15.1289C11.4616 15.7749 11.1902 16.2626 10.9142 16.5795C10.659 16.8724 10.4379 16.9794 10.2619 16.9944ZM10.3005 17.9987C14.6804 17.9541 18.2172 14.3896 18.2172 9.99912C18.2172 5.58084 14.6355 1.99911 10.2172 1.99911C5.79895 1.99911 2.21722 5.58084 2.21722 9.99912C2.21722 14.39 5.75469 17.9547 10.1352 17.9987C10.1625 18.0002 10.19 18.0009 10.2177 18.0009C10.2455 18.0009 10.2731 18.0002 10.3005 17.9987ZM12.0271 16.7581C12.2603 16.3906 12.4654 15.9563 12.6423 15.4762C13.1264 14.1623 13.4317 12.4148 13.4766 10.4941H17.1954C16.9845 13.5116 14.8598 16.0015 12.0271 16.7581ZM17.1944 9.48948C16.9775 6.47761 14.8538 3.99389 12.0244 3.23938C12.2587 3.60779 12.4647 4.04359 12.6423 4.52556C13.1248 5.83531 13.4298 7.57589 13.4761 9.48948H17.1944ZM8.73579 4.87285C8.30151 6.05159 8.01046 7.66986 7.96417 9.48948H12.4712C12.425 7.66986 12.1339 6.05159 11.6996 4.87285C11.4616 4.22683 11.1902 3.73919 10.9142 3.4223C10.6371 3.10424 10.4003 3.00547 10.2177 3.00547C10.0351 3.00547 9.79829 3.10424 9.52125 3.4223C9.24522 3.73919 8.97379 4.22683 8.73579 4.87285Z\" fill=\"currentColor\"/>\n</symbol>\n<symbol id=\"svg-icon-reports\" viewBox=\"0 0 20 20\">\n  <path d=\"M13.2 10.9001V13.7001\" stroke=\"currentColor\" fill=\"none\" stroke-width=\"1.2\" stroke-linecap=\"square\" stroke-linejoin=\"round\"/>\n  <path d=\"M10 7.30002V13.7\" stroke=\"currentColor\" fill=\"none\" stroke-width=\"1.2\" stroke-linecap=\"square\" stroke-linejoin=\"round\"/>\n  <path d=\"M6.80005 8.90005V13.7001\" stroke=\"currentColor\" fill=\"none\" stroke-width=\"1.2\" stroke-linecap=\"square\" stroke-linejoin=\"round\"/>\n  <path d=\"M2 3.5H18V16.5H2V3.5Z\" stroke=\"currentColor\" fill=\"none\" stroke-linecap=\"round\"/>\n</symbol>\n<symbol id=\"svg-icon-sd-wan\" viewBox=\"0 0 21 20\">\n  <path d=\"M5.76275 7.81104L5.84541 8.30649L6.20343 8.24676L6.2591 7.88809L5.76275 7.81104ZM14.6719 7.81105L14.1755 7.8881L14.2312 8.24676L14.5892 8.3065L14.6719 7.81105ZM5.76275 7.81104L6.2591 7.88809C6.5568 5.97028 8.21609 4.5023 10.2173 4.5023V4V3.4977C7.71317 3.4977 5.6389 5.33426 5.2664 7.73399L5.76275 7.81104ZM10.2173 4V4.5023C12.2185 4.5023 13.8778 5.97028 14.1755 7.8881L14.6719 7.81105L15.1682 7.73401C14.7957 5.33427 12.7215 3.4977 10.2173 3.4977V4ZM14.6719 7.81105L14.5892 8.3065C16.3629 8.60244 17.715 10.1453 17.715 12.0029H18.2173H18.7196C18.7196 9.6462 17.0046 7.69102 14.7546 7.3156L14.6719 7.81105ZM18.2173 12.0029H17.715C17.715 14.0727 16.0371 15.7506 13.9673 15.7506V16.2529V16.7552C16.5919 16.7552 18.7196 14.6275 18.7196 12.0029H18.2173ZM13.9673 16.2529V15.7506H6.46729V16.2529V16.7552H13.9673V16.2529ZM6.46729 16.2529V15.7506C4.39749 15.7506 2.71958 14.0727 2.71958 12.0029H2.21729H1.71499C1.71499 14.6275 3.84266 16.7552 6.46729 16.7552V16.2529ZM2.21729 12.0029H2.71958C2.71958 10.1453 4.07166 8.60241 5.84541 8.30649L5.76275 7.81104L5.68009 7.31559C3.43001 7.69098 1.71499 9.64617 1.71499 12.0029H2.21729Z\" fill=\"currentColor\"/>\n</symbol>\n<symbol id=\"svg-icon-security\" viewBox=\"0 0 20 20\">\n  <path d=\"M3.33334 4.44644L10.0032 2.49991L16.6667 4.44644V8.43832C16.6667 12.6341 13.9816 16.3589 10.001 17.6853C6.0193 16.359 3.33334 12.6332 3.33334 8.43646V4.44644Z\" stroke=\"currentColor\" fill=\"none\" stroke-linecap=\"square\"/>\n  <path d=\"M7.08334 9.16667L9.16667 11.6667L13.75 7.5\" stroke=\"currentColor\" fill=\"none\"/>\n</symbol>\n<symbol id=\"svg-icon-settings\" viewBox=\"0 0 20 20\">\n<path d=\"M7.85643 17.209C6.59976 16.8349 5.48117 16.1403 4.59545 15.2199C4.92587 14.8283 5.125 14.3223 5.125 13.7698C5.125 12.5272 4.11764 11.5198 2.875 11.5198C2.79983 11.5198 2.72552 11.5235 2.65225 11.5307C2.55242 11.0427 2.5 10.5374 2.5 10.0198C2.5 9.23585 2.62029 8.47997 2.84342 7.76961C2.85393 7.76976 2.86446 7.76983 2.875 7.76983C4.11764 7.76983 5.125 6.76247 5.125 5.51983C5.125 5.16309 5.04197 4.82578 4.89422 4.52608C5.76156 3.7196 6.82019 3.11605 7.99454 2.79097C8.36665 3.52036 9.12501 4.01984 10 4.01984C10.875 4.01984 11.6334 3.52036 12.0055 2.79097C13.1798 3.11605 14.2384 3.7196 15.1058 4.52608C14.958 4.82578 14.875 5.16309 14.875 5.51983C14.875 6.76247 15.8824 7.76983 17.125 7.76983C17.1355 7.76983 17.1461 7.76976 17.1566 7.76961C17.3797 8.47997 17.5 9.23585 17.5 10.0198C17.5 10.5374 17.4476 11.0427 17.3478 11.5307C17.2745 11.5235 17.2002 11.5198 17.125 11.5198C15.8824 11.5198 14.875 12.5272 14.875 13.7698C14.875 14.3223 15.0741 14.8283 15.4045 15.2199C14.5188 16.1403 13.4002 16.8349 12.1436 17.209C11.8535 16.3018 11.0035 15.6448 10 15.6448C8.9965 15.6448 8.14645 16.3018 7.85643 17.209Z\" stroke=\"currentColor\" fill=\"none\"/>\n<path d=\"M9.99998 12.6448C11.4497 12.6448 12.625 11.4695 12.625 10.0198C12.625 8.57001 11.4497 7.39476 9.99998 7.39476C8.55023 7.39476 7.37498 8.57001 7.37498 10.0198C7.37498 11.4695 8.55023 12.6448 9.99998 12.6448Z\" stroke=\"currentColor\" fill=\"none\"/>\n</symbol>\n<symbol id=\"svg-icon-site\" viewBox=\"0 0 20 20\">\n  <path d=\"M9.99998 17.6522C9.99998 17.6522 16.6666 14.4557 16.6666 8.67788C16.6666 4.99597 13.6819 2.01122 9.99998 2.01122C6.31807 2.01122 3.33331 4.99597 3.33331 8.67788C3.33331 14.4557 9.99998 17.6522 9.99998 17.6522Z\" stroke=\"currentColor\" fill=\"none\"/>\n  <path d=\"M9.99998 11.344C11.4727 11.344 12.6666 10.1501 12.6666 8.67738C12.6666 7.20462 11.4727 6.01071 9.99998 6.01071C8.52722 6.01071 7.33331 7.20462 7.33331 8.67738C7.33331 10.1501 8.52722 11.344 9.99998 11.344Z\" stroke=\"currentColor\" fill=\"none\" stroke-linejoin=\"round\"/>\n</symbol>\n<symbol id=\"svg-icon-sitetemplate\" viewBox=\"0 0 20 20\">\n<path d=\"M16 8.00005V6.50005L12.5 3.00005H4V17.2H10\" stroke=\"currentColor\" stroke-linecap=\"square\" fill=\"none\"/>\n<path d=\"M7 8.00005H12\" stroke=\"currentColor\" stroke-linecap=\"square\" stroke-linejoin=\"round\" fill=\"none\"/>\n<path d=\"M7 11.7H8.5\" stroke=\"currentColor\" stroke-linecap=\"square\" stroke-linejoin=\"round\" fill=\"none\"/>\n<path d=\"M14.5 17.9115C14.5 17.9115 18 16.2333 18 13.2C18 11.267 16.433 9.7 14.5 9.7C12.567 9.7 11 11.267 11 13.2C11 16.2333 14.5 17.9115 14.5 17.9115Z\" stroke=\"currentColor\" stroke-linejoin=\"round\" fill=\"none\"/>\n<path d=\"M14.5 14.45C15.1903 14.45 15.75 13.8904 15.75 13.2C15.75 12.5097 15.1903 11.95 14.5 11.95C13.8096 11.95 13.25 12.5097 13.25 13.2C13.25 13.8904 13.8096 14.45 14.5 14.45Z\" stroke=\"currentColor\" stroke-linejoin=\"round\" fill=\"none\"/>\n</symbol>\n<symbol id=\"svg-icon-statistics\" viewBox=\"0 0 20 20\">\n<path d=\"M7.12912 3.06923C6.2124 3.44934 5.38745 4.00602 4.69662 4.69684C3.3394 6.05407 2.49994 7.92903 2.49994 10C2.49994 14.1421 5.85777 17.4999 9.99987 17.4999C12.0709 17.4999 13.9459 16.6604 15.3031 15.3032C15.994 14.6124 16.5506 13.7875 16.9307 12.8708\" stroke=\"currentColor\" stroke-linecap=\"square\" stroke-linejoin=\"round\"/>\n<path d=\"M10 10H17.4999C17.4999 5.85795 14.1421 2.50015 10 2.50015V10Z\" stroke=\"currentColor\"/>\n</symbol>\n<symbol id=\"svg-icon-tools\" viewBox=\"0 0 20 20\">\n  <path d=\"M2.83302 6.22861H16.833V16.7412H2.83302V6.22861Z\" stroke=\"currentColor\" fill=\"none\" stroke-linecap=\"round\"/>\n  <path d=\"M5.6489 5.85308V3.48459H13.9384V5.85308\" stroke=\"currentColor\" fill=\"none\" stroke-linecap=\"round\"/>\n  <path d=\"M8.11686 9.01274H11.2748\" stroke=\"currentColor\" fill=\"none\" stroke-linecap=\"square\"/>\n</symbol>\n<symbol id=\"svg-icon-user\" viewBox=\"0 0 20 20\">\n<path d=\"M9.99998 8.70838C11.6752 8.70838 13.0333 7.35031 13.0333 5.67504C13.0333 3.99978 11.6752 2.64171 9.99998 2.64171C8.32471 2.64171 6.96664 3.99978 6.96664 5.67504C6.96664 7.35031 8.32471 8.70838 9.99998 8.70838Z\" stroke=\"currentColor\" fill=\"none\" stroke-linecap=\"round\" stroke-linejoin=\"round\"/>\n<path d=\"M3.49998 16.4217V16.9417H16.5V16.4217C16.5 14.4802 16.5 13.5095 16.1222 12.7679C15.7898 12.1156 15.2594 11.5852 14.6071 11.2529C13.8656 10.875 12.8948 10.875 10.9533 10.875H9.04665C7.10514 10.875 6.13439 10.875 5.39282 11.2529C4.74052 11.5852 4.21019 12.1156 3.87783 12.7679C3.49998 13.5095 3.49998 14.4802 3.49998 16.4217Z\" stroke=\"currentColor\" fill=\"none\" stroke-linecap=\"round\"/>\n</symbol>\n</svg>');
  
}