$.su.storeManager.define("ddnsStore",{type:"store",fields:[{name:"id"},{name:"service"},{name:"interfacePortId"},{name:"username"},{name:"password"},{name:"domainName"},{name:"updateInterval"},{name:"status"}],proxy:{root:"result",url:{read:"/setting/service/ddns"}}}),$.su.modelManager.define("editDdnsModel",{type:"model",fields:[{name:"service",defaultValue:0},{name:"interfacePortId",allowBlank:!1},{name:"username",maxLength:128,vtype:"ascii_visible",allowBlank:!1},{name:"password",maxLength:128,vtype:"ascii_visible",allowBlank:!1},{name:"domainName",vtype:"domain",allowBlank:!1},{name:"updateInterval",allowBlank:!1},{name:"status",defaultValue:!0}],proxy:{root:"result",update:{type:"PATCH",url:"/setting/service/ddns"}}}),$.su.storeManager.define("servicesOpts",{type:"store",fields:[{name:"name"},{name:"value"},{name:"selected"}],data:[{name:$.su.CHAR.SERVICES.DYN_DNS,value:0,selected:!0},{name:$.su.CHAR.SERVICES.NO_IP,value:1},{name:$.su.CHAR.SERVICES.PEANUTHULL,value:2},{name:$.su.CHAR.SERVICES.COMEXE,value:3}]}),$.su.storeManager.define("intervalOpts",{type:"store",fields:[{name:"name"},{name:"value"},{name:"selected"}],data:[{name:$.su.CHAR.SERVICES.HOURS_1,value:1},{name:$.su.CHAR.SERVICES.HOURS_6,value:6},{name:$.su.CHAR.SERVICES.HOURS_12,value:12},{name:$.su.CHAR.SERVICES.DAYS_1,value:24},{name:$.su.CHAR.SERVICES.DAYS_2,value:48},{name:$.su.CHAR.SERVICES.DAYS_3,value:72},{name:$.su.CHAR.SERVICES.NEVER,value:0}]}),$.su.modelManager.define("snmpModel",{type:"model",fields:[{name:"snmpV1V2CEnable",defaultValue:!0},{name:"communityString",allowBlank:!1,validator:function(e){return/^[\41\43-\76\100-\133\135-\176]{1,64}$/.test(e)||$.su.CHAR.SERVICES.INVALID_COMMUNITY}},{name:"snmpV3Enable",defaultValue:!0},{name:"username",maxLength:30,allowBlank:!1,validator:function(e,a){a=a.getData();return a.snmpV1V2CEnable&&a.snmpV3Enable&&e===a.communityString?$.su.CHAR.SERVICES.INVALID_USERNAME:/^[a-zA-Z0-9_-]{1,30}$/.test(e)||$.su.CHAR.SERVICES.INVALID_USERNAME_FORMAT}},{name:"password",allowBlank:!1,validator:function(e){return/^[\41\43-\76\100-\133\135-\176]{8,32}$/.test(e)||$.su.CHAR.SERVICES.INVALID_PWD}}],proxy:{root:"result",read:{type:"GET",url:"/setting/snmp"},update:{type:"PUT",url:"/setting/snmp"}}}),$.su.modelManager.define("upnpModel",{type:"model",fields:[{name:"enable",defaultValue:!0},{name:"wanPortIds",allowBlank:!1,validator:function(e){for(var a in e)if(e[a])return!0;return!1}},{name:"networkIds",allowBlank:!1}],convert:function(e){var a={enable:e.enable};if(e.wanPortIds){a.wanPortIds={};for(var n=0,t=e.wanPortIds.length;n<t;n++)a.wanPortIds[e.wanPortIds[n]]=!0}return e.networkIds&&(a.networkIds=e.networkIds),a},serialize:function(e){var a={enable:e.enable};if(e.enable){for(var n in a.wanPortIds=[],e.wanPortIds)e.wanPortIds.hasOwnProperty(n)&&!0===e.wanPortIds[n]&&a.wanPortIds.push(0<=+n?+n:n);a.networkIds=e.networkIds||[]}return a},proxy:{root:"result",read:{type:"GET",url:"/setting/upnp"},update:{type:"PUT",url:"/setting/upnp"}}}),$.su.modelManager.define("mdnsModel",{type:"model",fields:[{name:"enable",defaultValue:!1},{name:"networkIds",allowBlank:!1}],convert:function(e){var a={enable:e.enable};return e.networkIds&&(a.networkIds=e.networkIds),a},serialize:function(e){var a={enable:e.enable};return e.enable&&(a.networkIds=e.networkIds||[]),a},proxy:{root:"result",read:{type:"GET",url:"/setting/mdns"},update:{type:"PUT",url:"/setting/mdns"}}}),$.su.modelManager.define("sshModel",{type:"model",fields:[{name:"sshEnable"},{name:"sshServerPort",vtype:"number",valueType:"number",defaultValue:22,allowBlank:!1,validator:function(e){return 22===e||!(e<1025||65535<e)||$.su.CHAR.CLIENTS.SSH_PORT_ERROR.replace("%num",22).replace("%min",1025).replace("%max",65535)}},{name:"layer3Access",defaultValue:!1}],proxy:{root:"result",read:{type:"GET",url:"/setting/ssh"},update:{type:"PUT",url:"/setting/ssh"}}}),$.su.storeManager.define("rebootScheduleStore",{type:"store",fields:[{name:"id"},{name:"name"},{name:"nextExecute"},{name:"notInDst"},{name:"deviceMacs"},{name:"status"},{name:"occurrence"}],proxy:{root:"result",url:{read:"/setting/service/rebootSchedules"}}}),$.su.modelManager.define("rebootScheduleModel",{type:"model",fields:[{name:"name",allowBlank:!1,maxLength:128,checkCharLength:!0,autoTrim:!0},{name:"status",defaultValue:!0},{name:"deviceMacs"},{name:"timingType",defaultValue:3,valueType:"number"},{name:"dayOfWeek",defaultValue:0,valueType:"number"},{name:"dayOfMonth",defaultValue:1,valueType:"number"},{name:"time",allowBlank:!1},{name:"hour",valueType:"number"},{name:"minute",valueType:"number"}],convert:function(e){return e.occurrence&&(e.timingType=e.occurrence.timingType,e.time=e.occurrence.hour+":"+e.occurrence.minute,e.dayOfWeek=e.occurrence.dayOfWeek,e.dayOfMonth=e.occurrence.dayOfMonth,delete e.occurrence),e},serialize:function(e){var a=e.time.split(":");return e.occurrence={timingType:e.timingType,hour:+a[0],minute:+a[1]},2===e.timingType&&(e.occurrence.dayOfWeek=e.dayOfWeek),3===e.timingType&&(e.occurrence.dayOfMonth=e.dayOfMonth),delete e.timingType,delete e.time,delete e.hour,delete e.minute,delete e.dayOfWeek,delete e.dayOfMonth,e},proxy:{root:"result",update:{type:"PATCH",url:"/setting/service/rebootSchedules"}}}),$.su.storeManager.define("timeTypeOpts",{type:"store",fields:[{name:"name"},{name:"value"},{name:"selected"}],data:[{name:$.su.CHAR.SERVICES.DAY,value:1,selected:!0},{name:$.su.CHAR.SERVICES.WEEK,value:2},{name:$.su.CHAR.SERVICES.MONTH,value:3}]}),$.su.storeManager.define("weekOpts",{type:"store",fields:[{name:"name"},{name:"value"},{name:"selected"}],data:[{name:$.su.CHAR.SERVICES.SUNDAY,value:0,selected:!0},{name:$.su.CHAR.SERVICES.MONDAY,value:1},{name:$.su.CHAR.SERVICES.TUESDAY,value:2},{name:$.su.CHAR.SERVICES.WEDNESDAY,value:3},{name:$.su.CHAR.SERVICES.THURSDAY,value:4},{name:$.su.CHAR.SERVICES.FRIDAY,value:5},{name:$.su.CHAR.SERVICES.SATURDAY,value:6}]}),$.su.storeManager.define("scheduleDeviceStore",{keyProperty:"mac",type:"store",fields:[{name:"id"},{name:"name"},{name:"statusCategory"},{name:"status"},{name:"model"},{name:"firmwareVersion"},{name:"needUpgrade"},{name:"type"},{name:"model"},{name:"modelVersion"}],proxy:{root:"result",url:{read:"/devices"}}}),$.su.storeManager.define("poeScheduleStore",{type:"store",fields:[{name:"id"},{name:"name"},{name:"status"},{name:"turnOnTime"},{name:"nextExecute"},{name:"notInDst"},{name:"poePortsMap"}],proxy:{root:"result",url:{read:"/setting/service/poeSchedules"}}}),$.su.modelManager.define("poeScheduleModel",{type:"model",fields:[{name:"name",allowBlank:!1,maxLength:128,checkCharLength:!0,autoTrim:!0},{name:"status",defaultValue:!0},{name:"turnOnTime",allowBlank:!1},{name:"poePortsMap"}],proxy:{root:"result",update:{type:"PATCH",url:"/setting/service/poeSchedules"}}}),$.su.storeManager.define("poeDeviceStore",{keyProperty:"mac",type:"store",fields:[{name:"id"},{name:"type"},{name:"mac"},{name:"name"},{name:"combinedGateway"},{name:"model"},{name:"modelVersion"},{name:"hardwareVersion"},{name:"firmwareVersion"},{name:"status"},{name:"statusCategory"},{name:"poePort"}],proxy:{root:"result",url:{read:"/poe/ports"}}}),$.su.modelManager.define("exportDataModel",{type:"model",fields:[{name:"exportList",defaultValue:0},{name:"mode",defaultValue:0},{name:"format",defaultValue:1},{name:"siteIds",allowBlank:!1}],proxy:null}),$.su.storeManager.define("exportDataOpts",{type:"store",fields:[{name:"name"},{name:"value"},{name:"selected"}],data:[{name:$.su.CHAR.SERVICES.ED_DEVICE_LIST,value:0,selected:!0},{name:$.su.CHAR.SERVICES.CLIENT_LIST,value:1},{name:$.su.CHAR.SERVICES.INSIGHT_ROUGE_AP_LIST,value:2},{name:$.su.CHAR.SERVICES.LOG_LIST,value:3},{name:$.su.CHAR.SERVICES.GUEST_LIST,value:4},{name:$.su.CHAR.SERVICES.VOUCHER_CODES,value:5}]}),$.su.storeManager.define("exportDataModeOpts",{type:"store",fields:[{name:"value"},{name:"boxlabel"}],data:[{value:0,boxlabel:$.su.CHAR.SERVICES.ALL_COLUMNS},{value:1,boxlabel:$.su.CHAR.SERVICES.CURRENT_DISPLAY_COLS}]}),$.su.storeManager.define("exportTypeOpts",{type:"store",fields:[{name:"name"},{name:"value"},{name:"selected"}],data:[{value:0,name:$.su.CHAR.SERVICES.CSV},{value:1,name:$.su.CHAR.SERVICES.XLS,selected:!0}]}),$.su.storeManager.define("dhcpReservationStore",{type:"store",fields:[{name:"id"},{name:"description"},{name:"netId"},{name:"netName"},{name:"mac"},{name:"ip"},{name:"status"},{name:"exportToIpMacBinding"}],proxy:{root:"result",url:{read:"/setting/service/dhcp"}}}),$.su.modelManager.define("editDhcpModel",{type:"model",fields:[{name:"netId",allowBlank:!1},{name:"mac",vtype:"mac",allowBlank:!1},{name:"ip",vtype:{vtype:"ip",disallowLastZeroFlag:!1,disallowLastAllOneFlag:!1},allowBlank:!1,validator:function(e,a){var n=a.ipStart.getValue(),a=a.ipEnd.getValue();if(n&&a){e=$.su.ipToInt(e);if(e<n+1||a-1<e)return $.su.CHAR.CLIENTS_SETTINGS.IP_ERROR.replace("%start",$.su.intToIp(n+1)).replace("%end",$.su.intToIp(a-1))}return!0}},{name:"description",autoTrim:!0,validator:function(e,a){return!!/^[^ ]$|^[^ ].{0,126}[^ ]$/.test(e)||$.su.CHAR.VTYPETEXT.LEN_MIN_MAX.replace("%min",1).replace("%max",128)}},{name:"status",defaultValue:!0},{name:"ipStart"},{name:"ipEnd"}],proxy:{}}),$.su.storeManager.define("dhcpInterfaceOptions",{type:"store",fields:[{name:"name"},{name:"value"},{name:"boxlabel"},{name:"type"}]}),$.su.modelManager.define("exportDhcpModel",{type:"model",fields:[{name:"interfaceId",allowBlank:!1}],proxy:{url:"/setting/service/dhcp/export"}});