(function (g, f) {var hasExports = typeof exports === 'object';if (typeof define === "function" && define.amd) {define([], f);} else if (typeof module === "object" && module.exports) {module.exports = f();} else {var m = hasExports ? f() : f();var root = hasExports ? exports : g;for(var i in m) root[i] = m[i];}}(typeof self !== 'undefined' ? self : typeof globalThis !== 'undefined' ? globalThis : this, () => {var exports = {};var module = { exports };
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/iframe.ts
var iframe_exports = {};
__export(iframe_exports, {
  ChildIframe: () => ChildIframe,
  ParentIframe: () => ParentIframe
});
module.exports = __toCommonJS(iframe_exports);

// src/eventEmit.ts
var EventEmit = class {
  listener = /* @__PURE__ */ new Map();
  on(event, fn) {
    if (!this.listener.has(event)) {
      this.listener.set(event, /* @__PURE__ */ new Set());
    }
    const fnArray = this.listener.get(event);
    fnArray.add(fn);
    this.listener.set(event, fnArray);
  }
  off(event, fn) {
    if (this.listener.has(event)) {
      const fnArray = this.listener.get(event);
      fnArray.delete(fn);
      this.listener.set(event, fnArray);
    }
  }
  emit(data) {
    if (this.listener.has(data.type)) {
      this.listener.get(data.type)?.forEach((fn) => {
        fn(data);
      });
    }
  }
};

// src/maskObserver.ts
function debounce(func, wait, immediate) {
  let timeout;
  let flag = true;
  if (immediate) {
    return function(...args) {
      clearTimeout(timeout);
      if (flag) {
        func.apply(this, args);
        flag = false;
      }
      timeout = setTimeout(() => {
        flag = true;
      }, wait);
    };
  }
  return function(...args) {
    clearTimeout(timeout);
    timeout = setTimeout(() => {
      func.apply(this, args);
    }, wait);
  };
}
var initMaskObserver = (child, modalContainer = document.body) => {
  let lastMaskVisibleStatus = false;
  let selectors = child.modalSelector.join(",");
  var observeCallback = debounce(() => {
    let currentMaskVisibleStatus = false;
    const allElements = document.querySelectorAll(selectors);
    const length = allElements.length;
    for (let i = 0; i < length; i++) {
      if (getComputedStyle(allElements[i]).display === "none") {
      } else {
        currentMaskVisibleStatus = true;
        if (!lastMaskVisibleStatus) {
          child.send({
            type: "mask-toggle",
            data: {
              visible: currentMaskVisibleStatus
            }
          });
          lastMaskVisibleStatus = currentMaskVisibleStatus;
          return;
        }
      }
    }
    if (lastMaskVisibleStatus && !currentMaskVisibleStatus) {
      child.send({
        type: "mask-toggle",
        data: {
          visible: currentMaskVisibleStatus
        }
      });
      lastMaskVisibleStatus = currentMaskVisibleStatus;
    }
  }, 1);
  const observer = new MutationObserver((mutationRecords) => {
    observeCallback();
  });
  observer.observe(modalContainer, {
    attributes: true,
    attributeFilter: ["style"],
    childList: true,
    subtree: true
  });
};

// src/prefetch.ts
var HTML_COMMENT_REGEX = /<!--([\s\S]*?)-->/g;
var SCRIPT_TAG_REGEX = /(<script[\s\S]*?>)[\s\S]*?<\/script>/gi;
var SCRIPT_SRC_REGEX = /.*\ssrc=('|")?([^>'"\s]+)/;
var LINK_TAG_REGEX = /<(link)\s+[\s\S]*?>/ig;
var STYLE_TYPE_REGEX = /\s+rel=('|")?stylesheet\1.*/;
var STYLE_HREF_REGEX = /.*\shref=('|")?([^>'"\s]+)/;
var isSlowNetwork = navigator.connection ? navigator.connection.saveData || navigator.connection.type !== "wifi" && navigator.connection.type !== "ethernet" && /([23])g/.test(navigator.connection.effectiveType) : false;
var requestIdleCallback = window.requestIdleCallback || function requestIdleCallback2(cb) {
  const start = Date.now();
  return setTimeout(() => {
    cb({
      didTimeout: false,
      timeRemaining() {
        return Math.max(0, 50 - (Date.now() - start));
      }
    });
  }, 1);
};
function parseUrl(indexUrl, sourceUrl) {
  if (sourceUrl.startsWith("http")) {
    return sourceUrl;
  } else {
    if (sourceUrl.startsWith("/")) {
      return indexUrl.replace(/((http|https):\/\/.*?)\/.*/, "$1" + sourceUrl);
    }
    return indexUrl.replace(/((http|https):\/\/.*\/).*/, "$1" + sourceUrl);
  }
}
function prefetchSource(urlArray) {
  return () => Promise.all(urlArray.map((url) => {
    return fetch(url).then((res) => {
      return res.text();
    });
  }));
}
function prefetchEntry(url) {
  return fetch(url).then((response) => {
    return response.text();
  }).then((html) => {
    const scripts = [];
    const styles = [];
    html.replace(HTML_COMMENT_REGEX, "").replace(LINK_TAG_REGEX, (match) => {
      const styleType = !!match.match(STYLE_TYPE_REGEX);
      if (styleType) {
        const styleHref = match.match(STYLE_HREF_REGEX);
        if (styleHref) {
          const src = parseUrl(url, styleHref[2]);
          styles.push(src);
        }
      }
      return "";
    }).replace(SCRIPT_TAG_REGEX, (match) => {
      const scriptHref = match.match(SCRIPT_SRC_REGEX);
      if (scriptHref) {
        const src = parseUrl(url, scriptHref[2]);
        scripts.push(src);
      }
      return "";
    });
    setTimeout(() => {
      requestIdleCallback(prefetchSource(scripts));
      requestIdleCallback(prefetchSource(styles));
      sessionStorage.setItem("_has_cache_" + location.host, "true");
    }, 0);
  });
}
function prefetch(entry) {
  if (!navigator.onLine || isSlowNetwork || sessionStorage.getItem("_has_cache_" + location.host)) {
    return;
  }
  requestIdleCallback(() => {
    prefetchEntry(entry);
  });
}

// src/iframe.ts
var ParentIframe = class extends EventEmit {
  parentNode = /* @__PURE__ */ new Map();
  childList = /* @__PURE__ */ new Set();
  iframeNode = /* @__PURE__ */ new Map();
  childOrigin = /* @__PURE__ */ new Map();
  childStatus = /* @__PURE__ */ new Map();
  childMessageQueue = /* @__PURE__ */ new Map();
  currentChild = "";
  childHeartBeatInterval = null;
  constructor(options) {
    super();
    options.forEach((opt) => {
      this.childList.add(opt.name);
      this.parentNode.set(opt.name, opt.parentNode || document.body);
      this.iframeNode.set(opt.name, document.createElement("iframe"));
      this.childOrigin.set(opt.name, opt.childOrigin);
      this.childStatus.set(opt.name, {
        isInit: false,
        isLaunch: false,
        isActive: false
      });
      if (opt.default) {
        this.switchChild(opt.name);
      }
    });
    this.init();
  }
  switchChild(name, destroyOthers) {
    this.currentChild = name;
    if (!this.childStatus.get(name)?.isLaunch) {
      this.launch();
    } else {
      this.show();
    }
    this.hideOther();
  }
  // int
  init() {
    window.addEventListener("message", (event) => {
      if (event.data) {
        try {
          const data = event.data;
          if (data.type === "micro_app_heartbeat") {
            const name = data.name;
            let status = JSON.parse(JSON.stringify(this.childStatus.get(name)));
            status.isLaunch = true;
            this.childStatus.set(name, status);
            this.childMessageQueue.get(name)?.forEach((msg) => {
              this.send(msg, name);
            });
            this.childMessageQueue.set(name, []);
            this.sendHeartBeat(this.currentChild, 30 * 1e3);
          } else {
            this.emit(data);
          }
        } catch (err) {
          console.log(err);
        }
      }
    });
    this.childList.forEach((name) => {
      this.hide(name);
      this.parentNode.get(name)?.appendChild(this.iframeNode.get(name));
      this.childStatus.set(name, {
        isInit: true,
        isLaunch: false,
        isActive: false
      });
      this.childMessageQueue.set(name, []);
    });
  }
  prefetch(additionalList = [], delay = 1) {
    let resources = [...this.childOrigin.values(), ...additionalList];
    resources.forEach((resource) => {
      try {
        setTimeout(() => {
          prefetch(resource);
        }, delay * 1e3);
      } catch (err) {
      }
    });
  }
  setUrl(name, url, needRefresh) {
    if (needRefresh) {
      this.childStatus.set(name, {
        isInit: true,
        isLaunch: false,
        isActive: false
      });
      this.childOrigin.set(name, url);
    } else {
      this.childOrigin.set(name, url);
      this.iframeNode.get(name).src = this.childOrigin.get(name);
      this.show(name);
    }
  }
  launch(name = this.currentChild) {
    if (!this.iframeNode.get(name))
      return;
    this.iframeNode.get(name).src = this.childOrigin.get(name);
    this.iframeNode.get(name).onload = () => {
      if (!this.iframeNode.get(name).getAttribute("src"))
        return;
      if (this.childStatus.get(name).isLaunch) {
        this.childStatus.set(name, {
          isInit: true,
          isLaunch: false,
          isActive: false
        });
        this.emit({
          type: "reload",
          data: {
            name
          }
        });
      }
      this.show();
    };
  }
  send(data, name = this.currentChild) {
    if (this.childStatus.get(name)?.isLaunch) {
      this.iframeNode.get(name)?.contentWindow?.postMessage({
        ...data,
        name
      }, this.childOrigin.get(name));
    } else {
      if (data.type === "init") {
        this.childMessageQueue.get(name)?.unshift(data);
      } else {
        this.childMessageQueue.get(name)?.push(data);
      }
    }
  }
  sendHeartBeat(name = this.currentChild, interval = 10) {
    clearInterval(this.childHeartBeatInterval);
    if (!this.childStatus.get(name)?.isLaunch) {
      this.childHeartBeatInterval = setInterval(() => {
        this.iframeNode.get(name)?.contentWindow?.postMessage({
          type: "micro_app_heartbeat",
          name
        }, this.childOrigin.get(name));
      }, interval);
    }
  }
  show(name = this.currentChild) {
    if (!this.iframeNode.get(name))
      return;
    this.sendHeartBeat();
    this.iframeNode.get(name).style.display = "block";
    this.childStatus.set(name, {
      isInit: true,
      isLaunch: true,
      isActive: true
    });
  }
  hide(name = this.currentChild) {
    if (!this.iframeNode.get(name))
      return;
    this.iframeNode.get(name).style.display = "none";
    let status = JSON.parse(JSON.stringify(this.childStatus.get(name)));
    status.isActive = false;
    this.childStatus.set(name, status);
  }
  hideOther() {
    this.childList.forEach((name) => {
      if (name !== this.currentChild) {
        this.hide(name);
      }
    });
  }
  destroyChild(name) {
    if (!this.iframeNode.get(name))
      return;
    this.hide();
    this.iframeNode.get(name).setAttribute("src", "");
    this.childStatus.set(name, {
      isInit: true,
      isLaunch: false,
      isActive: false
    });
  }
};
var ChildIframe = class extends EventEmit {
  name;
  origin;
  messageQueue = [];
  isLoaded;
  modalSelector = [".ant-modal-mask"];
  constructor(options) {
    super();
    this.name = options.name;
    this.origin = options.origin || "";
    this.isLoaded = false;
    this.modalSelector = options.modalSelector || this.modalSelector;
    this.init();
  }
  init() {
    window.addEventListener("message", (event) => {
      if (event.data) {
        try {
          const data = event.data;
          if (this.origin === "" && !data.type.includes("webpack")) {
            this.origin = event.origin;
          }
          if (this.origin && data.name === this.name) {
            if (event.data.type === "micro_app_heartbeat") {
              this.sendHeartBeat();
            }
            this.emit(data);
          }
        } catch (err) {
          console.log(err);
        }
      }
    });
    window.addEventListener("click", (event) => {
      this.send({
        type: "click",
        data: {
          x: event.x,
          y: event.y
        }
      });
    }, true);
  }
  sendHeartBeat() {
    if (!this.isLoaded) {
      this.isLoaded = true;
      this.send({
        type: "micro_app_heartbeat",
        data: {}
      });
      setTimeout(() => {
        this.messageQueue.forEach((msg) => {
          this.send(msg);
        });
        this.messageQueue = [];
      }, 0);
      setTimeout(() => {
        initMaskObserver(this);
      }, 1 * 1e3);
    } else {
      console.log(">>> MICRO APP CONNECT");
    }
  }
  send(data) {
    if (this.isLoaded) {
      window.parent.postMessage({
        ...data,
        name: this.name
      }, this.origin);
    } else {
      this.messageQueue.push(data);
    }
  }
};
;if (typeof module.exports == "object" && typeof exports == "object") {
  var __cp = (to, from, except, desc) => {
    if ((from && typeof from === "object") || typeof from === "function") {
      for (let key of Object.getOwnPropertyNames(from)) {
        if (!Object.prototype.hasOwnProperty.call(to, key) && key !== except)
        Object.defineProperty(to, key, {
          get: () => from[key],
          enumerable: !(desc = Object.getOwnPropertyDescriptor(from, key)) || desc.enumerable,
        });
      }
    }
    return to;
  };
  module.exports = __cp(module.exports, exports);
}
return module.exports;
}))
