$.getUIColor = (css_variable_name) => {
  return getComputedStyle(document.documentElement).getPropertyValue(css_variable_name)
}

$.getColorHex = (colorStr) => {
  const rgbaRegex = new RegExp(/rgba\(\s*(\d{1,3})\s*,\s*(\d{1,3})\s*,\s*(\d{1,3})\s*,\s*(\d?\.\d+)\s*\)/)
  const rgbRegex = new RegExp(/rgb\(\s*(\d{1,3})\s*,\s*(\d{1,3})\s*,\s*(\d{1,3})\s*\)/)
  let args;
  if (rgbaRegex.test(colorStr)) {
    args = colorStr.replace(rgbaRegex, '$1,$2,$3,$4').split(',')
  } else if (rgbRegex.test(colorStr)) {
    args = colorStr.replace(rgbRegex, '$1,$2,$3').split(',').push('1')
  } else {
    return {
      hex: colorStr,
      opacity: '1'
    }
  }
  const decimalToHexadecimal = (numberStr) => Number(numberStr).toString(16).padStart(2, 0)
  const opacity = args.pop()
  return {
    hex: `#${args.map(decimalToHexadecimal).join('')}`,
    opacity
  }
}

$.getAlphaColor = (color, alpha, outputFormat = 'hex') => {

  if (!alpha || Number.isNaN(alpha) || alpha < 0 || alpha > 1 ||
    (outputFormat !== 'hex' && outputFormat !== 'rgba')) {
    return color
  }

  if (/^#?([0-9a-fA-F]{3}|[0-9a-fA-F]{6})$/.test(color)) {

    const hex = color.replace(/#/, '');
    const isThreeDigits = hex.length === 3;
    const expandedHex = isThreeDigits ? hex.split('').map(c => c + c).join('') : hex;

    const r = expandedHex.slice(0, 2);
    const g = expandedHex.slice(2, 4);
    const b = expandedHex.slice(4, 6);

    if (outputFormat === 'hex') {
      const rgbHex = Math.round(alpha * 255).toString(16).padStart(2, '0');
      return `#${r}${g}${b}${rgbHex}`;
    }

    const newR = parseInt(r, 16) || 0;
    const newG = parseInt(g, 16) || 0;
    const newB = parseInt(b, 16) || 0;
    return `rgba(${newR}, ${newG}, ${newB}, ${alpha})`;

  } else if (/^rgba?\(\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d+)\s*(,\s*(\d+(?:\.\d+)?)\s*)?\)$/.test(color)) {

    const [, r, g, b, , a] = color.match(/rgba?\(\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d+)\s*(,\s*(\d+\.?\d*)\s*)?\)/).map(Number);
    const finalAlpha = alpha || a || 1;

    if (outputFormat === 'hex') {
      const rgbHex = Math.round(finalAlpha * 255).toString(16).padStart(2, '0');
      return `#${((r << 16) | (g << 8) | b).toString(16).padStart(6, '0')}${rgbHex}`;
    }

    return `rgba(${r}, ${g}, ${b}, ${finalAlpha})`;
  }

  return color
}