/*
 * Copyright (c) 2024, TP-Link Corporation Limited. All rights reserved.
 */

const puppeteer = require("puppeteer-core");

const path = require("path");
const fs = require("fs-extra");

function getFileUrl(str) {
  var pathName = path.resolve(str).replace(/\\/g, "/");
  // Windows drive letter must be prefixed with a slash
  if (pathName[0] !== "/") {
    pathName = "/" + pathName;
  }
  return encodeURI("file://" + pathName);
}

const myArgs = process.argv.slice(2);

(async () => {

  const startTime = Date.now();
  // const browserURL = "http://localhost:21232";
  // ./bin/chromium/chrome.exe --remote-debugging-port=21232 --headless=true --no-sandbox --disable-setuid-sandbox --disable-dev-shm-usage --disable-acceleratccelerated-2d-canvas --no-first-run --no-zygote --single-process --disable-gpu



  const browser = await puppeteer.launch({
    // 此处运行command指令的路径是controller安装目录的路径, 所以指定chrome.exe需要使用绝对路径./bin/chromium/chrome.exe
    executablePath: "./bin/chromium/chrome.exe",
    headless: true,
    timeout: 6000,
    args: [
      '--no-sandbox',
      '--disable-setuid-sandbox',
      '--disable-dev-shm-usage',
      '--disable-accelerated-2d-canvas',
      '--no-first-run',
      '--no-zygote',
      '--single-process', // <- unsupported in Windows
      '--disable-gpu',
      '--js-flags="--max-old-space-size=256"']
  });


let chromeTmpDataDir = null;

// find chrome user data dir (puppeteer_dev_profile-XXXXX) to delete it after it had been used
let chromeSpawnArgs = browser.process().spawnargs;
for (let i = 0; i < chromeSpawnArgs.length; i++) {
    if (chromeSpawnArgs[i].indexOf("--user-data-dir=") === 0) {
        chromeTmpDataDir = chromeSpawnArgs[i].replace("--user-data-dir=", "");
    }
}
  // const browser = await puppeteer.connect({browserURL})

  let page;
  try {

    page = await browser.newPage();
    console.log("browser launched time", Date.now() - startTime)

    const fileName = myArgs[0];
    const imageCount = myArgs[1];
    const pdfName = fileName.replace(/html/g, "pdf");

    const address = getFileUrl(fileName);

    await page.setViewport({width: 1240, height: 1754, deviceScaleFactor: 1.0});

    await page.goto(address);

    console.log("page opened")

    const waitCommand = 'document.getElementById("done-text").innerText >= ' + imageCount;

    try {
      await page.waitForFunction(waitCommand, {timeout: 5000});
    } catch (timeoutError) {
      console.log("timeout waiting:", timeoutError);
    }

    console.log("image drawed")

    const startPDFTime = Date.now();

    await page.pdf({ path: pdfName, printBackground: true });

    const finishTime = Date.now();

    console.log("start time: ", startTime, ", pdf time: ", startPDFTime, ", finish time: ", finishTime);
  } catch (err) {
    console.log(err);
  } finally {
    await browser.close();
    if(chromeTmpDataDir != null) {
      // console.log(chromeTmpDataDir);
      fs.removeSync(chromeTmpDataDir);
    }
  // } finally {
  //   page.close();
  //   process.exit(0);
  }
})();