/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.client.port.mongo.data.statistic.ssidclientstat;

import com.tplink.smb.omada.client.domain.model.statistic.aggregation.SsidClientAggregationDTO;
import com.tplink.smb.omada.client.domain.model.statistic.networkreport.a.a;
import com.tplink.smb.omada.client.domain.model.statistic.networkreport.a.i;
import com.tplink.smb.omada.client.port.mongo.data.statistic.ssidclientstat.BaseSsidClientStatPO;
import com.tplink.smb.omada.client.port.mongo.data.statistic.ssidclientstat.b;
import com.tplink.smb.omada.common.mongo.repository.s;
import com.tplink.smb.omada.common.omadac.OmadacType;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.bson.types.ObjectId;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.AggregationOptions;
import org.springframework.data.mongodb.core.aggregation.AggregationResults;
import org.springframework.data.mongodb.core.index.IndexDefinition;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Component;

@Component
public abstract class c<E extends a, P extends BaseSsidClientStatPO>
extends s<P>
implements com.tplink.smb.omada.client.domain.model.statistic.networkreport.a.b<E> {
    private static final String a = "total";
    private static final String b = "average";
    private static final int c = 5;
    @Autowired
    @Qualifier(value="dataMongoTemplate")
    private MongoTemplate mongoTemplate;

    protected MongoTemplate getMongoTemplate() {
        return this.mongoTemplate;
    }

    public void a(E entity) {
        Object po = com.tplink.smb.omada.client.port.mongo.data.statistic.ssidclientstat.b.a(entity, this.getPOClass());
        if (po == null) {
            return;
        }
        this.mongoTemplate.insert(po, this.getCollectionNameForSave(po));
    }

    public void a(List<E> list) {
        List statPOList = list.stream().map(stat -> com.tplink.smb.omada.client.port.mongo.data.statistic.ssidclientstat.b.a(stat, this.getPOClass())).filter(Objects::nonNull).collect(Collectors.toList());
        Map<String, List<BaseSsidClientStatPO>> statPOListsGroupingByCollection = statPOList.stream().collect(Collectors.groupingBy(x$0 -> this.getCollectionNameForSave(x$0)));
        statPOListsGroupingByCollection.forEach((collectionName, poList) -> this.mongoTemplate.insert((Collection)poList, collectionName));
    }

    public i a() {
        return new i(ObjectId.get().toString());
    }

    public void a(String omadacId, String siteId) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId).and("site_id").is((Object)siteId));
        this.iteratorCollections(collectionName -> this.mongoTemplate.remove(query, collectionName));
    }

    public List<SsidClientAggregationDTO> a(String omadacId, String siteId, long start, long end) {
        HashMap topResMap = new HashMap();
        Aggregation aggregation = this.c(omadacId, siteId, start, end);
        this.iteratorCollectionsByTimeAsc(start, end, collectionName -> {
            AggregationResults results = this.mongoTemplate.aggregate(aggregation, collectionName, SsidClientAggregationDTO.class);
            List mappedResults = results.getMappedResults();
            mappedResults.forEach(statDTO -> topResMap.compute(statDTO.getSsid(), (mac, previous) -> {
                if (previous == null) {
                    return statDTO;
                }
                SsidClientAggregationDTO copied = new SsidClientAggregationDTO();
                copied.setSsid(statDTO.getSsid());
                copied.setAverage((statDTO.getAverage() * (double)statDTO.getTotal() + previous.getAverage() * (double)previous.getTotal()) / (double)(statDTO.getTotal() + previous.getTotal()));
                copied.setTotal(statDTO.getTotal() + previous.getTotal());
                return copied;
            }));
        });
        return new ArrayList<SsidClientAggregationDTO>(topResMap.values());
    }

    public List<E> b(String omadacId, String siteId, long start, long end) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId).and("site_id").is((Object)siteId).and("time").gt((Object)start).lte((Object)end));
        LinkedList result = new LinkedList();
        this.iteratorCollectionsByTimeAsc(start, end, collectionName -> {
            List poList = this.mongoTemplate.find(query, this.getPOClass(), collectionName);
            result.addAll(poList.stream().map(po -> com.tplink.smb.omada.client.port.mongo.data.statistic.ssidclientstat.b.a(po, this.b())).filter(Objects::nonNull).collect(Collectors.toList()));
        });
        return result;
    }

    public List<E> a(String omadacId, String siteId, Collection<String> ssids, long start, long end) {
        Query query = new Query();
        if (OmadacType.s()) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId));
        }
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"site_id").is((Object)siteId).and("ssid").in(ssids).and("time").gte((Object)start).lt((Object)end));
        LinkedList result = new LinkedList();
        this.iteratorCollectionsByTimeAsc(start, end, collectionName -> {
            List poList = this.mongoTemplate.find(query, this.getPOClass(), collectionName);
            result.addAll(poList.stream().map(po -> com.tplink.smb.omada.client.port.mongo.data.statistic.ssidclientstat.b.a(po, this.b())).filter(Objects::nonNull).collect(Collectors.toList()));
        });
        return result;
    }

    public long a(String omadacId) {
        AtomicLong atomicLong = new AtomicLong(0L);
        this.iteratorCollections(collectionName -> {
            long count = this.mongoTemplate.count(Query.query((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId)), collectionName);
            atomicLong.addAndGet(count);
        });
        return atomicLong.get();
    }

    public void a(String omadacId, int limit) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId));
        query.with(Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{"time"})).limit(limit);
        AtomicLong clearedCount = new AtomicLong(0L);
        this.iteratorCollections(collectionName -> {
            if (clearedCount.get() < (long)limit) {
                Query decorated = Query.of((Query)query).limit((int)((long)limit - clearedCount.get()));
                long deletedCount = this.mongoTemplate.remove(decorated, collectionName).getDeletedCount();
                clearedCount.addAndGet(deletedCount);
            }
        });
    }

    public void a(String omadacId, long time) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId).and("time").lt((Object)time));
        this.iteratorCollectionsByTimeAsc(0L, time, collectionName -> this.mongoTemplate.remove(query, collectionName));
    }

    public void a(long time) {
        this.tryDropCollectionOrDeleteByTimeLessThan(time, () -> {
            Query query = Query.query((CriteriaDefinition)Criteria.where((String)"time").lt((Object)time));
            this.mongoTemplate.remove(query, this.getCollectionNameOrPrefixIfSliced());
        });
    }

    public void b(String omadacId) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId));
        this.iteratorCollections(collectionName -> this.mongoTemplate.remove(query, collectionName));
    }

    private Aggregation c(String omadacId, String siteId, long start, long end) {
        Criteria criteria = OmadacType.s() ? Criteria.where((String)"omadac_id").is((Object)omadacId).and("site_id").is((Object)siteId).and("time").gte((Object)start).lt((Object)end) : Criteria.where((String)"site_id").is((Object)siteId).and("time").gte((Object)start).lt((Object)end);
        return Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), Aggregation.group((String[])new String[]{"ssid"}).count().as(a).avg("cl").as(b), Aggregation.project((String[])new String[0]).and(b).as(b).and(a).as(a).and("_id").as("ssid"), Aggregation.sort((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{b}), Aggregation.limit((long)5L)}).withOptions(AggregationOptions.builder().allowDiskUse(true).build());
    }

    @Nonnull
    protected IndexDefinition[] getIndexDefinitions() {
        return BaseSsidClientStatPO.INDEX_DEFINITIONS;
    }

    protected abstract Class<E> b();
}

