/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.client.port.mongo.data.statistic.a;

import com.tplink.smb.omada.client.api.internal.dto.ApClientConnectStatDTO;
import com.tplink.smb.omada.client.domain.model.statistic.clientconnect.a.a;
import com.tplink.smb.omada.client.domain.model.statistic.clientconnect.dto.ClientConnectStatQueryDTO;
import com.tplink.smb.omada.client.domain.model.statistic.clientconnect.model.ApConnectStatCountDTO;
import com.tplink.smb.omada.client.domain.model.statistic.clientconnect.model.SiteWifiHealthDTO;
import com.tplink.smb.omada.client.domain.model.statistic.clientconnect.model.WifiConnProblemByApDTO;
import com.tplink.smb.omada.client.domain.model.statistic.clientconnect.model.WifiConnProblemByClientDTO;
import com.tplink.smb.omada.client.domain.model.statistic.clientconnect.model.WifiConnProblemByMapPropertyDTO;
import com.tplink.smb.omada.client.domain.model.statistic.clientconnect.model.WifiConnProblemByRadioDTO;
import com.tplink.smb.omada.client.domain.model.statistic.clientconnect.model.WifiConnProblemBySsidDTO;
import com.tplink.smb.omada.client.domain.model.statistic.clientconnect.model.WifiConnProblemByStageDTO;
import com.tplink.smb.omada.client.port.mongo.a.d;
import com.tplink.smb.omada.client.port.mongo.data.statistic.connectstat.ClientConnectStatPO;
import com.tplink.smb.omada.common.mongo.repository.s;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.common.util.x;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationResults;
import org.springframework.data.mongodb.core.index.IndexDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.util.CollectionUtils;

public abstract class b<P extends ClientConnectStatPO>
extends s<P>
implements a {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(b.class);
    @Autowired
    @Qualifier(value="dataMongoTemplate")
    protected MongoTemplate mongoTemplate;
    @Autowired
    private com.tplink.smb.omada.client.port.h.a b;

    protected MongoTemplate getMongoTemplate() {
        return this.mongoTemplate;
    }

    @Nonnull
    protected IndexDefinition[] getIndexDefinitions() {
        return ClientConnectStatPO.INDEX_DEFINITIONS;
    }

    protected abstract Class<P> a();

    public void a(String omadacId) {
        Query query = d.a(omadacId);
        this.iteratorCollections(collectionName -> this.mongoTemplate.remove(query, collectionName));
    }

    public void a(String omadacId, String siteId) {
        Query query = d.a(omadacId, siteId);
        this.iteratorCollections(collectionName -> this.mongoTemplate.remove(query, collectionName));
    }

    public void a(String omadacId, String siteId, String mac) {
        Query query = d.a(omadacId, siteId, mac);
        this.iteratorCollections(collectionName -> this.mongoTemplate.remove(query, collectionName));
    }

    public void a(String omadacId, long time) {
        Query query = d.a(omadacId, time);
        this.iteratorCollections(collectionName -> this.mongoTemplate.remove(query, collectionName));
    }

    public void a(long time) {
        Query query = d.a(time);
        this.iteratorCollections(collectionName -> this.mongoTemplate.remove(query, collectionName));
    }

    public List<ApClientConnectStatDTO> a(ClientConnectStatQueryDTO queryDTO, int apNumLimit) {
        long start = System.currentTimeMillis();
        Integer radioId = queryDTO.getRadioId();
        Aggregation aggregation = d.c(queryDTO);
        HashMap apClientConnectStatMap = new HashMap();
        this.iteratorCollectionsByTimeAsc(queryDTO.getStart(), queryDTO.getEnd(), collectionName -> {
            AggregationResults results = this.mongoTemplate.aggregate(aggregation, collectionName, ApClientConnectStatDTO.class);
            List stats = results.getMappedResults();
            if (a.isDebugEnabled()) {
                a.debug("Get aggregate ap assoc result of {} is {}", collectionName, (Object)x.a((Object)stats));
            }
            stats.forEach(stat -> {
                ApClientConnectStatDTO srcStat = apClientConnectStatMap.computeIfAbsent(stat.getApMac(), apMac -> new ApClientConnectStatDTO(apMac, radioId));
                srcStat.accumulate(stat.getConnectFailNum(), stat.getConnectSuccessNum());
            });
        });
        Collection statList = apClientConnectStatMap.values();
        List<ApClientConnectStatDTO> sortedList = statList.stream().map(stat -> {
            stat.calculateFailPercent();
            return stat;
        }).sorted(Comparator.comparing(ApClientConnectStatDTO::getFailPercent).reversed()).limit(apNumLimit).collect(Collectors.toList());
        if (a.isDebugEnabled()) {
            a.debug("Query Ap Client Assoc Stat : query : {}, result : {}, use time : {} ms", new Object[]{x.a((Object)queryDTO), sortedList, System.currentTimeMillis() - start});
        }
        return sortedList;
    }

    public SiteWifiHealthDTO a(ClientConnectStatQueryDTO queryDTO) {
        long start = System.currentTimeMillis();
        SiteWifiHealthDTO wifiHealthResult = new SiteWifiHealthDTO(queryDTO.getSiteId());
        Aggregation aggregation = d.d(queryDTO);
        this.iteratorCollectionsByTimeAsc(queryDTO.getStart(), queryDTO.getEnd(), collectionName -> {
            AggregationResults results = this.mongoTemplate.aggregate(aggregation, collectionName, SiteWifiHealthDTO.class);
            SiteWifiHealthDTO stat = (SiteWifiHealthDTO)results.getUniqueMappedResult();
            if (a.isDebugEnabled()) {
                a.debug("Get aggregate site assoc result of {}  is {}", collectionName, (Object)x.a((Object)stat));
            }
            wifiHealthResult.accumulate(stat);
        });
        if (a.isDebugEnabled()) {
            a.debug("Query Site Wifi Health : query : {}, result : {}, use time : {} ms", new Object[]{x.a((Object)queryDTO), wifiHealthResult, System.currentTimeMillis() - start});
        }
        return wifiHealthResult;
    }

    public Map<Long, WifiConnProblemByStageDTO> b(ClientConnectStatQueryDTO queryDTO) {
        long start = System.currentTimeMillis();
        TreeMap<Long, WifiConnProblemByStageDTO> map = new TreeMap<Long, WifiConnProblemByStageDTO>();
        Aggregation aggregation = d.e(queryDTO);
        this.iteratorCollectionsByTimeAsc(queryDTO.getStart(), queryDTO.getEnd(), collectionName -> {
            AggregationResults results = this.mongoTemplate.aggregate(aggregation, collectionName, WifiConnProblemByStageDTO.class);
            List stats = results.getMappedResults();
            for (WifiConnProblemByStageDTO stat : stats) {
                Long time = stat.getTime();
                if (Objects.isNull(time)) continue;
                WifiConnProblemByStageDTO dataStat = map.computeIfAbsent(time, WifiConnProblemByStageDTO::new);
                dataStat.accumulate(stat);
            }
        });
        a.debug("Query Site Wifi Connection By Stage : query : {}, result.size : {}, use time : {} ms", new Object[]{x.a((Object)queryDTO), map.size(), System.currentTimeMillis() - start});
        return map;
    }

    public List<WifiConnProblemByRadioDTO> c(ClientConnectStatQueryDTO queryDTO) {
        long start = System.currentTimeMillis();
        TreeMap map = new TreeMap();
        Aggregation aggregation = d.a(queryDTO, "radio", "radio");
        this.iteratorCollectionsByTimeAsc(queryDTO.getStart(), queryDTO.getEnd(), collectionName -> {
            AggregationResults results = this.mongoTemplate.aggregate(aggregation, collectionName, WifiConnProblemByRadioDTO.class);
            List stats = results.getMappedResults();
            for (WifiConnProblemByRadioDTO stat : stats) {
                Long time = stat.getTime();
                Integer radio = stat.getRadio();
                if (Objects.isNull(time) || Objects.isNull(radio)) continue;
                String timeRadioKey = this.a(time, radio);
                WifiConnProblemByRadioDTO dataStat = map.computeIfAbsent(timeRadioKey, key -> new WifiConnProblemByRadioDTO(time.longValue(), radio));
                dataStat.accumulate(stat);
            }
        });
        a.debug("Query Site Wifi Connection By Radio : query : {}, result.size : {}, use time : {} ms", new Object[]{x.a((Object)queryDTO), map.size(), System.currentTimeMillis() - start});
        return new ArrayList<WifiConnProblemByRadioDTO>(map.values());
    }

    public List<WifiConnProblemByApDTO> d(ClientConnectStatQueryDTO queryDTO) {
        long start = System.currentTimeMillis();
        TreeMap map = new TreeMap();
        Aggregation aggregation = d.a(queryDTO, "ap_mac", "apMac");
        this.iteratorCollectionsByTimeAsc(queryDTO.getStart(), queryDTO.getEnd(), collectionName -> {
            AggregationResults results = this.mongoTemplate.aggregate(aggregation, collectionName, WifiConnProblemByApDTO.class);
            List stats = results.getMappedResults();
            for (WifiConnProblemByApDTO stat : stats) {
                Long time = stat.getTime();
                String apMac = stat.getApMac();
                if (Objects.isNull(time) || T.c((String)apMac)) continue;
                String timeApKey = this.a(time, apMac);
                WifiConnProblemByApDTO dataStat = map.computeIfAbsent(timeApKey, key -> new WifiConnProblemByApDTO(time.longValue(), apMac));
                dataStat.accumulate(stat);
            }
        });
        a.debug("Query Site Wifi Connection By Ap : query : {}, result.size : {}, use time : {} ms", new Object[]{x.a((Object)queryDTO), map.size(), System.currentTimeMillis() - start});
        return new ArrayList<WifiConnProblemByApDTO>(map.values());
    }

    public List<WifiConnProblemBySsidDTO> e(ClientConnectStatQueryDTO queryDTO) {
        long start = System.currentTimeMillis();
        TreeMap map = new TreeMap();
        Aggregation aggregation = d.a(queryDTO, "ssid", "ssid");
        this.iteratorCollectionsByTimeAsc(queryDTO.getStart(), queryDTO.getEnd(), collectionName -> {
            AggregationResults results = this.mongoTemplate.aggregate(aggregation, collectionName, WifiConnProblemBySsidDTO.class);
            List stats = results.getMappedResults();
            for (WifiConnProblemBySsidDTO stat : stats) {
                Long time = stat.getTime();
                String ssid = stat.getSsid();
                if (Objects.isNull(time) || T.c((String)ssid)) continue;
                String timeSsidKey = this.a(time, ssid);
                WifiConnProblemBySsidDTO dataStat = map.computeIfAbsent(timeSsidKey, key -> new WifiConnProblemBySsidDTO(time.longValue(), ssid));
                dataStat.accumulate(stat);
            }
        });
        a.debug("Query Site Wifi Connection By SSID : query : {}, result.size : {}, use time : {} ms", new Object[]{x.a((Object)queryDTO), map.size(), System.currentTimeMillis() - start});
        return new ArrayList<WifiConnProblemBySsidDTO>(map.values());
    }

    public Map<String, WifiConnProblemByClientDTO> f(ClientConnectStatQueryDTO queryDTO) {
        long start = System.currentTimeMillis();
        TreeMap<String, WifiConnProblemByClientDTO> map = new TreeMap<String, WifiConnProblemByClientDTO>();
        Aggregation aggregation = d.b(queryDTO, "mac", "clientMac");
        this.iteratorCollectionsByTimeAsc(queryDTO.getStart(), queryDTO.getEnd(), collectionName -> {
            AggregationResults results = this.mongoTemplate.aggregate(aggregation, collectionName, WifiConnProblemByClientDTO.class);
            List stats = results.getMappedResults();
            for (WifiConnProblemByClientDTO stat : stats) {
                Long time = stat.getTime();
                String clientMac = stat.getClientMac();
                if (Objects.isNull(time) || T.c((String)clientMac)) continue;
                WifiConnProblemByClientDTO dataStat = map.computeIfAbsent(clientMac, key -> new WifiConnProblemByClientDTO(time.longValue(), clientMac));
                long maxTime = Math.max(time, dataStat.getTime());
                dataStat.setTime(Long.valueOf(maxTime));
                stat.setTime(Long.valueOf(maxTime));
                dataStat.accumulate(stat);
            }
        });
        a.debug("Query Site Wifi Connection Top Client : query : {}, result.size : {}, use time : {} ms", new Object[]{x.a((Object)queryDTO), map.size(), System.currentTimeMillis() - start});
        return map;
    }

    public List<WifiConnProblemByClientDTO> a(ClientConnectStatQueryDTO queryDTO, Set<String> clientMacs) {
        if (CollectionUtils.isEmpty(clientMacs)) {
            return Collections.emptyList();
        }
        long start = System.currentTimeMillis();
        ArrayList<WifiConnProblemByClientDTO> statList = new ArrayList<WifiConnProblemByClientDTO>();
        Aggregation aggregation = d.a(queryDTO, clientMacs, "mac", "clientMac");
        this.iteratorCollectionsByTimeAsc(queryDTO.getStart(), queryDTO.getEnd(), collectionName -> {
            AggregationResults results = this.mongoTemplate.aggregate(aggregation, collectionName, WifiConnProblemByClientDTO.class);
            List stats = results.getMappedResults();
            if (!CollectionUtils.isEmpty((Collection)stats)) {
                statList.addAll(stats);
            }
        });
        a.debug("Query Site Wifi Connection Client History : query : {}, result.size : {}, use time : {} ms", new Object[]{x.a((Object)queryDTO), statList.size(), System.currentTimeMillis() - start});
        return statList;
    }

    public Map<String, WifiConnProblemByApDTO> g(ClientConnectStatQueryDTO queryDTO) {
        long start = System.currentTimeMillis();
        TreeMap<String, WifiConnProblemByApDTO> map = new TreeMap<String, WifiConnProblemByApDTO>();
        Aggregation aggregation = d.b(queryDTO, "ap_mac", "apMac");
        this.iteratorCollectionsByTimeAsc(queryDTO.getStart(), queryDTO.getEnd(), collectionName -> {
            AggregationResults results = this.mongoTemplate.aggregate(aggregation, collectionName, WifiConnProblemByApDTO.class);
            List stats = results.getMappedResults();
            for (WifiConnProblemByApDTO stat : stats) {
                Long time = stat.getTime();
                String apMac = stat.getApMac();
                if (Objects.isNull(time) || T.c((String)apMac)) continue;
                WifiConnProblemByApDTO dataStat = map.computeIfAbsent(apMac, key -> new WifiConnProblemByApDTO(time.longValue(), apMac));
                long maxTime = Math.max(time, dataStat.getTime());
                dataStat.setTime(Long.valueOf(maxTime));
                stat.setTime(Long.valueOf(maxTime));
                dataStat.accumulate(stat);
            }
        });
        a.debug("Query Site Wifi Connection Top Ap : query : {}, result.size : {}, use time : {} ms", new Object[]{x.a((Object)queryDTO), map.size(), System.currentTimeMillis() - start});
        return map;
    }

    public List<WifiConnProblemByApDTO> b(ClientConnectStatQueryDTO queryDTO, Set<String> apMacs) {
        if (CollectionUtils.isEmpty(apMacs)) {
            return Collections.emptyList();
        }
        long start = System.currentTimeMillis();
        ArrayList<WifiConnProblemByApDTO> statList = new ArrayList<WifiConnProblemByApDTO>();
        Aggregation aggregation = d.a(queryDTO, apMacs, "ap_mac", "apMac");
        this.iteratorCollectionsByTimeAsc(queryDTO.getStart(), queryDTO.getEnd(), collectionName -> {
            AggregationResults results = this.mongoTemplate.aggregate(aggregation, collectionName, WifiConnProblemByApDTO.class);
            List stats = results.getMappedResults();
            if (!CollectionUtils.isEmpty((Collection)stats)) {
                statList.addAll(stats);
            }
        });
        a.debug("Query Site Wifi Connection Ap History : query : {}, result.size : {}, use time : {} ms", new Object[]{x.a((Object)queryDTO), statList.size(), System.currentTimeMillis() - start});
        return statList;
    }

    public List<WifiConnProblemByMapPropertyDTO> h(ClientConnectStatQueryDTO queryDTO) {
        long start = System.currentTimeMillis();
        ArrayList<WifiConnProblemByMapPropertyDTO> statList = new ArrayList<WifiConnProblemByMapPropertyDTO>();
        Aggregation aggregation = d.c(queryDTO, "authenticationTypeFail", "authenticationTypeDelay");
        this.iteratorCollectionsByTimeAsc(queryDTO.getStart(), queryDTO.getEnd(), collectionName -> {
            AggregationResults results = this.mongoTemplate.aggregate(aggregation, collectionName, WifiConnProblemByMapPropertyDTO.class);
            List stats = results.getMappedResults();
            if (!CollectionUtils.isEmpty((Collection)stats)) {
                statList.addAll(stats);
            }
        });
        a.debug("Query Site Wifi Connection By Auth Type : query : {}, result.size : {}, use time : {} ms", new Object[]{x.a((Object)queryDTO), statList.size(), System.currentTimeMillis() - start});
        return statList;
    }

    public List<WifiConnProblemByMapPropertyDTO> i(ClientConnectStatQueryDTO queryDTO) {
        long start = System.currentTimeMillis();
        ArrayList<WifiConnProblemByMapPropertyDTO> statList = new ArrayList<WifiConnProblemByMapPropertyDTO>();
        Aggregation aggregation = d.c(queryDTO, "authenticationServerFail", "authenticationServerDelay");
        this.iteratorCollectionsByTimeAsc(queryDTO.getStart(), queryDTO.getEnd(), collectionName -> {
            AggregationResults results = this.mongoTemplate.aggregate(aggregation, collectionName, WifiConnProblemByMapPropertyDTO.class);
            List stats = results.getMappedResults();
            if (!CollectionUtils.isEmpty((Collection)stats)) {
                statList.addAll(stats);
            }
        });
        a.debug("Query Site Wifi Connection By Auth Server : query : {}, result.size : {}, use time : {} ms", new Object[]{x.a((Object)queryDTO), statList.size(), System.currentTimeMillis() - start});
        return statList;
    }

    public List<WifiConnProblemByMapPropertyDTO> j(ClientConnectStatQueryDTO queryDTO) {
        long start = System.currentTimeMillis();
        ArrayList<WifiConnProblemByMapPropertyDTO> statList = new ArrayList<WifiConnProblemByMapPropertyDTO>();
        Aggregation aggregation = d.c(queryDTO, "dhcpReasonFail", "dhcpReasonDelay");
        this.iteratorCollectionsByTimeAsc(queryDTO.getStart(), queryDTO.getEnd(), collectionName -> {
            AggregationResults results = this.mongoTemplate.aggregate(aggregation, collectionName, WifiConnProblemByMapPropertyDTO.class);
            List stats = results.getMappedResults();
            if (!CollectionUtils.isEmpty((Collection)stats)) {
                statList.addAll(stats);
            }
        });
        a.debug("Query Site Wifi Connection By Dhcp Reason : query : {}, result.size : {}, use time : {} ms", new Object[]{x.a((Object)queryDTO), statList.size(), System.currentTimeMillis() - start});
        return statList;
    }

    public List<WifiConnProblemByMapPropertyDTO> k(ClientConnectStatQueryDTO queryDTO) {
        long start = System.currentTimeMillis();
        ArrayList<WifiConnProblemByMapPropertyDTO> statList = new ArrayList<WifiConnProblemByMapPropertyDTO>();
        Aggregation aggregation = d.c(queryDTO, "dnsReasonFail", "dnsReasonDelay");
        this.iteratorCollectionsByTimeAsc(queryDTO.getStart(), queryDTO.getEnd(), collectionName -> {
            AggregationResults results = this.mongoTemplate.aggregate(aggregation, collectionName, WifiConnProblemByMapPropertyDTO.class);
            List stats = results.getMappedResults();
            if (!CollectionUtils.isEmpty((Collection)stats)) {
                statList.addAll(stats);
            }
        });
        a.debug("Query Site Wifi Connection By Dns Reason : query : {}, result.size : {}, use time : {} ms", new Object[]{x.a((Object)queryDTO), statList.size(), System.currentTimeMillis() - start});
        return statList;
    }

    public List<WifiConnProblemByMapPropertyDTO> l(ClientConnectStatQueryDTO queryDTO) {
        long start = System.currentTimeMillis();
        ArrayList<WifiConnProblemByMapPropertyDTO> statList = new ArrayList<WifiConnProblemByMapPropertyDTO>();
        Aggregation aggregation = d.c(queryDTO, "dnsServerFail", "dnsServerDelay");
        this.iteratorCollectionsByTimeAsc(queryDTO.getStart(), queryDTO.getEnd(), collectionName -> {
            AggregationResults results = this.mongoTemplate.aggregate(aggregation, collectionName, WifiConnProblemByMapPropertyDTO.class);
            List stats = results.getMappedResults();
            if (!CollectionUtils.isEmpty((Collection)stats)) {
                statList.addAll(stats);
            }
        });
        a.debug("Query Site Wifi Connection By Dns Server : query : {}, result.size : {}, use time : {} ms", new Object[]{x.a((Object)queryDTO), statList.size(), System.currentTimeMillis() - start});
        return statList;
    }

    public Map<String, ApConnectStatCountDTO> m(ClientConnectStatQueryDTO queryDTO) {
        long start = System.currentTimeMillis();
        HashMap<String, ApConnectStatCountDTO> result = new HashMap<String, ApConnectStatCountDTO>();
        Aggregation aggregation = d.b(queryDTO);
        this.iteratorCollectionsByTimeAsc(queryDTO.getStart(), queryDTO.getEnd(), collectionName -> {
            AggregationResults results = this.mongoTemplate.aggregate(aggregation, collectionName, ApConnectStatCountDTO.class);
            List stats = results.getMappedResults();
            if (!CollectionUtils.isEmpty((Collection)stats)) {
                stats.forEach(stat -> {
                    if (Objects.isNull(stat) || Objects.isNull(stat.getApMac())) {
                        return;
                    }
                    ApConnectStatCountDTO dto = result.computeIfAbsent(stat.getApMac(), ApConnectStatCountDTO::new);
                    dto.accumulate(stat);
                });
            }
        });
        a.debug("Query Site AP Connect Stat Count : query : {}, result.size : {}, use time : {} ms", new Object[]{x.a((Object)queryDTO), result.size(), System.currentTimeMillis() - start});
        return result;
    }

    private String a(Long time, Integer radio) {
        return time + ":" + radio;
    }

    private String a(Long time, String apMac) {
        return time + ":" + apMac;
    }
}

