/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.client.port.mongo.data.history;

import com.mongodb.bulk.BulkWriteResult;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoIterable;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Sorts;
import com.tplink.smb.eventcenter.api.event.DomainEventSubscriber;
import com.tplink.smb.eventcenter.domain.DomainEventBusHolder;
import com.tplink.smb.omada.client.api.internal.dto.ClientsLongestUptimeDTO;
import com.tplink.smb.omada.client.common.domain.model.shared.r;
import com.tplink.smb.omada.client.common.domain.model.shared.z;
import com.tplink.smb.omada.client.domain.model.history.h;
import com.tplink.smb.omada.client.domain.model.history.i;
import com.tplink.smb.omada.client.domain.model.history.j;
import com.tplink.smb.omada.client.domain.model.statistic.aggregation.ClientMacAggregationDTO;
import com.tplink.smb.omada.client.domain.model.statistic.aggregation.ClientMacDeviceMacDTO;
import com.tplink.smb.omada.client.domain.model.statistic.aggregation.ClientMacGuestAggregationDTO;
import com.tplink.smb.omada.client.domain.model.statistic.aggregation.ClientMacRadioAggregationDTO;
import com.tplink.smb.omada.client.domain.model.statistic.aggregation.ClientMacSsidAggregationDTO;
import com.tplink.smb.omada.client.port.mongo.data.history.ClientHistoryPO;
import com.tplink.smb.omada.client.port.mongo.data.history.c;
import com.tplink.smb.omada.client.port.mongo.data.history.f;
import com.tplink.smb.omada.client.port.mongo.data.history.g;
import com.tplink.smb.omada.client.port.mongo.data.history.k;
import com.tplink.smb.omada.client.port.mongo.data.history.l;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.constant.DeviceTypeEnum;
import com.tplink.smb.omada.common.e.n;
import com.tplink.smb.omada.common.gridquery.a;
import com.tplink.smb.omada.common.gridquery.d;
import com.tplink.smb.omada.common.mongo.repository.p;
import com.tplink.smb.omada.common.mongo.repository.q;
import com.tplink.smb.omada.common.mongo.repository.u;
import com.tplink.smb.omada.common.omadac.OmadacType;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.BulkOperations;
import org.springframework.data.mongodb.core.FindAndReplaceOptions;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.AggregationOptions;
import org.springframework.data.mongodb.core.index.IndexDefinition;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class e
extends q<ClientHistoryPO, r>
implements DomainEventSubscriber<com.tplink.smb.omada.client.domain.model.statistic.task.a>,
j {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(e.class);
    @Value(value="${client.history.max-collection-iteration:3}")
    private int b = 3;
    private k c;
    private MongoTemplate d;

    private MongoCollection<ClientHistoryPO> a(String collectionName) {
        return this.d.getDb().getCollection(collectionName, ClientHistoryPO.class);
    }

    private static void a(Query query, r omadacId) {
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()));
    }

    @Nonnull
    private static Query c(r omadacId, z siteId, a<com.tplink.smb.omada.client.domain.model.history.f> grid, @Nullable Long timeStartMillis, @Nullable Long timeEndMillis) {
        Query query = g.a(grid.getSearchFilters(), (List<com.tplink.smb.omada.common.gridquery.c>)grid.getFilters());
        if (OmadacType.s() && grid.getFilters().stream().noneMatch(filter -> Objects.equals("omadac_id", filter.a()))) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()));
        }
        if (grid.getFilters().stream().noneMatch(filter -> Objects.equals("site", filter.a()))) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"site").is((Object)siteId.a()));
        }
        if ((timeStartMillis != null || timeEndMillis != null) && grid.getFilters().stream().noneMatch(filter -> Objects.equals("last_seen", filter.a()))) {
            Criteria criteria = Criteria.where((String)"last_seen");
            if (timeStartMillis != null) {
                criteria.gte((Object)timeStartMillis);
            }
            if (timeEndMillis != null) {
                criteria.lte((Object)timeEndMillis);
            }
            query.addCriteria((CriteriaDefinition)criteria);
        }
        return query;
    }

    @PostConstruct
    public void b() {
        DomainEventBusHolder.getHandlerRegistry().registerSync(com.tplink.smb.omada.client.domain.model.statistic.task.a.class, (DomainEventSubscriber)this);
    }

    public void a(com.tplink.smb.omada.client.domain.model.history.f clientHistory) {
        com.tplink.smb.omada.client.port.mongo.data.history.c.a(clientHistory);
    }

    public void a(com.tplink.smb.omada.client.domain.model.history.f oldClientHistory, com.tplink.smb.omada.client.domain.model.history.f newClientHistory) {
        String newCollection;
        String oldCollection = this.getCollectionNameForQuery((n)f.a(oldClientHistory));
        if (!Objects.equals(oldCollection, newCollection = this.getCollectionNameForSave(f.a(newClientHistory)))) {
            this.d.remove(Query.query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)oldClientHistory.c().a()).and("omadac_id").is((Object)oldClientHistory.d().a()).and("site").is((Object)oldClientHistory.e().a())), oldCollection);
        }
        this.a(newClientHistory);
    }

    public void a(List<com.tplink.smb.omada.client.domain.model.history.f> list) {
        this.b(list);
    }

    public i a() {
        return new i(ObjectId.get().toString());
    }

    public Optional<com.tplink.smb.omada.client.domain.model.history.f> a(r omadacId, z siteId, String clientMac, long lastSeen) {
        Set c2;
        Bson filter = Filters.and((Bson[])new Bson[]{Filters.eq((String)"site", (Object)siteId.a()), Filters.eq((String)"mac", (Object)clientMac), Filters.gte((String)"last_seen", (Object)lastSeen)});
        if (OmadacType.s()) {
            filter = Filters.and((Bson[])new Bson[]{Filters.eq((String)"omadac_id", (Object)omadacId.a()), filter});
        }
        if (!(c2 = this.buildCurrentPeriodCollectionNames()).isEmpty()) {
            AtomicReference<Object> result = new AtomicReference<Object>(null);
            AtomicInteger iteration = new AtomicInteger(0);
            Bson finalFilter = filter;
            this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, lastSeen / 1000L, System.currentTimeMillis() / 1000L, omadacId, collectionName -> {
                if (result.get() != null) {
                    return;
                }
                if (iteration.incrementAndGet() > this.b) {
                    a.debug("Find client history reached iteration limit, Omadac: {}, Site: {}, client: {}, lastSeen: {}, current collection: {}", new Object[]{omadacId, siteId, clientMac, lastSeen, collectionName});
                    return;
                }
                result.set(((ClientHistoryPO)this.a((String)collectionName).find(finalFilter).sort(Sorts.descending((String[])new String[]{"last_seen"})).first()));
            });
            ClientHistoryPO po = result.get();
            return Optional.ofNullable(po).map(entity -> f.a(omadacId.a(), entity));
        }
        return Optional.empty();
    }

    public void a(r omadacId, z siteId, String clientMac) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"site").is((Object)siteId.a()).and("mac").is((Object)clientMac));
        if (OmadacType.s()) {
            e.a(query, omadacId);
        }
        this.iteratorCollectionsBySliceKey(omadacId, collectionName -> this.d.remove(query, collectionName));
    }

    public void a(r omadacId, z siteId, Collection<String> clientMacs) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"site").is((Object)siteId.a()).and("mac").in(clientMacs));
        if (OmadacType.s()) {
            e.a(query, omadacId);
        }
        this.iteratorCollectionsBySliceKey(omadacId, collectionName -> this.d.remove(query, collectionName));
    }

    public void a(r omadacId, z siteId, a<com.tplink.smb.omada.client.domain.model.history.f> grid, @Nullable Long timeStartMillis, @Nullable Long timeEndMillis) {
        List<com.tplink.smb.omada.common.gridquery.e> sorts;
        Query query = e.c(omadacId, siteId, grid, timeStartMillis, timeEndMillis);
        long startTimeSec = timeStartMillis == null ? 0L : timeStartMillis / 1000L;
        long endTimeSec = (timeEndMillis == null ? System.currentTimeMillis() : timeEndMillis) / 1000L;
        AtomicLong total = new AtomicLong(0L);
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTimeSec, endTimeSec, omadacId, collectionName -> total.addAndGet(this.d.count(query, collectionName)));
        grid.setTotalRows(total.get());
        com.tplink.smb.omada.client.port.mongo.a.a.a(query, grid.getQueryPage());
        if (grid.getQuerySorts().stream().anyMatch(sort -> !Objects.equals(sort.b(), "last_seen"))) {
            a.warn("Client history grid query contains unsupported sort key: {}", (Object)grid.getQuerySorts());
        }
        if (CollectionUtils.isEmpty(sorts = grid.getQuerySorts().stream().filter(sort -> Objects.equals(sort.b(), "last_seen")).collect(Collectors.toList()))) {
            query.with(Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.desc((String)"last_seen")}));
        } else {
            com.tplink.smb.omada.client.port.mongo.a.a.a(query, sorts);
        }
        boolean sortedByLastSeen = query.getSortObject().entrySet().stream().allMatch(entry -> Objects.equals(entry.getKey(), "last_seen"));
        Object sortObj = query.getSortObject().get((Object)"last_seen");
        if (!sortedByLastSeen || !(sortObj instanceof Number)) {
            throw new l("Invalid sort, must use \"last_seen\" as sort key");
        }
        Sort.Direction direction = ((Number)sortObj).intValue() > 0 ? Sort.Direction.ASC : Sort.Direction.DESC;
        LinkedList results = new LinkedList();
        this.iteratorCollectionsByTimeAndSliceKeyWithSkip(direction, startTimeSec, endTimeSec, omadacId, query, (collectionName, decorated) -> {
            a.trace("Get Grid from {}, decorated query: {}", collectionName, decorated);
            List list = this.d.find(decorated, ClientHistoryPO.class, collectionName);
            results.addAll(list);
        });
        grid.setData(results.stream().map(po -> f.a(omadacId.a(), po)).collect(Collectors.toList()));
    }

    public OperationResponse a(r omadacId, z siteId, Function<com.tplink.smb.omada.client.domain.model.history.f, OperationResponse> func) {
        Criteria criteria = Criteria.where((String)"omadac_id").is((Object)omadacId.a()).and("site").is((Object)siteId.a());
        Query query = new Query((CriteriaDefinition)criteria);
        int startTimeSec = 0;
        long endTimeSec = System.currentTimeMillis() / 1000L;
        ArrayList collectionNameList = new ArrayList();
        this.iteratorCollectionsByTimeDesc(startTimeSec, endTimeSec, collectionNameList::add);
        for (String collectionName : collectionNameList) {
            MongoIterable iterable = this.d.getCollection(collectionName).find((Bson)query.getQueryObject()).batchSize(1000).sort((Bson)query.getSortObject()).map(src -> (ClientHistoryPO)this.d.getConverter().read(ClientHistoryPO.class, src));
            for (ClientHistoryPO po : iterable) {
                OperationResponse innerResp = func.apply(f.a(omadacId.a(), po));
                if (innerResp.success()) continue;
                return innerResp;
            }
        }
        return OperationResponse.SUCCESS;
    }

    public long b(r omadacId, z siteId, a<com.tplink.smb.omada.client.domain.model.history.f> grid, @Nullable Long timeStartMillis, @Nullable Long timeEndMillis) {
        Query query = e.c(omadacId, siteId, grid, timeStartMillis, timeEndMillis);
        long startTimeSec = timeStartMillis == null ? 0L : timeStartMillis / 1000L;
        long endTimeSec = (timeEndMillis == null ? System.currentTimeMillis() : timeEndMillis) / 1000L;
        AtomicLong total = new AtomicLong(0L);
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTimeSec, endTimeSec, omadacId, collectionName -> total.addAndGet(this.d.count(query, collectionName)));
        return total.get();
    }

    public long a(r omadacId, z siteId) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()).and("site_id").is((Object)siteId));
        AtomicLong total = new AtomicLong(0L);
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, 0L, System.currentTimeMillis(), omadacId, collectionName -> total.addAndGet(this.d.count(query, collectionName)));
        return total.get();
    }

    public long a(r omadacId, z siteId, String deviceMac, long start, long end) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"site").is((Object)siteId.a()).and("device_mac").is((Object)deviceMac).and("last_seen").lte((Object)end).gte((Object)start));
        if (OmadacType.s()) {
            e.a(query, omadacId);
        }
        AtomicLong total = new AtomicLong(0L);
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, start / 1000L, end / 1000L, omadacId, collectionName -> total.addAndGet(this.d.count(query, collectionName)));
        return total.get();
    }

    public List<com.tplink.smb.omada.client.domain.model.history.f> a(r omadacId, z siteId, String deviceMac, long start, long end, int pageSize, int page) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"site").is((Object)siteId.a()).and("device_mac").is((Object)deviceMac).and("last_seen").lte((Object)end).gte((Object)start));
        if (OmadacType.s()) {
            e.a(query, omadacId);
        }
        query.with(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"last_seen"}));
        com.tplink.smb.omada.client.port.mongo.a.a.a(query, new d(page, pageSize));
        LinkedList results = new LinkedList();
        this.iteratorCollectionsByTimeAndSliceKeyWithSkip(Sort.Direction.DESC, start / 1000L, end / 1000L, omadacId, query, (collectionName, decorated) -> {
            List list = this.d.find(decorated, ClientHistoryPO.class, collectionName);
            results.addAll(list);
        });
        return results.stream().map(po -> f.a(omadacId.a(), po)).collect(Collectors.toList());
    }

    public List<com.tplink.smb.omada.client.domain.model.history.f> b(r omadacId, z siteId, String clientMac, long start, long end) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"site").is((Object)siteId.a()).and("mac").is((Object)clientMac).and("last_seen").gte((Object)start).lte((Object)end));
        if (OmadacType.s()) {
            e.a(query, omadacId);
        }
        ArrayList poList = new ArrayList();
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.ASC, start / 1000L, end / 1000L, omadacId, collectionName -> poList.addAll(this.d.find(query, ClientHistoryPO.class, collectionName)));
        if (CollectionUtils.isEmpty(poList)) {
            return Collections.emptyList();
        }
        return poList.stream().filter(Objects::nonNull).map(po -> f.a(omadacId.a(), po)).collect(Collectors.toList());
    }

    public List<h> c(r omadacId, z siteId, String clientMac, long start, long end) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"site").is((Object)siteId.a()).and("mac").is((Object)clientMac).and("last_seen").gte((Object)start).lte((Object)end));
        if (OmadacType.s()) {
            e.a(query, omadacId);
        }
        query.fields().include(new String[]{"mac", "last_seen", "duration"});
        ArrayList poList = new ArrayList();
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.ASC, start / 1000L, end / 1000L, omadacId, collectionName -> poList.addAll(this.d.find(query, ClientHistoryPO.class, collectionName)));
        if (CollectionUtils.isEmpty(poList)) {
            return Collections.emptyList();
        }
        return poList.stream().filter(Objects::nonNull).map(po -> new h().a(po.getMac()).a(po.getLastSeen()).b(po.getDuration())).collect(Collectors.toList());
    }

    public List<ClientsLongestUptimeDTO> a(r omadacId, z siteId, long start, long end, int topK) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"site").is((Object)siteId.a()).and("last_seen").gte((Object)start).lte((Object)end));
        if (OmadacType.s()) {
            e.a(query, omadacId);
        }
        query.fields().include(new String[]{"mac", "name", "client_type", "duration"});
        query.with(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"duration"})).limit(topK);
        ArrayList poList = new ArrayList();
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.ASC, start / 1000L, end / 1000L, omadacId, collectionName -> poList.addAll(this.d.find(query, ClientHistoryPO.class, collectionName)));
        if (CollectionUtils.isEmpty(poList)) {
            return Collections.emptyList();
        }
        return poList.stream().filter(Objects::nonNull).map(po -> new ClientsLongestUptimeDTO(po.getMac(), po.getName(), po.getClientType(), po.getDuration())).collect(Collectors.toList());
    }

    public List<ClientMacRadioAggregationDTO> a(r omadacId, z siteId, long start, long end) {
        Criteria criteria = Criteria.where((String)"site").is((Object)siteId.a()).and("last_seen").gte((Object)start).and("associated").lt((Object)end).and("type").is((Object)DeviceTypeEnum.a.b()).and("port").is(null);
        if (OmadacType.s()) {
            criteria.and("omadac_id").is((Object)omadacId.a());
        }
        Aggregation aggregation = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), Aggregation.group((String[])new String[]{"mac", "radio_Id", "multi_radio_Id"}).first("mac").as("a").first("radio_Id").as("b").first("multi_radio_Id").as("c"), Aggregation.project((String[])new String[]{"a", "b", "c"})}).withOptions(AggregationOptions.builder().allowDiskUse(true).build());
        HashSet result = new HashSet();
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, start / 1000L, Long.MAX_VALUE, omadacId, collectionName -> {
            List list = this.d.aggregate(aggregation, collectionName, ClientMacRadioAggregationDTO.class).getMappedResults();
            result.addAll(list);
        });
        return new ArrayList<ClientMacRadioAggregationDTO>(result);
    }

    public List<ClientMacGuestAggregationDTO> b(r omadacId, z siteId, long start, long end) {
        Criteria criteria = Criteria.where((String)"site").is((Object)siteId.a()).and("last_seen").gte((Object)start).and("associated").lt((Object)end).and("guest").in(new Object[]{true, false}).and("type").is((Object)DeviceTypeEnum.a.b()).and("port").is(null);
        if (OmadacType.s()) {
            criteria.and("omadac_id").is((Object)omadacId.a());
        }
        Aggregation aggregation = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), Aggregation.group((String[])new String[]{"mac", "guest"}).first("mac").as("a").first("guest").as("b"), Aggregation.project((String[])new String[]{"a", "b"})}).withOptions(AggregationOptions.builder().allowDiskUse(true).build());
        HashSet result = new HashSet();
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, start / 1000L, Long.MAX_VALUE, omadacId, collectionName -> {
            List list = this.d.aggregate(aggregation, collectionName, ClientMacGuestAggregationDTO.class).getMappedResults();
            result.addAll(list);
        });
        return new ArrayList<ClientMacGuestAggregationDTO>(result);
    }

    public List<ClientMacSsidAggregationDTO> c(r omadacId, z siteId, long start, long end) {
        Criteria criteria = Criteria.where((String)"site").is((Object)siteId.a()).and("last_seen").gte((Object)start).and("associated").lt((Object)end).and("type").is((Object)DeviceTypeEnum.a.b()).and("port").is(null);
        if (OmadacType.s()) {
            criteria.and("omadac_id").is((Object)omadacId.a());
        }
        Aggregation aggregation = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), Aggregation.group((String[])new String[]{"mac", "ssid"}).first("mac").as("a").first("ssid").as("b"), Aggregation.project((String[])new String[]{"a", "b"})}).withOptions(AggregationOptions.builder().allowDiskUse(true).build());
        HashSet result = new HashSet();
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, start / 1000L, Long.MAX_VALUE, omadacId, collectionName -> {
            List list = this.d.aggregate(aggregation, collectionName, ClientMacSsidAggregationDTO.class).getMappedResults();
            result.addAll(list);
        });
        return new ArrayList<ClientMacSsidAggregationDTO>(result);
    }

    public List<ClientMacDeviceMacDTO> a(r omadacId, z siteId, DeviceTypeEnum deviceType, long start, long end) {
        Criteria criteria = Criteria.where((String)"site").is((Object)siteId.a()).and("last_seen").gte((Object)start).and("associated").lt((Object)end).and("type").is((Object)deviceType.b());
        if (OmadacType.s()) {
            criteria.and("omadac_id").is((Object)omadacId.a());
        }
        Aggregation aggregation = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), Aggregation.group((String[])new String[]{"mac", "device_mac"}).first("mac").as("clientMac").first("device_mac").as("deviceMac"), Aggregation.project((String[])new String[]{"clientMac", "deviceMac"})});
        HashSet result = new HashSet();
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, start / 1000L, Long.MAX_VALUE, omadacId, collectionName -> {
            List list = this.d.aggregate(aggregation, collectionName, ClientMacDeviceMacDTO.class).getMappedResults();
            result.addAll(list);
        });
        return new ArrayList<ClientMacDeviceMacDTO>(result);
    }

    public List<String> d(r omadacId, z siteId, long start, long end) {
        Criteria criteria = Criteria.where((String)"site").is((Object)siteId.a()).and("last_seen").gte((Object)start).and("associated").lt((Object)end).and("type").is((Object)DeviceTypeEnum.a.b()).and("port").is(null);
        if (OmadacType.s()) {
            criteria.and("omadac_id").is((Object)omadacId.a());
        }
        Query query = Query.query((CriteriaDefinition)criteria);
        Aggregation aggregation = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), Aggregation.group((String[])new String[]{"mac"}).first("mac").as("a"), Aggregation.project((String[])new String[]{"a"})}).withOptions(AggregationOptions.builder().allowDiskUse(true).build());
        HashSet result = new HashSet();
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, start / 1000L, Long.MAX_VALUE, omadacId, collectionName -> {
            List list = this.d.aggregate(aggregation, collectionName, ClientMacAggregationDTO.class).getMappedResults();
            result.addAll(list);
        });
        return result.stream().map(ClientMacAggregationDTO::getA).collect(Collectors.toList());
    }

    public List<String> e(r omadacId, z siteId, long start, long end) {
        Criteria criteria = Criteria.where((String)"site").is((Object)siteId.a()).and("last_seen").gte((Object)start).and("associated").lt((Object)end).and("ssid").is(null);
        if (OmadacType.s()) {
            criteria.and("omadac_id").is((Object)omadacId.a());
        }
        Query query = Query.query((CriteriaDefinition)criteria);
        Aggregation aggregation = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), Aggregation.group((String[])new String[]{"mac"}).first("mac").as("a"), Aggregation.project((String[])new String[]{"a"})}).withOptions(AggregationOptions.builder().allowDiskUse(true).build());
        HashSet result = new HashSet();
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, start / 1000L, Long.MAX_VALUE, omadacId, collectionName -> {
            List list = this.d.aggregate(aggregation, collectionName, ClientMacAggregationDTO.class).getMappedResults();
            result.addAll(list);
        });
        return result.stream().map(ClientMacAggregationDTO::getA).collect(Collectors.toList());
    }

    @PreDestroy
    public void c() {
        com.tplink.smb.omada.client.port.mongo.data.history.c.a.shutdown();
    }

    public void a(com.tplink.smb.omada.client.domain.model.statistic.task.a event) {
        this.dbMaintenance(event.a());
    }

    protected int a(@Nullable r key) {
        if (key == null) {
            return 0;
        }
        return key.a().hashCode();
    }

    protected k d() {
        return this.c;
    }

    private void b(List<com.tplink.smb.omada.client.domain.model.history.f> list) {
        Map<String, List<ClientHistoryPO>> collectionNameToPOsMap = list.stream().map(f::a).collect(Collectors.groupingBy(x$0 -> this.getCollectionNameForSave(x$0)));
        boolean isCloudBaseController = OmadacType.s();
        collectionNameToPOsMap.forEach((collectionName, poList) -> {
            BulkOperations bulkOperations = this.d.bulkOps(BulkOperations.BulkMode.UNORDERED, collectionName);
            poList.forEach(clientHistory -> {
                Query query = new Query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)clientHistory.getId()));
                if (isCloudBaseController) {
                    query.addCriteria((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)clientHistory.getOmadacId())).addCriteria((CriteriaDefinition)Criteria.where((String)"site").is((Object)clientHistory.getSiteId()));
                }
                bulkOperations.replaceOne(query, clientHistory, FindAndReplaceOptions.options().upsert());
            });
            BulkWriteResult result = bulkOperations.execute();
            a.debug("Bulk write client history result: {}", (Object)result);
        });
    }

    @Nonnull
    protected IndexDefinition[] getIndexDefinitions() {
        return ClientHistoryPO.INDEX_DEFINITIONS;
    }

    protected MongoTemplate getMongoTemplate() {
        return this.d;
    }

    @Nonnull
    protected String getCollectionNameOrPrefixIfSliced() {
        return "clienthistory";
    }

    protected Class<ClientHistoryPO> getPOClass() {
        return ClientHistoryPO.class;
    }

    @Qualifier(value="dataMongoTemplate")
    @Autowired
    public void a(MongoTemplate mongoTemplate) {
        this.d = mongoTemplate;
    }

    @Autowired
    public void a(k sliceStrategy) {
        this.c = sliceStrategy;
    }

    protected /* synthetic */ p getStrategy() {
        return this.d();
    }

    protected /* synthetic */ int hashCodeOfKey(@Nullable Object object) {
        return this.a((r)object);
    }

    protected /* synthetic */ u getStrategy() {
        return this.d();
    }

    public /* synthetic */ void handleEvent(Object object) {
        this.a((com.tplink.smb.omada.client.domain.model.statistic.task.a)object);
    }
}

