/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.portal.web.controller;

import com.tplink.nbu.common.pii.utils.PIIJacksonUtil;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.constant.DeviceTypeEnum;
import com.tplink.smb.omada.common.g.b;
import com.tplink.smb.omada.common.obfuscate.KeepClassName;
import com.tplink.smb.omada.common.omadac.OmadacType;
import com.tplink.smb.omada.common.util.G;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.common.util.Y;
import com.tplink.smb.omada.common.util.b.k;
import com.tplink.smb.omada.common.util.x;
import com.tplink.smb.omada.portal.api.common.AuthResponse;
import com.tplink.smb.omada.portal.api.dto.AuthReqDTO;
import com.tplink.smb.omada.portal.api.dto.FacebookAuthReqDTO;
import com.tplink.smb.omada.portal.api.dto.FacebookForwardResultDTO;
import com.tplink.smb.omada.portal.api.dto.LogoutPageDTO;
import com.tplink.smb.omada.portal.api.dto.LogoutRequestDTO;
import com.tplink.smb.omada.portal.api.dto.LogoutSettingDTO;
import com.tplink.smb.omada.portal.api.dto.PortalPageDTO;
import com.tplink.smb.omada.portal.api.dto.SocialAuthReqDTO;
import com.tplink.smb.omada.portal.api.dto.SocialLoginForwardResultDTO;
import com.tplink.smb.omada.portal.api.internal.dto.CookieDTO;
import com.tplink.smb.omada.portal.api.internal.dto.ImportedPageDTO;
import com.tplink.smb.omada.portal.api.internal.dto.ImportedPageQueryDTO;
import com.tplink.smb.omada.portal.api.internal.dto.ImportedPageZipStaticQueryDTO;
import com.tplink.smb.omada.portal.api.internal.dto.LandingRedirectDTO;
import com.tplink.smb.omada.portal.api.internal.dto.PortalEntranceDTO;
import com.tplink.smb.omada.portal.api.internal.dto.PortalEntranceQueryDTO;
import com.tplink.smb.omada.portal.api.internal.dto.PortalLogoutQueryDTO;
import com.tplink.smb.omada.portal.api.internal.dto.PortalViewControlDTO;
import com.tplink.smb.omada.portal.api.internal.dto.RSAKeyPairDTO;
import com.tplink.smb.omada.portal.api.internal.dto.SendSmsCodeRequestDTO;
import com.tplink.smb.omada.portal.api.internal.dto.SocialPortalEntranceQueryDTO;
import com.tplink.smb.omada.portal.api.internal.dto.TransFormatMacDTO;
import com.tplink.smb.omada.portal.api.internal.h;
import com.tplink.smb.omada.portal.web.controller.a.a;
import com.tplink.smb.omada.portal.web.controller.c;
import com.tplink.smb.omada.portal.web.controller.vo.LogoutParamVO;
import com.tplink.smb.omada.portal.web.controller.vo.PortalParamVO;
import io.swagger.v3.oas.annotations.Hidden;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.commons.collections4.EnumerationUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.util.UriComponentsBuilder;

@Hidden
@Controller
@KeepClassName
public class PortalController {
    @Generated
    private static final Logger a = LogManager.getLogger(PortalController.class);
    private static final Pattern b = Pattern.compile("^(http://)|(https://)", 2);
    private static final String c = "%s://%s";
    private static final String d = "RSA/ECB/PKCS1Padding";
    private h e;
    private c f;
    private com.tplink.smb.omada.portal.web.controller.a g;

    private static int a(HttpServletRequest request) {
        if (OmadacType.s()) {
            String host = request.getHeader(com.tplink.smb.omada.portal.web.util.c.a);
            a.debug("Portal request : {}, Host : {}", (Object)request.getServletPath(), (Object)host);
            if (host != null) {
                Optional<Integer> optPort = PortalController.a(host);
                if (optPort.isPresent()) {
                    return optPort.get();
                }
                String xForwardedProto = request.getHeader("x-forwarded-proto");
                if (xForwardedProto != null) {
                    if ("http".equals(xForwardedProto)) {
                        return 80;
                    }
                    if ("https".equals(xForwardedProto)) {
                        return 443;
                    }
                }
            }
        }
        return request.getServerPort();
    }

    @Nonnull
    private static RSAPrivateKey a(@Nonnull RSAKeyPairDTO dto) {
        return k.b((String)dto.getPrivateKey());
    }

    @Nonnull
    private static RSAPublicKey b(@Nonnull RSAKeyPairDTO dto) {
        return k.a((String)dto.getPublicKey());
    }

    private static Optional<Integer> a(String host) {
        int index = host.indexOf(58) + 1;
        if (index > 0) {
            try {
                return Optional.of(Integer.parseInt(host.substring(index)));
            }
            catch (NumberFormatException e) {
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    @GetMapping(value={"/portal/entry"})
    public String a(HttpServletResponse response, HttpServletRequest request, @RequestParam(value="cid", required=false) String cid, @RequestParam(value="ap", required=false) String ap, @RequestParam(value="gateway", required=false) String gateway, @RequestParam(value="ssid", required=false) String ssid, @RequestParam(value="rid", required=false) Integer rid, @RequestParam(value="vid", required=false) Integer vid, @RequestParam(value="t", required=false) Long t, @RequestParam(value="u", required=false) String u, @RequestParam(value="clientIp", required=false) String clientIp) {
        cid = G.b((String)cid);
        ap = G.b((String)ap);
        gateway = G.b((String)gateway);
        PortalEntranceQueryDTO query = new PortalEntranceQueryDTO().setClientMac(cid).setClientIp(Optional.ofNullable(clientIp).orElseGet(() -> com.tplink.smb.omada.portal.web.util.c.a(request))).setApMac(ap).setSsid(ssid).setRadioId(rid).setOsgMac(gateway).setVid(vid).setTimestamp(Optional.ofNullable(t).orElse(System.currentTimeMillis())).setOriginUrl(u).setServerLocation(request.getServerName()).setServerPort(Integer.valueOf(PortalController.a(request)));
        com.tplink.smb.omada.portal.web.controller.a.a.a().o("/portal/entry").e(query.getClientMac()).f(query.getApMac()).g(query.getSsid()).c(query.getRadioId()).h(query.getOsgMac()).d(query.getVid()).i(query.getOriginUrl());
        DeviceTypeEnum authDevType = this.c(ap, gateway);
        if (authDevType == null) {
            response.setStatus(HttpStatus.BAD_REQUEST.value());
            a.debug("Failed to resolve authDevType.");
            return null;
        }
        a.info("Handling GET {}... PortalEntranceQueryDTO :{}", (Object)"/portal/entry", (Object)PIIJacksonUtil.parseToStr((Object)query));
        if (!this.a(query)) {
            a.warn("GET {}: Query parameters is invalid. PortalEntranceQueryDTO :{}", (Object)"/portal/entry", (Object)PIIJacksonUtil.parseToStr((Object)query));
            response.setStatus(HttpStatus.BAD_REQUEST.value());
            return null;
        }
        return this.a(request, response, query, null);
    }

    @GetMapping(value={"/portal/logout"})
    public String a(HttpServletResponse response, HttpServletRequest request, @RequestParam(value="clientMac", required=false) String clientMac, @RequestParam(value="apMac", required=false) String apMac, @RequestParam(value="gatewayMac", required=false) String gatewayMac, @RequestParam(value="ssid", required=false) String ssid, @RequestParam(value="vid", required=false) Integer vid, @RequestParam(value="cliToken", required=false) String cliToken) {
        clientMac = G.b((String)clientMac);
        apMac = G.b((String)apMac);
        gatewayMac = G.b((String)gatewayMac);
        PortalLogoutQueryDTO query = new PortalLogoutQueryDTO().setClientMac(clientMac).setApMac(apMac).setSsid(ssid).setOsgMac(gatewayMac).setVid(vid).setToken(cliToken);
        com.tplink.smb.omada.portal.web.controller.a.a.a().o("/portal/logout").e(query.getClientMac()).f(query.getApMac()).g(query.getSsid()).h(query.getOsgMac()).d(query.getVid());
        DeviceTypeEnum authDevType = this.c(apMac, gatewayMac);
        if (authDevType == null) {
            response.setStatus(HttpStatus.BAD_REQUEST.value());
            a.debug("Failed to resolve authDevType.");
            return null;
        }
        a.info("Handling GET {}... PortalLogoutQueryDTO :{}", (Object)"/portal/logout", (Object)PIIJacksonUtil.parseToStr((Object)query));
        if (!this.a(query)) {
            a.warn("GET {}: Query parameters is invalid. PortalLogoutQueryDTO :{}", (Object)"/portal/logout", (Object)PIIJacksonUtil.parseToStr((Object)query));
            response.setStatus(HttpStatus.BAD_REQUEST.value());
            return null;
        }
        return this.a(request, response, query);
    }

    @PostMapping(value={"/portal/getPortalPageSetting"})
    @ResponseBody
    public OperationResponse<PortalPageDTO> a(@RequestBody PortalParamVO portalParam, HttpServletRequest request) {
        if (!this.a(portalParam)) {
            a.warn("GetPortalPageSetting: parameter is invalid. PortalParamDTO:{}", (Object)portalParam);
            return new OperationResponse(com.tplink.smb.omada.common.g.b.d);
        }
        a stat = com.tplink.smb.omada.portal.web.controller.a.a.a().o("/portal/getPortalPageSetting").e(portalParam.getClientMac()).f(portalParam.getApMac()).g(portalParam.getSsidName()).c(portalParam.getRadioId()).h(portalParam.getGatewayMac()).d(portalParam.getVid()).i(portalParam.getOriginUrl());
        OperationResponse optRes = this.e.c(new PortalEntranceQueryDTO().setClientMac(G.b((String)portalParam.getClientMac())).setClientIp(Optional.ofNullable(portalParam.getClientIp()).orElseGet(() -> com.tplink.smb.omada.portal.web.util.c.a(request))).setApMac(G.b((String)portalParam.getApMac())).setSsid(portalParam.getSsidName()).setRadioId(portalParam.getRadioId()).setOsgMac(G.b((String)portalParam.getGatewayMac())).setVid(portalParam.getVid()).setTimestamp(portalParam.getT()).setOriginUrl(portalParam.getOriginUrl()).setServerLocation(request.getServerName()).setServerPort(Integer.valueOf(PortalController.a(request))));
        optRes.ifSuccessAndNonnull(dto -> stat.b(dto.getOmadacId()).c(dto.getSiteId()).d((String)Optional.ofNullable(stat.g()).map(com.tplink.smb.omada.portal.api.common.c::a).map(com.tplink.smb.omada.portal.api.common.c::b).orElse(null)));
        return optRes;
    }

    @PostMapping(value={"/portal/getLogoutPageSetting"})
    @ResponseBody
    public OperationResponse<LogoutPageDTO> a(@RequestBody LogoutParamVO param, HttpServletRequest request) {
        if (!this.a(param)) {
            a.warn("getLogoutPageSetting: parameter is invalid. LogoutParam:{}", (Object)PIIJacksonUtil.parseToStr((Object)param));
            return new OperationResponse(com.tplink.smb.omada.common.g.b.d);
        }
        com.tplink.smb.omada.portal.web.controller.a.a.a().o("/portal/getLogoutPageSetting").e(param.getClientMac()).f(param.getApMac()).g(param.getSsidName()).h(param.getGatewayMac()).d(param.getVid());
        return this.e.b(new PortalLogoutQueryDTO().setClientMac(G.b((String)param.getClientMac())).setApMac(G.b((String)param.getApMac())).setSsid(param.getSsidName()).setOsgMac(G.b((String)param.getGatewayMac())).setVid(param.getVid()).setToken(param.getCliToken()));
    }

    @PostMapping(value={"/portal/doLogoutPreprocess"})
    @ResponseBody
    public OperationResponse<LogoutSettingDTO> b(@RequestBody LogoutParamVO param, HttpServletRequest request) {
        if (!this.a(param)) {
            a.warn("getLogoutPageSetting: parameter is invalid. LogoutParam:{}", (Object)param);
            return new OperationResponse(com.tplink.smb.omada.common.g.b.d);
        }
        com.tplink.smb.omada.portal.web.controller.a.a.a().o("/portal/doLogoutPreprocess").e(param.getClientMac()).f(param.getApMac()).g(param.getSsidName()).h(param.getGatewayMac()).d(param.getVid());
        return this.e.c(new PortalLogoutQueryDTO().setClientMac(G.b((String)param.getClientMac())).setApMac(G.b((String)param.getApMac())).setSsid(param.getSsidName()).setOsgMac(G.b((String)param.getGatewayMac())).setVid(param.getVid()).setToken(param.getCliToken()));
    }

    @GetMapping(value={"/portal/pics/{picId}"})
    public void a(@PathVariable(value="picId") String picId, HttpServletResponse response) throws IOException {
        if (null == picId) {
            a.warn("Failed to load PortalPicture, fileId is null");
            response.setStatus(HttpStatus.NOT_FOUND.value());
        } else {
            a.debug("Loading PortalPicture: fileId {}", (Object)picId);
            OperationResponse resp = this.e.a(picId, (OutputStream)response.getOutputStream());
            if (!resp.success()) {
                a.warn("Failed to read PortalPicture: fileId {}", (Object)picId);
                response.setStatus(HttpStatus.NOT_FOUND.value());
            }
        }
    }

    @GetMapping(value={"/portal/entry/{omadacId}/{siteId}/{pageId}"})
    public void a(@PathVariable(value="omadacId") String omadacId, @PathVariable(value="siteId") String siteId, @PathVariable(value="pageId") String pageId, @RequestParam(value="clientMac", required=false) String clientMac, @RequestParam(value="apMac", required=false) String apMac, @RequestParam(value="gatewayMac", required=false) String gatewayMac, @RequestParam(value="ssidName", required=false) String ssidName, @RequestParam(value="radioId", required=false) Integer radioId, @RequestParam(value="vid", required=false) Integer vid, @RequestParam(value="originUrl", required=false) String originUrl, @RequestParam(value="clientIp", required=false) String clientIp, HttpServletRequest request, HttpServletResponse response) throws IOException {
        PortalEntranceQueryDTO query = new PortalEntranceQueryDTO().setClientMac(G.b((String)clientMac)).setClientIp(Optional.ofNullable(clientIp).orElseGet(() -> com.tplink.smb.omada.portal.web.util.c.a(request))).setApMac(G.b((String)apMac)).setSsid(ssidName).setRadioId(radioId).setOsgMac(G.b((String)gatewayMac)).setVid(vid).setTimestamp(Long.valueOf(System.currentTimeMillis())).setOriginUrl(originUrl).setServerLocation(request.getServerName()).setServerPort(Integer.valueOf(PortalController.a(request)));
        com.tplink.smb.omada.portal.web.controller.a.a.a().o("/portal/entry/{omadacId}/{siteId}/{pageId}").e(clientMac).f(apMac).g(ssidName).c(radioId).h(gatewayMac).d(vid).i(originUrl);
        if (!this.a(query)) {
            a.warn("GET {}: Query parameters is invalid. PortalEntranceQueryDTO :{}", (Object)request.getServletPath(), (Object)PIIJacksonUtil.parseToStr((Object)query));
            response.setStatus(HttpStatus.BAD_REQUEST.value());
            return;
        }
        OperationResponse portalEntranceResp = this.e.a(query);
        if (!portalEntranceResp.success()) {
            a.warn("GET {}: Portal related setting seems illegal. PortalEntranceQueryDTO :{}", (Object)request.getServletPath(), (Object)PIIJacksonUtil.parseToStr((Object)query));
            response.setStatus(HttpStatus.BAD_REQUEST.value());
            return;
        }
        PortalEntranceDTO entranceDTO = (PortalEntranceDTO)portalEntranceResp.getResult();
        if (!Objects.equals(entranceDTO.getOmadacId(), omadacId) || !Objects.equals(entranceDTO.getSiteId(), siteId)) {
            a.warn("GET {}: Portal path segments seems illegal. PortalEntrance :{}", (Object)request.getServletPath(), (Object)entranceDTO);
            response.setStatus(HttpStatus.BAD_REQUEST.value());
            return;
        }
        com.tplink.smb.omada.portal.web.controller.a.a.a().b(omadacId).c(siteId).a(entranceDTO.getAuthType()).d((String)Optional.ofNullable(entranceDTO.getAuthType()).map(com.tplink.smb.omada.portal.api.common.c::a).map(com.tplink.smb.omada.portal.api.common.c::b).orElse(null));
        OperationResponse res = this.e.a(new ImportedPageQueryDTO().setOmadacId(entranceDTO.getOmadacId()).setSiteId(entranceDTO.getSiteId()).setImportedPageId(pageId), (OutputStream)response.getOutputStream());
        if (!res.success()) {
            a.warn("Failed to read ImportedPortalPage, fileId: {}", (Object)pageId);
            response.setStatus(HttpStatus.NOT_FOUND.value());
        }
    }

    @GetMapping(value={"/portal/entry/{omadacId}/{siteId}/{pageId}/index.html"})
    public void b(@PathVariable(value="omadacId") String omadacId, @PathVariable(value="siteId") String siteId, @PathVariable(value="pageId") String pageId, @RequestParam(value="clientMac", required=false) String clientMac, @RequestParam(value="apMac", required=false) String apMac, @RequestParam(value="gatewayMac", required=false) String gatewayMac, @RequestParam(value="ssidName", required=false) String ssidName, @RequestParam(value="radioId", required=false) Integer radioId, @RequestParam(value="vid", required=false) Integer vid, @RequestParam(value="originUrl", required=false) String originUrl, @RequestParam(value="clientIp", required=false) String clientIp, HttpServletRequest request, HttpServletResponse response) throws IOException {
        PortalEntranceQueryDTO query = new PortalEntranceQueryDTO().setClientMac(G.b((String)clientMac)).setClientIp(Optional.ofNullable(clientIp).orElseGet(() -> com.tplink.smb.omada.portal.web.util.c.a(request))).setApMac(G.b((String)apMac)).setSsid(ssidName).setRadioId(radioId).setOsgMac(G.b((String)gatewayMac)).setVid(vid).setTimestamp(Long.valueOf(System.currentTimeMillis())).setOriginUrl(originUrl).setServerLocation(request.getServerName()).setServerPort(Integer.valueOf(PortalController.a(request)));
        com.tplink.smb.omada.portal.web.controller.a.a.a().o("/portal/entry/{omadacId}/{siteId}/{pageId}/index.html").b(omadacId).c(siteId).e(clientMac).f(apMac).g(ssidName).c(radioId).h(gatewayMac).d(vid).i(originUrl);
        if (!this.a(query)) {
            a.warn("GET {}: Query parameters is invalid. PortalEntranceQueryDTO :{}", (Object)request.getServletPath(), (Object)PIIJacksonUtil.parseToStr((Object)query));
            response.setStatus(HttpStatus.BAD_REQUEST.value());
            return;
        }
        OperationResponse portalEntranceResp = this.e.a(query);
        if (!portalEntranceResp.success()) {
            a.warn("GET {}: Portal related setting seems illegal. PortalEntranceQueryDTO :{}", (Object)request.getServletPath(), (Object)PIIJacksonUtil.parseToStr((Object)query));
            response.setStatus(HttpStatus.BAD_REQUEST.value());
            return;
        }
        PortalEntranceDTO entranceDTO = (PortalEntranceDTO)portalEntranceResp.getResult();
        if (entranceDTO.getViewControl() == null) {
            a.warn("Unexpected param viewControl in entranceDTO:{}", (Object)entranceDTO);
            return;
        }
        if (!Objects.equals(entranceDTO.getViewControl().getPortalSiteType(), 2) || entranceDTO.getViewControl().getImportedPageId() == null) {
            a.warn("GET {}: Portal is not using imported page. PortalEntranceQueryDTO: {}", (Object)request.getServletPath(), (Object)PIIJacksonUtil.parseToStr((Object)query));
            response.setStatus(HttpStatus.BAD_REQUEST.value());
            return;
        }
        a.debug("GET {}: Trying to load {} from PortalPage {}", (Object)request.getServletPath(), (Object)"index.html", (Object)pageId);
        OperationResponse res = this.e.a(new ImportedPageZipStaticQueryDTO().setOmadacId(omadacId).setSiteId(siteId).setImportedPageId(pageId).setRelativePath("index.html"), (OutputStream)response.getOutputStream());
        if (!res.success()) {
            a.warn("Failed to read ImportedPortalPage, fileId: {}, relativePath: {}", (Object)pageId, (Object)"index.html");
            response.setStatus(HttpStatus.NOT_FOUND.value());
        }
    }

    @GetMapping(value={"/portal/entry/{omadacId}/{siteId}/{pageId}/**"})
    public void a(@PathVariable(value="omadacId") String omadacId, @PathVariable(value="siteId") String siteId, @PathVariable(value="pageId") String pageId, HttpServletRequest request, HttpServletResponse response) throws IOException {
        com.tplink.smb.omada.portal.web.controller.a.a.a().o("/portal/entry/{omadacId}/{siteId}/{pageId}/**").b(omadacId).c(siteId);
        String uri = request.getRequestURI();
        String[] pathSegments = uri.split(pageId + "/");
        if (pathSegments.length < 2) {
            response.setStatus(HttpStatus.NOT_FOUND.value());
            return;
        }
        String relativePath = Y.b((String)pathSegments[1]);
        if (Objects.equals("index.html", relativePath)) {
            a.warn("GET {}: Failed to load index.html, wrong handler.", (Object)request.getServletPath());
            response.setStatus(HttpStatus.BAD_REQUEST.value());
            return;
        }
        a.debug("GET {}: Trying to load {} from PortalPage {}", (Object)request.getServletPath(), (Object)relativePath, (Object)pageId);
        OperationResponse res = this.e.a(new ImportedPageZipStaticQueryDTO().setOmadacId(omadacId).setSiteId(siteId).setImportedPageId(pageId).setRelativePath(relativePath), (OutputStream)response.getOutputStream());
        if (!res.success()) {
            a.warn("Failed to read ImportedPortalPage, fileId: {}, relativePath: {}", (Object)pageId, (Object)relativePath);
            response.setStatus(HttpStatus.NOT_FOUND.value());
        }
    }

    @PostMapping(value={"/portal/sendSmsAuthCode"})
    @ResponseBody
    public OperationResponse<?> a(@RequestParam(value="key", required=false) String key, @RequestBody String reqBody) {
        SendSmsCodeRequestDTO sendSmsReq;
        String originBody;
        try {
            originBody = this.b(key, reqBody);
        }
        catch (Exception e) {
            return new OperationResponse(com.tplink.smb.omada.common.g.b.IT);
        }
        try {
            sendSmsReq = (SendSmsCodeRequestDTO)x.a((String)originBody, SendSmsCodeRequestDTO.class);
        }
        catch (Exception e) {
            a.debug("Invalid JSON format.", (Throwable)e);
            return OperationResponse.PARAM_ERROR;
        }
        if (sendSmsReq == null) {
            return OperationResponse.PARAM_ERROR;
        }
        com.tplink.smb.omada.portal.web.controller.a.a.a().o("/portal/sendSmsAuthCode").e(sendSmsReq.getClientMac()).f(sendSmsReq.getApMac()).g(sendSmsReq.getSsidName()).c(sendSmsReq.getRadioId()).h(sendSmsReq.getGatewayMac()).d(sendSmsReq.getVid());
        sendSmsReq.setApMac(G.b((String)sendSmsReq.getApMac()));
        sendSmsReq.setGatewayMac(G.b((String)sendSmsReq.getGatewayMac()));
        sendSmsReq.setClientMac(G.b((String)sendSmsReq.getClientMac()));
        a.debug("Send SMS Code Request: {}", new Supplier[]{() -> PIIJacksonUtil.parseToStr((Object)sendSmsReq)});
        return this.e.a(sendSmsReq);
    }

    @PostMapping(value={"/portal/radius/auth"})
    @ResponseBody
    public OperationResponse<?> a(@RequestParam(value="key", required=false) String key, @RequestBody String reqBody, HttpServletRequest request, HttpServletResponse response) {
        AuthReqDTO authReqDTO;
        String originBody;
        try {
            originBody = this.b(key, reqBody);
        }
        catch (Exception e) {
            return new OperationResponse(com.tplink.smb.omada.common.g.b.IT);
        }
        try {
            authReqDTO = (AuthReqDTO)x.a((String)originBody, AuthReqDTO.class);
            authReqDTO.setApMac(G.b((String)authReqDTO.getApMac())).setGatewayMac(G.b((String)authReqDTO.getGatewayMac())).setClientMac(G.b((String)authReqDTO.getClientMac()));
        }
        catch (Exception e) {
            a.debug("Invalid JSON format.", (Throwable)e);
            return OperationResponse.PARAM_ERROR;
        }
        OperationResponse ops = com.tplink.smb.omada.portal.web.util.b.a(authReqDTO);
        if (!ops.success()) {
            return ops;
        }
        authReqDTO.setClientIp(Optional.ofNullable(authReqDTO.getClientIp()).orElse(com.tplink.smb.omada.portal.web.util.c.a(request)));
        authReqDTO.setServerLocation(request.getServerName());
        authReqDTO.setServerPort(Integer.valueOf(PortalController.a(request)));
        a stat = com.tplink.smb.omada.portal.web.controller.a.a.a().o("/portal/radius/auth").b(authReqDTO.getAuthType()).d((String)Optional.ofNullable(authReqDTO.getAuthType()).map(com.tplink.smb.omada.portal.api.common.c::a).map(com.tplink.smb.omada.portal.api.common.c::b).orElse(null)).e(authReqDTO.getClientMac()).f(authReqDTO.getApMac()).g(authReqDTO.getSsidName()).c(authReqDTO.getRadioId()).h(authReqDTO.getGatewayMac()).d(authReqDTO.getVid()).i(authReqDTO.getOriginUrl());
        OperationResponse authResp = this.e.a(authReqDTO);
        if (authResp instanceof AuthResponse) {
            stat.b(((AuthResponse)authResp).getOmadacId()).c(((AuthResponse)authResp).getSiteId());
        }
        return authResp;
    }

    @RequestMapping(value={"/portal/radius/browserauth"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public OperationResponse a(@RequestParam(value="username", required=true) String username, @RequestParam(value="password", required=true) String password, @RequestParam(value="clientMac", required=false) String clientMac, @RequestParam(value="clientIp", required=false) String clientIp, @RequestParam(value="apMac", required=false) String apMac, @RequestParam(value="gatewayMac", required=false) String gatewayMac, @RequestParam(value="ssidName", required=false) String ssidName, @RequestParam(value="radioId", required=false) Integer radioId, @RequestParam(value="vid", required=false) Integer vid, @RequestParam(value="authType", required=false) Integer authType, @RequestParam(value="originUrl", required=false) String originUrl, HttpServletRequest request, HttpServletResponse response) {
        response.setHeader("Access-Control-Allow-Origin", request.getHeader("Access-Control-Allow-Origin"));
        AuthReqDTO authReqDTO = new AuthReqDTO();
        authReqDTO.setUsername(username);
        authReqDTO.setPassword(password);
        authReqDTO.setClientMac(G.b((String)clientMac));
        authReqDTO.setClientIp(Optional.ofNullable(clientIp).orElseGet(() -> com.tplink.smb.omada.portal.web.util.c.a(request)));
        authReqDTO.setApMac(G.b((String)apMac));
        authReqDTO.setGatewayMac(G.b((String)gatewayMac));
        authReqDTO.setSsidName(ssidName);
        authReqDTO.setRadioId(radioId);
        authReqDTO.setVid(vid);
        authReqDTO.setAuthType(authType);
        authReqDTO.setOriginUrl(originUrl);
        OperationResponse ops = com.tplink.smb.omada.portal.web.util.b.a(authReqDTO);
        if (!ops.success()) {
            return ops;
        }
        authReqDTO.setServerLocation(request.getServerName());
        authReqDTO.setServerPort(Integer.valueOf(PortalController.a(request)));
        authReqDTO.setControllerRedirect(Boolean.valueOf(true));
        com.tplink.smb.omada.portal.web.controller.a.a.a().b(authReqDTO.getAuthType()).d((String)Optional.ofNullable(authReqDTO.getAuthType()).map(com.tplink.smb.omada.portal.api.common.c::a).map(com.tplink.smb.omada.portal.api.common.c::b).orElse(null)).e(authReqDTO.getClientMac()).f(authReqDTO.getApMac()).g(authReqDTO.getSsidName()).c(authReqDTO.getRadioId()).h(authReqDTO.getGatewayMac()).d(authReqDTO.getVid()).i(authReqDTO.getOriginUrl());
        OperationResponse resp = this.e.a(authReqDTO);
        try {
            if (resp.success()) {
                String redirectUrl;
                String radiusResultRedirectUrl = (String)resp.getResult();
                String string = redirectUrl = radiusResultRedirectUrl == null ? originUrl : radiusResultRedirectUrl;
                if (T.a((String)redirectUrl)) {
                    a.info("Empty originUrl when handle radiusAuthRedirect, will not send redirect. authReqDTO:{}", (Object)PIIJacksonUtil.parseToStr((Object)authReqDTO));
                } else {
                    this.b(response, redirectUrl);
                }
            } else {
                this.a(authReqDTO, request, response, this.a(resp.getErrorCode()));
            }
        }
        catch (IOException e) {
            a.info("Handling radiusAuth /portal/radius/corsauth failed, originUrl:{}.", (Object)originUrl, (Object)e);
        }
        return resp;
    }

    @RequestMapping(value={"/portal/radius/corsauth"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public OperationResponse b(@RequestParam(value="username", required=true) String username, @RequestParam(value="password", required=true) String password, @RequestParam(value="clientMac", required=false) String clientMac, @RequestParam(value="clientIp", required=false) String clientIp, @RequestParam(value="apMac", required=false) String apMac, @RequestParam(value="gatewayMac", required=false) String gatewayMac, @RequestParam(value="ssidName", required=false) String ssidName, @RequestParam(value="radioId", required=false) Integer radioId, @RequestParam(value="vid", required=false) Integer vid, @RequestParam(value="authType", required=false) Integer authType, @RequestParam(value="originUrl", required=false) String originUrl, HttpServletRequest request, HttpServletResponse response) {
        response.setHeader("Access-Control-Allow-Origin", request.getHeader("Access-Control-Allow-Origin"));
        AuthReqDTO authReqDTO = new AuthReqDTO();
        try {
            authReqDTO.setUsername(username);
            authReqDTO.setPassword(password);
            authReqDTO.setClientMac(G.b((String)clientMac));
            String remoteAddress = com.tplink.smb.omada.portal.web.util.c.a(request);
            authReqDTO.setClientIp(Optional.ofNullable(clientIp).orElse(remoteAddress));
            if (clientIp != null && !Objects.equals(clientIp, remoteAddress)) {
                a.info("Unmatched auth param: clientIp:{}, remoteAddress:{}", (Object)authReqDTO.getClientIp(), (Object)remoteAddress);
            }
            authReqDTO.setApMac(G.b((String)apMac));
            authReqDTO.setGatewayMac(G.b((String)gatewayMac));
            authReqDTO.setSsidName(ssidName);
            authReqDTO.setRadioId(radioId);
            authReqDTO.setVid(vid);
            authReqDTO.setAuthType(authType);
            authReqDTO.setOriginUrl(originUrl);
        }
        catch (Exception e) {
            a.debug("Invalid JSON format.", (Throwable)e);
            return OperationResponse.PARAM_ERROR;
        }
        OperationResponse ops = com.tplink.smb.omada.portal.web.util.b.a(authReqDTO);
        if (!ops.success()) {
            return ops;
        }
        authReqDTO.setServerLocation(request.getServerName());
        authReqDTO.setServerPort(Integer.valueOf(PortalController.a(request)));
        a stat = com.tplink.smb.omada.portal.web.controller.a.a.a().o("/portal/radius/corsauth").b(authReqDTO.getAuthType()).d((String)Optional.ofNullable(authReqDTO.getAuthType()).map(com.tplink.smb.omada.portal.api.common.c::a).map(com.tplink.smb.omada.portal.api.common.c::b).orElse(null)).e(authReqDTO.getClientMac()).f(authReqDTO.getApMac()).g(authReqDTO.getSsidName()).c(authReqDTO.getRadioId()).h(authReqDTO.getGatewayMac()).d(authReqDTO.getVid()).i(authReqDTO.getOriginUrl());
        OperationResponse authResp = this.e.a(authReqDTO);
        if (authResp instanceof AuthResponse) {
            stat.b(((AuthResponse)authResp).getOmadacId()).c(((AuthResponse)authResp).getSiteId());
        }
        return authResp;
    }

    @PostMapping(value={"/portal/auth"})
    @ResponseBody
    public OperationResponse<?> a(@RequestParam(value="key", required=false) String key, @RequestBody String reqBody, HttpServletRequest request) {
        AuthReqDTO authReqDTO;
        String originBody;
        try {
            originBody = this.b(key, reqBody);
        }
        catch (Exception e) {
            return new OperationResponse(com.tplink.smb.omada.common.g.b.IT);
        }
        try {
            authReqDTO = (AuthReqDTO)x.a((String)originBody, AuthReqDTO.class);
            authReqDTO.setApMac(G.b((String)authReqDTO.getApMac())).setGatewayMac(G.b((String)authReqDTO.getGatewayMac())).setClientMac(G.b((String)authReqDTO.getClientMac()));
        }
        catch (Exception e) {
            a.warn("Invalid JSON format.", (Throwable)e);
            return OperationResponse.PARAM_ERROR;
        }
        if (T.a((String)authReqDTO.getClientMac())) {
            a.warn("/portal/auth: Client Mac is null. {}", (Object)PIIJacksonUtil.parseToStr((Object)authReqDTO));
            return OperationResponse.PARAM_ERROR;
        }
        if (authReqDTO.getAuthType() == null || com.tplink.smb.omada.portal.api.common.c.a((int)authReqDTO.getAuthType()) == null) {
            a.warn("/portal/auth: Invalid AuthType. {}", (Object)PIIJacksonUtil.parseToStr((Object)authReqDTO));
            return OperationResponse.PARAM_ERROR;
        }
        String remoteAddress = com.tplink.smb.omada.portal.web.util.c.a(request);
        if (authReqDTO.getClientIp() == null) {
            authReqDTO.setClientIp(remoteAddress);
        } else if (!Objects.equals(authReqDTO.getClientIp(), remoteAddress)) {
            a.info("Unmatched auth param: clientIp:{}, remoteAddress:{}", (Object)authReqDTO.getClientIp(), (Object)remoteAddress);
        }
        authReqDTO.setServerLocation(request.getServerName());
        authReqDTO.setServerPort(Integer.valueOf(PortalController.a(request)));
        a stat = com.tplink.smb.omada.portal.web.controller.a.a.a().o("/portal/auth").b(authReqDTO.getAuthType()).d((String)Optional.ofNullable(authReqDTO.getAuthType()).map(com.tplink.smb.omada.portal.api.common.c::a).map(com.tplink.smb.omada.portal.api.common.c::b).orElse(null)).e(authReqDTO.getClientMac()).f(authReqDTO.getApMac()).g(authReqDTO.getSsidName()).c(authReqDTO.getRadioId()).h(authReqDTO.getGatewayMac()).d(authReqDTO.getVid()).i(authReqDTO.getOriginUrl());
        OperationResponse authResp = this.e.a(authReqDTO);
        if (authResp instanceof AuthResponse) {
            stat.b(((AuthResponse)authResp).getOmadacId()).c(((AuthResponse)authResp).getSiteId());
        }
        return authResp;
    }

    @PostMapping(value={"/portal/ldap/auth"})
    @ResponseBody
    public OperationResponse<?> b(@RequestParam(value="key", required=false) String key, @RequestBody String reqBody, HttpServletRequest request, HttpServletResponse response) {
        AuthReqDTO authReqDTO;
        String originBody;
        response.setHeader("Access-Control-Allow-Origin", request.getHeader("Access-Control-Allow-Origin"));
        try {
            originBody = this.b(key, reqBody);
        }
        catch (Exception e) {
            return new OperationResponse(com.tplink.smb.omada.common.g.b.IT);
        }
        try {
            authReqDTO = (AuthReqDTO)x.a((String)originBody, AuthReqDTO.class);
            authReqDTO.setApMac(G.b((String)authReqDTO.getApMac())).setGatewayMac(G.b((String)authReqDTO.getGatewayMac())).setClientMac(G.b((String)authReqDTO.getClientMac()));
        }
        catch (Exception e) {
            a.warn("Invalid JSON format.", (Throwable)e);
            return OperationResponse.PARAM_ERROR;
        }
        OperationResponse<?> validateRes = this.a(authReqDTO);
        if (!validateRes.success()) {
            return validateRes;
        }
        authReqDTO.setClientIp(Optional.ofNullable(authReqDTO.getClientIp()).orElse(com.tplink.smb.omada.portal.web.util.c.a(request)));
        authReqDTO.setServerLocation(request.getServerName());
        authReqDTO.setServerPort(Integer.valueOf(PortalController.a(request)));
        a stat = com.tplink.smb.omada.portal.web.controller.a.a.a().o("/portal/ldap/auth").b(authReqDTO.getAuthType()).d(com.tplink.smb.omada.portal.api.common.c.m.b()).e(authReqDTO.getClientMac()).f(authReqDTO.getApMac()).g(authReqDTO.getSsidName()).c(authReqDTO.getRadioId()).h(authReqDTO.getGatewayMac()).d(authReqDTO.getVid()).i(authReqDTO.getOriginUrl());
        OperationResponse authResp = this.e.a(authReqDTO);
        if (authResp instanceof AuthResponse) {
            stat.b(((AuthResponse)authResp).getOmadacId()).c(((AuthResponse)authResp).getSiteId());
        }
        return authResp;
    }

    @RequestMapping(path={"/portal/ldap/browserauth"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public OperationResponse<?> a(@RequestParam(value="ldapUsername", required=true) String ldapUsername, @RequestParam(value="ldapPassword", required=true) String ldapPassword, @RequestParam(value="clientMac", required=false) String clientMac, @RequestParam(value="clientIp", required=false) String clientIp, @RequestParam(value="apMac", required=false) String apMac, @RequestParam(value="gatewayMac", required=false) String gatewayMac, @RequestParam(value="ssidName", required=false) String ssidName, @RequestParam(value="radioId", required=false) Integer radioId, @RequestParam(value="vid", required=false) Integer vid, @RequestParam(value="originUrl", required=false) String originUrl, HttpServletRequest request, HttpServletResponse response) {
        response.setHeader("Access-Control-Allow-Origin", request.getHeader("Access-Control-Allow-Origin"));
        AuthReqDTO authReqDTO = new AuthReqDTO();
        authReqDTO.setLdapUsername(ldapUsername);
        authReqDTO.setLdapPassword(ldapPassword);
        authReqDTO.setClientMac(G.b((String)clientMac));
        authReqDTO.setClientIp(Optional.ofNullable(clientIp).orElseGet(() -> com.tplink.smb.omada.portal.web.util.c.a(request)));
        authReqDTO.setApMac(G.b((String)apMac));
        authReqDTO.setGatewayMac(G.b((String)gatewayMac));
        authReqDTO.setSsidName(ssidName);
        authReqDTO.setRadioId(radioId);
        authReqDTO.setVid(vid);
        authReqDTO.setOriginUrl(originUrl);
        authReqDTO.setAuthType(Integer.valueOf(com.tplink.smb.omada.portal.api.common.c.m.a()));
        authReqDTO.setServerLocation(request.getServerName());
        authReqDTO.setServerPort(Integer.valueOf(PortalController.a(request)));
        authReqDTO.setControllerRedirect(Boolean.valueOf(true));
        OperationResponse<?> validateRes = this.a(authReqDTO);
        if (!validateRes.success()) {
            return validateRes;
        }
        com.tplink.smb.omada.portal.web.controller.a.a.a().o("/portal/ldap/browserauth").b(authReqDTO.getAuthType()).d(com.tplink.smb.omada.portal.api.common.c.m.b()).e(authReqDTO.getClientMac()).f(authReqDTO.getApMac()).g(authReqDTO.getSsidName()).c(authReqDTO.getRadioId()).h(authReqDTO.getGatewayMac()).d(authReqDTO.getVid()).i(authReqDTO.getOriginUrl());
        OperationResponse authRes = this.e.a(authReqDTO);
        try {
            if (authRes.success()) {
                String redirectUrl;
                String successPage = (String)authRes.getResult();
                String string = redirectUrl = successPage == null ? originUrl : successPage;
                if (T.a((String)redirectUrl)) {
                    a.info("Empty originUrl when handle ldapBrowserAuth, will not send redirect. authReq:{}", (Object)PIIJacksonUtil.parseToStr((Object)authReqDTO));
                } else {
                    this.b(response, redirectUrl);
                }
            } else {
                this.b(authReqDTO, request, response, this.b(authRes.getErrorCode()));
            }
        }
        catch (IOException e) {
            a.info("Handling ldapAuth /portal/ldap/browserAuth failed, originUrl:{}.", (Object)originUrl, (Object)e);
        }
        return authRes;
    }

    @PostMapping(value={"/portal/doLogout"})
    @ResponseBody
    public OperationResponse<?> b(@RequestParam(value="key", required=false) String key, @RequestBody String reqBody, HttpServletRequest request) {
        LogoutRequestDTO logoutReqDTO;
        String originBody;
        try {
            originBody = this.b(key, reqBody);
        }
        catch (Exception e) {
            a.warn(e.toString(), (Throwable)e);
            return new OperationResponse(com.tplink.smb.omada.common.g.b.IT);
        }
        try {
            logoutReqDTO = (LogoutRequestDTO)x.a((String)originBody, LogoutRequestDTO.class);
            logoutReqDTO.setApMac(G.b((String)logoutReqDTO.getApMac())).setGatewayMac(G.b((String)logoutReqDTO.getGatewayMac())).setClientMac(G.b((String)logoutReqDTO.getClientMac()));
        }
        catch (Exception e) {
            a.warn("Invalid JSON format.", (Throwable)e);
            return OperationResponse.PARAM_ERROR;
        }
        com.tplink.smb.omada.portal.web.controller.a.a.a().o("/portal/doLogout").e(logoutReqDTO.getClientMac()).f(logoutReqDTO.getApMac()).g(logoutReqDTO.getSsidName()).h(logoutReqDTO.getGatewayMac()).d(logoutReqDTO.getVid());
        return this.e.a(logoutReqDTO);
    }

    @Deprecated
    @GetMapping(value={"/portal/fbwifi/forward"})
    public void a(@RequestParam(value="clientMac", required=false) String clientMac, @RequestParam(value="clientIp", required=false) String clientIp, @RequestParam(value="apMac", required=false) String apMac, @RequestParam(value="gatewayMac", required=false) String gatewayMac, @RequestParam(value="ssidName", required=false) String ssidName, @RequestParam(value="radioId", required=false) Integer radioId, @RequestParam(value="vid", required=false) Integer vid, @RequestParam(value="t", required=false) Long t, @RequestParam(value="originUrl", required=false) String originUrl, HttpServletRequest request, HttpServletResponse response) throws IOException {
        PortalEntranceQueryDTO query = new PortalEntranceQueryDTO().setClientMac(G.b((String)clientMac)).setClientIp(Optional.ofNullable(clientIp).orElse(com.tplink.smb.omada.portal.web.util.c.a(request))).setApMac(G.b((String)apMac)).setSsid(ssidName).setRadioId(radioId).setOsgMac(G.b((String)gatewayMac)).setVid(vid).setTimestamp(Optional.ofNullable(t).orElse(System.currentTimeMillis())).setOriginUrl(originUrl).setServerLocation(this.g.a(request)).setServerPort(Integer.valueOf(this.g.b(request)));
        com.tplink.smb.omada.portal.web.controller.a.a.a().o("/portal/fbwifi/forward").b(com.tplink.smb.omada.portal.api.common.c.h.a()).d(com.tplink.smb.omada.portal.api.common.c.h.b()).e(clientMac).f(apMac).g(ssidName).c(radioId).h(gatewayMac).d(vid).i(originUrl);
        DeviceTypeEnum authDevType = this.c(apMac, gatewayMac);
        if (authDevType == null) {
            response.setStatus(HttpStatus.BAD_REQUEST.value());
            a.debug("Failed to resolve authDevType.");
            return;
        }
        a.info("Handling GET {}... PortalEntranceQueryDTO :{}", (Object)"/portal/fbwifi/forward", (Object)PIIJacksonUtil.parseToStr((Object)query));
        if (!this.a(query)) {
            a.warn("GET {}: Query parameters is invalid. PortalEntranceQueryDTO :{}", (Object)"/portal/fbwifi/forward", (Object)PIIJacksonUtil.parseToStr((Object)query));
            response.setStatus(HttpStatus.BAD_REQUEST.value());
            return;
        }
        OperationResponse forwardResponse = this.e.b(query);
        if (forwardResponse.getErrorCode() == com.tplink.smb.omada.common.g.b.rC.b()) {
            response.setStatus(HttpStatus.BAD_REQUEST.value());
            response.getWriter().write("The EAPs/Gateway are in an earlier firmware version and does not support Facebook Wi-Fi V2, please contact the network administrator for more information.");
            return;
        }
        if (!forwardResponse.success()) {
            a.warn("GET {}: Portal related setting seems illegal. PortalEntranceQueryDTO :{}", (Object)"/portal/fbwifi/forward", (Object)PIIJacksonUtil.parseToStr((Object)query));
            response.setStatus(HttpStatus.BAD_REQUEST.value());
            return;
        }
        FacebookForwardResultDTO result = (FacebookForwardResultDTO)forwardResponse.getResult();
        com.tplink.smb.omada.portal.web.controller.a.a.a().b(result.getOmadacId()).c(result.getSiteId());
        if (!Boolean.TRUE.equals(result.getPortalEnabled())) {
            a.info("GET {}: Portal is not enabled. PortalEntranceQueryDTO : {}, FacebookForwardResult : {}, redirecting to origin url.", (Object)"/portal/fbwifi/forward", (Object)PIIJacksonUtil.parseToStr((Object)query), (Object)result);
            response.sendRedirect(originUrl);
            return;
        }
        if (!Objects.equals(com.tplink.smb.omada.portal.api.common.c.h.a(), result.getAuthType())) {
            a.warn("GET {}: Not Facebook Portal. PortalEntranceQueryDTO : {}, FacebookForwardResult : {}", (Object)"/portal/fbwifi/forward", (Object)PIIJacksonUtil.parseToStr((Object)query), (Object)result);
            response.setStatus(HttpStatus.BAD_REQUEST.value());
            response.getWriter().write("The EAPs/Gateway are in an earlier firmware version and does not support Facebook Wi-Fi V2, please contact the network administrator for more information.");
            return;
        }
        if (Boolean.TRUE.equals(result.getAuthed())) {
            if (T.a((String)originUrl)) {
                a.info("Empty originUrl when handle facebookWifiForward, will not send redirect. apMac:{}, ssidName:{}, osgMac:{}, vid:{}, clientMac:{}", (Object)com.tplink.smb.omada.common.util.e.a.d((String)query.getApMac()), (Object)com.tplink.smb.omada.common.util.e.a.d((String)query.getSsid()), (Object)com.tplink.smb.omada.common.util.e.a.d((String)query.getOsgMac()), (Object)query.getVid(), (Object)com.tplink.smb.omada.common.util.e.a.d((String)query.getClientMac()));
            } else {
                this.b(response, originUrl);
            }
            return;
        }
        this.a(Collections.singletonList(result.getCookie()), response);
        this.a(response, result.getRedirectUrl());
    }

    @Deprecated
    @GetMapping(value={"/portal/fbwifi/auth"})
    public void c(@RequestParam(name="c") String cookieKey, @RequestParam(name="token") String token, HttpServletRequest request, HttpServletResponse response) {
        FacebookAuthReqDTO fbAuthReq = new FacebookAuthReqDTO(token, cookieKey);
        a.info("Facebook auth request is {}", (Object)fbAuthReq);
        OperationResponse authRes = this.e.a(fbAuthReq);
        if (!authRes.success()) {
            a.debug("Facebook auth failed, request :{}, response: {}", (Object)fbAuthReq, (Object)authRes);
            return;
        }
        com.tplink.smb.omada.portal.web.controller.a.a.a().o("/portal/fbwifi/auth").b(com.tplink.smb.omada.portal.api.common.c.h.a()).d(com.tplink.smb.omada.portal.api.common.c.h.b());
        try {
            response.sendRedirect((String)authRes.getResult());
        }
        catch (IOException e) {
            a.warn("Failed to redirect facebook portal page.", (Throwable)e);
        }
    }

    @GetMapping(value={"/portal/fbwifi/continue"})
    @Deprecated
    public void d(@RequestParam(name="c") String cookieKey, @RequestParam(name="token") String token, HttpServletRequest request, HttpServletResponse response) {
        Cookie[] cookies = request.getCookies();
        try {
            if (cookies == null || cookies.length < 1) {
                a.debug("Get fb origin url cookie failed.");
                response.getWriter().write("<h1>Facebook Auth Succeeded!</h1>");
                return;
            }
            for (Cookie cookie : cookies) {
                if (!("c_" + cookieKey).equals(cookie.getName())) continue;
                String redirectUrl = cookie.getValue();
                response.sendRedirect(redirectUrl);
                return;
            }
            a.debug("Cannot find fb origin url cookie.");
            response.getWriter().write("<h1>Facebook Auth Succeeded!</h1>");
        }
        catch (IOException e) {
            a.warn("Failed to write success message.");
        }
    }

    @GetMapping(value={"/portal/sociallogin/forward"})
    public void a(@RequestParam(value="authType", required=false) Integer authType, @RequestParam(value="clientMac", required=false) String clientMac, @RequestParam(value="clientIp", required=false) String clientIp, @RequestParam(value="apMac", required=false) String apMac, @RequestParam(value="gatewayMac", required=false) String gatewayMac, @RequestParam(value="ssidName", required=false) String ssidName, @RequestParam(value="radioId", required=false) Integer radioId, @RequestParam(value="vid", required=false) Integer vid, @RequestParam(value="t", required=false) Long t, @RequestParam(value="originUrl", required=false) String originUrl, HttpServletRequest request, HttpServletResponse response) throws IOException {
        SocialPortalEntranceQueryDTO query = new SocialPortalEntranceQueryDTO().setClientMac(G.b((String)clientMac)).setClientIp(Optional.ofNullable(clientIp).orElse(com.tplink.smb.omada.portal.web.util.c.a(request))).setApMac(G.b((String)apMac)).setSsid(ssidName).setRadioId(radioId).setOsgMac(G.b((String)gatewayMac)).setVid(vid).setTimestamp(Optional.ofNullable(t).orElse(System.currentTimeMillis())).setOriginUrl(originUrl).setServerLocation(request.getServerName()).setServerPort(Integer.valueOf(request.getServerPort())).setAuthType(authType);
        DeviceTypeEnum authDevType = this.c(apMac, gatewayMac);
        if (authDevType == null) {
            response.setStatus(HttpStatus.BAD_REQUEST.value());
            a.debug("Failed to resolve authDevType :{}", new Supplier[]{() -> PIIJacksonUtil.parseToStr((Object)query)});
            return;
        }
        a.info("Handling GET {}... SocialPortalEntranceQueryDTO :{}", (Object)"/portal/sociallogin/forward", (Object)PIIJacksonUtil.parseToStr((Object)query));
        if (!this.a(query)) {
            a.warn("GET {}: Query parameters is invalid. PortalEntranceQueryDTO :{}", (Object)"/portal/sociallogin/forward", (Object)PIIJacksonUtil.parseToStr((Object)query));
            response.setStatus(HttpStatus.BAD_REQUEST.value());
            return;
        }
        OperationResponse forwardResponse = this.e.a(query);
        if (!forwardResponse.success()) {
            a.warn("GET {}: Portal related setting seems illegal. SocialPortalEntranceQueryDTO :{}", (Object)"/portal/sociallogin/forward", (Object)PIIJacksonUtil.parseToStr((Object)query));
            response.setStatus(HttpStatus.BAD_REQUEST.value());
            return;
        }
        SocialLoginForwardResultDTO result = (SocialLoginForwardResultDTO)forwardResponse.getResult();
        com.tplink.smb.omada.portal.web.controller.a.a.a().b(result.getOmadacId()).c(result.getSiteId());
        if (!Boolean.TRUE.equals(result.getPortalEnabled())) {
            a.info("GET {}: Portal is not enabled. PortalEntranceQueryDTO : {}, SocialForwardResult : {}, redirecting to origin url.", (Object)"/portal/sociallogin/forward", (Object)PIIJacksonUtil.parseToStr((Object)query), (Object)result);
            response.sendRedirect(originUrl);
            return;
        }
        if (Boolean.TRUE.equals(result.getAuthed())) {
            if (T.a((String)originUrl)) {
                a.info("Empty originUrl when handle socialLoginForward, will not send redirect. apMac:{}, ssidName:{}, osgMac:{}, vid:{}, clientMac:{}", (Object)com.tplink.smb.omada.common.util.e.a.d((String)query.getApMac()), (Object)com.tplink.smb.omada.common.util.e.a.d((String)query.getSsid()), (Object)com.tplink.smb.omada.common.util.e.a.d((String)query.getOsgMac()), (Object)query.getVid(), (Object)com.tplink.smb.omada.common.util.e.a.d((String)query.getClientMac()));
            } else {
                this.b(response, originUrl);
            }
            return;
        }
        this.a(response, result.getRedirectUrl());
    }

    @GetMapping(value={"/portal/sociallogin/auth"})
    public void e(@RequestParam(name="state") String state, @RequestParam(name="code") String code, HttpServletRequest request, HttpServletResponse response) {
        SocialAuthReqDTO socialAuthReq = new SocialAuthReqDTO();
        socialAuthReq.setState(state);
        socialAuthReq.setCode(code);
        socialAuthReq.setScheme(request.getScheme());
        a.debug("Social auth request is {}", (Object)socialAuthReq);
        OperationResponse authRes = this.e.a(socialAuthReq);
        if (authRes.getResult() != null) {
            this.b(response, (String)authRes.getResult());
        }
    }

    @ResponseBody
    @GetMapping(value={"/portal/pubKey"})
    public OperationResponse<?> a() {
        RSAKeyPairDTO keyPairDTO = this.e.a();
        return new OperationResponse(com.tplink.smb.omada.common.g.b.a, Collections.singletonMap("key", k.a((String)"PUBLIC KEY", (Key)PortalController.b(keyPairDTO))));
    }

    @Nullable
    private String a(int errCode) {
        b code = com.tplink.smb.omada.common.g.b.a((int)errCode);
        switch (code) {
            case a: {
                return null;
            }
            case IU: {
                return "INVALID_USERNAME_OR_PASSWORD";
            }
            case IV: {
                return "RADIUS_SERVER_TIMEOUT";
            }
        }
        return "AUTH_FAILED";
    }

    private void a(AuthReqDTO authReqDTO, HttpServletRequest request, HttpServletResponse response, @Nullable String errorHint) throws IOException {
        PortalEntranceQueryDTO query = new PortalEntranceQueryDTO().setClientMac(authReqDTO.getClientMac()).setClientIp(authReqDTO.getClientIp()).setApMac(authReqDTO.getApMac()).setSsid(authReqDTO.getSsidName()).setRadioId(authReqDTO.getRadioId()).setOsgMac(authReqDTO.getGatewayMac()).setVid(authReqDTO.getVid()).setTimestamp(Optional.ofNullable(authReqDTO.getTime()).orElse(System.currentTimeMillis())).setServerLocation(authReqDTO.getServerLocation()).setServerPort(authReqDTO.getServerPort()).setOriginUrl(authReqDTO.getOriginUrl());
        OperationResponse portalEntranceResp = this.e.a(query);
        if (!portalEntranceResp.success()) {
            a.warn("GET {}: Portal related setting seems illegal. PortalEntranceQueryDTO :{}", (Object)"/portal/entry", (Object)PIIJacksonUtil.parseToStr((Object)query));
            response.setStatus(HttpStatus.BAD_REQUEST.value());
            return;
        }
        this.a(request, response, query, errorHint);
    }

    private void b(AuthReqDTO authReqDTO, HttpServletRequest request, HttpServletResponse response, @Nullable String errorHint) throws IOException {
        PortalEntranceQueryDTO query = new PortalEntranceQueryDTO().setClientMac(authReqDTO.getClientMac()).setClientIp(authReqDTO.getClientIp()).setApMac(authReqDTO.getApMac()).setSsid(authReqDTO.getSsidName()).setRadioId(authReqDTO.getRadioId()).setOsgMac(authReqDTO.getGatewayMac()).setVid(authReqDTO.getVid()).setTimestamp(Optional.ofNullable(authReqDTO.getTime()).orElse(System.currentTimeMillis())).setServerLocation(authReqDTO.getServerLocation()).setServerPort(authReqDTO.getServerPort()).setOriginUrl(authReqDTO.getOriginUrl());
        OperationResponse portalEntranceResp = this.e.a(query);
        if (!portalEntranceResp.success()) {
            a.warn("GET {}: Portal related setting seems illegal. PortalEntranceQueryDTO :{}", (Object)"/portal/entry", (Object)PIIJacksonUtil.parseToStr((Object)query));
            response.setStatus(HttpStatus.BAD_REQUEST.value());
            return;
        }
        this.a(request, response, query, errorHint);
    }

    @Nullable
    private String b(int errCode) {
        b code = com.tplink.smb.omada.common.g.b.a((int)errCode);
        switch (code) {
            case a: {
                return null;
            }
            case Lq: {
                return "LDAP_INVALID_CONFIGURATION";
            }
            case Lr: {
                return "LDAP_INVALID_CREDENTIALS";
            }
        }
        return "AUTH_FAILED";
    }

    @Nullable
    private String a(HttpServletRequest request, HttpServletResponse response, PortalEntranceQueryDTO query, @Nullable String errorHint) {
        OperationResponse portalEntranceResp = this.e.a(query);
        if (!portalEntranceResp.success()) {
            a.warn("GET {}: Portal related setting seems illegal. PortalEntranceQueryDTO :{}", (Object)"/portal/entry", (Object)PIIJacksonUtil.parseToStr((Object)query));
            response.setStatus(HttpStatus.BAD_REQUEST.value());
            return null;
        }
        PortalEntranceDTO entranceDTO = (PortalEntranceDTO)portalEntranceResp.getResult();
        com.tplink.smb.omada.portal.web.controller.a.a.a().b(entranceDTO.getOmadacId()).c(entranceDTO.getSiteId()).a(entranceDTO.getAuthType()).d((String)Optional.ofNullable(entranceDTO.getAuthType()).map(com.tplink.smb.omada.portal.api.common.c::a).map(com.tplink.smb.omada.portal.api.common.c::b).orElse(null));
        if (!Boolean.TRUE.equals(entranceDTO.getPortalEnabled())) {
            a.warn("GET {}: Portal not enabled. PortalEntranceQueryDTO :{}, PortalEntranceDTO:{}", (Object)"/portal/entry", (Object)PIIJacksonUtil.parseToStr((Object)query), (Object)entranceDTO);
            return null;
        }
        if (Boolean.TRUE.equals(entranceDTO.getAuthed())) {
            a.info("GET {}: Client already authed. PortalEntranceQueryDTO :{}, PortalEntranceDTO:{}", (Object)"/portal/entry", (Object)PIIJacksonUtil.parseToStr((Object)query), (Object)entranceDTO);
            this.a(response, query.getOriginUrl(), entranceDTO);
            return null;
        }
        if (entranceDTO.getAuthType() != null && com.tplink.smb.omada.portal.api.common.c.l.a() == entranceDTO.getAuthType().intValue()) {
            a.info("GET {}: Cannot handle Facebook V2 portal. PortalEntranceQueryDTO :{}, PortalEntranceDTO:{}", (Object)"/portal/entry", (Object)PIIJacksonUtil.parseToStr((Object)query), (Object)entranceDTO);
            return null;
        }
        PortalViewControlDTO viewControl = entranceDTO.getViewControl();
        if (viewControl == null) {
            a.warn("Unexpected param viewControl when handleEntrance in entranceDTO:{}", (Object)entranceDTO);
            response.setStatus(HttpStatus.BAD_REQUEST.value());
            return null;
        }
        switch (viewControl.getPortalSiteType()) {
            case 1: {
                return this.f.a(response, query, entranceDTO.getOmadacId());
            }
            case 2: {
                a.debug("GET {}: Redirecting to imported page. PortalEntranceQueryDTO :{}, PortalEntranceDTO:{}", new Supplier[]{() -> "/portal/entry", () -> PIIJacksonUtil.parseToStr((Object)query), () -> entranceDTO});
                Optional optPageDTO = this.e.a(new ImportedPageQueryDTO().setOmadacId(entranceDTO.getOmadacId()).setSiteId(entranceDTO.getSiteId()).setImportedPageId(viewControl.getImportedPageId()));
                if (!optPageDTO.isPresent()) {
                    a.error("Handling jump imported page, page is not exist, return as 404");
                    response.setStatus(HttpStatus.NOT_FOUND.value());
                    return null;
                }
                return this.a(entranceDTO.getOmadacId(), entranceDTO.getSiteId(), request, response, query, (ImportedPageDTO)optPageDTO.get());
            }
            case 3: {
                a.debug("GET {}: Redirecting to other portal server. PortalEntranceQueryDTO :{}, PortalEntranceDTO:{}", new Supplier[]{() -> "/portal/entry", () -> PIIJacksonUtil.parseToStr((Object)query), () -> entranceDTO});
                String externalPageUrl = viewControl.getExternalPageUrl();
                if (!T.c((String)errorHint)) {
                    UriComponentsBuilder builder = UriComponentsBuilder.fromHttpUrl((String)externalPageUrl);
                    builder.queryParam("errorHint", new Object[]{errorHint});
                    externalPageUrl = builder.toUriString();
                }
                return this.a(response, externalPageUrl);
            }
        }
        a.warn("GET {}: Unknown portal site type. PortalEntranceQueryDTO :{}, PortalEntranceDTO:{}", (Object)"/portal/entry", (Object)PIIJacksonUtil.parseToStr((Object)query), (Object)entranceDTO);
        return null;
    }

    @Nullable
    private String a(HttpServletRequest request, HttpServletResponse response, PortalLogoutQueryDTO query) {
        OperationResponse checkLogoutEntranceResp = this.e.a(query);
        if (!checkLogoutEntranceResp.success()) {
            a.warn("GET {}: Portal related setting seems illegal. PortalLogoutQueryDTO :{}", (Object)"/portal/logout", (Object)PIIJacksonUtil.parseToStr((Object)query));
            response.setStatus(HttpStatus.BAD_REQUEST.value());
            try {
                response.getWriter().write(checkLogoutEntranceResp.getMsg());
            }
            catch (Exception e) {
                a.warn("httpResponse execption {}", (Object)e.getMessage(), (Object)e);
            }
            return null;
        }
        PortalEntranceDTO entranceDTO = (PortalEntranceDTO)checkLogoutEntranceResp.getResult();
        com.tplink.smb.omada.portal.web.controller.a.a.a().b(entranceDTO.getOmadacId()).c(entranceDTO.getSiteId());
        return this.f.a(response, query, entranceDTO.getOmadacId());
    }

    private void a(@Nullable List<CookieDTO> cookies, @Nonnull HttpServletResponse response) {
        if (CollectionUtils.isEmpty(cookies)) {
            return;
        }
        for (CookieDTO cookieDTO : cookies) {
            if (cookieDTO == null) continue;
            Cookie cookie = new Cookie(cookieDTO.getName(), cookieDTO.getValue());
            cookie.setSecure(Boolean.TRUE.equals(cookieDTO.getSecure()));
            cookie.setMaxAge(cookieDTO.getMaxAge().intValue());
            if (!T.a((String)cookieDTO.getDomain())) {
                cookie.setDomain(cookieDTO.getDomain());
            }
            if (!T.a((String)cookieDTO.getPath())) {
                cookie.setPath(cookieDTO.getPath());
            }
            cookie.setHttpOnly(Boolean.TRUE.equals(cookieDTO.getHttpOnly()));
            response.addCookie(cookie);
        }
    }

    private String a(HttpServletResponse response, String url) {
        try {
            response.sendRedirect(url);
        }
        catch (Exception e) {
            a.warn("Redirect to portal site:{} failed with exception.", (Object)url, (Object)e);
        }
        return null;
    }

    private String a(String omadacId, String siteId, HttpServletRequest request, HttpServletResponse response, PortalEntranceQueryDTO query, ImportedPageDTO importedPage) {
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            List headerValues = EnumerationUtils.toList((Enumeration)request.getHeaders(headerName));
            a.debug("Handling jump imported page. Header: {}={}", (Object)headerName, (Object)headerValues);
        }
        boolean isZip = importedPage.getFileName().toLowerCase(Locale.ROOT).endsWith(".zip");
        String relativePath = query.getApMac() != null ? this.a(omadacId, siteId, query.getClientMac(), query.getClientIp(), query.getApMac(), query.getSsid(), query.getRadioId(), query.getOriginUrl(), importedPage.getId(), isZip) : this.a(omadacId, siteId, query.getClientMac(), query.getClientIp(), query.getOsgMac(), query.getVid(), query.getOriginUrl(), importedPage.getId(), isZip);
        try {
            response.getWriter().write(this.b(relativePath));
        }
        catch (IOException e) {
            a.warn("Failed to redirect to imported portal page.");
        }
        return null;
    }

    private String b(String redirectLink) {
        return String.format(Locale.ROOT, "<html><head></head><body><script type=\"text/javascript\" language=\"javascript\">top.location.href=\"%s\";</script></body></html>", redirectLink);
    }

    private String a(String omadacId, String siteId, String clientMac, String clientIp, String apMac, String ssidName, Integer radioId, String originUrl, String pageId, boolean isZip) {
        UriComponentsBuilder builder = this.f.a(omadacId, siteId, pageId);
        if (isZip) {
            builder.pathSegment(new String[]{"index.html"});
        }
        return builder.queryParam("apMac", new Object[]{this.e.a(new TransFormatMacDTO(omadacId, apMac))}).queryParam("clientMac", new Object[]{this.e.a(new TransFormatMacDTO(omadacId, clientMac))}).queryParam("clientIp", new Object[]{clientIp}).queryParam("ssidName", new Object[]{ssidName}).queryParam("radioId", new Object[]{radioId}).queryParam("originUrl", new Object[]{originUrl == null ? "" : originUrl}).encode().build().toUri().toString();
    }

    private String a(String omadacId, String siteId, String clientMac, String clientIp, String gatewayMac, Integer vid, String originUrl, String pageId, boolean isZip) {
        UriComponentsBuilder builder = this.f.a(omadacId, siteId, pageId);
        if (isZip) {
            builder.pathSegment(new String[]{"index.html"});
        }
        return builder.queryParam("gatewayMac", new Object[]{this.e.a(new TransFormatMacDTO(omadacId, gatewayMac))}).queryParam("clientMac", new Object[]{this.e.a(new TransFormatMacDTO(omadacId, clientMac))}).queryParam("clientIp", new Object[]{clientIp}).queryParam("vid", new Object[]{vid}).queryParam("originUrl", new Object[]{originUrl == null ? "" : originUrl}).encode().build().toUri().toString();
    }

    private boolean a(PortalParamVO portalParam) {
        return portalParam.getClientMac() != null && portalParam.getOriginUrl() != null && (portalParam.getApMac() != null && portalParam.getSsidName() != null || portalParam.getGatewayMac() != null && portalParam.getVid() != null);
    }

    private boolean a(LogoutParamVO param) {
        return param.getClientMac() != null && param.getCliToken() != null && (param.getApMac() != null && param.getSsidName() != null || param.getGatewayMac() != null && param.getVid() != null);
    }

    private boolean a(PortalEntranceQueryDTO query) {
        return query.getClientMac() != null && (query.getApMac() != null && query.getSsid() != null || query.getOsgMac() != null && query.getVid() != null);
    }

    private boolean a(SocialPortalEntranceQueryDTO query) {
        return query.getClientMac() != null && query.getAuthType() != null && (query.getApMac() != null && query.getSsid() != null || query.getOsgMac() != null && query.getVid() != null);
    }

    private boolean a(PortalLogoutQueryDTO query) {
        return query.getClientMac() != null && query.getToken() != null && (query.getApMac() != null && query.getSsid() != null || query.getOsgMac() != null && query.getVid() != null);
    }

    private void a(HttpServletResponse response, String originUrl, PortalEntranceDTO entranceDTO) {
        LandingRedirectDTO landing = entranceDTO.getLanding();
        if (landing == null) {
            a.warn("Unexpected param landing in entranceDTO:{}", (Object)entranceDTO);
            return;
        }
        if (Objects.equals(landing.getLandingPage(), 1)) {
            if (T.a((String)originUrl)) {
                a.info("Empty originUrl when handleAlreadyAuthed, will not send redirect, omadacId:{}, siteId:{}, portalId:{}", (Object)entranceDTO.getOmadacId(), (Object)entranceDTO.getSiteId(), (Object)entranceDTO.getPortalId());
            } else {
                this.b(response, originUrl);
            }
        } else if (Objects.equals(landing.getLandingPage(), 2) && landing.getLandingUrlScheme() != null && landing.getLandingUrl() != null) {
            this.b(response, String.format(Locale.ROOT, c, landing.getLandingUrlScheme(), landing.getLandingUrl()));
        }
    }

    private void b(@Nonnull HttpServletResponse response, @Nonnull String url) {
        try {
            Matcher matcher = b.matcher((CharSequence)url);
            if (!matcher.find()) {
                url = "http://" + (String)url;
            }
            response.sendRedirect((String)url);
        }
        catch (IOException e) {
            a.warn("Failed to send HTTP redirect to {}", url, (Object)e);
        }
    }

    private String b(String aesKey, String reqBody) {
        if (aesKey == null) {
            a.debug("AES key is null, handle as not encrypted.");
            return reqBody;
        }
        RSAKeyPairDTO keyPairDTO = this.e.a();
        try {
            byte[] keyIv = k.a((byte[])com.tplink.smb.omada.common.util.b.c.b((String)aesKey), (Key)PortalController.a(keyPairDTO), (int)2, (String)d);
            byte[] originData = com.tplink.smb.omada.portal.web.util.a.a(com.tplink.smb.omada.common.util.b.c.b((String)reqBody), keyIv);
            return new String(originData, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            if (OmadacType.s()) {
                a.warn("[Portal decryptReqBody]: Failed to decrypt portal request body, AES Key: {}, Request Body: {}, RSA Key Pair: {}", (Object)aesKey, (Object)reqBody, (Object)keyPairDTO, (Object)e);
            } else {
                a.warn("[Portal decryptReqBody]: Failed to decrypt portal request body, AES Key: {}", (Object)aesKey, (Object)e);
            }
            throw e;
        }
    }

    @Nullable
    private DeviceTypeEnum c(String ap, String gateway) {
        DeviceTypeEnum srcDevType;
        if (ap != null) {
            srcDevType = DeviceTypeEnum.a;
        } else if (gateway != null) {
            srcDevType = DeviceTypeEnum.b;
        } else {
            a.warn("Redirect device is not valid.");
            return null;
        }
        return srcDevType;
    }

    private OperationResponse<?> a(AuthReqDTO authReq) {
        if (T.a((String)authReq.getLdapUsername())) {
            return new OperationResponse(com.tplink.smb.omada.common.g.b.rI);
        }
        if (T.a((String)authReq.getLdapPassword())) {
            return new OperationResponse(com.tplink.smb.omada.common.g.b.rJ);
        }
        if (T.a((String)authReq.getClientMac())) {
            return new OperationResponse(com.tplink.smb.omada.common.g.b.rK);
        }
        if (!T.a((String)authReq.getApMac())) {
            if (T.a((String)authReq.getSsidName())) {
                return new OperationResponse(com.tplink.smb.omada.common.g.b.rM);
            }
        } else if (!T.a((String)authReq.getGatewayMac())) {
            if (authReq.getVid() == null) {
                return new OperationResponse(com.tplink.smb.omada.common.g.b.rO);
            }
        } else {
            return OperationResponse.PARAM_ERROR;
        }
        return OperationResponse.SUCCESS;
    }

    @Autowired
    public void a(h portalInternalApiService) {
        this.e = portalInternalApiService;
    }

    @Autowired
    public void a(c portalEntryPageHandler) {
        this.f = portalEntryPageHandler;
    }

    @Autowired
    public void a(com.tplink.smb.omada.portal.web.controller.a facebookRedirectionHandler) {
        this.g = facebookRedirectionHandler;
    }
}

