/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.stack.api.web.dto.app;

import com.tplink.smb.omada.common.validator.anons.NumberSet;
import com.tplink.smb.omada.manager.device.api.web.device.dto.IpSettingVO;
import com.tplink.smb.omada.manager.device.api.web.osw.dto.OswConfigVO;
import com.tplink.smb.omada.manager.stack.api.web.dto.OswStackDetailVO;
import jakarta.validation.constraints.Pattern;
import java.util.Optional;
import lombok.Generated;

public class OswStackConfigAppVO {
    private String id;
    @Pattern(regexp="^[^ \\+\\-\\@\\=]$|^[^ \\+\\-\\@\\=].{0,126}[^ ]$", message="Parameter [name] should be 1 ~ 128 characters")
    private @Pattern(regexp="^[^ \\+\\-\\@\\=]$|^[^ \\+\\-\\@\\=].{0,126}[^ ]$", message="Parameter [name] should be 1 ~ 128 characters") String name;
    private Integer status;
    private String model;
    private String uptime;
    @NumberSet(value={0, 1, 2}, message="Parameter [ledSetting] should be 0 or 1 or 2")
    private Integer ledSetting;
    private IpSettingVO ipSetting;

    public static OswConfigVO toWebVO(OswStackConfigAppVO appVO) {
        OswConfigVO vo = new OswConfigVO();
        vo.setName(appVO.getName());
        vo.setLedSetting(appVO.getLedSetting());
        return vo;
    }

    public static OswStackConfigAppVO toAppVO(OswStackDetailVO vo) {
        OswStackConfigAppVO oswStackConfigAppVO = new OswStackConfigAppVO();
        oswStackConfigAppVO.setId(vo.getId());
        oswStackConfigAppVO.setName(vo.getName());
        oswStackConfigAppVO.setStatus(vo.getStatus());
        oswStackConfigAppVO.setModel(vo.getModel());
        oswStackConfigAppVO.setUptime(vo.getUptime());
        oswStackConfigAppVO.setLedSetting(vo.getLedSetting());
        oswStackConfigAppVO.setIpSetting(Optional.ofNullable(vo.getIpSetting()).orElse(null));
        return oswStackConfigAppVO;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Integer getStatus() {
        return this.status;
    }

    @Generated
    public String getModel() {
        return this.model;
    }

    @Generated
    public String getUptime() {
        return this.uptime;
    }

    @Generated
    public Integer getLedSetting() {
        return this.ledSetting;
    }

    @Generated
    public IpSettingVO getIpSetting() {
        return this.ipSetting;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setStatus(Integer status) {
        this.status = status;
    }

    @Generated
    public void setModel(String model) {
        this.model = model;
    }

    @Generated
    public void setUptime(String uptime) {
        this.uptime = uptime;
    }

    @Generated
    public void setLedSetting(Integer ledSetting) {
        this.ledSetting = ledSetting;
    }

    @Generated
    public void setIpSetting(IpSettingVO ipSetting) {
        this.ipSetting = ipSetting;
    }

    @Generated
    public String toString() {
        return "OswStackConfigAppVO(id=" + this.getId() + ", name=" + this.getName() + ", status=" + this.getStatus() + ", model=" + this.getModel() + ", uptime=" + this.getUptime() + ", ledSetting=" + this.getLedSetting() + ", ipSetting=" + this.getIpSetting() + ")";
    }

    @Generated
    public OswStackConfigAppVO() {
    }

    @Generated
    public OswStackConfigAppVO(String id, String name, Integer status, String model, String uptime, Integer ledSetting, IpSettingVO ipSetting) {
        this.id = id;
        this.name = name;
        this.status = status;
        this.model = model;
        this.uptime = uptime;
        this.ledSetting = ledSetting;
        this.ipSetting = ipSetting;
    }
}

