/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.stack.api.web.dto;

import com.tplink.smb.omada.a.a;
import com.tplink.smb.omada.common.cache.a.a.c;
import com.tplink.smb.omada.manager.device.api.web.osw.dto.OswQosConfigVO;
import com.tplink.smb.omada.manager.stack.api.web.dto.MacDelayVO;
import com.tplink.smb.omada.manager.stack.api.web.dto.MadSettingVO;
import com.tplink.smb.omada.manager.stack.api.web.dto.OswStackMemberVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nonnull;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import java.util.Optional;
import lombok.Generated;

public class OswStackVO
extends com.tplink.smb.omada.common.cache.a.a {
    @Schema(name="id", description="Stack ID")
    private String id;
    @Schema(name="siteId", description="Site ID")
    private String siteId;
    @Schema(name="siteName", description="Site Name")
    private String siteName;
    @NotNull
    @com.tplink.smb.omada.common.cache.a.a.a(a="name", d=true)
    @c(b="name")
    @Schema(name="name", description="Stack Name")
    private String name;
    @com.tplink.smb.omada.common.cache.a.a.a(a="status", b=true)
    @Schema(name="status", description="Stack Status should be a value as follows: 0: normal; 1: abnormal; 2: stack not ready")
    private Integer status;
    @Schema(name="abnormalReason", description="Abnormal Reason")
    private Integer abnormalReason;
    @Schema(name="ip", description="IP")
    private String ip;
    @Schema(name="devicesNum", description="Number of devices")
    private Integer devicesNum;
    @com.tplink.smb.omada.common.cache.a.a.a(a="licenseStatus", b=true)
    @Schema(name="licenseStatus", description="License Status should be a value as follows: 0: Activated; 1: Unactivated; 2: Not All Activated, 3: Expired")
    private Integer licenseStatus;
    @Schema(name="dueTime", description="Expiration time")
    private Long dueTime;
    @Schema(name="dueTimeLeft", description="The number of milliseconds from the current time to the expiration time")
    private Long dueTimeLeft;
    @Schema(name="trafficDown", description="Traffic Down")
    private Long trafficDown;
    @Schema(name="trafficUp", description="Traffic Up")
    private Long trafficUp;
    @Schema(name="clients", description="Clients")
    private Integer clients;
    @Schema(name="masterMac", description="Master device mac")
    @a
    private String masterMac;
    @Schema(name="masterDeviceActive", description="Marks whether the master device of the stack system is activated")
    private Boolean masterDeviceActive;
    @Schema(name="loopbackNum", description="Loopback Num")
    private Integer loopbackNum;
    @Schema(name="loop", description="Loopback port")
    private String loop;
    @com.tplink.smb.omada.common.cache.a.a.a(a="tag", b=true)
    @c(b="tag")
    @Schema(name="tag", description="Tag")
    private String tag;
    @Valid
    @Schema(name="member", description="Stack member list")
    private List<OswStackMemberVO> member;
    @Schema(name="detectedMember", description="List of members that have been detected by the stack")
    private List<OswStackMemberVO> detectedMember;
    @Schema(name="locateEnable", description="Indicates whether the locate function is enabled")
    private Boolean locateEnable;
    @Schema(name="version", description="Version")
    private String version;
    @Schema(name="latestVersion", description="Latest Version")
    private String latestVersion;
    @Schema(name="needUpgrade", description="Indicates whether an upgrade is required")
    private Boolean needUpgrade;
    @Schema(name="fwDownload", description="Indicates whether the upgrade status is downloading")
    private Boolean fwDownload;
    private String description;
    @Schema(name="qosConfig", description="Switch qos config")
    private OswQosConfigVO qosConfig;
    @Schema(name="macDelay", description="Mac Delay")
    private MacDelayVO macDelay;
    @Schema(name="virtualMac", description="Virtual Mac")
    @a
    private String virtualMac;
    @Schema(name="madSetting", description="Mad Setting")
    private MadSettingVO madSetting;
    private Boolean supportMacDelay;

    @Nonnull
    public String acquireMasterMac() {
        return Optional.ofNullable(this.member).map(stackmembers -> stackmembers.stream().filter(stackMember -> com.tplink.smb.omada.manager.stack.api.internal.dto.a.a.a(stackMember.getMemberStatus())).map(OswStackMemberVO::getMac).findFirst().orElse("")).orElse("");
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getSiteId() {
        return this.siteId;
    }

    @Generated
    public String getSiteName() {
        return this.siteName;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Integer getStatus() {
        return this.status;
    }

    @Generated
    public Integer getAbnormalReason() {
        return this.abnormalReason;
    }

    @Generated
    public String getIp() {
        return this.ip;
    }

    @Generated
    public Integer getDevicesNum() {
        return this.devicesNum;
    }

    @Generated
    public Integer getLicenseStatus() {
        return this.licenseStatus;
    }

    @Generated
    public Long getDueTime() {
        return this.dueTime;
    }

    @Generated
    public Long getDueTimeLeft() {
        return this.dueTimeLeft;
    }

    @Generated
    public Long getTrafficDown() {
        return this.trafficDown;
    }

    @Generated
    public Long getTrafficUp() {
        return this.trafficUp;
    }

    @Generated
    public Integer getClients() {
        return this.clients;
    }

    @Generated
    public String getMasterMac() {
        return this.masterMac;
    }

    @Generated
    public Boolean getMasterDeviceActive() {
        return this.masterDeviceActive;
    }

    @Generated
    public Integer getLoopbackNum() {
        return this.loopbackNum;
    }

    @Generated
    public String getLoop() {
        return this.loop;
    }

    @Generated
    public String getTag() {
        return this.tag;
    }

    @Generated
    public List<OswStackMemberVO> getMember() {
        return this.member;
    }

    @Generated
    public List<OswStackMemberVO> getDetectedMember() {
        return this.detectedMember;
    }

    @Generated
    public Boolean getLocateEnable() {
        return this.locateEnable;
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    @Generated
    public String getLatestVersion() {
        return this.latestVersion;
    }

    @Generated
    public Boolean getNeedUpgrade() {
        return this.needUpgrade;
    }

    @Generated
    public Boolean getFwDownload() {
        return this.fwDownload;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public OswQosConfigVO getQosConfig() {
        return this.qosConfig;
    }

    @Generated
    public MacDelayVO getMacDelay() {
        return this.macDelay;
    }

    @Generated
    public String getVirtualMac() {
        return this.virtualMac;
    }

    @Generated
    public MadSettingVO getMadSetting() {
        return this.madSetting;
    }

    @Generated
    public Boolean getSupportMacDelay() {
        return this.supportMacDelay;
    }

    @Generated
    public OswStackVO setId(String id) {
        this.id = id;
        return this;
    }

    @Generated
    public OswStackVO setSiteId(String siteId) {
        this.siteId = siteId;
        return this;
    }

    @Generated
    public OswStackVO setSiteName(String siteName) {
        this.siteName = siteName;
        return this;
    }

    @Generated
    public OswStackVO setName(String name) {
        this.name = name;
        return this;
    }

    @Generated
    public OswStackVO setStatus(Integer status) {
        this.status = status;
        return this;
    }

    @Generated
    public OswStackVO setAbnormalReason(Integer abnormalReason) {
        this.abnormalReason = abnormalReason;
        return this;
    }

    @Generated
    public OswStackVO setIp(String ip) {
        this.ip = ip;
        return this;
    }

    @Generated
    public OswStackVO setDevicesNum(Integer devicesNum) {
        this.devicesNum = devicesNum;
        return this;
    }

    @Generated
    public OswStackVO setLicenseStatus(Integer licenseStatus) {
        this.licenseStatus = licenseStatus;
        return this;
    }

    @Generated
    public OswStackVO setDueTime(Long dueTime) {
        this.dueTime = dueTime;
        return this;
    }

    @Generated
    public OswStackVO setDueTimeLeft(Long dueTimeLeft) {
        this.dueTimeLeft = dueTimeLeft;
        return this;
    }

    @Generated
    public OswStackVO setTrafficDown(Long trafficDown) {
        this.trafficDown = trafficDown;
        return this;
    }

    @Generated
    public OswStackVO setTrafficUp(Long trafficUp) {
        this.trafficUp = trafficUp;
        return this;
    }

    @Generated
    public OswStackVO setClients(Integer clients) {
        this.clients = clients;
        return this;
    }

    @Generated
    public OswStackVO setMasterMac(String masterMac) {
        this.masterMac = masterMac;
        return this;
    }

    @Generated
    public OswStackVO setMasterDeviceActive(Boolean masterDeviceActive) {
        this.masterDeviceActive = masterDeviceActive;
        return this;
    }

    @Generated
    public OswStackVO setLoopbackNum(Integer loopbackNum) {
        this.loopbackNum = loopbackNum;
        return this;
    }

    @Generated
    public OswStackVO setLoop(String loop) {
        this.loop = loop;
        return this;
    }

    @Generated
    public OswStackVO setTag(String tag) {
        this.tag = tag;
        return this;
    }

    @Generated
    public OswStackVO setMember(List<OswStackMemberVO> member) {
        this.member = member;
        return this;
    }

    @Generated
    public OswStackVO setDetectedMember(List<OswStackMemberVO> detectedMember) {
        this.detectedMember = detectedMember;
        return this;
    }

    @Generated
    public OswStackVO setLocateEnable(Boolean locateEnable) {
        this.locateEnable = locateEnable;
        return this;
    }

    @Generated
    public OswStackVO setVersion(String version) {
        this.version = version;
        return this;
    }

    @Generated
    public OswStackVO setLatestVersion(String latestVersion) {
        this.latestVersion = latestVersion;
        return this;
    }

    @Generated
    public OswStackVO setNeedUpgrade(Boolean needUpgrade) {
        this.needUpgrade = needUpgrade;
        return this;
    }

    @Generated
    public OswStackVO setFwDownload(Boolean fwDownload) {
        this.fwDownload = fwDownload;
        return this;
    }

    @Generated
    public OswStackVO setDescription(String description) {
        this.description = description;
        return this;
    }

    @Generated
    public OswStackVO setQosConfig(OswQosConfigVO qosConfig) {
        this.qosConfig = qosConfig;
        return this;
    }

    @Generated
    public OswStackVO setMacDelay(MacDelayVO macDelay) {
        this.macDelay = macDelay;
        return this;
    }

    @Generated
    public OswStackVO setVirtualMac(String virtualMac) {
        this.virtualMac = virtualMac;
        return this;
    }

    @Generated
    public OswStackVO setMadSetting(MadSettingVO madSetting) {
        this.madSetting = madSetting;
        return this;
    }

    @Generated
    public OswStackVO setSupportMacDelay(Boolean supportMacDelay) {
        this.supportMacDelay = supportMacDelay;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OswStackVO)) {
            return false;
        }
        OswStackVO other = (OswStackVO)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Integer this$status = this.getStatus();
        Integer other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)this$status).equals(other$status)) {
            return false;
        }
        Integer this$abnormalReason = this.getAbnormalReason();
        Integer other$abnormalReason = other.getAbnormalReason();
        if (this$abnormalReason == null ? other$abnormalReason != null : !((Object)this$abnormalReason).equals(other$abnormalReason)) {
            return false;
        }
        Integer this$devicesNum = this.getDevicesNum();
        Integer other$devicesNum = other.getDevicesNum();
        if (this$devicesNum == null ? other$devicesNum != null : !((Object)this$devicesNum).equals(other$devicesNum)) {
            return false;
        }
        Integer this$licenseStatus = this.getLicenseStatus();
        Integer other$licenseStatus = other.getLicenseStatus();
        if (this$licenseStatus == null ? other$licenseStatus != null : !((Object)this$licenseStatus).equals(other$licenseStatus)) {
            return false;
        }
        Long this$dueTime = this.getDueTime();
        Long other$dueTime = other.getDueTime();
        if (this$dueTime == null ? other$dueTime != null : !((Object)this$dueTime).equals(other$dueTime)) {
            return false;
        }
        Long this$dueTimeLeft = this.getDueTimeLeft();
        Long other$dueTimeLeft = other.getDueTimeLeft();
        if (this$dueTimeLeft == null ? other$dueTimeLeft != null : !((Object)this$dueTimeLeft).equals(other$dueTimeLeft)) {
            return false;
        }
        Long this$trafficDown = this.getTrafficDown();
        Long other$trafficDown = other.getTrafficDown();
        if (this$trafficDown == null ? other$trafficDown != null : !((Object)this$trafficDown).equals(other$trafficDown)) {
            return false;
        }
        Long this$trafficUp = this.getTrafficUp();
        Long other$trafficUp = other.getTrafficUp();
        if (this$trafficUp == null ? other$trafficUp != null : !((Object)this$trafficUp).equals(other$trafficUp)) {
            return false;
        }
        Integer this$clients = this.getClients();
        Integer other$clients = other.getClients();
        if (this$clients == null ? other$clients != null : !((Object)this$clients).equals(other$clients)) {
            return false;
        }
        Boolean this$masterDeviceActive = this.getMasterDeviceActive();
        Boolean other$masterDeviceActive = other.getMasterDeviceActive();
        if (this$masterDeviceActive == null ? other$masterDeviceActive != null : !((Object)this$masterDeviceActive).equals(other$masterDeviceActive)) {
            return false;
        }
        Integer this$loopbackNum = this.getLoopbackNum();
        Integer other$loopbackNum = other.getLoopbackNum();
        if (this$loopbackNum == null ? other$loopbackNum != null : !((Object)this$loopbackNum).equals(other$loopbackNum)) {
            return false;
        }
        Boolean this$locateEnable = this.getLocateEnable();
        Boolean other$locateEnable = other.getLocateEnable();
        if (this$locateEnable == null ? other$locateEnable != null : !((Object)this$locateEnable).equals(other$locateEnable)) {
            return false;
        }
        Boolean this$needUpgrade = this.getNeedUpgrade();
        Boolean other$needUpgrade = other.getNeedUpgrade();
        if (this$needUpgrade == null ? other$needUpgrade != null : !((Object)this$needUpgrade).equals(other$needUpgrade)) {
            return false;
        }
        Boolean this$fwDownload = this.getFwDownload();
        Boolean other$fwDownload = other.getFwDownload();
        if (this$fwDownload == null ? other$fwDownload != null : !((Object)this$fwDownload).equals(other$fwDownload)) {
            return false;
        }
        Boolean this$supportMacDelay = this.getSupportMacDelay();
        Boolean other$supportMacDelay = other.getSupportMacDelay();
        if (this$supportMacDelay == null ? other$supportMacDelay != null : !((Object)this$supportMacDelay).equals(other$supportMacDelay)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$siteId = this.getSiteId();
        String other$siteId = other.getSiteId();
        if (this$siteId == null ? other$siteId != null : !this$siteId.equals(other$siteId)) {
            return false;
        }
        String this$siteName = this.getSiteName();
        String other$siteName = other.getSiteName();
        if (this$siteName == null ? other$siteName != null : !this$siteName.equals(other$siteName)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$ip = this.getIp();
        String other$ip = other.getIp();
        if (this$ip == null ? other$ip != null : !this$ip.equals(other$ip)) {
            return false;
        }
        String this$masterMac = this.getMasterMac();
        String other$masterMac = other.getMasterMac();
        if (this$masterMac == null ? other$masterMac != null : !this$masterMac.equals(other$masterMac)) {
            return false;
        }
        String this$loop = this.getLoop();
        String other$loop = other.getLoop();
        if (this$loop == null ? other$loop != null : !this$loop.equals(other$loop)) {
            return false;
        }
        String this$tag = this.getTag();
        String other$tag = other.getTag();
        if (this$tag == null ? other$tag != null : !this$tag.equals(other$tag)) {
            return false;
        }
        List<OswStackMemberVO> this$member = this.getMember();
        List<OswStackMemberVO> other$member = other.getMember();
        if (this$member == null ? other$member != null : !((Object)this$member).equals(other$member)) {
            return false;
        }
        List<OswStackMemberVO> this$detectedMember = this.getDetectedMember();
        List<OswStackMemberVO> other$detectedMember = other.getDetectedMember();
        if (this$detectedMember == null ? other$detectedMember != null : !((Object)this$detectedMember).equals(other$detectedMember)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$latestVersion = this.getLatestVersion();
        String other$latestVersion = other.getLatestVersion();
        if (this$latestVersion == null ? other$latestVersion != null : !this$latestVersion.equals(other$latestVersion)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        OswQosConfigVO this$qosConfig = this.getQosConfig();
        OswQosConfigVO other$qosConfig = other.getQosConfig();
        if (this$qosConfig == null ? other$qosConfig != null : !this$qosConfig.equals(other$qosConfig)) {
            return false;
        }
        MacDelayVO this$macDelay = this.getMacDelay();
        MacDelayVO other$macDelay = other.getMacDelay();
        if (this$macDelay == null ? other$macDelay != null : !this$macDelay.equals(other$macDelay)) {
            return false;
        }
        String this$virtualMac = this.getVirtualMac();
        String other$virtualMac = other.getVirtualMac();
        if (this$virtualMac == null ? other$virtualMac != null : !this$virtualMac.equals(other$virtualMac)) {
            return false;
        }
        MadSettingVO this$madSetting = this.getMadSetting();
        MadSettingVO other$madSetting = other.getMadSetting();
        return !(this$madSetting == null ? other$madSetting != null : !this$madSetting.equals(other$madSetting));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof OswStackVO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)$status).hashCode());
        Integer $abnormalReason = this.getAbnormalReason();
        result = result * 59 + ($abnormalReason == null ? 43 : ((Object)$abnormalReason).hashCode());
        Integer $devicesNum = this.getDevicesNum();
        result = result * 59 + ($devicesNum == null ? 43 : ((Object)$devicesNum).hashCode());
        Integer $licenseStatus = this.getLicenseStatus();
        result = result * 59 + ($licenseStatus == null ? 43 : ((Object)$licenseStatus).hashCode());
        Long $dueTime = this.getDueTime();
        result = result * 59 + ($dueTime == null ? 43 : ((Object)$dueTime).hashCode());
        Long $dueTimeLeft = this.getDueTimeLeft();
        result = result * 59 + ($dueTimeLeft == null ? 43 : ((Object)$dueTimeLeft).hashCode());
        Long $trafficDown = this.getTrafficDown();
        result = result * 59 + ($trafficDown == null ? 43 : ((Object)$trafficDown).hashCode());
        Long $trafficUp = this.getTrafficUp();
        result = result * 59 + ($trafficUp == null ? 43 : ((Object)$trafficUp).hashCode());
        Integer $clients = this.getClients();
        result = result * 59 + ($clients == null ? 43 : ((Object)$clients).hashCode());
        Boolean $masterDeviceActive = this.getMasterDeviceActive();
        result = result * 59 + ($masterDeviceActive == null ? 43 : ((Object)$masterDeviceActive).hashCode());
        Integer $loopbackNum = this.getLoopbackNum();
        result = result * 59 + ($loopbackNum == null ? 43 : ((Object)$loopbackNum).hashCode());
        Boolean $locateEnable = this.getLocateEnable();
        result = result * 59 + ($locateEnable == null ? 43 : ((Object)$locateEnable).hashCode());
        Boolean $needUpgrade = this.getNeedUpgrade();
        result = result * 59 + ($needUpgrade == null ? 43 : ((Object)$needUpgrade).hashCode());
        Boolean $fwDownload = this.getFwDownload();
        result = result * 59 + ($fwDownload == null ? 43 : ((Object)$fwDownload).hashCode());
        Boolean $supportMacDelay = this.getSupportMacDelay();
        result = result * 59 + ($supportMacDelay == null ? 43 : ((Object)$supportMacDelay).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $siteId = this.getSiteId();
        result = result * 59 + ($siteId == null ? 43 : $siteId.hashCode());
        String $siteName = this.getSiteName();
        result = result * 59 + ($siteName == null ? 43 : $siteName.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $ip = this.getIp();
        result = result * 59 + ($ip == null ? 43 : $ip.hashCode());
        String $masterMac = this.getMasterMac();
        result = result * 59 + ($masterMac == null ? 43 : $masterMac.hashCode());
        String $loop = this.getLoop();
        result = result * 59 + ($loop == null ? 43 : $loop.hashCode());
        String $tag = this.getTag();
        result = result * 59 + ($tag == null ? 43 : $tag.hashCode());
        List<OswStackMemberVO> $member = this.getMember();
        result = result * 59 + ($member == null ? 43 : ((Object)$member).hashCode());
        List<OswStackMemberVO> $detectedMember = this.getDetectedMember();
        result = result * 59 + ($detectedMember == null ? 43 : ((Object)$detectedMember).hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $latestVersion = this.getLatestVersion();
        result = result * 59 + ($latestVersion == null ? 43 : $latestVersion.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        OswQosConfigVO $qosConfig = this.getQosConfig();
        result = result * 59 + ($qosConfig == null ? 43 : $qosConfig.hashCode());
        MacDelayVO $macDelay = this.getMacDelay();
        result = result * 59 + ($macDelay == null ? 43 : $macDelay.hashCode());
        String $virtualMac = this.getVirtualMac();
        result = result * 59 + ($virtualMac == null ? 43 : $virtualMac.hashCode());
        MadSettingVO $madSetting = this.getMadSetting();
        result = result * 59 + ($madSetting == null ? 43 : $madSetting.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "OswStackVO(id=" + this.getId() + ", siteId=" + this.getSiteId() + ", siteName=" + this.getSiteName() + ", name=" + this.getName() + ", status=" + this.getStatus() + ", abnormalReason=" + this.getAbnormalReason() + ", ip=" + this.getIp() + ", devicesNum=" + this.getDevicesNum() + ", licenseStatus=" + this.getLicenseStatus() + ", dueTime=" + this.getDueTime() + ", dueTimeLeft=" + this.getDueTimeLeft() + ", trafficDown=" + this.getTrafficDown() + ", trafficUp=" + this.getTrafficUp() + ", clients=" + this.getClients() + ", masterMac=" + this.getMasterMac() + ", masterDeviceActive=" + this.getMasterDeviceActive() + ", loopbackNum=" + this.getLoopbackNum() + ", loop=" + this.getLoop() + ", tag=" + this.getTag() + ", member=" + this.getMember() + ", detectedMember=" + this.getDetectedMember() + ", locateEnable=" + this.getLocateEnable() + ", version=" + this.getVersion() + ", latestVersion=" + this.getLatestVersion() + ", needUpgrade=" + this.getNeedUpgrade() + ", fwDownload=" + this.getFwDownload() + ", description=" + this.getDescription() + ", qosConfig=" + this.getQosConfig() + ", macDelay=" + this.getMacDelay() + ", virtualMac=" + this.getVirtualMac() + ", madSetting=" + this.getMadSetting() + ", supportMacDelay=" + this.getSupportMacDelay() + ")";
    }

    @Generated
    public OswStackVO() {
    }
}

