/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.stack.api.web.dto;

import com.tplink.nbu.common.pii.annotation.PII;
import com.tplink.nbu.common.pii.constant.PIIMaskStrategy;
import com.tplink.smb.omada.a.a;
import com.tplink.smb.omada.manager.device.api.web.osw.dto.OswDownlinkVO;
import com.tplink.smb.omada.manager.device.api.web.osw.dto.OswLagVO;
import com.tplink.smb.omada.manager.device.api.web.osw.dto.OswStackMemberPortVO;
import com.tplink.smb.omada.manager.device.api.web.osw.dto.OswStackPortGroupVO;
import com.tplink.smb.omada.manager.device.api.web.osw.dto.OswUplinkVO;
import com.tplink.smb.omada.manager.stack.api.web.dto.OswStackMemberPortCapAndStatusVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

public class OswStackMemberVO {
    @Schema(name="omadacId", description="OmadacId")
    private String omadacId;
    @NotNull(message="Mac should not be null")
    @PII(strategy=PIIMaskStrategy.ENCRYPT)
    @Schema(name="mac", description="Device Mac")
    @a
    private @NotNull(message="Mac should not be null") String mac;
    @PII(strategy=PIIMaskStrategy.HASH)
    @Schema(name="name", description="Device Name")
    private String name;
    @PII(strategy=PIIMaskStrategy.HASH)
    @Schema(name="ip", description="IP")
    private String ip;
    @NotNull(message="Unit should not be null")
    @Schema(name="unit", description="Unit number of the local stacking system of the device")
    private @NotNull(message="Unit should not be null") Integer unit;
    @NotNull(message="Priority should not be null")
    @Range(min=1L, max=255L, message="Value of priority limit is from 1 to 255")
    @Schema(name="priority", description="Priority of the device in the local stacking system")
    private @NotNull(message="Priority should not be null") @Range(min=1L, max=255L, message="Value of priority limit is from 1 to 255") Integer priority;
    @Schema(name="status", description="Device Status")
    private Integer status;
    @Schema(name="memberStatus", description="Stack Member Status should be a value as follows: 0: master; 1: slaver; 2: notInitial; 3: licenseOverdue; 4: licenseUnactive")
    private Integer memberStatus;
    @Schema(name="compatible", description="Compatible Type")
    private Integer compatible;
    @Schema(name="model", description="Member Model")
    private String model;
    @Schema(name="modelVersion", description="Member Model Version")
    private String modelVersion;
    @Schema(name="showModel", description="ShowModel")
    private String showModel;
    private String compoundModel;
    @Schema(name="version", description="Software Version")
    private String version;
    @Schema(name="active", description="Indicates whether the device is activated")
    private Boolean active;
    @Schema(name="licenseStatus", description="License Status should be a value as follows: 0: UnActive; 1: Unbind; 2: Expired; 3: Active; 4: NotMatch; 5: NearExpired")
    private Integer licenseStatus;
    @Schema(name="dueTime", description="Expiration time")
    private Long dueTime;
    @Schema(name="dueTimeLeft", description="The number of milliseconds from the current time to the expiration time")
    private Long dueTimeLeft;
    @Schema(name="category", description="Category")
    private String category;
    @Schema(name="licenseId", description="License Id")
    private String licenseId;
    @Schema(name="licenseUnbindingLimit", description="The remaining number of times to unbind the license")
    private Integer licenseUnbindingLimit;
    @Schema(name="initialUnbindingLimit", description="The initial number of times to unbind the license")
    private Integer initialUnbindingLimit;
    @Schema(name="uptime", description="Uptime")
    private String uptime;
    @Schema(name="cpuUtil", description="Real-time CPU usage")
    private Integer cpuUtil;
    @Schema(name="memUitl", description="Real-time memory usage")
    private Integer memUtil;
    @Schema(name="poeTotalPower", description="PoE Total Power (W)")
    private Double poeTotalPower;
    @Schema(name="poeRemain", description="PoE Residual Power (W)")
    private Double poeRemain;
    @Schema(name="poeRemainPercent", description="PoE Residual Power Percentage")
    private Double poeRemainPercent;
    @Schema(name="loopbackNum", description="Number of loops")
    private Integer loopbackNum;
    @Schema(name="loop", description="Loopback port")
    private String loop;
    @Schema(name="portCaps", description="Port Information")
    private List<OswStackMemberPortCapAndStatusVO> portCaps;
    @Schema(name="ports", description="Including some port configuration information and port real-time status")
    private List<OswStackMemberPortVO> ports;
    @Valid
    @NotEmpty(message="StackPorts should not be null or empty")
    @Schema(name="stackPorts", description="Stack port list")
    private @Valid @NotEmpty(message="StackPorts should not be null or empty") List<OswStackPortGroupVO> stackPorts;
    @Schema(name="oswStackPortGroupStatus", description="Including some port configuration information and port real-time status")
    private List<OswLagVO> oswStackPortGroupStatus;
    @Schema(name="maxStackGroups", description="Maximum number of stacking port aggregation groups supported")
    private Integer maxStackGroups;
    @Schema(name="maxStackUnitNumber", description="The maximum unit number supported by the device, starting from 1")
    private Integer maxStackUnitNumber;
    private Map<String, List<String>> stackPortCap;
    @Schema(name="locateEnable", description="Indicates whether the locate function is enabled")
    private Boolean locateEnable;
    @Schema(name="inWhitelist", description="Indicates whether it is in the whitelist")
    private Boolean inWhitelist;
    @Schema(name="deviceSeriesType", description="DeviceSeriesType should be a value as follows: 0: advanced; 1: pro")
    private Integer deviceSeriesType;
    @Schema(name="type", description="Type")
    private String type;
    private Integer statusCategory;
    @Schema(name="uplink", description="Uplink Omada device")
    private OswUplinkVO uplink;
    @Schema(name="downlinkList", description="Downlink Omada device list")
    private List<OswDownlinkVO> downlinkList;

    @Generated
    public String getOmadacId() {
        return this.omadacId;
    }

    @Generated
    public String getMac() {
        return this.mac;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getIp() {
        return this.ip;
    }

    @Generated
    public Integer getUnit() {
        return this.unit;
    }

    @Generated
    public Integer getPriority() {
        return this.priority;
    }

    @Generated
    public Integer getStatus() {
        return this.status;
    }

    @Generated
    public Integer getMemberStatus() {
        return this.memberStatus;
    }

    @Generated
    public Integer getCompatible() {
        return this.compatible;
    }

    @Generated
    public String getModel() {
        return this.model;
    }

    @Generated
    public String getModelVersion() {
        return this.modelVersion;
    }

    @Generated
    public String getShowModel() {
        return this.showModel;
    }

    @Generated
    public String getCompoundModel() {
        return this.compoundModel;
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    @Generated
    public Boolean getActive() {
        return this.active;
    }

    @Generated
    public Integer getLicenseStatus() {
        return this.licenseStatus;
    }

    @Generated
    public Long getDueTime() {
        return this.dueTime;
    }

    @Generated
    public Long getDueTimeLeft() {
        return this.dueTimeLeft;
    }

    @Generated
    public String getCategory() {
        return this.category;
    }

    @Generated
    public String getLicenseId() {
        return this.licenseId;
    }

    @Generated
    public Integer getLicenseUnbindingLimit() {
        return this.licenseUnbindingLimit;
    }

    @Generated
    public Integer getInitialUnbindingLimit() {
        return this.initialUnbindingLimit;
    }

    @Generated
    public String getUptime() {
        return this.uptime;
    }

    @Generated
    public Integer getCpuUtil() {
        return this.cpuUtil;
    }

    @Generated
    public Integer getMemUtil() {
        return this.memUtil;
    }

    @Generated
    public Double getPoeTotalPower() {
        return this.poeTotalPower;
    }

    @Generated
    public Double getPoeRemain() {
        return this.poeRemain;
    }

    @Generated
    public Double getPoeRemainPercent() {
        return this.poeRemainPercent;
    }

    @Generated
    public Integer getLoopbackNum() {
        return this.loopbackNum;
    }

    @Generated
    public String getLoop() {
        return this.loop;
    }

    @Generated
    public List<OswStackMemberPortCapAndStatusVO> getPortCaps() {
        return this.portCaps;
    }

    @Generated
    public List<OswStackMemberPortVO> getPorts() {
        return this.ports;
    }

    @Generated
    public List<OswStackPortGroupVO> getStackPorts() {
        return this.stackPorts;
    }

    @Generated
    public List<OswLagVO> getOswStackPortGroupStatus() {
        return this.oswStackPortGroupStatus;
    }

    @Generated
    public Integer getMaxStackGroups() {
        return this.maxStackGroups;
    }

    @Generated
    public Integer getMaxStackUnitNumber() {
        return this.maxStackUnitNumber;
    }

    @Generated
    public Map<String, List<String>> getStackPortCap() {
        return this.stackPortCap;
    }

    @Generated
    public Boolean getLocateEnable() {
        return this.locateEnable;
    }

    @Generated
    public Boolean getInWhitelist() {
        return this.inWhitelist;
    }

    @Generated
    public Integer getDeviceSeriesType() {
        return this.deviceSeriesType;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public Integer getStatusCategory() {
        return this.statusCategory;
    }

    @Generated
    public OswUplinkVO getUplink() {
        return this.uplink;
    }

    @Generated
    public List<OswDownlinkVO> getDownlinkList() {
        return this.downlinkList;
    }

    @Generated
    public OswStackMemberVO setOmadacId(String omadacId) {
        this.omadacId = omadacId;
        return this;
    }

    @Generated
    public OswStackMemberVO setMac(String mac) {
        this.mac = mac;
        return this;
    }

    @Generated
    public OswStackMemberVO setName(String name) {
        this.name = name;
        return this;
    }

    @Generated
    public OswStackMemberVO setIp(String ip) {
        this.ip = ip;
        return this;
    }

    @Generated
    public OswStackMemberVO setUnit(Integer unit) {
        this.unit = unit;
        return this;
    }

    @Generated
    public OswStackMemberVO setPriority(Integer priority) {
        this.priority = priority;
        return this;
    }

    @Generated
    public OswStackMemberVO setStatus(Integer status) {
        this.status = status;
        return this;
    }

    @Generated
    public OswStackMemberVO setMemberStatus(Integer memberStatus) {
        this.memberStatus = memberStatus;
        return this;
    }

    @Generated
    public OswStackMemberVO setCompatible(Integer compatible) {
        this.compatible = compatible;
        return this;
    }

    @Generated
    public OswStackMemberVO setModel(String model) {
        this.model = model;
        return this;
    }

    @Generated
    public OswStackMemberVO setModelVersion(String modelVersion) {
        this.modelVersion = modelVersion;
        return this;
    }

    @Generated
    public OswStackMemberVO setShowModel(String showModel) {
        this.showModel = showModel;
        return this;
    }

    @Generated
    public OswStackMemberVO setCompoundModel(String compoundModel) {
        this.compoundModel = compoundModel;
        return this;
    }

    @Generated
    public OswStackMemberVO setVersion(String version) {
        this.version = version;
        return this;
    }

    @Generated
    public OswStackMemberVO setActive(Boolean active) {
        this.active = active;
        return this;
    }

    @Generated
    public OswStackMemberVO setLicenseStatus(Integer licenseStatus) {
        this.licenseStatus = licenseStatus;
        return this;
    }

    @Generated
    public OswStackMemberVO setDueTime(Long dueTime) {
        this.dueTime = dueTime;
        return this;
    }

    @Generated
    public OswStackMemberVO setDueTimeLeft(Long dueTimeLeft) {
        this.dueTimeLeft = dueTimeLeft;
        return this;
    }

    @Generated
    public OswStackMemberVO setCategory(String category) {
        this.category = category;
        return this;
    }

    @Generated
    public OswStackMemberVO setLicenseId(String licenseId) {
        this.licenseId = licenseId;
        return this;
    }

    @Generated
    public OswStackMemberVO setLicenseUnbindingLimit(Integer licenseUnbindingLimit) {
        this.licenseUnbindingLimit = licenseUnbindingLimit;
        return this;
    }

    @Generated
    public OswStackMemberVO setInitialUnbindingLimit(Integer initialUnbindingLimit) {
        this.initialUnbindingLimit = initialUnbindingLimit;
        return this;
    }

    @Generated
    public OswStackMemberVO setUptime(String uptime) {
        this.uptime = uptime;
        return this;
    }

    @Generated
    public OswStackMemberVO setCpuUtil(Integer cpuUtil) {
        this.cpuUtil = cpuUtil;
        return this;
    }

    @Generated
    public OswStackMemberVO setMemUtil(Integer memUtil) {
        this.memUtil = memUtil;
        return this;
    }

    @Generated
    public OswStackMemberVO setPoeTotalPower(Double poeTotalPower) {
        this.poeTotalPower = poeTotalPower;
        return this;
    }

    @Generated
    public OswStackMemberVO setPoeRemain(Double poeRemain) {
        this.poeRemain = poeRemain;
        return this;
    }

    @Generated
    public OswStackMemberVO setPoeRemainPercent(Double poeRemainPercent) {
        this.poeRemainPercent = poeRemainPercent;
        return this;
    }

    @Generated
    public OswStackMemberVO setLoopbackNum(Integer loopbackNum) {
        this.loopbackNum = loopbackNum;
        return this;
    }

    @Generated
    public OswStackMemberVO setLoop(String loop) {
        this.loop = loop;
        return this;
    }

    @Generated
    public OswStackMemberVO setPortCaps(List<OswStackMemberPortCapAndStatusVO> portCaps) {
        this.portCaps = portCaps;
        return this;
    }

    @Generated
    public OswStackMemberVO setPorts(List<OswStackMemberPortVO> ports) {
        this.ports = ports;
        return this;
    }

    @Generated
    public OswStackMemberVO setStackPorts(List<OswStackPortGroupVO> stackPorts) {
        this.stackPorts = stackPorts;
        return this;
    }

    @Generated
    public OswStackMemberVO setOswStackPortGroupStatus(List<OswLagVO> oswStackPortGroupStatus) {
        this.oswStackPortGroupStatus = oswStackPortGroupStatus;
        return this;
    }

    @Generated
    public OswStackMemberVO setMaxStackGroups(Integer maxStackGroups) {
        this.maxStackGroups = maxStackGroups;
        return this;
    }

    @Generated
    public OswStackMemberVO setMaxStackUnitNumber(Integer maxStackUnitNumber) {
        this.maxStackUnitNumber = maxStackUnitNumber;
        return this;
    }

    @Generated
    public OswStackMemberVO setStackPortCap(Map<String, List<String>> stackPortCap) {
        this.stackPortCap = stackPortCap;
        return this;
    }

    @Generated
    public OswStackMemberVO setLocateEnable(Boolean locateEnable) {
        this.locateEnable = locateEnable;
        return this;
    }

    @Generated
    public OswStackMemberVO setInWhitelist(Boolean inWhitelist) {
        this.inWhitelist = inWhitelist;
        return this;
    }

    @Generated
    public OswStackMemberVO setDeviceSeriesType(Integer deviceSeriesType) {
        this.deviceSeriesType = deviceSeriesType;
        return this;
    }

    @Generated
    public OswStackMemberVO setType(String type) {
        this.type = type;
        return this;
    }

    @Generated
    public OswStackMemberVO setStatusCategory(Integer statusCategory) {
        this.statusCategory = statusCategory;
        return this;
    }

    @Generated
    public OswStackMemberVO setUplink(OswUplinkVO uplink) {
        this.uplink = uplink;
        return this;
    }

    @Generated
    public OswStackMemberVO setDownlinkList(List<OswDownlinkVO> downlinkList) {
        this.downlinkList = downlinkList;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OswStackMemberVO)) {
            return false;
        }
        OswStackMemberVO other = (OswStackMemberVO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$unit = this.getUnit();
        Integer other$unit = other.getUnit();
        if (this$unit == null ? other$unit != null : !((Object)this$unit).equals(other$unit)) {
            return false;
        }
        Integer this$priority = this.getPriority();
        Integer other$priority = other.getPriority();
        if (this$priority == null ? other$priority != null : !((Object)this$priority).equals(other$priority)) {
            return false;
        }
        Integer this$status = this.getStatus();
        Integer other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)this$status).equals(other$status)) {
            return false;
        }
        Integer this$memberStatus = this.getMemberStatus();
        Integer other$memberStatus = other.getMemberStatus();
        if (this$memberStatus == null ? other$memberStatus != null : !((Object)this$memberStatus).equals(other$memberStatus)) {
            return false;
        }
        Integer this$compatible = this.getCompatible();
        Integer other$compatible = other.getCompatible();
        if (this$compatible == null ? other$compatible != null : !((Object)this$compatible).equals(other$compatible)) {
            return false;
        }
        Boolean this$active = this.getActive();
        Boolean other$active = other.getActive();
        if (this$active == null ? other$active != null : !((Object)this$active).equals(other$active)) {
            return false;
        }
        Integer this$licenseStatus = this.getLicenseStatus();
        Integer other$licenseStatus = other.getLicenseStatus();
        if (this$licenseStatus == null ? other$licenseStatus != null : !((Object)this$licenseStatus).equals(other$licenseStatus)) {
            return false;
        }
        Long this$dueTime = this.getDueTime();
        Long other$dueTime = other.getDueTime();
        if (this$dueTime == null ? other$dueTime != null : !((Object)this$dueTime).equals(other$dueTime)) {
            return false;
        }
        Long this$dueTimeLeft = this.getDueTimeLeft();
        Long other$dueTimeLeft = other.getDueTimeLeft();
        if (this$dueTimeLeft == null ? other$dueTimeLeft != null : !((Object)this$dueTimeLeft).equals(other$dueTimeLeft)) {
            return false;
        }
        Integer this$licenseUnbindingLimit = this.getLicenseUnbindingLimit();
        Integer other$licenseUnbindingLimit = other.getLicenseUnbindingLimit();
        if (this$licenseUnbindingLimit == null ? other$licenseUnbindingLimit != null : !((Object)this$licenseUnbindingLimit).equals(other$licenseUnbindingLimit)) {
            return false;
        }
        Integer this$initialUnbindingLimit = this.getInitialUnbindingLimit();
        Integer other$initialUnbindingLimit = other.getInitialUnbindingLimit();
        if (this$initialUnbindingLimit == null ? other$initialUnbindingLimit != null : !((Object)this$initialUnbindingLimit).equals(other$initialUnbindingLimit)) {
            return false;
        }
        Integer this$cpuUtil = this.getCpuUtil();
        Integer other$cpuUtil = other.getCpuUtil();
        if (this$cpuUtil == null ? other$cpuUtil != null : !((Object)this$cpuUtil).equals(other$cpuUtil)) {
            return false;
        }
        Integer this$memUtil = this.getMemUtil();
        Integer other$memUtil = other.getMemUtil();
        if (this$memUtil == null ? other$memUtil != null : !((Object)this$memUtil).equals(other$memUtil)) {
            return false;
        }
        Double this$poeTotalPower = this.getPoeTotalPower();
        Double other$poeTotalPower = other.getPoeTotalPower();
        if (this$poeTotalPower == null ? other$poeTotalPower != null : !((Object)this$poeTotalPower).equals(other$poeTotalPower)) {
            return false;
        }
        Double this$poeRemain = this.getPoeRemain();
        Double other$poeRemain = other.getPoeRemain();
        if (this$poeRemain == null ? other$poeRemain != null : !((Object)this$poeRemain).equals(other$poeRemain)) {
            return false;
        }
        Double this$poeRemainPercent = this.getPoeRemainPercent();
        Double other$poeRemainPercent = other.getPoeRemainPercent();
        if (this$poeRemainPercent == null ? other$poeRemainPercent != null : !((Object)this$poeRemainPercent).equals(other$poeRemainPercent)) {
            return false;
        }
        Integer this$loopbackNum = this.getLoopbackNum();
        Integer other$loopbackNum = other.getLoopbackNum();
        if (this$loopbackNum == null ? other$loopbackNum != null : !((Object)this$loopbackNum).equals(other$loopbackNum)) {
            return false;
        }
        Integer this$maxStackGroups = this.getMaxStackGroups();
        Integer other$maxStackGroups = other.getMaxStackGroups();
        if (this$maxStackGroups == null ? other$maxStackGroups != null : !((Object)this$maxStackGroups).equals(other$maxStackGroups)) {
            return false;
        }
        Integer this$maxStackUnitNumber = this.getMaxStackUnitNumber();
        Integer other$maxStackUnitNumber = other.getMaxStackUnitNumber();
        if (this$maxStackUnitNumber == null ? other$maxStackUnitNumber != null : !((Object)this$maxStackUnitNumber).equals(other$maxStackUnitNumber)) {
            return false;
        }
        Boolean this$locateEnable = this.getLocateEnable();
        Boolean other$locateEnable = other.getLocateEnable();
        if (this$locateEnable == null ? other$locateEnable != null : !((Object)this$locateEnable).equals(other$locateEnable)) {
            return false;
        }
        Boolean this$inWhitelist = this.getInWhitelist();
        Boolean other$inWhitelist = other.getInWhitelist();
        if (this$inWhitelist == null ? other$inWhitelist != null : !((Object)this$inWhitelist).equals(other$inWhitelist)) {
            return false;
        }
        Integer this$deviceSeriesType = this.getDeviceSeriesType();
        Integer other$deviceSeriesType = other.getDeviceSeriesType();
        if (this$deviceSeriesType == null ? other$deviceSeriesType != null : !((Object)this$deviceSeriesType).equals(other$deviceSeriesType)) {
            return false;
        }
        Integer this$statusCategory = this.getStatusCategory();
        Integer other$statusCategory = other.getStatusCategory();
        if (this$statusCategory == null ? other$statusCategory != null : !((Object)this$statusCategory).equals(other$statusCategory)) {
            return false;
        }
        String this$omadacId = this.getOmadacId();
        String other$omadacId = other.getOmadacId();
        if (this$omadacId == null ? other$omadacId != null : !this$omadacId.equals(other$omadacId)) {
            return false;
        }
        String this$mac = this.getMac();
        String other$mac = other.getMac();
        if (this$mac == null ? other$mac != null : !this$mac.equals(other$mac)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$ip = this.getIp();
        String other$ip = other.getIp();
        if (this$ip == null ? other$ip != null : !this$ip.equals(other$ip)) {
            return false;
        }
        String this$model = this.getModel();
        String other$model = other.getModel();
        if (this$model == null ? other$model != null : !this$model.equals(other$model)) {
            return false;
        }
        String this$modelVersion = this.getModelVersion();
        String other$modelVersion = other.getModelVersion();
        if (this$modelVersion == null ? other$modelVersion != null : !this$modelVersion.equals(other$modelVersion)) {
            return false;
        }
        String this$showModel = this.getShowModel();
        String other$showModel = other.getShowModel();
        if (this$showModel == null ? other$showModel != null : !this$showModel.equals(other$showModel)) {
            return false;
        }
        String this$compoundModel = this.getCompoundModel();
        String other$compoundModel = other.getCompoundModel();
        if (this$compoundModel == null ? other$compoundModel != null : !this$compoundModel.equals(other$compoundModel)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$category = this.getCategory();
        String other$category = other.getCategory();
        if (this$category == null ? other$category != null : !this$category.equals(other$category)) {
            return false;
        }
        String this$licenseId = this.getLicenseId();
        String other$licenseId = other.getLicenseId();
        if (this$licenseId == null ? other$licenseId != null : !this$licenseId.equals(other$licenseId)) {
            return false;
        }
        String this$uptime = this.getUptime();
        String other$uptime = other.getUptime();
        if (this$uptime == null ? other$uptime != null : !this$uptime.equals(other$uptime)) {
            return false;
        }
        String this$loop = this.getLoop();
        String other$loop = other.getLoop();
        if (this$loop == null ? other$loop != null : !this$loop.equals(other$loop)) {
            return false;
        }
        List<OswStackMemberPortCapAndStatusVO> this$portCaps = this.getPortCaps();
        List<OswStackMemberPortCapAndStatusVO> other$portCaps = other.getPortCaps();
        if (this$portCaps == null ? other$portCaps != null : !((Object)this$portCaps).equals(other$portCaps)) {
            return false;
        }
        List<OswStackMemberPortVO> this$ports = this.getPorts();
        List<OswStackMemberPortVO> other$ports = other.getPorts();
        if (this$ports == null ? other$ports != null : !((Object)this$ports).equals(other$ports)) {
            return false;
        }
        List<OswStackPortGroupVO> this$stackPorts = this.getStackPorts();
        List<OswStackPortGroupVO> other$stackPorts = other.getStackPorts();
        if (this$stackPorts == null ? other$stackPorts != null : !((Object)this$stackPorts).equals(other$stackPorts)) {
            return false;
        }
        List<OswLagVO> this$oswStackPortGroupStatus = this.getOswStackPortGroupStatus();
        List<OswLagVO> other$oswStackPortGroupStatus = other.getOswStackPortGroupStatus();
        if (this$oswStackPortGroupStatus == null ? other$oswStackPortGroupStatus != null : !((Object)this$oswStackPortGroupStatus).equals(other$oswStackPortGroupStatus)) {
            return false;
        }
        Map<String, List<String>> this$stackPortCap = this.getStackPortCap();
        Map<String, List<String>> other$stackPortCap = other.getStackPortCap();
        if (this$stackPortCap == null ? other$stackPortCap != null : !((Object)this$stackPortCap).equals(other$stackPortCap)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        OswUplinkVO this$uplink = this.getUplink();
        OswUplinkVO other$uplink = other.getUplink();
        if (this$uplink == null ? other$uplink != null : !this$uplink.equals(other$uplink)) {
            return false;
        }
        List<OswDownlinkVO> this$downlinkList = this.getDownlinkList();
        List<OswDownlinkVO> other$downlinkList = other.getDownlinkList();
        return !(this$downlinkList == null ? other$downlinkList != null : !((Object)this$downlinkList).equals(other$downlinkList));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof OswStackMemberVO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $unit = this.getUnit();
        result = result * 59 + ($unit == null ? 43 : ((Object)$unit).hashCode());
        Integer $priority = this.getPriority();
        result = result * 59 + ($priority == null ? 43 : ((Object)$priority).hashCode());
        Integer $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)$status).hashCode());
        Integer $memberStatus = this.getMemberStatus();
        result = result * 59 + ($memberStatus == null ? 43 : ((Object)$memberStatus).hashCode());
        Integer $compatible = this.getCompatible();
        result = result * 59 + ($compatible == null ? 43 : ((Object)$compatible).hashCode());
        Boolean $active = this.getActive();
        result = result * 59 + ($active == null ? 43 : ((Object)$active).hashCode());
        Integer $licenseStatus = this.getLicenseStatus();
        result = result * 59 + ($licenseStatus == null ? 43 : ((Object)$licenseStatus).hashCode());
        Long $dueTime = this.getDueTime();
        result = result * 59 + ($dueTime == null ? 43 : ((Object)$dueTime).hashCode());
        Long $dueTimeLeft = this.getDueTimeLeft();
        result = result * 59 + ($dueTimeLeft == null ? 43 : ((Object)$dueTimeLeft).hashCode());
        Integer $licenseUnbindingLimit = this.getLicenseUnbindingLimit();
        result = result * 59 + ($licenseUnbindingLimit == null ? 43 : ((Object)$licenseUnbindingLimit).hashCode());
        Integer $initialUnbindingLimit = this.getInitialUnbindingLimit();
        result = result * 59 + ($initialUnbindingLimit == null ? 43 : ((Object)$initialUnbindingLimit).hashCode());
        Integer $cpuUtil = this.getCpuUtil();
        result = result * 59 + ($cpuUtil == null ? 43 : ((Object)$cpuUtil).hashCode());
        Integer $memUtil = this.getMemUtil();
        result = result * 59 + ($memUtil == null ? 43 : ((Object)$memUtil).hashCode());
        Double $poeTotalPower = this.getPoeTotalPower();
        result = result * 59 + ($poeTotalPower == null ? 43 : ((Object)$poeTotalPower).hashCode());
        Double $poeRemain = this.getPoeRemain();
        result = result * 59 + ($poeRemain == null ? 43 : ((Object)$poeRemain).hashCode());
        Double $poeRemainPercent = this.getPoeRemainPercent();
        result = result * 59 + ($poeRemainPercent == null ? 43 : ((Object)$poeRemainPercent).hashCode());
        Integer $loopbackNum = this.getLoopbackNum();
        result = result * 59 + ($loopbackNum == null ? 43 : ((Object)$loopbackNum).hashCode());
        Integer $maxStackGroups = this.getMaxStackGroups();
        result = result * 59 + ($maxStackGroups == null ? 43 : ((Object)$maxStackGroups).hashCode());
        Integer $maxStackUnitNumber = this.getMaxStackUnitNumber();
        result = result * 59 + ($maxStackUnitNumber == null ? 43 : ((Object)$maxStackUnitNumber).hashCode());
        Boolean $locateEnable = this.getLocateEnable();
        result = result * 59 + ($locateEnable == null ? 43 : ((Object)$locateEnable).hashCode());
        Boolean $inWhitelist = this.getInWhitelist();
        result = result * 59 + ($inWhitelist == null ? 43 : ((Object)$inWhitelist).hashCode());
        Integer $deviceSeriesType = this.getDeviceSeriesType();
        result = result * 59 + ($deviceSeriesType == null ? 43 : ((Object)$deviceSeriesType).hashCode());
        Integer $statusCategory = this.getStatusCategory();
        result = result * 59 + ($statusCategory == null ? 43 : ((Object)$statusCategory).hashCode());
        String $omadacId = this.getOmadacId();
        result = result * 59 + ($omadacId == null ? 43 : $omadacId.hashCode());
        String $mac = this.getMac();
        result = result * 59 + ($mac == null ? 43 : $mac.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $ip = this.getIp();
        result = result * 59 + ($ip == null ? 43 : $ip.hashCode());
        String $model = this.getModel();
        result = result * 59 + ($model == null ? 43 : $model.hashCode());
        String $modelVersion = this.getModelVersion();
        result = result * 59 + ($modelVersion == null ? 43 : $modelVersion.hashCode());
        String $showModel = this.getShowModel();
        result = result * 59 + ($showModel == null ? 43 : $showModel.hashCode());
        String $compoundModel = this.getCompoundModel();
        result = result * 59 + ($compoundModel == null ? 43 : $compoundModel.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $category = this.getCategory();
        result = result * 59 + ($category == null ? 43 : $category.hashCode());
        String $licenseId = this.getLicenseId();
        result = result * 59 + ($licenseId == null ? 43 : $licenseId.hashCode());
        String $uptime = this.getUptime();
        result = result * 59 + ($uptime == null ? 43 : $uptime.hashCode());
        String $loop = this.getLoop();
        result = result * 59 + ($loop == null ? 43 : $loop.hashCode());
        List<OswStackMemberPortCapAndStatusVO> $portCaps = this.getPortCaps();
        result = result * 59 + ($portCaps == null ? 43 : ((Object)$portCaps).hashCode());
        List<OswStackMemberPortVO> $ports = this.getPorts();
        result = result * 59 + ($ports == null ? 43 : ((Object)$ports).hashCode());
        List<OswStackPortGroupVO> $stackPorts = this.getStackPorts();
        result = result * 59 + ($stackPorts == null ? 43 : ((Object)$stackPorts).hashCode());
        List<OswLagVO> $oswStackPortGroupStatus = this.getOswStackPortGroupStatus();
        result = result * 59 + ($oswStackPortGroupStatus == null ? 43 : ((Object)$oswStackPortGroupStatus).hashCode());
        Map<String, List<String>> $stackPortCap = this.getStackPortCap();
        result = result * 59 + ($stackPortCap == null ? 43 : ((Object)$stackPortCap).hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        OswUplinkVO $uplink = this.getUplink();
        result = result * 59 + ($uplink == null ? 43 : $uplink.hashCode());
        List<OswDownlinkVO> $downlinkList = this.getDownlinkList();
        result = result * 59 + ($downlinkList == null ? 43 : ((Object)$downlinkList).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "OswStackMemberVO(omadacId=" + this.getOmadacId() + ", mac=" + this.getMac() + ", name=" + this.getName() + ", ip=" + this.getIp() + ", unit=" + this.getUnit() + ", priority=" + this.getPriority() + ", status=" + this.getStatus() + ", memberStatus=" + this.getMemberStatus() + ", compatible=" + this.getCompatible() + ", model=" + this.getModel() + ", modelVersion=" + this.getModelVersion() + ", showModel=" + this.getShowModel() + ", compoundModel=" + this.getCompoundModel() + ", version=" + this.getVersion() + ", active=" + this.getActive() + ", licenseStatus=" + this.getLicenseStatus() + ", dueTime=" + this.getDueTime() + ", dueTimeLeft=" + this.getDueTimeLeft() + ", category=" + this.getCategory() + ", licenseId=" + this.getLicenseId() + ", licenseUnbindingLimit=" + this.getLicenseUnbindingLimit() + ", initialUnbindingLimit=" + this.getInitialUnbindingLimit() + ", uptime=" + this.getUptime() + ", cpuUtil=" + this.getCpuUtil() + ", memUtil=" + this.getMemUtil() + ", poeTotalPower=" + this.getPoeTotalPower() + ", poeRemain=" + this.getPoeRemain() + ", poeRemainPercent=" + this.getPoeRemainPercent() + ", loopbackNum=" + this.getLoopbackNum() + ", loop=" + this.getLoop() + ", portCaps=" + this.getPortCaps() + ", ports=" + this.getPorts() + ", stackPorts=" + this.getStackPorts() + ", oswStackPortGroupStatus=" + this.getOswStackPortGroupStatus() + ", maxStackGroups=" + this.getMaxStackGroups() + ", maxStackUnitNumber=" + this.getMaxStackUnitNumber() + ", stackPortCap=" + this.getStackPortCap() + ", locateEnable=" + this.getLocateEnable() + ", inWhitelist=" + this.getInWhitelist() + ", deviceSeriesType=" + this.getDeviceSeriesType() + ", type=" + this.getType() + ", statusCategory=" + this.getStatusCategory() + ", uplink=" + this.getUplink() + ", downlinkList=" + this.getDownlinkList() + ")";
    }

    @Generated
    public OswStackMemberVO() {
    }
}

