/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.stack.api.internal.dto;

import com.tplink.nbu.common.pii.annotation.PII;
import com.tplink.nbu.common.pii.constant.PIIMaskStrategy;
import com.tplink.smb.omada.common.access.UserTypeEnumDTO;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;

public class LogUserDTO {
    private String id;
    private String name;
    @PII(strategy=PIIMaskStrategy.HASH)
    private String email;
    private String accountId;
    private String tenantId;
    private Integer userType;
    private String omadacId;
    private String roleId;
    private String roleTypeName;
    private Boolean openApiRequest;

    public Optional<String> getUsernameOrCloudAccount() {
        return this.isCloudUser() ? Optional.ofNullable(this.email) : Optional.ofNullable(this.name);
    }

    public boolean isCloudUser() {
        if (this.getUserType() != null) {
            return Objects.equals(UserTypeEnumDTO.CLOUD_USER.getValue(), this.getUserType());
        }
        return false;
    }

    public String getControllerId() {
        return this.getOmadacId();
    }

    public int userResource() {
        return Boolean.TRUE.equals(this.getOpenApiRequest()) ? 1 : 0;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setEmail(String email) {
        this.email = email;
    }

    @Generated
    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    @Generated
    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    @Generated
    public void setUserType(Integer userType) {
        this.userType = userType;
    }

    @Generated
    public void setOmadacId(String omadacId) {
        this.omadacId = omadacId;
    }

    @Generated
    public void setRoleId(String roleId) {
        this.roleId = roleId;
    }

    @Generated
    public void setRoleTypeName(String roleTypeName) {
        this.roleTypeName = roleTypeName;
    }

    @Generated
    public void setOpenApiRequest(Boolean openApiRequest) {
        this.openApiRequest = openApiRequest;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getEmail() {
        return this.email;
    }

    @Generated
    public String getAccountId() {
        return this.accountId;
    }

    @Generated
    public String getTenantId() {
        return this.tenantId;
    }

    @Generated
    public Integer getUserType() {
        return this.userType;
    }

    @Generated
    public String getOmadacId() {
        return this.omadacId;
    }

    @Generated
    public String getRoleId() {
        return this.roleId;
    }

    @Generated
    public String getRoleTypeName() {
        return this.roleTypeName;
    }

    @Generated
    public Boolean getOpenApiRequest() {
        return this.openApiRequest;
    }

    @Generated
    public LogUserDTO() {
    }

    @Generated
    public LogUserDTO(String id, String name, String email, String accountId, String tenantId, Integer userType, String omadacId, String roleId, String roleTypeName, Boolean openApiRequest) {
        this.id = id;
        this.name = name;
        this.email = email;
        this.accountId = accountId;
        this.tenantId = tenantId;
        this.userType = userType;
        this.omadacId = omadacId;
        this.roleId = roleId;
        this.roleTypeName = roleTypeName;
        this.openApiRequest = openApiRequest;
    }

    @Generated
    public String toString() {
        return "LogUserDTO(id=" + this.getId() + ", name=" + this.getName() + ", email=" + this.getEmail() + ", accountId=" + this.getAccountId() + ", tenantId=" + this.getTenantId() + ", userType=" + this.getUserType() + ", omadacId=" + this.getOmadacId() + ", roleId=" + this.getRoleId() + ", roleTypeName=" + this.getRoleTypeName() + ", openApiRequest=" + this.getOpenApiRequest() + ")";
    }
}

