/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.video.v1.room;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.video.v1.room.RoomRecording;

public class RoomRecordingReader
extends Reader<RoomRecording> {
    private final String pathRoomSid;

    public RoomRecordingReader(String pathRoomSid) {
        this.pathRoomSid = pathRoomSid;
    }

    @Override
    public ResourceSet<RoomRecording> read(TwilioRestClient client) {
        return new ResourceSet<RoomRecording>(this, client, this.firstPage(client));
    }

    @Override
    public Page<RoomRecording> firstPage(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, Domains.VIDEO.toString(), "/v1/Rooms/" + this.pathRoomSid + "/Recordings", client.getRegion());
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<RoomRecording> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<RoomRecording> nextPage(Page<RoomRecording> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.VIDEO.toString(), client.getRegion()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<RoomRecording> previousPage(Page<RoomRecording> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.VIDEO.toString(), client.getRegion()));
        return this.pageForRequest(client, request);
    }

    private Page<RoomRecording> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("RoomRecording read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Page.fromJson("recordings", response.getContent(), RoomRecording.class, client.getObjectMapper());
    }

    private void addQueryParams(Request request) {
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

