/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.video.v1;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.video.v1.Recording;
import java.util.List;

public class RecordingReader
extends Reader<Recording> {
    private Recording.Status status;
    private String sourceSid;
    private List<String> groupingSid;

    public RecordingReader setStatus(Recording.Status status) {
        this.status = status;
        return this;
    }

    public RecordingReader setSourceSid(String sourceSid) {
        this.sourceSid = sourceSid;
        return this;
    }

    public RecordingReader setGroupingSid(List<String> groupingSid) {
        this.groupingSid = groupingSid;
        return this;
    }

    public RecordingReader setGroupingSid(String groupingSid) {
        return this.setGroupingSid(Promoter.listOfOne(groupingSid));
    }

    @Override
    public ResourceSet<Recording> read(TwilioRestClient client) {
        return new ResourceSet<Recording>(this, client, this.firstPage(client));
    }

    @Override
    public Page<Recording> firstPage(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, Domains.VIDEO.toString(), "/v1/Recordings", client.getRegion());
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Recording> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Recording> nextPage(Page<Recording> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.VIDEO.toString(), client.getRegion()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Recording> previousPage(Page<Recording> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.VIDEO.toString(), client.getRegion()));
        return this.pageForRequest(client, request);
    }

    private Page<Recording> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Recording read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Page.fromJson("recordings", response.getContent(), Recording.class, client.getObjectMapper());
    }

    private void addQueryParams(Request request) {
        if (this.status != null) {
            request.addQueryParam("Status", this.status.toString());
        }
        if (this.sourceSid != null) {
            request.addQueryParam("SourceSid", this.sourceSid);
        }
        if (this.groupingSid != null) {
            for (String prop : this.groupingSid) {
                request.addQueryParam("GroupingSid", prop);
            }
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

