/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.taskrouter.v1.workspace.task;

import com.twilio.base.Updater;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.taskrouter.v1.workspace.task.Reservation;
import java.net.URI;

public class ReservationUpdater
extends Updater<Reservation> {
    private final String pathWorkspaceSid;
    private final String pathTaskSid;
    private final String pathSid;
    private Reservation.Status reservationStatus;
    private String workerActivitySid;
    private String instruction;
    private String dequeuePostWorkActivitySid;
    private String dequeueFrom;
    private String dequeueRecord;
    private Integer dequeueTimeout;
    private String dequeueTo;
    private URI dequeueStatusCallbackUrl;
    private String callFrom;
    private String callRecord;
    private Integer callTimeout;
    private String callTo;
    private URI callUrl;
    private URI callStatusCallbackUrl;
    private Boolean callAccept;
    private String redirectCallSid;
    private Boolean redirectAccept;
    private URI redirectUrl;

    public ReservationUpdater(String pathWorkspaceSid, String pathTaskSid, String pathSid) {
        this.pathWorkspaceSid = pathWorkspaceSid;
        this.pathTaskSid = pathTaskSid;
        this.pathSid = pathSid;
    }

    public ReservationUpdater setReservationStatus(Reservation.Status reservationStatus) {
        this.reservationStatus = reservationStatus;
        return this;
    }

    public ReservationUpdater setWorkerActivitySid(String workerActivitySid) {
        this.workerActivitySid = workerActivitySid;
        return this;
    }

    public ReservationUpdater setInstruction(String instruction) {
        this.instruction = instruction;
        return this;
    }

    public ReservationUpdater setDequeuePostWorkActivitySid(String dequeuePostWorkActivitySid) {
        this.dequeuePostWorkActivitySid = dequeuePostWorkActivitySid;
        return this;
    }

    public ReservationUpdater setDequeueFrom(String dequeueFrom) {
        this.dequeueFrom = dequeueFrom;
        return this;
    }

    public ReservationUpdater setDequeueRecord(String dequeueRecord) {
        this.dequeueRecord = dequeueRecord;
        return this;
    }

    public ReservationUpdater setDequeueTimeout(Integer dequeueTimeout) {
        this.dequeueTimeout = dequeueTimeout;
        return this;
    }

    public ReservationUpdater setDequeueTo(String dequeueTo) {
        this.dequeueTo = dequeueTo;
        return this;
    }

    public ReservationUpdater setDequeueStatusCallbackUrl(URI dequeueStatusCallbackUrl) {
        this.dequeueStatusCallbackUrl = dequeueStatusCallbackUrl;
        return this;
    }

    public ReservationUpdater setDequeueStatusCallbackUrl(String dequeueStatusCallbackUrl) {
        return this.setDequeueStatusCallbackUrl(Promoter.uriFromString(dequeueStatusCallbackUrl));
    }

    public ReservationUpdater setCallFrom(String callFrom) {
        this.callFrom = callFrom;
        return this;
    }

    public ReservationUpdater setCallRecord(String callRecord) {
        this.callRecord = callRecord;
        return this;
    }

    public ReservationUpdater setCallTimeout(Integer callTimeout) {
        this.callTimeout = callTimeout;
        return this;
    }

    public ReservationUpdater setCallTo(String callTo) {
        this.callTo = callTo;
        return this;
    }

    public ReservationUpdater setCallUrl(URI callUrl) {
        this.callUrl = callUrl;
        return this;
    }

    public ReservationUpdater setCallUrl(String callUrl) {
        return this.setCallUrl(Promoter.uriFromString(callUrl));
    }

    public ReservationUpdater setCallStatusCallbackUrl(URI callStatusCallbackUrl) {
        this.callStatusCallbackUrl = callStatusCallbackUrl;
        return this;
    }

    public ReservationUpdater setCallStatusCallbackUrl(String callStatusCallbackUrl) {
        return this.setCallStatusCallbackUrl(Promoter.uriFromString(callStatusCallbackUrl));
    }

    public ReservationUpdater setCallAccept(Boolean callAccept) {
        this.callAccept = callAccept;
        return this;
    }

    public ReservationUpdater setRedirectCallSid(String redirectCallSid) {
        this.redirectCallSid = redirectCallSid;
        return this;
    }

    public ReservationUpdater setRedirectAccept(Boolean redirectAccept) {
        this.redirectAccept = redirectAccept;
        return this;
    }

    public ReservationUpdater setRedirectUrl(URI redirectUrl) {
        this.redirectUrl = redirectUrl;
        return this;
    }

    public ReservationUpdater setRedirectUrl(String redirectUrl) {
        return this.setRedirectUrl(Promoter.uriFromString(redirectUrl));
    }

    @Override
    public Reservation update(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, Domains.TASKROUTER.toString(), "/v1/Workspaces/" + this.pathWorkspaceSid + "/Tasks/" + this.pathTaskSid + "/Reservations/" + this.pathSid + "", client.getRegion());
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Reservation update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Reservation.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.reservationStatus != null) {
            request.addPostParam("ReservationStatus", this.reservationStatus.toString());
        }
        if (this.workerActivitySid != null) {
            request.addPostParam("WorkerActivitySid", this.workerActivitySid);
        }
        if (this.instruction != null) {
            request.addPostParam("Instruction", this.instruction);
        }
        if (this.dequeuePostWorkActivitySid != null) {
            request.addPostParam("DequeuePostWorkActivitySid", this.dequeuePostWorkActivitySid);
        }
        if (this.dequeueFrom != null) {
            request.addPostParam("DequeueFrom", this.dequeueFrom);
        }
        if (this.dequeueRecord != null) {
            request.addPostParam("DequeueRecord", this.dequeueRecord);
        }
        if (this.dequeueTimeout != null) {
            request.addPostParam("DequeueTimeout", this.dequeueTimeout.toString());
        }
        if (this.dequeueTo != null) {
            request.addPostParam("DequeueTo", this.dequeueTo);
        }
        if (this.dequeueStatusCallbackUrl != null) {
            request.addPostParam("DequeueStatusCallbackUrl", this.dequeueStatusCallbackUrl.toString());
        }
        if (this.callFrom != null) {
            request.addPostParam("CallFrom", this.callFrom);
        }
        if (this.callRecord != null) {
            request.addPostParam("CallRecord", this.callRecord);
        }
        if (this.callTimeout != null) {
            request.addPostParam("CallTimeout", this.callTimeout.toString());
        }
        if (this.callTo != null) {
            request.addPostParam("CallTo", this.callTo);
        }
        if (this.callUrl != null) {
            request.addPostParam("CallUrl", this.callUrl.toString());
        }
        if (this.callStatusCallbackUrl != null) {
            request.addPostParam("CallStatusCallbackUrl", this.callStatusCallbackUrl.toString());
        }
        if (this.callAccept != null) {
            request.addPostParam("CallAccept", this.callAccept.toString());
        }
        if (this.redirectCallSid != null) {
            request.addPostParam("RedirectCallSid", this.redirectCallSid);
        }
        if (this.redirectAccept != null) {
            request.addPostParam("RedirectAccept", this.redirectAccept.toString());
        }
        if (this.redirectUrl != null) {
            request.addPostParam("RedirectUrl", this.redirectUrl.toString());
        }
    }
}

