/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.taskrouter.v1.workspace;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.taskrouter.v1.workspace.Task;
import java.util.List;

public class TaskReader
extends Reader<Task> {
    private final String pathWorkspaceSid;
    private Integer priority;
    private List<String> assignmentStatus;
    private String workflowSid;
    private String workflowName;
    private String taskQueueSid;
    private String taskQueueName;
    private String evaluateTaskAttributes;
    private String ordering;
    private Boolean hasAddons;

    public TaskReader(String pathWorkspaceSid) {
        this.pathWorkspaceSid = pathWorkspaceSid;
    }

    public TaskReader setPriority(Integer priority) {
        this.priority = priority;
        return this;
    }

    public TaskReader setAssignmentStatus(List<String> assignmentStatus) {
        this.assignmentStatus = assignmentStatus;
        return this;
    }

    public TaskReader setAssignmentStatus(String assignmentStatus) {
        return this.setAssignmentStatus(Promoter.listOfOne(assignmentStatus));
    }

    public TaskReader setWorkflowSid(String workflowSid) {
        this.workflowSid = workflowSid;
        return this;
    }

    public TaskReader setWorkflowName(String workflowName) {
        this.workflowName = workflowName;
        return this;
    }

    public TaskReader setTaskQueueSid(String taskQueueSid) {
        this.taskQueueSid = taskQueueSid;
        return this;
    }

    public TaskReader setTaskQueueName(String taskQueueName) {
        this.taskQueueName = taskQueueName;
        return this;
    }

    public TaskReader setEvaluateTaskAttributes(String evaluateTaskAttributes) {
        this.evaluateTaskAttributes = evaluateTaskAttributes;
        return this;
    }

    public TaskReader setOrdering(String ordering) {
        this.ordering = ordering;
        return this;
    }

    public TaskReader setHasAddons(Boolean hasAddons) {
        this.hasAddons = hasAddons;
        return this;
    }

    @Override
    public ResourceSet<Task> read(TwilioRestClient client) {
        return new ResourceSet<Task>(this, client, this.firstPage(client));
    }

    @Override
    public Page<Task> firstPage(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, Domains.TASKROUTER.toString(), "/v1/Workspaces/" + this.pathWorkspaceSid + "/Tasks", client.getRegion());
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Task> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Task> nextPage(Page<Task> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.TASKROUTER.toString(), client.getRegion()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Task> previousPage(Page<Task> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.TASKROUTER.toString(), client.getRegion()));
        return this.pageForRequest(client, request);
    }

    private Page<Task> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Task read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Page.fromJson("tasks", response.getContent(), Task.class, client.getObjectMapper());
    }

    private void addQueryParams(Request request) {
        if (this.priority != null) {
            request.addQueryParam("Priority", this.priority.toString());
        }
        if (this.assignmentStatus != null) {
            for (String prop : this.assignmentStatus) {
                request.addQueryParam("AssignmentStatus", prop);
            }
        }
        if (this.workflowSid != null) {
            request.addQueryParam("WorkflowSid", this.workflowSid);
        }
        if (this.workflowName != null) {
            request.addQueryParam("WorkflowName", this.workflowName);
        }
        if (this.taskQueueSid != null) {
            request.addQueryParam("TaskQueueSid", this.taskQueueSid);
        }
        if (this.taskQueueName != null) {
            request.addQueryParam("TaskQueueName", this.taskQueueName);
        }
        if (this.evaluateTaskAttributes != null) {
            request.addQueryParam("EvaluateTaskAttributes", this.evaluateTaskAttributes);
        }
        if (this.ordering != null) {
            request.addQueryParam("Ordering", this.ordering);
        }
        if (this.hasAddons != null) {
            request.addQueryParam("HasAddons", this.hasAddons.toString());
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

