/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.taskrouter.v1.workspace;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.taskrouter.v1.workspace.TaskQueueCreator;
import com.twilio.rest.taskrouter.v1.workspace.TaskQueueDeleter;
import com.twilio.rest.taskrouter.v1.workspace.TaskQueueFetcher;
import com.twilio.rest.taskrouter.v1.workspace.TaskQueueReader;
import com.twilio.rest.taskrouter.v1.workspace.TaskQueueUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class TaskQueue
extends Resource {
    private static final long serialVersionUID = 86871980541241L;
    private final String accountSid;
    private final String assignmentActivitySid;
    private final String assignmentActivityName;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final String friendlyName;
    private final Integer maxReservedWorkers;
    private final String reservationActivitySid;
    private final String reservationActivityName;
    private final String sid;
    private final String targetWorkers;
    private final TaskOrder taskOrder;
    private final URI url;
    private final String workspaceSid;
    private final Map<String, String> links;

    public static TaskQueueFetcher fetcher(String pathWorkspaceSid, String pathSid) {
        return new TaskQueueFetcher(pathWorkspaceSid, pathSid);
    }

    public static TaskQueueUpdater updater(String pathWorkspaceSid, String pathSid) {
        return new TaskQueueUpdater(pathWorkspaceSid, pathSid);
    }

    public static TaskQueueReader reader(String pathWorkspaceSid) {
        return new TaskQueueReader(pathWorkspaceSid);
    }

    public static TaskQueueCreator creator(String pathWorkspaceSid, String friendlyName, String reservationActivitySid, String assignmentActivitySid) {
        return new TaskQueueCreator(pathWorkspaceSid, friendlyName, reservationActivitySid, assignmentActivitySid);
    }

    public static TaskQueueDeleter deleter(String pathWorkspaceSid, String pathSid) {
        return new TaskQueueDeleter(pathWorkspaceSid, pathSid);
    }

    public static TaskQueue fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (TaskQueue)objectMapper.readValue(json, TaskQueue.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static TaskQueue fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (TaskQueue)objectMapper.readValue(json, TaskQueue.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private TaskQueue(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="assignment_activity_sid") String assignmentActivitySid, @JsonProperty(value="assignment_activity_name") String assignmentActivityName, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="friendly_name") String friendlyName, @JsonProperty(value="max_reserved_workers") Integer maxReservedWorkers, @JsonProperty(value="reservation_activity_sid") String reservationActivitySid, @JsonProperty(value="reservation_activity_name") String reservationActivityName, @JsonProperty(value="sid") String sid, @JsonProperty(value="target_workers") String targetWorkers, @JsonProperty(value="task_order") TaskOrder taskOrder, @JsonProperty(value="url") URI url, @JsonProperty(value="workspace_sid") String workspaceSid, @JsonProperty(value="links") Map<String, String> links) {
        this.accountSid = accountSid;
        this.assignmentActivitySid = assignmentActivitySid;
        this.assignmentActivityName = assignmentActivityName;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.friendlyName = friendlyName;
        this.maxReservedWorkers = maxReservedWorkers;
        this.reservationActivitySid = reservationActivitySid;
        this.reservationActivityName = reservationActivityName;
        this.sid = sid;
        this.targetWorkers = targetWorkers;
        this.taskOrder = taskOrder;
        this.url = url;
        this.workspaceSid = workspaceSid;
        this.links = links;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getAssignmentActivitySid() {
        return this.assignmentActivitySid;
    }

    public final String getAssignmentActivityName() {
        return this.assignmentActivityName;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final String getFriendlyName() {
        return this.friendlyName;
    }

    public final Integer getMaxReservedWorkers() {
        return this.maxReservedWorkers;
    }

    public final String getReservationActivitySid() {
        return this.reservationActivitySid;
    }

    public final String getReservationActivityName() {
        return this.reservationActivityName;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getTargetWorkers() {
        return this.targetWorkers;
    }

    public final TaskOrder getTaskOrder() {
        return this.taskOrder;
    }

    public final URI getUrl() {
        return this.url;
    }

    public final String getWorkspaceSid() {
        return this.workspaceSid;
    }

    public final Map<String, String> getLinks() {
        return this.links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskQueue other = (TaskQueue)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.assignmentActivitySid, other.assignmentActivitySid) && Objects.equals(this.assignmentActivityName, other.assignmentActivityName) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.friendlyName, other.friendlyName) && Objects.equals(this.maxReservedWorkers, other.maxReservedWorkers) && Objects.equals(this.reservationActivitySid, other.reservationActivitySid) && Objects.equals(this.reservationActivityName, other.reservationActivityName) && Objects.equals(this.sid, other.sid) && Objects.equals(this.targetWorkers, other.targetWorkers) && Objects.equals((Object)this.taskOrder, (Object)other.taskOrder) && Objects.equals(this.url, other.url) && Objects.equals(this.workspaceSid, other.workspaceSid) && Objects.equals(this.links, other.links);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountSid, this.assignmentActivitySid, this.assignmentActivityName, this.dateCreated, this.dateUpdated, this.friendlyName, this.maxReservedWorkers, this.reservationActivitySid, this.reservationActivityName, this.sid, this.targetWorkers, this.taskOrder, this.url, this.workspaceSid, this.links});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("accountSid", (Object)this.accountSid).add("assignmentActivitySid", (Object)this.assignmentActivitySid).add("assignmentActivityName", (Object)this.assignmentActivityName).add("dateCreated", (Object)this.dateCreated).add("dateUpdated", (Object)this.dateUpdated).add("friendlyName", (Object)this.friendlyName).add("maxReservedWorkers", (Object)this.maxReservedWorkers).add("reservationActivitySid", (Object)this.reservationActivitySid).add("reservationActivityName", (Object)this.reservationActivityName).add("sid", (Object)this.sid).add("targetWorkers", (Object)this.targetWorkers).add("taskOrder", (Object)this.taskOrder).add("url", (Object)this.url).add("workspaceSid", (Object)this.workspaceSid).add("links", this.links).toString();
    }

    public static enum TaskOrder {
        FIFO("FIFO"),
        LIFO("LIFO");

        private final String value;

        private TaskOrder(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static TaskOrder forValue(String value) {
            return (TaskOrder)Promoter.enumFromString((String)value, (Enum[])TaskOrder.values());
        }
    }
}

