/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.lookups.v1;

import com.twilio.base.Fetcher;
import com.twilio.converter.PrefixedCollapsibleMap;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.lookups.v1.PhoneNumber;
import java.util.List;
import java.util.Map;

public class PhoneNumberFetcher
extends Fetcher<PhoneNumber> {
    private final com.twilio.type.PhoneNumber pathPhoneNumber;
    private String countryCode;
    private List<String> type;
    private List<String> addOns;
    private Map<String, Object> addOnsData;

    public PhoneNumberFetcher(com.twilio.type.PhoneNumber pathPhoneNumber) {
        this.pathPhoneNumber = pathPhoneNumber;
    }

    public PhoneNumberFetcher setCountryCode(String countryCode) {
        this.countryCode = countryCode;
        return this;
    }

    public PhoneNumberFetcher setType(List<String> type) {
        this.type = type;
        return this;
    }

    public PhoneNumberFetcher setType(String type) {
        return this.setType(Promoter.listOfOne(type));
    }

    public PhoneNumberFetcher setAddOns(List<String> addOns) {
        this.addOns = addOns;
        return this;
    }

    public PhoneNumberFetcher setAddOns(String addOns) {
        return this.setAddOns(Promoter.listOfOne(addOns));
    }

    public PhoneNumberFetcher setAddOnsData(Map<String, Object> addOnsData) {
        this.addOnsData = addOnsData;
        return this;
    }

    @Override
    public PhoneNumber fetch(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, Domains.LOOKUPS.toString(), "/v1/PhoneNumbers/" + this.pathPhoneNumber + "", client.getRegion());
        this.addQueryParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("PhoneNumber fetch failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return PhoneNumber.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addQueryParams(Request request) {
        if (this.countryCode != null) {
            request.addQueryParam("CountryCode", this.countryCode);
        }
        if (this.type != null) {
            for (String prop : this.type) {
                request.addQueryParam("Type", prop);
            }
        }
        if (this.addOns != null) {
            for (String prop : this.addOns) {
                request.addQueryParam("AddOns", prop);
            }
        }
        if (this.addOnsData != null) {
            Map<String, String> params = PrefixedCollapsibleMap.serialize(this.addOnsData, "AddOns");
            for (Map.Entry<String, String> entry : params.entrySet()) {
                request.addQueryParam(entry.getKey(), entry.getValue());
            }
        }
    }
}

