/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.ipmessaging.v2.service;

import com.twilio.base.Updater;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.ipmessaging.v2.service.Channel;

public class ChannelUpdater
extends Updater<Channel> {
    private final String pathServiceSid;
    private final String pathSid;
    private String friendlyName;
    private String uniqueName;
    private String attributes;

    public ChannelUpdater(String pathServiceSid, String pathSid) {
        this.pathServiceSid = pathServiceSid;
        this.pathSid = pathSid;
    }

    public ChannelUpdater setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    public ChannelUpdater setUniqueName(String uniqueName) {
        this.uniqueName = uniqueName;
        return this;
    }

    public ChannelUpdater setAttributes(String attributes) {
        this.attributes = attributes;
        return this;
    }

    @Override
    public Channel update(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, Domains.IPMESSAGING.toString(), "/v2/Services/" + this.pathServiceSid + "/Channels/" + this.pathSid + "", client.getRegion());
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Channel update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Channel.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.friendlyName != null) {
            request.addPostParam("FriendlyName", this.friendlyName);
        }
        if (this.uniqueName != null) {
            request.addPostParam("UniqueName", this.uniqueName);
        }
        if (this.attributes != null) {
            request.addPostParam("Attributes", this.attributes);
        }
    }
}

