/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.chat.v1.service.channel;

import com.twilio.base.Updater;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.chat.v1.service.channel.Message;

public class MessageUpdater
extends Updater<Message> {
    private final String pathServiceSid;
    private final String pathChannelSid;
    private final String pathSid;
    private String body;
    private String attributes;

    public MessageUpdater(String pathServiceSid, String pathChannelSid, String pathSid) {
        this.pathServiceSid = pathServiceSid;
        this.pathChannelSid = pathChannelSid;
        this.pathSid = pathSid;
    }

    public MessageUpdater setBody(String body) {
        this.body = body;
        return this;
    }

    public MessageUpdater setAttributes(String attributes) {
        this.attributes = attributes;
        return this;
    }

    @Override
    public Message update(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, Domains.CHAT.toString(), "/v1/Services/" + this.pathServiceSid + "/Channels/" + this.pathChannelSid + "/Messages/" + this.pathSid + "", client.getRegion());
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Message update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Message.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.body != null) {
            request.addPostParam("Body", this.body);
        }
        if (this.attributes != null) {
            request.addPostParam("Attributes", this.attributes);
        }
    }
}

