/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010.account.sip;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.api.v2010.account.sip.IpAccessControlListCreator;
import com.twilio.rest.api.v2010.account.sip.IpAccessControlListDeleter;
import com.twilio.rest.api.v2010.account.sip.IpAccessControlListFetcher;
import com.twilio.rest.api.v2010.account.sip.IpAccessControlListReader;
import com.twilio.rest.api.v2010.account.sip.IpAccessControlListUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class IpAccessControlList
extends Resource {
    private static final long serialVersionUID = 214188792953524L;
    private final String sid;
    private final String accountSid;
    private final String friendlyName;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final Map<String, String> subresourceUris;
    private final String uri;

    public static IpAccessControlListReader reader(String pathAccountSid) {
        return new IpAccessControlListReader(pathAccountSid);
    }

    public static IpAccessControlListReader reader() {
        return new IpAccessControlListReader();
    }

    public static IpAccessControlListCreator creator(String pathAccountSid, String friendlyName) {
        return new IpAccessControlListCreator(pathAccountSid, friendlyName);
    }

    public static IpAccessControlListCreator creator(String friendlyName) {
        return new IpAccessControlListCreator(friendlyName);
    }

    public static IpAccessControlListFetcher fetcher(String pathAccountSid, String pathSid) {
        return new IpAccessControlListFetcher(pathAccountSid, pathSid);
    }

    public static IpAccessControlListFetcher fetcher(String pathSid) {
        return new IpAccessControlListFetcher(pathSid);
    }

    public static IpAccessControlListUpdater updater(String pathAccountSid, String pathSid, String friendlyName) {
        return new IpAccessControlListUpdater(pathAccountSid, pathSid, friendlyName);
    }

    public static IpAccessControlListUpdater updater(String pathSid, String friendlyName) {
        return new IpAccessControlListUpdater(pathSid, friendlyName);
    }

    public static IpAccessControlListDeleter deleter(String pathAccountSid, String pathSid) {
        return new IpAccessControlListDeleter(pathAccountSid, pathSid);
    }

    public static IpAccessControlListDeleter deleter(String pathSid) {
        return new IpAccessControlListDeleter(pathSid);
    }

    public static IpAccessControlList fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (IpAccessControlList)objectMapper.readValue(json, IpAccessControlList.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static IpAccessControlList fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (IpAccessControlList)objectMapper.readValue(json, IpAccessControlList.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private IpAccessControlList(@JsonProperty(value="sid") String sid, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="friendly_name") String friendlyName, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="subresource_uris") Map<String, String> subresourceUris, @JsonProperty(value="uri") String uri) {
        this.sid = sid;
        this.accountSid = accountSid;
        this.friendlyName = friendlyName;
        this.dateCreated = DateConverter.rfc2822DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.rfc2822DateTimeFromString(dateUpdated);
        this.subresourceUris = subresourceUris;
        this.uri = uri;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getFriendlyName() {
        return this.friendlyName;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final Map<String, String> getSubresourceUris() {
        return this.subresourceUris;
    }

    public final String getUri() {
        return this.uri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IpAccessControlList other = (IpAccessControlList)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.friendlyName, other.friendlyName) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.subresourceUris, other.subresourceUris) && Objects.equals(this.uri, other.uri);
    }

    public int hashCode() {
        return Objects.hash(this.sid, this.accountSid, this.friendlyName, this.dateCreated, this.dateUpdated, this.subresourceUris, this.uri);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("sid", (Object)this.sid).add("accountSid", (Object)this.accountSid).add("friendlyName", (Object)this.friendlyName).add("dateCreated", (Object)this.dateCreated).add("dateUpdated", (Object)this.dateUpdated).add("subresourceUris", this.subresourceUris).add("uri", (Object)this.uri).toString();
    }
}

