/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010.account.conference;

import com.twilio.base.Updater;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.api.v2010.account.conference.Participant;
import java.net.URI;

public class ParticipantUpdater
extends Updater<Participant> {
    private String pathAccountSid;
    private final String pathConferenceSid;
    private final String pathCallSid;
    private Boolean muted;
    private Boolean hold;
    private URI holdUrl;
    private HttpMethod holdMethod;
    private URI announceUrl;
    private HttpMethod announceUrlMethod;

    public ParticipantUpdater(String pathConferenceSid, String pathCallSid) {
        this.pathConferenceSid = pathConferenceSid;
        this.pathCallSid = pathCallSid;
    }

    public ParticipantUpdater(String pathAccountSid, String pathConferenceSid, String pathCallSid) {
        this.pathAccountSid = pathAccountSid;
        this.pathConferenceSid = pathConferenceSid;
        this.pathCallSid = pathCallSid;
    }

    public ParticipantUpdater setMuted(Boolean muted) {
        this.muted = muted;
        return this;
    }

    public ParticipantUpdater setHold(Boolean hold) {
        this.hold = hold;
        return this;
    }

    public ParticipantUpdater setHoldUrl(URI holdUrl) {
        this.holdUrl = holdUrl;
        return this;
    }

    public ParticipantUpdater setHoldUrl(String holdUrl) {
        return this.setHoldUrl(Promoter.uriFromString(holdUrl));
    }

    public ParticipantUpdater setHoldMethod(HttpMethod holdMethod) {
        this.holdMethod = holdMethod;
        return this;
    }

    public ParticipantUpdater setAnnounceUrl(URI announceUrl) {
        this.announceUrl = announceUrl;
        return this;
    }

    public ParticipantUpdater setAnnounceUrl(String announceUrl) {
        return this.setAnnounceUrl(Promoter.uriFromString(announceUrl));
    }

    public ParticipantUpdater setAnnounceUrlMethod(HttpMethod announceUrlMethod) {
        this.announceUrlMethod = announceUrlMethod;
        return this;
    }

    @Override
    public Participant update(TwilioRestClient client) {
        this.pathAccountSid = this.pathAccountSid == null ? client.getAccountSid() : this.pathAccountSid;
        Request request = new Request(HttpMethod.POST, Domains.API.toString(), "/2010-04-01/Accounts/" + this.pathAccountSid + "/Conferences/" + this.pathConferenceSid + "/Participants/" + this.pathCallSid + ".json", client.getRegion());
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Participant update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Participant.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.muted != null) {
            request.addPostParam("Muted", this.muted.toString());
        }
        if (this.hold != null) {
            request.addPostParam("Hold", this.hold.toString());
        }
        if (this.holdUrl != null) {
            request.addPostParam("HoldUrl", this.holdUrl.toString());
        }
        if (this.holdMethod != null) {
            request.addPostParam("HoldMethod", this.holdMethod.toString());
        }
        if (this.announceUrl != null) {
            request.addPostParam("AnnounceUrl", this.announceUrl.toString());
        }
        if (this.announceUrlMethod != null) {
            request.addPostParam("AnnounceUrlMethod", this.announceUrlMethod.toString());
        }
    }
}

